/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services.plugins;

import hu.belicza.andras.sc2gearspluginapi.api.SettingsApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Properties;

class SettingsApiImpl
implements SettingsApi {
    private final File settingsFile;
    private Properties properties;

    public SettingsApiImpl(File file) {
        this.settingsFile = file;
        this.loadProperties();
    }

    @Override
    public void set(String string, Object object) {
        this.properties.setProperty(string, object.toString());
    }

    @Override
    public String getString(String string) {
        return this.properties.getProperty(string);
    }

    @Override
    public int getInt(String string) {
        return Integer.parseInt(this.properties.getProperty(string));
    }

    @Override
    public boolean getBoolean(String string) {
        return Boolean.parseBoolean(this.properties.getProperty(string));
    }

    @Override
    public void remove(String string) {
        this.properties.remove(string);
    }

    @Override
    public void removeAll() {
        this.properties.clear();
    }

    @Override
    public boolean loadProperties() {
        if (this.settingsFile.exists()) {
            try {
                this.properties.loadFromXML(new FileInputStream(this.settingsFile));
                return true;
            }
            catch (Exception exception) {
                System.err.println("Failed to load plugin properties!");
                exception.printStackTrace(System.err);
            }
        }
        return false;
    }

    @Override
    public boolean saveProperties() {
        if (this.properties.isEmpty()) {
            if (this.settingsFile.exists()) {
                return this.settingsFile.delete();
            }
            return true;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.settingsFile);
            this.properties.storeToXML(fileOutputStream, "Saved at " + new Date());
            return true;
        }
        catch (Exception exception) {
            System.err.println("Failed to save plugin properties!");
            exception.printStackTrace(System.err);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean isPersisted() {
        return this.settingsFile.exists();
    }
}

