/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.settings;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.ui.dialogs.ShareReplayDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Settings {
    private static final File SETTINGS_FILE;
    public static final int MAX_SC2_AUTOREP_FOLDERS = 5;
    public static final String KEY_RECENT_REPLAYS_COUNT = "recentReplays.count";
    public static final String KEY_RECENT_REPLAY_ENTRIES = "recentReplays.entry.";
    public static final String KEY_NAVIGATION_SHOW_BAR = "navigation.showNavbar";
    public static final String KEY_NAVIGATION_USE_SMALL_FONT = "navigation.useSmallFont";
    public static final String KEY_NAVIGATION_BAR_POSITION = "navigation.position";
    public static final String KEY_SETTINGS_LANGUAGE = "settings.language";
    public static final String KEY_SETTINGS_LANGUAGE_LEETNESS_LEVEL = "settings.language.leetnessLevel";
    public static final String KEY_SETTINGS_LAF = "settings.laf";
    public static final String KEY_SETTINGS_VOICE = "settings.voice";
    public static final String KEY_SETTINGS_FOLDER_SC2_INSTALLATION = "settings.folders.sc2Installation";
    public static final String KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY = "settings.folders.sc2AutoReplay";
    public static final String KEY_SETTINGS_FOLDER_ENABLE_EXTRA_SC2_AUTO_REPLAY = "settings.folders.enableExtraSc2AutoReplay";
    public static final String KEY_SETTINGS_FOLDER_SC2_MAPS = "settings.folders.sc2Maps";
    public static final String KEY_SETTINGS_FOLDER_DEFAULT_REPLAY = "settings.folders.defaultReplay";
    public static final String KEY_SETTINGS_FOLDER_REPLAY_AUTO_SAVE = "settings.folders.replayAutoSave";
    public static final String KEY_SETTINGS_FOLDER_MOUSE_PRINT_OUTPUT = "settings.folders.mousePrintOutput";
    public static final String KEY_SETTINGS_MISC_SOUND_VOLUME = "settings.misc.soundVolume";
    public static final String KEY_SETTINGS_MISC_APM_ALERT_LEVEL = "settings.misc.apmAlertLevel";
    public static final String KEY_SETTINGS_MISC_APM_WARMUP_TIME = "settings.misc.apmWarmupTime";
    public static final String KEY_SETTINGS_MISC_APM_CHECK_INTERVAL_SEC = "settings.misc.apmCheckIntervalSec";
    public static final String KEY_SETTINGS_MISC_ALERT_WHEN_APM_IS_BACK_TO_NORMAL = "settings.misc.alertWhenApmIsBackToNormal";
    public static final String KEY_SETTINGS_MISC_APM_ALERT_REPETITION_INTERVAL_SEC = "settings.misc.apmAlertRepetitionIntervalSec";
    public static final String KEY_SETTINGS_MISC_ALERT_ON_GAME_START = "settings.misc.alertOnGameStart";
    public static final String KEY_SETTINGS_MISC_ALERT_ON_GAME_END = "settings.misc.alertOnGameEnd";
    public static final String KEY_SETTINGS_MISC_SAVE_MOUSE_PRINTS = "settings.misc.saveMousePrints";
    public static final String KEY_SETTINGS_MISC_STORE_MOUSE_PRINTS = "settings.misc.storeMousePrints";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_SAMPLING_TIME = "settings.misc.mousePrintSamplingTime";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_WHAT_TO_SAVE = "settings.misc.mousePrintWhatToSave";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_DATA_COMPRESSION = "settings.misc.mousePrintDataCompression";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_IMAGE_OUTPUT_FORMAT = "settings.misc.mousePrintImageOutputFormat";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_USE_ANTIALIASING = "settings.misc.mousePrintUseAntialiasing";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_BACKGROUND_COLOR = "settings.misc.mousePrintBackgroundColor";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_COLOR = "settings.misc.mousePrintColor";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_POUR_INK_IDLE_TIME = "settings.misc.mousePrintPourInkIdleTime";
    public static final String KEY_SETTINGS_MISC_MOUSE_PRINT_IDLE_INK_FLOW_RATE = "settings.misc.mousePrintIdleInkFlowRate";
    public static final String KEY_SETTINGS_MISC_MOUSE_WARMUP_TIME = "settings.misc.mouseWarmupTime";
    public static final String KEY_SETTINGS_MISC_NEW_REP_CHECK_INTERVAL_SEC = "settings.misc.newRepCheckIntervalSec";
    public static final String KEY_SETTINGS_MISC_NAV_BAR_INITIAL_WIDTH = "settings.misc.navBarInitialWidth";
    public static final String KEY_SETTINGS_MISC_TOOL_TIP_INITIAL_DELAY = "settings.misc.toolTipInitialDelay";
    public static final String KEY_SETTINGS_MISC_TOOL_TIP_DISMISS_DELAY = "settings.misc.toolTipDismissDelay";
    public static final String KEY_SETTINGS_MISC_TIME_TO_KEEP_LOG_FILES = "settings.misc.timeToKeepLogFiles";
    public static final String KEY_SETTINGS_MISC_TIME_LIMIT_FOR_MULTI_REP_ANALYSIS = "settings.misc.timeLimitForMultiRepAnalysis";
    public static final String KEY_SETTINGS_MISC_BUILD_ORDER_LENGTH = "settings.misc.buildOrderLength";
    public static final String KEY_SETTINGS_MISC_CHARTS_ACTION_LIST_PARTITIONING = "settings.misc.chartsActionListPartitioning";
    public static final String KEY_SETTINGS_MISC_INITIAL_TIME_TO_EXCLUDE_FROM_APM = "settings.misc.initialTimeToExcludeFromApm";
    public static final String KEY_SETTINGS_MISC_REP_AUTO_SAVE_NAME_TEMPLATE = "settings.misc.repAutoSaveNameTemplate";
    public static final String KEY_SETTINGS_MISC_FAVORED_PLAYER_LIST = "settings.misc.favoredPlayerList";
    public static final String KEY_SETTINGS_MISC_REARRANGE_PLAYERS_IN_REP_ANALYZER = "settings.misc.rearrangePlayersInRepAnalyzer";
    public static final String KEY_SETTINGS_MISC_PREFERRED_BNET_LANGUAGE = "settings.misc.preferredBnetLanguage";
    public static final String KEY_REP_MISC_ANALYZER_SHOW_PROFILE_INFO = "settings.misc.showProfileInfo";
    public static final String KEY_REP_MISC_ANALYZER_AUTO_RETRIEVE_EXT_PROFILE_INFO = "settings.misc.autoRetrieveExtProfileInfo";
    public static final String KEY_REP_MISC_ANALYZER_MAX_ROWS_IN_PROFILE_TOOL_TIP = "settings.misc.maxRowsInProfileToolTip";
    public static final String KEY_SETTINGS_MISC_USE_REAL_TIME_MEASUREMENT = "settings.misc.useRealTimeMeasurement";
    public static final String KEY_SETTINGS_MISC_SHOW_WINNERS = "settings.misc.showWinners";
    public static final String KEY_SETTINGS_MISC_DECLARE_LARGEST_AS_WINNER = "settings.misc.declareLargestAsWinner";
    public static final String KEY_SETTINGS_MISC_ANIMATOR_FPS = "settings.misc.animatorFps";
    public static final String KEY_SETTINGS_MISC_ANIMATOR_JUMP_TIME = "settings.misc.animatorJumpTime";
    public static final String KEY_SETTINGS_MISC_ANIMATOR_SPEED = "settings.misc.animatorSpeed";
    public static final String KEY_SETTINGS_MISC_NEW_REPLAY_DETECTION_METHOD = "settings.misc.newReplayDetectionMethod";
    public static final String KEY_SETTINGS_MISC_DELETE_AUTO_SAVED_REPLAYS = "settings.misc.deleteAutoSavedReplays";
    public static final String KEY_SETTINGS_MISC_AUTO_OPEN_NEW_REPLAYS = "settings.misc.autoOpenNewReplays";
    public static final String KEY_SETTINGS_MISC_AUTO_STORE_NEW_REPLAYS = "settings.misc.autoStoreNewReplays";
    public static final String KEY_SETTINGS_MISC_CACHE_PREPROCESSED_REPLAYS = "settings.misc.cachePreprocessedReplays";
    public static final String KEY_SETTINGS_MISC_USE_IN_MEMORY_REPLAY_CACHE = "settings.misc.useInMemoryReplayCache";
    public static final String KEY_SETTINGS_MISC_USE_MD5_HASH_FROM_FILE_NAME = "settings.misc.useMd5HashFromFileName";
    public static final String KEY_SETTINGS_MISC_PROFILE_INFO_VALIDITY_TIME = "settings.misc.profileInfoValidityTime";
    public static final String KEY_SETTINGS_MISC_PRELOAD_SC2_ICONS_ON_STARTUP = "settings.misc.preloadSc2IconsOnStartup";
    public static final String KEY_SETTINGS_MISC_CUSTOM_DATE_FORMAT = "settings.misc.customDateFormat";
    public static final String KEY_SETTINGS_MISC_CUSTOM_TIME_FORMAT = "settings.misc.customTimeFormat";
    public static final String KEY_SETTINGS_MISC_CUSTOM_DATE_TIME_FORMAT = "settings.misc.customDateTimeFormat";
    public static final String KEY_SETTINGS_MISC_PLAYER_ALIASES = "settings.misc.playerAliases";
    public static final String KEY_SETTINGS_MISC_MAP_ALIASES = "settings.misc.mapAliases";
    public static final String KEY_SETTINGS_MISC_PREDEFINED_LISTS = "settings.misc.predefinedList.";
    public static final String KEY_SETTINGS_MISC_AUTHORIZATION_KEY = "settings.misc.authorizationKey";
    public static final String KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES_ACKNOWLEDGED = "settings.misc.customReplaySitesAcknowledged";
    private static final String KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES = "settings.misc.customReplaySites";
    public static final String KEY_SETTINGS_SAVE_ON_EXIT = "settings.saveOnExit";
    public static final String KEY_SETTINGS_ENABLE_VOICE_NOTIFICATIONS = "settings.enableVoiceNotifications";
    public static final String KEY_SETTINGS_ALLOW_ONLY_ONE_INSTANCE = "settings.allowOnlyOneInstance";
    public static final String KEY_SETTINGS_SHOW_START_PAGE_ON_STARTUP = "settings.showStartPageOnStartup";
    public static final String KEY_SETTINGS_ENABLE_REPLAY_AUTO_SAVE = "settings.enableReplayAutoSave";
    public static final String KEY_SETTINGS_ENABLE_GLOBAL_HOTKEYS = "settings.enableGlobalHotkeys";
    public static final String KEY_SETTINGS_ENABLE_APM_ALERT = "settings.enableApmAlert";
    public static final String KEY_SETTINGS_CHECK_UPDATES_ON_STARTUP = "settings.checkUpdatesOnStartup";
    public static final String KEY_WINDOW_START_MAXIMIZED = "window.startMaximized";
    public static final String KEY_WINDOW_START_MINIMIZED_TO_TRAY = "window.startMinimizedToTray";
    public static final String KEY_WINDOW_MINIMIZE_TO_TRAY_ON_MINIMIZE = "window.minimizeToTrayOnMinimize";
    public static final String KEY_WINDOW_MINIMIZE_TO_TRAY_ON_CLOSE = "window.minimizeToTrayOnClose";
    public static final String KEY_WINDOW_VERTICAL_TILE_STRATEGY = "window.verticalTileStrategy";
    public static final String KEY_REP_ANALYZER_CHARTS_CHART_TYPE = "module.repAnalyzer.charts.chartType";
    public static final String KEY_REP_ANALYZER_CHARTS_GROUP_BY_TEAMS = "module.repAnalyzer.charts.groupByTeams";
    public static final String KEY_REP_ANALYZER_CHARTS_ALL_PLAYERS_ON_1_CHART = "module.repAnalyzer.charts.allPlayersOn1Chart";
    public static final String KEY_REP_ANALYZER_CHARTS_USE_PLAYERS_COLORS = "module.repAnalyzer.charts.usePlayersColors";
    public static final String KEY_REP_ANALYZER_CHARTS_DISPLAY_IN_SECONDS = "module.repAnalyzer.charts.displayInSeconds";
    public static final String KEY_REP_ANALYZER_CHARTS_ZOOM = "module.repAnalyzer.charts.zoom";
    public static final String KEY_REP_ANALYZER_CHARTS_GRID = "module.repAnalyzer.charts.grid";
    public static final String KEY_REP_ANALYZER_CHARTS_PREDEFINED_GRID = "module.repAnalyzer.charts.grid.predefined";
    public static final String KEY_REP_ANALYZER_CHARTS_GRID_FIRST_MARKER = "module.repAnalyzer.charts.grid.firstMarker";
    public static final String KEY_REP_ANALYZER_CHARTS_GRID_REPEAT_MARKER = "module.repAnalyzer.charts.grid.repeatMarker";
    public static final String KEY_REP_ANALYZER_CHARTS_APM_GRANULARITY = "module.repAnalyzer.charts.apm.granularity";
    public static final String KEY_REP_ANALYZER_CHARTS_APM_GRAPH_APPROXIMATION = "module.repAnalyzer.charts.apm.graphApproximation";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_MICRO_MACRO_APM = "module.repAnalyzer.charts.apm.showMicroMacroApm";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_SELECT_HOTKEYS = "module.repAnalyzer.charts.hotkeys.showSelectHotkeys";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_BUILDS = "module.repAnalyzer.charts.buildsTech.showBuilds";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_TRAINS = "module.repAnalyzer.charts.buildsTech.showTrains";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_WORKERS = "module.repAnalyzer.charts.buildsTech.showWorkers";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES = "module.repAnalyzer.charts.buildsTech.showResearches";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES = "module.repAnalyzer.charts.buildsTech.showUpgrades";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS = "module.repAnalyzer.charts.buildsTech.showAbilityGroups";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_DURATION = "module.repAnalyzer.charts.buildsTech.showDuration";
    public static final String KEY_REP_ANALYZER_CHARTS_ICON_SIZES = "module.repAnalyzer.charts.buildsTech.iconSizes";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UNITS_STAT = "module.repAnalyzer.charts.buildsTechStat.showUnits";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_BUILDINGS_STAT = "module.repAnalyzer.charts.buildsTechStat.showBuildings";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES_STAT = "module.repAnalyzer.charts.buildsTechStat.showResearches";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES_STAT = "module.repAnalyzer.charts.buildsTechStat.showUpgrades";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS_STAT = "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups";
    public static final String KEY_REP_ANALYZER_CHARTS_BAR_SIZE = "module.repAnalyzer.charts.buildsTechStat.barSize";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_AFTER_COMPLETED = "module.repAnalyzer.charts.showAfterCompleted";
    public static final String KEY_REP_ANALYZER_CHARTS_UNIT_TIERS_GRANULARITY = "module.repAnalyzer.charts.unitTiersGranularity";
    public static final String KEY_REP_ANALYZER_CHARTS_STRETCH_BARS = "module.repAnalyzer.charts.stretchBars";
    public static final String KEY_REP_ANALYZER_CHARTS_MAP_VIEW_QUALITY = "module.repAnalyzer.charts.mapView.quality";
    public static final String KEY_REP_ANALYZER_CHARTS_MAP_BACKGROUND = "module.repAnalyzer.charts.mapView.background";
    public static final String KEY_REP_ANALYZER_CHARTS_AREA_GRANULARITY = "module.repAnalyzer.charts.mapView.areaGranularity";
    public static final String KEY_REP_ANALYZER_CHARTS_HIDE_OVERLAPPED_BUILDINGS = "module.repAnalyzer.charts.mapView.hideOverlappedBuildings";
    public static final String KEY_REP_ANALYZER_CHARTS_FILL_BUILDING_ICONS = "module.repAnalyzer.charts.mapView.fillBuildingIcons";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_MAP_OBJECTS = "module.repAnalyzer.charts.mapView.showMapObjects";
    public static final String KEY_REP_ANALYZER_CHARTS_GROUP_SAME_PRODUCTIONS = "module.repAnalyzer.charts.productions.groupSameProductions";
    public static final String KEY_REP_ANALYZER_CHARTS_ICON_SIZES_P = "module.repAnalyzer.charts.productions.iconSizes";
    public static final String KEY_REP_ANALYZER_CHARTS_ICON_SIZES_PS = "module.repAnalyzer.charts.playerSelections.iconSizes";
    public static final String KEY_REP_ANALYZER_CHARTS_INCLUDE_INITIAL_UNITS = "module.repAnalyzer.charts.producedArmySupply.includeInitialUnits";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_ACTION_TYPES = "module.repAnalyzer.charts.actions.actionType.";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_INVERT_COLORS = "module.repAnalyzer.charts.actions.invertColors";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_ICON_SIZE = "module.repAnalyzer.charts.actions.iconSize";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_USE_LISTED_AS_INPUT = "module.repAnalyzer.charts.actions.useListedAsInput";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_HIDE_MESSAGE_TARGETS = "module.repAnalyzer.inGameChat.hideMessageTargets";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_SHOW_BLINKS = "module.repAnalyzer.inGameChat.showBlinks";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_FORMAT_INTO_PARAGRAPHS = "module.repAnalyzer.inGameChat.formatIntoParagraphs";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_TARGET_LANGUAGE = "module.repAnalyzer.inGameChat.targetLanguage";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_SOURCE_LANGUAGE = "module.repAnalyzer.inGameChat.sourceLanguage";
    public static final String KEY_REP_ANALYZER_MAP_PREVIEW_DOWNLOAD_FROM_GATEWAY = "module.repAnalyzer.mapPreview.downloadFromGateway";
    public static final String KEY_REP_ANALYZER_MAP_PREVIEW_ZOOM = "module.repAnalyzer.mapPreview.zoom";
    public static final String KEY_MULTI_REP_ANAL_AUTO_OPEN_FIRST_PLAYER = "module.multiRepAnal.autoOpenFirstPlayer";
    public static final String KEY_MULTI_REP_ANAL_STRETCH_TO_WINDOW = "module.multiRepAnal.stretchToWindow";
    public static final String KEY_MULTI_REP_ANAL_CHARTS_CHART_TYPE = "module.multiRepAnal.charts.chartType";
    public static final String KEY_MULTI_REP_ANAL_CHARTS_CHART_GRANULARITY = "module.multiRepAnal.charts.chartGranularity";
    public static final String KEY_MULTI_REP_ANAL_CHARTS_GRAPH_APPROXIMATION = "module.multiRepAnal.charts.graphApproximation";
    public static final String KEY_MULTI_REP_ANAL_TRENDS_TREND_TYPE = "module.multiRepAnal.trends.trendType";
    public static final String KEY_REP_SEARCH_SOURCE_AUTO_SORT = "module.repSearch.source.autoSort";
    public static final String KEY_REP_SEARCH_RESULTS_STRETCH_TO_WINDOW = "module.repSearch.results.stretchToWindow";
    public static final String KEY_REP_SEARCH_RESULTS_INCLUDE_PATH_IN_ZIP = "module.repSearch.results.includePathInZip";
    public static final String KEY_REP_SEARCH_RESULTS_RENAME_TEMPLATE = "module.repSearch.results.renameTemplate";
    public static final String KEY_SHARE_REP_REPLAY_SITE = "shareRep.replaySite";
    public static final String KEY_SHARE_REP_USER_NAME = "shareRep.userName";
    public static final String KEY_IMPORT_BO_LATEST_IMPORT_FOLDER = "importBO.latestImportFolder";
    public static final String KEY_PROGRESS_DIALOG_ALERT_WHEN_DONE = "progressDialog.alertWhenDone";
    public static final String KEY_MOUSE_PRINT_REFRESH_RATE = "mousePrint.refreshRate";
    public static final String KEY_MOUSE_PRINT_IMAGE_ZOOM = "mousePrint.imageZoom";
    public static final String KEY_SHOW_NEW_TO_SC2GEARS_DIALOG_ON_STARTUP = "showNewToSc2gearsDialogOnStartup";
    public static final String KEY_START_PAGE_CHANNEL = "startPageChannel";
    public static final String KEY_SC2GEARS_DATABASE_DOWNLOADER_FILE_TYPE = "sc2gearsDatabaseDownloader.fileType";
    public static final String KEY_SC2GEARS_DATABASE_DOWNLOADER_TARGET_FOLDER = "sc2gearsDatabaseDownloader.targetFolder";
    public static final String KEY_PLUGIN_MANAGER_ENABLED_PLUGINS = "pluginManager.enabledPlugins";
    public static final String DEFAULT_APP_LANGUAGE = "English";
    public static final String DEFAULT_APP_LAF = "Nimbus";
    private static final Properties DEFAULT_PROPERTIES;
    private static Properties properties;
    private static final Map<Details.PlayerId, Details.PlayerId> playerAliasGroupMap;
    private static final Map<String, String> mapAliasGroupMap;
    private static Map<PredefinedList, Vector<String>> predefinedListMap;
    private static volatile List<ShareReplayDialog.ReplayUploadSite> customReplayUploadSiteList;
    private static volatile Set<String> enabledPluginSet;

    static {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        SETTINGS_FILE = new File("User Content", "settings.xml");
        DEFAULT_PROPERTIES = new Properties();
        DEFAULT_PROPERTIES.setProperty(KEY_RECENT_REPLAYS_COUNT, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_SHOW_BAR, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_USE_SMALL_FONT, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_BAR_POSITION, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_LANGUAGE, DEFAULT_APP_LANGUAGE);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_LANGUAGE_LEETNESS_LEVEL, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_LAF, DEFAULT_APP_LAF);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_VOICE, "smix");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_SOUND_VOLUME, "70");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_APM_ALERT_LEVEL, "60");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_APM_WARMUP_TIME, "90");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_APM_CHECK_INTERVAL_SEC, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ALERT_WHEN_APM_IS_BACK_TO_NORMAL, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_APM_ALERT_REPETITION_INTERVAL_SEC, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ALERT_ON_GAME_START, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ALERT_ON_GAME_END, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_SAVE_MOUSE_PRINTS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_STORE_MOUSE_PRINTS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_SAMPLING_TIME, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_WHAT_TO_SAVE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_DATA_COMPRESSION, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_IMAGE_OUTPUT_FORMAT, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_USE_ANTIALIASING, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_BACKGROUND_COLOR, "255,255,255");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_COLOR, "0,0,0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_POUR_INK_IDLE_TIME, "3");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_PRINT_IDLE_INK_FLOW_RATE, "200");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MOUSE_WARMUP_TIME, "50");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_NEW_REP_CHECK_INTERVAL_SEC, "3");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_NAV_BAR_INITIAL_WIDTH, "250");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_TOOL_TIP_INITIAL_DELAY, "200");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_TOOL_TIP_DISMISS_DELAY, "10000");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_TIME_TO_KEEP_LOG_FILES, "14");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_TIME_LIMIT_FOR_MULTI_REP_ANALYSIS, "120");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_BUILD_ORDER_LENGTH, "6");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CHARTS_ACTION_LIST_PARTITIONING, "70");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_INITIAL_TIME_TO_EXCLUDE_FROM_APM, "110");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_REP_AUTO_SAVE_NAME_TEMPLATE, "/D  /h./e");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_FAVORED_PLAYER_LIST, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_REARRANGE_PLAYERS_IN_REP_ANALYZER, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_PREFERRED_BNET_LANGUAGE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_MISC_ANALYZER_SHOW_PROFILE_INFO, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_MISC_ANALYZER_AUTO_RETRIEVE_EXT_PROFILE_INFO, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_MISC_ANALYZER_MAX_ROWS_IN_PROFILE_TOOL_TIP, "16");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_USE_REAL_TIME_MEASUREMENT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_SHOW_WINNERS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_DECLARE_LARGEST_AS_WINNER, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ANIMATOR_FPS, "16");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ANIMATOR_JUMP_TIME, "60");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_ANIMATOR_SPEED, "5");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_NEW_REPLAY_DETECTION_METHOD, GeneralUtils.isWindows() ? "1" : "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_DELETE_AUTO_SAVED_REPLAYS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_AUTO_OPEN_NEW_REPLAYS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_AUTO_STORE_NEW_REPLAYS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CACHE_PREPROCESSED_REPLAYS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_USE_IN_MEMORY_REPLAY_CACHE, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_USE_MD5_HASH_FROM_FILE_NAME, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_PROFILE_INFO_VALIDITY_TIME, "3");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_PRELOAD_SC2_ICONS_ON_STARTUP, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CUSTOM_DATE_FORMAT, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CUSTOM_TIME_FORMAT, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CUSTOM_DATE_TIME_FORMAT, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_PLAYER_ALIASES, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_MAP_ALIASES, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_AUTHORIZATION_KEY, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES_ACKNOWLEDGED, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_SAVE_ON_EXIT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_ENABLE_VOICE_NOTIFICATIONS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_ALLOW_ONLY_ONE_INSTANCE, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_SHOW_START_PAGE_ON_STARTUP, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_ENABLE_REPLAY_AUTO_SAVE, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_ENABLE_GLOBAL_HOTKEYS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_ENABLE_APM_ALERT, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_CHECK_UPDATES_ON_STARTUP, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_START_MAXIMIZED, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_START_MINIMIZED_TO_TRAY, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_MINIMIZE_TO_TRAY_ON_MINIMIZE, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_MINIMIZE_TO_TRAY_ON_CLOSE, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_VERTICAL_TILE_STRATEGY, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_CHART_TYPE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_GROUP_BY_TEAMS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ALL_PLAYERS_ON_1_CHART, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_USE_PLAYERS_COLORS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_DISPLAY_IN_SECONDS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ZOOM, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_GRID, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_PREDEFINED_GRID, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_GRID_FIRST_MARKER, "180,0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_GRID_REPEAT_MARKER, "25,2");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_APM_GRANULARITY, "5");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_APM_GRAPH_APPROXIMATION, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_MICRO_MACRO_APM, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_SELECT_HOTKEYS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_BUILDS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_TRAINS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_WORKERS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_DURATION, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ICON_SIZES, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UNITS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_BUILDINGS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_BAR_SIZE, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_AFTER_COMPLETED, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_UNIT_TIERS_GRANULARITY, "8");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_STRETCH_BARS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_MAP_VIEW_QUALITY, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_MAP_BACKGROUND, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_AREA_GRANULARITY, "6");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_HIDE_OVERLAPPED_BUILDINGS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_FILL_BUILDING_ICONS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_MAP_OBJECTS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_GROUP_SAME_PRODUCTIONS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ICON_SIZES_P, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ICON_SIZES_PS, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_INCLUDE_INITIAL_UNITS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_INVERT_COLORS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_ICON_SIZE, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_USE_LISTED_AS_INPUT, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_MAP_PREVIEW_DOWNLOAD_FROM_GATEWAY, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_MAP_PREVIEW_ZOOM, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_HIDE_MESSAGE_TARGETS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_SHOW_BLINKS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_FORMAT_INTO_PARAGRAPHS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_TARGET_LANGUAGE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_SOURCE_LANGUAGE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_AUTO_OPEN_FIRST_PLAYER, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_STRETCH_TO_WINDOW, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_CHARTS_CHART_TYPE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_CHARTS_CHART_GRANULARITY, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_CHARTS_GRAPH_APPROXIMATION, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_MULTI_REP_ANAL_TRENDS_TREND_TYPE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_SOURCE_AUTO_SORT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_STRETCH_TO_WINDOW, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_INCLUDE_PATH_IN_ZIP, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_RENAME_TEMPLATE, "/T - /m - /q./e");
        DEFAULT_PROPERTIES.setProperty(KEY_SHARE_REP_REPLAY_SITE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SHARE_REP_USER_NAME, "");
        DEFAULT_PROPERTIES.setProperty(KEY_IMPORT_BO_LATEST_IMPORT_FOLDER, "");
        DEFAULT_PROPERTIES.setProperty(KEY_PROGRESS_DIALOG_ALERT_WHEN_DONE, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_MOUSE_PRINT_REFRESH_RATE, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_MOUSE_PRINT_IMAGE_ZOOM, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_SHOW_NEW_TO_SC2GEARS_DIALOG_ON_STARTUP, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_START_PAGE_CHANNEL, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SC2GEARS_DATABASE_DOWNLOADER_FILE_TYPE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SC2GEARS_DATABASE_DOWNLOADER_TARGET_FOLDER, "");
        DEFAULT_PROPERTIES.setProperty(KEY_PLUGIN_MANAGER_ENABLED_PLUGINS, "");
        if (GeneralUtils.isWindows7() || GeneralUtils.isWindowsVista()) {
            string5 = new File("C:/Program Files (x86)").exists() ? "C:/Program Files (x86)" : "C:/Program Files";
            string4 = "/Documents";
            string3 = "C:/ProgramData/Blizzard Entertainment";
            string2 = "C:";
            string = "C:";
        } else if (GeneralUtils.isWindowsXp()) {
            string5 = new File("C:/Program Files (x86)").exists() ? "C:/Program Files (x86)" : "C:/Program Files";
            string4 = "/My Documents";
            string3 = "C:/Documents and Settings/All Users/Application Data/Blizzard Entertainment";
            string2 = "C:";
            string = "C:";
        } else if (GeneralUtils.isMac()) {
            string5 = "/Applications";
            string4 = "/Documents/Blizzard";
            string3 = "/Users/Shared/Blizzard";
            string2 = "/Users/Shared";
            string = "/Users/Shared";
        } else {
            string5 = "/Applications";
            string4 = "/Documents";
            string3 = "/Documents/Blizzard Entertainment";
            string2 = "";
            string = "";
        }
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_INSTALLATION, String.valueOf(string5) + "/StarCraft II");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY, String.valueOf(string4) + "/StarCraft II/Accounts");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_MAPS, String.valueOf(string3) + "/Battle.net/Cache");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_DEFAULT_REPLAY, "");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_REPLAY_AUTO_SAVE, String.valueOf(string2) + "/SC2Replay Archive");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_MOUSE_PRINT_OUTPUT, String.valueOf(string) + "/Sc2gears Mouse prints");
        String string6 = DEFAULT_PROPERTIES.getProperty(KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY);
        int n = 2;
        while (n <= 5) {
            DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY + n, string6);
            DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_ENABLE_EXTRA_SC2_AUTO_REPLAY + n, "false");
            ++n;
        }
        properties = new Properties(DEFAULT_PROPERTIES);
        playerAliasGroupMap = new HashMap<Details.PlayerId, Details.PlayerId>();
        mapAliasGroupMap = new HashMap<String, String>();
    }

    private Settings() {
    }

    public static boolean doesSettingsFileExist() {
        return SETTINGS_FILE.exists();
    }

    public static void loadProperties() {
        if (SETTINGS_FILE.exists()) {
            try {
                properties.loadFromXML(new FileInputStream(SETTINGS_FILE));
            }
            catch (Exception exception) {
                System.err.println("Failed to load properties!");
                exception.printStackTrace(System.err);
            }
        } else {
            System.err.println("Warning: settings file does not exist, the default settings will be used.");
        }
        Settings.rebuildAliases();
    }

    public static void completeDefaultPropertiesInitialization() {
        Enum enum_;
        Enum[] enumArray = ReplayConsts.ActionType.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_ACTION_TYPES + enum_.ordinal(), enum_ == ReplayConsts.ActionType.INACTION ? "false" : "true");
            ++n2;
        }
        enumArray = PredefinedList.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            DEFAULT_PROPERTIES.setProperty(((PredefinedList)enum_).settingsKey, ((PredefinedList)enum_).defaultValue);
            ++n2;
        }
        predefinedListMap = new EnumMap<PredefinedList, Vector<String>>(PredefinedList.class);
        enumArray = PredefinedList.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            predefinedListMap.put((PredefinedList)enum_, new Vector(5));
            ++n2;
        }
        Settings.rebuildPredefinedLists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rebuildAliases() {
        playerAliasGroupMap.clear();
        mapAliasGroupMap.clear();
        int n = 0;
        while (n < 2) {
            block15: {
                String string = Settings.getString(n == 0 ? KEY_SETTINGS_MISC_PLAYER_ALIASES : KEY_SETTINGS_MISC_MAP_ALIASES);
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                try {
                    try {
                        String string2;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            Details.PlayerId playerId;
                            String string3;
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                            if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken().trim()).length() == 0) continue;
                            Details.PlayerId playerId2 = playerId = n == 0 ? Details.PlayerId.parse(string3) : null;
                            if (n == 0 && playerId == null) continue;
                            while (stringTokenizer.hasMoreTokens()) {
                                String string4 = stringTokenizer.nextToken().trim();
                                if (string4.length() <= 0) continue;
                                if (n == 0) {
                                    Details.PlayerId playerId3 = Details.PlayerId.parse(string4);
                                    if (playerId3 == null) continue;
                                    playerAliasGroupMap.put(playerId3, playerId);
                                    continue;
                                }
                                mapAliasGroupMap.put(string4, string3);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    public static void rebuildPredefinedLists() {
        PredefinedList[] predefinedListArray = PredefinedList.values();
        int n = predefinedListArray.length;
        int n2 = 0;
        while (n2 < n) {
            PredefinedList predefinedList = predefinedListArray[n2];
            Vector<String> vector = predefinedListMap.get((Object)predefinedList);
            vector.clear();
            Settings.breakIntoLines(Settings.getString(predefinedList.settingsKey), vector);
            ++n2;
        }
    }

    public static void breakIntoLines(String string, Collection<String> collection) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    collection.add(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveProperties() {
        block12: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(SETTINGS_FILE);
                    properties.storeToXML(fileOutputStream, "Saved at " + new Date());
                }
                catch (Exception exception) {
                    System.err.println("Failed to save properties!");
                    exception.printStackTrace(System.err);
                    if (fileOutputStream == null) break block12;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void set(String string, Object object) {
        properties.setProperty(string, object.toString());
    }

    public static String getString(String string) {
        return properties.getProperty(string);
    }

    public static int getInt(String string) {
        return Integer.parseInt(properties.getProperty(string));
    }

    public static boolean getBoolean(String string) {
        return Boolean.parseBoolean(properties.getProperty(string));
    }

    public static void remove(String string) {
        properties.remove(string);
    }

    public static String getDefaultString(String string) {
        return DEFAULT_PROPERTIES.getProperty(string);
    }

    public static int getDefaultInt(String string) {
        return Integer.parseInt(DEFAULT_PROPERTIES.getProperty(string));
    }

    public static boolean getDefaultBoolean(String string) {
        return Boolean.parseBoolean(DEFAULT_PROPERTIES.getProperty(string));
    }

    public static Details.PlayerId getAliasGroupPlayerId(Details.PlayerId playerId) {
        Details.PlayerId playerId2 = playerAliasGroupMap.get(playerId);
        return playerId2 == null ? playerId : playerId2;
    }

    public static String getMapAliasGroupName(String string) {
        String string2 = mapAliasGroupMap.get(string);
        return string2 == null ? string : string2;
    }

    public static Vector<String> getPredefinedListValues(PredefinedList predefinedList) {
        return predefinedListMap.get((Object)predefinedList);
    }

    public static List<ShareReplayDialog.ReplayUploadSite> getCustomReplayUploadSiteList() {
        if (customReplayUploadSiteList == null) {
            ArrayList<ShareReplayDialog.ReplayUploadSite> arrayList = new ArrayList<ShareReplayDialog.ReplayUploadSite>(4);
            String string = Settings.getString(KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES);
            if (string.length() > 0) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
                    Element element = document.getDocumentElement();
                    NodeList nodeList = element.getElementsByTagName("site");
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Element element2 = (Element)nodeList.item(n2);
                        ShareReplayDialog.ReplayUploadSite replayUploadSite = new ShareReplayDialog.ReplayUploadSite();
                        replayUploadSite.displayName = element2.getElementsByTagName("displayName").item(0).getTextContent();
                        replayUploadSite.homePage = element2.getElementsByTagName("homePage").item(0).getTextContent();
                        replayUploadSite.uploadUrl = element2.getElementsByTagName("uploadUrl").item(0).getTextContent();
                        arrayList.add(replayUploadSite);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            customReplayUploadSiteList = arrayList;
        }
        return customReplayUploadSiteList;
    }

    public static void setCustomReplayUploadSiteList(List<ShareReplayDialog.ReplayUploadSite> list) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("customReplaySites");
            element.setAttribute("version", "1.0");
            for (ShareReplayDialog.ReplayUploadSite object2 : list) {
                Element element2 = document.createElement("site");
                Element element3 = document.createElement("displayName");
                element3.setTextContent(object2.displayName);
                element2.appendChild(element3);
                element3 = document.createElement("homePage");
                element3.setTextContent(object2.homePage);
                element2.appendChild(element3);
                element3 = document.createElement("uploadUrl");
                element3.setTextContent(object2.uploadUrl);
                element2.appendChild(element3);
                element.appendChild(element2);
            }
            document.appendChild(element);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            Settings.set(KEY_SETTINGS_MISC_CUSTOM_REPLAY_SITES, stringWriter.getBuffer().toString());
            customReplayUploadSiteList = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Set<String> getEnabledPluginSet() {
        if (enabledPluginSet == null) {
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = Settings.getString(KEY_PLUGIN_MANAGER_ENABLED_PLUGINS).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                hashSet.add(string);
                ++n2;
            }
            enabledPluginSet = hashSet;
        }
        return enabledPluginSet;
    }

    public static void setEnabledPluginSet(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        Settings.set(KEY_PLUGIN_MANAGER_ENABLED_PLUGINS, stringBuilder.toString());
        enabledPluginSet = null;
    }

    public static enum PredefinedList {
        REP_ANAL_SEARCH(Icons.CHART, "miscSettings.predefinedList.repAnalSearch", "repAnalSearch", "\nleave game\nresources\nactivate/deactivate"),
        REP_ANAL_FILTER(Icons.CHART, "miscSettings.predefinedList.repAnalFilter", "repAnalFilter", "\n[WORKERS]     OR train probe OR train scv OR train drone OR calldown mule\n[SUPPLY]     OR build pylon OR build supply depot OR train overlord OR calldown extra supplies\n[EXPAND]     OR build nexus OR build command center OR build hatchery\n[DEFENSE]     OR build cannon OR build bunker OR build missile turret OR build spine crawler OR build spore crawler\n[TRADE]     OR resources\n[TIER 1]     OR train zergling OR train marine OR train zealot\n[TIER 1.5]     OR train roach OR morph baneling OR train marauder OR train reaper OR train stalker OR train sentry\n[TIER 2]     OR train hydralisk OR train infestor OR train mutalisk OR train corruptor OR morph overseer OR train ghost OR train hellion OR train immortal OR train phoenix OR train void ray OR train observer OR train warp prism\n[TIER 2.5]     OR train siege tank OR train medivac OR train viking OR train banshee\n[TIER 3]     OR train ultralisk OR morph brood lord OR train raven OR train battlecruiser OR train thor OR train colossus OR train mothership OR train carrier OR train high templar OR train dark templar"),
        REP_ANAL_FILTER_OUT(Icons.CHART, "miscSettings.predefinedList.repAnalFilterOut", "repAnalFilterOut", "\nright click"),
        REP_AUTO_SAVE_TEMPLATE(Icons.UI_SCROLL_PANE_LIST, "miscSettings.predefinedList.repAutoSaveTemplate", "repAutoSaveTemplate", "\n/D  /h./e\n/D./e\n/F4 </p (/r)>./e\n/f\\/F4 </p (/r)>./e\n/Y\\/F4 </p (/r)>./e\n/m\\/F4 </p (/r)>./e\n/G\\</p (/r)>./e\n/G\\/T - </p>./e\n/D </p>./e\n/D [/m] </p>./e\n/m - </p (/r)>./e\n/m - /T - </p (/r)>./e\n/m\\/T - </p (/r)>./e"),
        REP_RENAME_TEMPLATE(Icons.DOCUMENT_RENAME, "miscSettings.predefinedList.repRenameTemplate", "repRenameTemplate", "\n/D  /h./e\n/D./e\n/D - /m./e\n/T - /m - /q./e\n/C4 - /m./e\n/C4 - </p (/r)>./e\n/G\\</p (/r)>./e\n/G\\/T - </p>./e"),
        REP_SEARCH_PLAYER_NAME(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchPlayerName", "repSearchPlayerName", ""),
        REP_SEARCH_MAP_NAME(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchMapName", "repSearchMapName", "\nAbyss\nAgria Valley\nArakan Citadel\nArid Wastes\nBlistering Sands\nCoalition\nColony 426\nDecena\nDelta Quadrant\nDesert Oasis\nDig Site\nDiscord IV\nExtinction\nFrontier\nHigh Ground\nHigh Orbit\nIncineration Zone\nJungle Basin\nKulas Ravine\nLava Flow\nLost Temple\nMegaton\nMetalopolis\nMonlyth Ridge\nMonsoon\nOutpost\nQuicksand\nSand Canyon\nScorched Haven\nScrap Station\nShakuras Plateau\nSteppes of War\nTarsonis Assault\nTempest\nThe Bio Lab\nToxic Slums\nTwilight Fortress\nTyphon\nUlaan Deeps\nWar Zone\nXel'Naga Caverns"),
        REP_SEARCH_RACE_MATCHUP(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchRaceMatchup", "repSearchRaceMatchup", "\n*vP\n*vT\n*vZ\n*vR\nPv*\nTv*\nZv*\nRv*"),
        REP_SEARCH_FILE_NAME(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchFileName", "repSearchFileName", ""),
        REP_SEARCH_CHAT_MESSAGE(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchChatMessage", "repSearchChatMessage", "\ngg\ngl hf"),
        REP_SEARCH_BUILD_ORDER(Icons.BINOCULAR, "miscSettings.predefinedList.repSearchBuildOrder", "repSearchBuildOrder", "\nPylon, Gateway, Assimilator, Pylon, Cybernetics Core\nPylon, Gateway, Pylon, Gateway\nPylon, Forge\nPylon, Gateway, Pylon, Nexus\nPylon, Nexus\nSupply Depot, Barracks, Refinery, Supply Depot, Tech Lab (Barracks)\nSupply Depot, Barracks, Barracks, Supply Depot\nSupply Depot, Barracks, Refinery, Supply Depot, Factory\nSupply Depot, Barracks, Supply Depot, Command Center\nSupply Depot, Refinery, Barracks, Supply Depot\nSpawning Pool, Extractor, Lair\nSpawning Pool, Extractor, Roach Warren\nSpawning Pool, Extractor, Baneling Nest\nSpawning Pool, Hatchery, Extractor\nSpawning Pool, Extractor, Hatchery"),
        REP_SHARE_USER_NAME(Icons.DOCUMENT_SHARE, "miscSettings.predefinedList.repShareUserName", "repShareUserName", ""),
        CUSTOM_DATE_FORMAT(Icons.CALENDAR_BLUE, "miscSettings.predefinedList.customDateFormat", "customDateFormat", "\nyyyy-MM-dd\nyyyy.MM.dd\nyyyy/MM/dd\nyy-MM-dd\nyy.MM.dd\nyy/MM/dd"),
        CUSTOM_TIME_FORMAT(Icons.CALENDAR_BLUE, "miscSettings.predefinedList.customTimeFormat", "customTimeFormat", "\nHH:mm:ss\nHH-mm-ss"),
        CUSTOM_DATE_TIME_FORMAT(Icons.CALENDAR_BLUE, "miscSettings.predefinedList.customDateTimeFormat", "customDateTimeFormat", "\nyyyy-MM-dd HH:mm:ss\nyyyy.MM.dd HH:mm:ss\nyyyy/MM/dd HH:mm:ss\nyy-MM-dd HH:mm:ss\nyy.MM.dd HH:mm:ss\nyy/MM/dd HH:mm:ss");

        public final Icon icon;
        public final String stringValue;
        public final String settingsKey;
        public final String defaultValue;

        private PredefinedList(Icon icon, String string2, String string3, String string4) {
            this.icon = icon;
            this.stringValue = Language.getText(string2);
            this.settingsKey = Settings.KEY_SETTINGS_MISC_PREDEFINED_LISTS + string3;
            this.defaultValue = string4;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

