/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.smpd;

import hu.belicza.andras.sc2gears.language.Language;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SmpdUtil {
    public static final String SMPD_FILE_EXTENSION = "smpd";
    public static final byte[] SMPD_MAGIC = "SMPD".getBytes();
    public static final short VERSION = 256;
    public static final int HEADER_SIZE = 41;

    public static void writeEncodedValue(int n, OutputStream outputStream) throws IOException {
        int n2 = n = n > 0 ? n << 1 : -n << 1 | 1;
        while (true) {
            if (n < 128) {
                outputStream.write(n);
                return;
            }
            outputStream.write(n & 0x7F | 0x80);
            n >>= 7;
        }
    }

    public static int readEncodedValue(InputStream inputStream) throws EOFException, IOException {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = inputStream.read()) < 0) {
                if (n2 == 0) {
                    return Integer.MAX_VALUE;
                }
                throw new EOFException();
            }
            n |= (n3 & 0x7F) << n2;
            if ((n3 & 0x80) == 0) {
                return (n & 1) > 0 ? -(n >> 1) : n >> 1;
            }
            n2 += 7;
        }
    }

    public static String getVersionString(short s) {
        return String.valueOf(s >> 8) + "." + (s & 0xFF);
    }

    public static enum DataCompression {
        NO_COMPRESSION("miscSettings.binaryDataCompressionAlgorithm.noCompression"),
        DEFLATE("miscSettings.binaryDataCompressionAlgorithm.deflate"),
        BZIP2("miscSettings.binaryDataCompressionAlgorithm.bzip2");

        public final String stringValue;

        private DataCompression(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

