/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sound;

import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class Sounds {
    public static final VoiceDescription[] VOICE_DESCRIPTIONS = new VoiceDescription[]{new VoiceDescription("smix", "Smix", "Smix", "", "English"), new VoiceDescription("smixkorean", "Smix \ud55c\uad6d\uc5b4", "Smix", "", "Korean"), new VoiceDescription("smuck", "Smuck", "Andrea", "Smuck", "Hungarian"), new VoiceDescription("google", "Google", "Google TTS", "", "English")};
    private static final String DEFAULT_THEME = "google";
    public static final String SAMPLE_VOICE_NAME = "voice_name";
    public static final String SAMPLE_CHANGING_LANGUAGE = "changing_language";
    public static final String SAMPLE_CHANGING_THEME = "changing_theme";
    public static final String SAMPLE_REPLAY_SAVED = "replay_saved";
    public static final String SAMPLE_REPLAY_SAVE_FAILED = "replay_save_failed";
    public static final String SAMPLE_SC2GEARS = "sc2gears";
    public static final String SAMPLE_THANK_YOU = "thank_you";
    public static final String SAMPLE_UPDATES_AVAILABLE = "updates_available";
    public static final String SAMPLE_WELCOME = "welcome";
    public static final String SAMPLE_LANGUAGE_UPDATED = "language_updated";
    public static final String SAMPLE_LOW_APM = "low_apm";
    public static final String SAMPLE_APM_OK = "apm_ok";
    public static final String SAMPLE_GAME_STARTED = "game_started";
    public static final String SAMPLE_GAME_ENDED = "game_ended";
    public static final String SAMPLE_AUTO_SAVE_ON = "auto_save_on";
    public static final String SAMPLE_AUTO_SAVE_OFF = "auto_save_off";
    public static final String SAMPLE_APM_ALERT_ON = "apm_alert_on";
    public static final String SAMPLE_APM_ALERT_OFF = "apm_alert_off";
    public static final String SAMPLE_RECORDING_STARTED = "recording_started";
    public static final String SAMPLE_RECORDING_STOPPED = "recording_stopped";

    public static VoiceDescription getVoiceDescription(String string) {
        VoiceDescription[] voiceDescriptionArray = VOICE_DESCRIPTIONS;
        int n = VOICE_DESCRIPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            VoiceDescription voiceDescription = voiceDescriptionArray[n2];
            if (voiceDescription.name.equals(string)) {
                return voiceDescription;
            }
            ++n2;
        }
        return null;
    }

    public static boolean playSoundSample(String string, boolean bl) {
        return Sounds.playSoundSample(string, bl, Settings.getInt("settings.misc.soundVolume"));
    }

    public static boolean playSoundSample(String string, boolean bl, int n) {
        InputStream inputStream = Sounds.class.getResourceAsStream(String.valueOf(Settings.getString("settings.voice")) + "/" + string + ".mp3");
        if (inputStream == null) {
            if (!DEFAULT_THEME.equals(Settings.getString("settings.voice"))) {
                inputStream = Sounds.class.getResourceAsStream("google/" + string + ".mp3");
            }
            if (inputStream == null) {
                return false;
            }
        }
        return Sounds.playSound(inputStream, bl, n);
    }

    public static boolean playSound(InputStream inputStream, boolean bl, int n) {
        try {
            Object object;
            final AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            final AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            final SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioFormat2));
            sourceDataLine.open(audioFormat2);
            if (sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                object = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                ((FloatControl)object).setValue(20.0f * (float)Math.log10((double)n / 100.0));
            }
            object = new NormalThread("Sound player"){

                @Override
                public void run() {
                    try {
                        try {
                            int n;
                            sourceDataLine.start();
                            byte[] byArray = new byte[65536];
                            while ((n = audioInputStream2.read(byArray)) > 0) {
                                sourceDataLine.write(byArray, 0, n);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            sourceDataLine.drain();
                            sourceDataLine.stop();
                            sourceDataLine.close();
                            try {
                                audioInputStream2.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                audioInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        sourceDataLine.drain();
                        sourceDataLine.stop();
                        sourceDataLine.close();
                        try {
                            audioInputStream2.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            audioInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            ((Thread)object).start();
            if (bl) {
                ((Thread)object).join();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static class VoiceDescription {
        public final String name;
        public final String displayName;
        public final String authorFirstName;
        public final String authorLastName;
        public final String language;

        public VoiceDescription(String string, String string2, String string3, String string4, String string5) {
            this.name = string;
            this.displayName = string2;
            this.authorFirstName = string3;
            this.authorLastName = string4;
            this.language = string5;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

