/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.CustomComboBoxModel;
import hu.belicza.andras.sc2gears.ui.components.ReplayInfoBox;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.Pair;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;

public class GuiUtils {
    public static final int MOUSE_BUTTON_LEFT = 1;
    public static final int MOUSE_BUTTON_RIGHT = 3;
    public static final int MOUSE_BUTTON_MIDDLE = 2;
    public static FileFilter SC2_REPLAY_FILTER;
    public static FileFilter SC2_REPLAY_SOURCE_FILE_FILTER;
    public static FileFilter SC2_REPLAY_LIST_FILE_FILTER;
    public static FileFilter ZIP_FILE_FILTER;
    public static FileFilter TEXT_FILE_FILTER;
    public static FileFilter MOUSE_PRINT_DATA_FILE_FILTER;
    public static FileFilter SEARCH_FILTER_FILE_FILTER;
    public static final FileView SC2GEARS_FILE_VIEW;

    static {
        SC2GEARS_FILE_VIEW = new FileView(){

            @Override
            public Icon getIcon(File file) {
                if (file.isDirectory()) {
                    return null;
                }
                if (SC2_REPLAY_FILTER.accept(file)) {
                    return Icons.SC2;
                }
                if (SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                    return Icons.FOLDERS_STACK;
                }
                if (SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                    return Icons.TABLE_EXCEL;
                }
                if (ZIP_FILE_FILTER.accept(file)) {
                    return Icons.DOCUMENT_ZIPPER;
                }
                if (MOUSE_PRINT_DATA_FILE_FILTER.accept(file)) {
                    return Icons.FINGERPRINT;
                }
                if (SEARCH_FILTER_FILE_FILTER.accept(file)) {
                    return Icons.EDIT_COLUMN;
                }
                return null;
            }
        };
    }

    private GuiUtils() {
    }

    public static void initFileFilters() {
        SC2_REPLAY_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayFiles"), "SC2Replay");
        SC2_REPLAY_SOURCE_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplaySources"), ".sc2repsrc".substring(1));
        SC2_REPLAY_LIST_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayLists"), ".csv".substring(1));
        ZIP_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.zipFiles"), "zip");
        TEXT_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.textFiles"), "txt");
        MOUSE_PRINT_DATA_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.mousePrintDataFiles"), "smpd");
        SEARCH_FILTER_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.searchFilterFiles"), ".filters".substring(1));
    }

    public static void updateButtonText(AbstractButton abstractButton, String string, Object ... objectArray) {
        Pair<String, Character> pair = Language.getTextAndMnemonic(string, objectArray);
        abstractButton.setText((String)pair.value1);
        if (pair.value2 != null) {
            abstractButton.setMnemonic(((Character)pair.value2).charValue());
        }
    }

    public static JPanel wrapInPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.add(jComponent);
        return jPanel;
    }

    public static JPanel wrapInPanelLeftAligned(JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static JPanel wrapInBorderPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jComponent);
        return jPanel;
    }

    public static void centerWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void centerWindowToWindow(Window window, Window window2) {
        window.setLocation(window2.getX() + (window2.getWidth() - window.getWidth()) / 2, window2.getY() + (window2.getHeight() - window.getHeight()) / 2);
    }

    public static boolean setLAF(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if (lookAndFeelInfo.getName().equals(string)) {
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Failed to set " + lookAndFeelInfo.getName() + " look and feel!");
                    exception.printStackTrace(System.err);
                    return false;
                }
            }
            ++n2;
        }
        System.err.println(String.valueOf(string) + " look and feel was not found!");
        return false;
    }

    public static void packTable(JTable jTable) {
        int n = jTable.getColumnCount() - 1;
        while (n >= 0) {
            int n2 = 70;
            int n3 = jTable.getRowCount() - 1;
            while (n3 >= 0) {
                n2 = Math.max(n2, jTable.getRowMargin() + jTable.getCellRenderer((int)n3, (int)n).getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)n3, (int)n), (boolean)false, (boolean)false, (int)n3, (int)n).getPreferredSize().width);
                --n3;
            }
            jTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
            --n;
        }
    }

    public static void packTable(JTable jTable, int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            int n4 = 10;
            int n5 = jTable.getRowCount() - 1;
            while (n5 >= 0) {
                n4 = Math.max(n4, jTable.getRowMargin() + jTable.getCellRenderer((int)n5, (int)n3).getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)n5, (int)n3), (boolean)false, (boolean)false, (int)n5, (int)n3).getPreferredSize().width);
                --n5;
            }
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n3);
            tableColumn.setMaxWidth(n4);
            tableColumn.setMinWidth(n4);
            ++n2;
        }
    }

    public static UIManager.LookAndFeelInfo[] getSortedInstalledLAFInfos() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        Arrays.sort(lookAndFeelInfoArray, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo lookAndFeelInfo, UIManager.LookAndFeelInfo lookAndFeelInfo2) {
                String[] stringArray;
                String[] stringArray2 = stringArray = new String[]{"Nimbus", "Metal", "Windows", "Squareness", "Napkin", "Office 2003", "Office XP", "Visual Studio 2005", "EaSynthLookAndFeel"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    if (string.equals(lookAndFeelInfo.getName())) {
                        return -1;
                    }
                    if (string.equals(lookAndFeelInfo2.getName())) {
                        return 1;
                    }
                    ++n2;
                }
                return 0;
            }
        });
        return lookAndFeelInfoArray;
    }

    public static void addNewTab(String string, Icon icon, boolean bl, JTabbedPane jTabbedPane, JComponent jComponent, Runnable runnable) {
        GuiUtils.addNewTab(string, icon, bl, jTabbedPane, jComponent, true, runnable);
    }

    public static void addNewTab(String string, Icon icon, boolean bl, final JTabbedPane jTabbedPane, final JComponent jComponent, boolean bl2, final Runnable runnable) {
        JLabel jLabel;
        jTabbedPane.addTab(null, jComponent);
        Character c = null;
        if (bl2) {
            int n = jTabbedPane.getTabCount();
            if (n == 1) {
                c = Character.valueOf('1');
            } else {
                int n2 = jTabbedPane.getMnemonicAt(n - 2);
                if (n2 >= 0 && n2 < 57) {
                    c = Character.valueOf((char)(n2 + 1));
                }
            }
        }
        if (c != null) {
            jLabel = new JLabel(c + " " + string, icon, 2);
            jLabel.setDisplayedMnemonicIndex(0);
            jTabbedPane.setMnemonicAt(jTabbedPane.getTabCount() - 1, c.charValue());
        } else {
            jLabel = new JLabel(string, icon, 2);
        }
        if (bl) {
            final Box box = Box.createHorizontalBox();
            box.add(jLabel);
            final Holder holder = new Holder();
            final AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    jTabbedPane.remove(jComponent);
                    jTabbedPane.removeMouseListener((MouseListener)holder.value);
                }
            };
            JLabel jLabel2 = new JLabel(Icons.CROSS_SMALL);
            jLabel2.setToolTipText(Language.getText("tab.close.tooltop"));
            jLabel2.setCursor(Cursor.getPredefinedCursor(12));
            jLabel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    abstractAction.actionPerformed(null);
                }
            });
            box.add(jLabel2);
            holder.value = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 2 && box.contains(SwingUtilities.convertPoint(jTabbedPane, mouseEvent.getPoint(), box))) {
                        abstractAction.actionPerformed(null);
                    }
                }
            };
            jTabbedPane.addMouseListener((MouseListener)holder.value);
            Object object = new Object();
            jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(87, 2), object);
            jComponent.getActionMap().put(object, abstractAction);
            jTabbedPane.setTabComponentAt(jTabbedPane.getTabCount() - 1, box);
        } else {
            jTabbedPane.setTabComponentAt(jTabbedPane.getTabCount() - 1, jLabel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
    }

    public static void appendNewLineWithTimestamp(JTextArea jTextArea, String string) {
        jTextArea.append(Language.formatDateTime(new Date()));
        jTextArea.append(" - ");
        GuiUtils.appendNewLine(jTextArea, string);
    }

    public static void appendNewLine(JTextArea jTextArea, String string) {
        jTextArea.append(string);
        jTextArea.append("\n");
        jTextArea.setCaretPosition(jTextArea.getDocument().getLength());
    }

    public static JLabel createErrorDetailsLink() {
        JLabel jLabel = GeneralUtils.createLinkStyledLabel(Language.getText("general.errorDetails"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MainFrame.INSTANCE.viewSystemMessagesMenuItem.doClick();
            }
        });
        return jLabel;
    }

    public static void showErrorDialog(Object object, Frame ... frameArray) {
        String string = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(frameArray.length == 0 ? MainFrame.INSTANCE : frameArray[0], new Object[]{object, new JLabel(" "), GuiUtils.createErrorDetailsLink()}, Language.getText("general.errorTitle"), -1, 0, null, new Object[]{string}, string);
    }

    public static void showInfoDialog(Object object, Frame ... frameArray) {
        String string = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(frameArray.length == 0 ? MainFrame.INSTANCE : frameArray[0], object, Language.getText("general.infoTitle"), -1, 1, null, new Object[]{string}, string);
    }

    public static int showConfirmDialog(Object object, boolean bl, Frame ... frameArray) {
        String string = Language.getText("general.yesButton");
        return JOptionPane.showOptionDialog(frameArray.length == 0 ? MainFrame.INSTANCE : frameArray[0], object, Language.getText("general.confirmationTitle"), -1, bl ? 2 : 3, null, new Object[]{string, Language.getText(bl ? "general.cancelButton" : "general.noButton")}, string);
    }

    public static JComponent createReplayFilePreviewAccessory(JFileChooser jFileChooser) {
        final ReplayInfoBox replayInfoBox = new ReplayInfoBox();
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file == null || file.isDirectory()) {
                        return;
                    }
                    replayInfoBox.setReplayFile(file);
                }
            }
        });
        return replayInfoBox;
    }

    public static JCheckBox createCheckBox(String string, final String string2) {
        final JCheckBox jCheckBox = new JCheckBox(Language.getText(string), Settings.getBoolean(string2));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string2, jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String string, final String string2, Icon icon) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        GuiUtils.updateButtonText(jCheckBoxMenuItem, string, new Object[0]);
        if (icon != null) {
            jCheckBoxMenuItem.setIcon(icon);
        }
        jCheckBoxMenuItem.setSelected(Settings.getBoolean(string2));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string2, jCheckBoxMenuItem.isSelected());
            }
        });
        return jCheckBoxMenuItem;
    }

    public static JComboBox createComboBox(Object[] objectArray, String string) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            vector.add(object);
            ++n2;
        }
        return GuiUtils.createComboBox(vector, string, true);
    }

    public static JComboBox createComboBox(Vector<?> vector, final String string, boolean bl) {
        final JComboBox jComboBox = new JComboBox(new CustomComboBoxModel(vector));
        try {
            jComboBox.setSelectedIndex(Settings.getInt(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            jComboBox.setSelectedIndex(Settings.getDefaultInt(string));
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string, jComboBox.getSelectedIndex());
            }
        });
        if (bl) {
            jComboBox.putClientProperty("JComponent.sizeVariant", "small");
            jComboBox.updateUI();
        }
        return jComboBox;
    }

    public static JComboBox createPredefinedListComboBox(Settings.PredefinedList predefinedList) {
        return GuiUtils.createPredefinedListComboBox(predefinedList, true);
    }

    public static JComboBox createPredefinedListComboBox(final Settings.PredefinedList predefinedList, boolean bl) {
        final JComboBox jComboBox = new JComboBox(new CustomComboBoxModel((Vector<?>)Settings.getPredefinedListValues(predefinedList)));
        jComboBox.setEditable(true);
        jComboBox.setMaximumRowCount(20);
        jComboBox.setEditor(new ComboBoxEditor(){
            private final JTextField editorTextField = new JTextField(1);
            {
                this.editorTextField.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
                this.editorTextField.addActionListener(actionListener);
            }

            @Override
            public Component getEditorComponent() {
                return this.editorTextField;
            }

            @Override
            public Object getItem() {
                return this.editorTextField.getText();
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
                this.editorTextField.removeActionListener(actionListener);
            }

            @Override
            public void selectAll() {
                this.editorTextField.selectAll();
            }

            @Override
            public void setItem(Object object) {
                this.editorTextField.setText(object == null ? null : object.toString());
            }
        });
        if (bl) {
            GuiUtils.addEditListLinkToComboBoxPopup(jComboBox, new Runnable(){

                @Override
                public void run() {
                    new MiscSettingsDialog((Frame)MainFrame.INSTANCE, MiscSettingsDialog.SettingsTab.PREDEFINED_LISTS, predefinedList);
                    if (jComboBox.getModel() instanceof CustomComboBoxModel) {
                        ((CustomComboBoxModel)jComboBox.getModel()).fireContentsChanged(jComboBox);
                    }
                }
            });
        }
        return jComboBox;
    }

    public static void addEditListLinkToComboBoxPopup(final JComboBox jComboBox, final Runnable runnable) {
        Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
        if (accessible instanceof JPopupMenu) {
            JPanel jPanel = new JPanel(new FlowLayout(2, 3, 1));
            JLabel jLabel = GeneralUtils.createLinkStyledLabel(Language.getText("general.editList"));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    jComboBox.hidePopup();
                    runnable.run();
                }
            });
            jPanel.add(jLabel);
            ((JPopupMenu)accessible).add(jPanel);
        }
    }

    public static void makeComponentDragScrollable(final JComponent jComponent) {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            int dragStartX;
            int dragStartY;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    this.dragStartX = mouseEvent.getXOnScreen();
                    this.dragStartY = mouseEvent.getYOnScreen();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    Rectangle rectangle = jComponent.getVisibleRect();
                    rectangle.x += (this.dragStartX - mouseEvent.getXOnScreen()) * 2;
                    rectangle.y += (this.dragStartY - mouseEvent.getYOnScreen()) * 2;
                    jComponent.scrollRectToVisible(rectangle);
                    this.dragStartX = mouseEvent.getXOnScreen();
                    this.dragStartY = mouseEvent.getYOnScreen();
                }
            }
        };
        jComponent.addMouseListener(mouseAdapter);
        jComponent.addMouseMotionListener(mouseAdapter);
    }

    public static JComponent changeFontToBold(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(1));
        return jComponent;
    }

    public static JComponent changeFontToItalic(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(2));
        return jComponent;
    }

    public static JTable createNonEditableTable() {
        return new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }

    public static JLabel createRaceIconLabel(ReplayConsts.Race race) {
        JLabel jLabel = new JLabel(Icons.getRaceIcon(race));
        jLabel.setToolTipText(race == null ? "" : race.stringValue);
        return jLabel;
    }

    public static JComponent createNameTemplateEditor(final JComboBox jComboBox, String ... stringArray) {
        JComponent jComponent;
        Box box = Box.createVerticalBox();
        int n = 1;
        while (n <= 4) {
            if (n == 2 || n == 4) {
                box.add(Box.createVerticalStrut(10));
            }
            jComponent = new JPanel(new FlowLayout(0, 5, 0));
            jComponent.add(new JLabel(Language.getText("replayops.renameDialog.description" + n)));
            box.add(jComponent);
            ++n;
        }
        Object[][][] objectArrayArray = new Object[5][][];
        Object[][] objectArrayArray2 = new Object[8][];
        objectArrayArray2[0] = new Object[]{"/f", "replayops.renameDialog.symbol.format", Icons.FORMAT};
        objectArrayArray2[1] = new Object[]{"/T", "replayops.renameDialog.symbol.raceMatchup", Icons.RACE_ANY};
        objectArrayArray2[2] = new Object[]{"/d", "replayops.renameDialog.symbol.date", Icons.CALENDAR_SELECT};
        objectArrayArray2[3] = new Object[]{"/D", "replayops.renameDialog.symbol.dateTime", Icons.CALENDAR_BLUE};
        Object[] objectArray = new Object[3];
        objectArray[0] = "/Y";
        objectArray[1] = "replayops.renameDialog.symbol.gameType";
        objectArrayArray2[4] = objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "/G";
        objectArray2[1] = "replayops.renameDialog.symbol.gateway";
        objectArrayArray2[5] = objectArray2;
        objectArrayArray2[6] = new Object[]{"/l", "replayops.renameDialog.symbol.gameLength", Icons.CLOCK};
        objectArrayArray2[7] = new Object[]{"/L", "replayops.renameDialog.symbol.gameLengthLong", Icons.CLOCK};
        objectArrayArray[0] = objectArrayArray2;
        Object[][] objectArrayArray3 = new Object[8][];
        objectArrayArray3[0] = new Object[]{"<>", "replayops.renameDialog.symbol.playerInfoBlock", Icons.USERS};
        objectArrayArray3[1] = new Object[]{"/px", "replayops.renameDialog.symbol.playerName", Icons.USER};
        objectArrayArray3[2] = new Object[]{"/rx", "replayops.renameDialog.symbol.playerRaceFirstLetter", Icons.RACE_ALL};
        objectArrayArray3[3] = new Object[]{"/Rx", "replayops.renameDialog.symbol.playerRace", Icons.RACE_ALL};
        Object[] objectArray3 = new Object[3];
        objectArray3[0] = "/Ax";
        objectArray3[1] = "replayops.renameDialog.symbol.playerApm";
        objectArrayArray3[4] = objectArray3;
        objectArrayArray3[5] = new Object[]{"/Wx", "replayops.renameDialog.symbol.playerResult", Icons.TROPHY};
        objectArrayArray3[6] = new Object[]{"/q", "replayops.renameDialog.symbol.allPlayerNames", Icons.USERS};
        objectArrayArray3[7] = new Object[]{"/g", "replayops.renameDialog.symbol.allPlayerNamesGrouped", Icons.USERS};
        objectArrayArray[1] = objectArrayArray3;
        objectArrayArray[2] = new Object[][]{{"/m", "replayops.renameDialog.symbol.mapName", Icons.MAP}, {"/Mx", "replayops.renameDialog.symbol.firstWordsOfMapName", Icons.MAP_PENCIL}, {"/Nxy", "replayops.renameDialog.symbol.firstLettersOfMapName", Icons.MAP_PENCIL}, {"/S", "replayops.renameDialog.symbol.mapNameAcronym", Icons.MAP_PENCIL}};
        objectArrayArray[3] = new Object[][]{{"/c", "replayops.renameDialog.symbol.counter", Icons.COUNTER_RESET}, {"/Cx", "replayops.renameDialog.symbol.counter2", Icons.COUNTER_RESET}, {"/Fx", "replayops.renameDialog.symbol.replayCounter", Icons.COUNTER_COUNT_UP}};
        objectArrayArray[4] = new Object[][]{{"\\", "replayops.renameDialog.symbol.subfolderSeparator", Icons.FOLDER_TREE}, {"/n", "replayops.renameDialog.symbol.name", Icons.CARD}, {"/e", "replayops.renameDialog.symbol.extension", Icons.SC2}, {"/h", "replayops.renameDialog.symbol.md5", Icons.DOCUMENT_BINARY}};
        Object[][][] objectArrayArray4 = objectArrayArray;
        jComponent = new JTabbedPane();
        String[] stringArray2 = new String[]{"replayops.renameDialog.tab.replayInfo", "replayops.renameDialog.tab.players", "replayops.renameDialog.tab.map", "replayops.renameDialog.tab.counters", "replayops.renameDialog.tab.general"};
        Icon[] iconArray = new Icon[5];
        iconArray[0] = Icons.SC2;
        iconArray[1] = Icons.USERS;
        iconArray[2] = Icons.MAP;
        iconArray[3] = Icons.COUNTER_COUNT_UP;
        Icon[] iconArray2 = iconArray;
        ArrayList<JButton> arrayList = new ArrayList<JButton>(32);
        int n2 = 0;
        while (n2 < objectArrayArray4.length) {
            Object[][] object = objectArrayArray4[n2];
            Iterator iterator = Box.createVerticalBox();
            int n3 = 0;
            while (n3 < object.length) {
                block12: {
                    Object object2;
                    String[] stringArray3 = stringArray;
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        object2 = stringArray3[n5];
                        if (!object[n3][0].equals(object2)) {
                            ++n5;
                            continue;
                        }
                        break block12;
                    }
                    object2 = Box.createHorizontalBox();
                    ((JComponent)object2).setAlignmentX(0.0f);
                    JButton jButton = new JButton((String)object[n3][0], (ImageIcon)object[n3][2]);
                    arrayList.add(jButton);
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
                                jTextField.getDocument().insertString(jTextField.getCaretPosition(), ((JButton)actionEvent.getSource()).getText(), null);
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                            jComboBox.requestFocusInWindow();
                        }
                    });
                    ((Container)object2).add(jButton);
                    ((Container)object2).add(Box.createHorizontalStrut(3));
                    if ("<>".equals(object[n3][0])) {
                        ((Container)object2).add(new JLabel(Language.getText((String)object[n3][1], TemplateEngine.PLAYER_INFO_SYMBOLS_STRING)));
                    } else if ("/Wx".equals(object[n3][0])) {
                        ((Container)object2).add(new JLabel(Language.getText((String)object[n3][1], ReplayConsts.MatchResult.getDescription())));
                    } else {
                        ((Container)object2).add(new JLabel(Language.getText((String)object[n3][1])));
                    }
                    ((Container)((Object)iterator)).add((Component)object2);
                }
                ++n3;
            }
            GuiUtils.addNewTab(Language.getText(stringArray2[n2]), iconArray2[n2], false, (JTabbedPane)jComponent, GuiUtils.wrapInPanelLeftAligned(iterator), null);
            ++n2;
        }
        n2 = 0;
        for (JButton jButton : arrayList) {
            n2 = Math.max(n2, jButton.getPreferredSize().width);
        }
        for (JButton jButton : arrayList) {
            Dimension dimension = new Dimension(n2, jButton.getPreferredSize().height);
            jButton.setPreferredSize(dimension);
            jButton.setMaximumSize(dimension);
        }
        box.add(jComponent);
        box.add(jComboBox);
        return box;
    }

    public static JLabel createIconLabelButton(ImageIcon imageIcon, String string) {
        final JLabel jLabel = new JLabel(imageIcon);
        jLabel.setToolTipText(Language.getText(string));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        });
        return jLabel;
    }

    public static Icon getColorIcon(final Color color) {
        final Color color2 = GeneralUtils.getInvertedColor(color);
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(color);
                graphics2D.fillRoundRect(n + 1, n2, 8, 15, 8, 8);
                graphics2D.setColor(color2);
                graphics2D.drawRoundRect(n + 1, n2, 8, 15, 8, 8);
            }

            @Override
            public int getIconWidth() {
                return 10;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    public static void alignBox(Box box, int n) {
        int n2 = 0;
        while (n2 < n) {
            Box box2;
            int n3 = 0;
            int n4 = box.getComponentCount() - 1;
            while (n4 >= 0) {
                if (box.getComponent(n4) instanceof Box) {
                    box2 = (Box)box.getComponent(n4);
                    n3 = Math.max(n3, box2.getComponent((int)n2).getPreferredSize().width);
                }
                --n4;
            }
            n4 = box.getComponentCount() - 1;
            while (n4 >= 0) {
                if (box.getComponent(n4) instanceof Box) {
                    box2 = (Box)box.getComponent(n4);
                    box2.getComponent(n2).setPreferredSize(new Dimension(n3, box2.getComponent((int)n2).getPreferredSize().height));
                }
                --n4;
            }
            ++n2;
        }
    }

    public static void setComponentTreeEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof JPanel || component instanceof Box) {
            Container container = (Container)component;
            int n = container.getComponentCount() - 1;
            while (n >= 0) {
                GuiUtils.setComponentTreeEnabled(container.getComponent(n), bl);
                --n;
            }
        }
    }

    public static JPanel createRightAlignedInfoWrapperPanel(JLabel jLabel, int n) {
        GuiUtils.changeFontToItalic(jLabel);
        jLabel.setFont(jLabel.getFont().deriveFont((float)(jLabel.getFont().getSize() - 2)));
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, n));
        jPanel.add(jLabel);
        return jPanel;
    }

    public static JEditorPane createEditorPane() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GeneralUtils.showURLInBrowser(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
        Object object = new Object();
        jEditorPane.getInputMap(0).put(KeyStroke.getKeyStroke(79, 192), object);
        jEditorPane.getActionMap().put(object, null);
        return jEditorPane;
    }
}

