/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.importing.ReplaySpecification;
import hu.belicza.andras.sc2gears.services.ApmAlert;
import hu.belicza.andras.sc2gears.services.GlobalHotkeys;
import hu.belicza.andras.sc2gears.services.MousePrintRecorder;
import hu.belicza.andras.sc2gears.services.ReplayAutoSaver;
import hu.belicza.andras.sc2gears.services.UpdateChecker;
import hu.belicza.andras.sc2gears.services.plugins.PluginManager;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.AboutDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.DiagnosticToolDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.GameTimeRealTimeConverterDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ImportBODialog;
import hu.belicza.andras.sc2gears.ui.dialogs.KeyboardShortcutsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MySharedReplaysDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.NewToSc2gearsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.PluginManagerDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.RenameItemDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.Sc2gearsDatabaseDownloaderDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ShareReplayDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.SystemMessagesDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.TipsDialog;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MultiRepAnalysis;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import hu.belicza.andras.sc2gears.ui.moduls.startpage.StartPage;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.LeetTranslator;
import hu.belicza.andras.sc2gears.util.ProfileCache;
import hu.belicza.andras.sc2gears.util.ReplayCache;
import hu.belicza.andras.sc2gearspluginapi.impl.Hotkey;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private static final int MAX_RECENT_REPLAYS = 15;
    public static MainFrame INSTANCE;
    private TrayIcon trayIcon;
    private JPopupMenu trayIconPopupMenu;
    private final JSplitPane mainSplitPane = new JSplitPane(1, true);
    private final JCheckBoxMenuItem enableReplayAutoSaveTrayMenuItem = new JCheckBoxMenuItem(Language.getText("tray.enableReplayAutoSave"), Icons.DATABASE_SAVE, Settings.getBoolean("settings.enableReplayAutoSave"));
    private final JCheckBoxMenuItem enableApmAlertTrayMenuItem = new JCheckBoxMenuItem(Language.getText("tray.enableApmAlert"), Icons.ALARM_CLOCK, Settings.getBoolean("settings.enableApmAlert"));
    private final JMenuItem openLastReplayMenuItem = new JMenuItem(Icons.CHART);
    private final JMenu recentReplaysMenu = new JMenu();
    private final JCheckBoxMenuItem enableReplayAutoSaveMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.enableReplayAutoSave", "settings.enableReplayAutoSave", Icons.DATABASE_SAVE);
    private final JCheckBoxMenuItem enableApmAlertMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.enableApmAlert", "settings.enableApmAlert", Icons.ALARM_CLOCK);
    private final JMenuItem minimizeToTrayMenuItem = new JMenuItem(Icons.APPLICATION_DOCK_TAB);
    private final JMenuItem startMinimizedToTrayMenuItem = GuiUtils.createCheckBoxMenuItem("menu.window.startMinimimizedToTray", "window.startMinimizedToTray", Icons.APPLICATION_DOCK_TAB);
    public final JMenuItem viewSystemMessagesMenuItem = new JMenuItem(Icons.REPORT_EXCLAMATION);
    private final JMenuItem checkUpdatesMenuItem = new JMenuItem(Icons.ARROW_CIRCLE_DOUBLE);
    private final Box navigationBox = Box.createVerticalBox();
    private final JScrollPane navigationBar = new JScrollPane();
    private final JTree navigationTree = new JTree();
    private final DefaultMutableTreeNode repAnalNode = new DefaultMutableTreeNode(Language.getText("module.repAnalyzer.name"));
    private final DefaultMutableTreeNode newRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode multiRepAnalNode = new DefaultMutableTreeNode(Language.getText("module.multiRepAnal.name"));
    private final DefaultMutableTreeNode newMultiRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSearchNode = new DefaultMutableTreeNode(Language.getText("module.repSearch.name"));
    private final DefaultMutableTreeNode newRepSearchNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSourcesNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.name"));
    public final DefaultMutableTreeNode sc2AutoRepsRepSourceNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.sc2AutoReps.name"));
    public final DefaultMutableTreeNode autoSavedRepsRepSourceNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.autoSavedReps.name"));
    public final DefaultMutableTreeNode emptyRepSourceNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final DefaultMutableTreeNode repListsNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repLists.name"));
    public final DefaultMutableTreeNode emptyRepListNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final JDesktopPane desktopPane = new JDesktopPane();
    private JMenuItem hideTrayMenuItem;
    private JMenuItem restoreTrayMenuItem;
    private boolean windowSizeInitialized;
    private StartPage startPage;
    private ReplayAutoSaver replayAutoSaver;
    private static final AtomicInteger backgroundJobsCount;

    static {
        backgroundJobsCount = new AtomicInteger();
    }

    public MainFrame(String[] stringArray) {
        super("Sc2gears 7.0.1");
        if (INSTANCE != null) {
            throw new RuntimeException("Only one instance of MainFrame is allowed!");
        }
        INSTANCE = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Settings.getBoolean("window.minimizeToTrayOnClose")) {
                    MainFrame.this.minimizeToTrayMenuItem.doClick(0);
                } else {
                    MainFrame.this.exit(false, new String[0]);
                }
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (Settings.getBoolean("window.minimizeToTrayOnMinimize")) {
                    MainFrame.this.minimizeToTrayMenuItem.doClick(0);
                }
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        this.installTrayIcon();
        this.buildGUI();
        GlobalHotkeys.addHotkey(new Hotkey(16387, 84){

            @Override
            public void run() {
                MainFrame.this.restoreMainFrame();
            }
        });
        GlobalHotkeys.addHotkey(new Hotkey(16387, 77){

            @Override
            public void run() {
                if (MousePrintRecorder.isRecording()) {
                    MousePrintRecorder.stopRecording();
                    if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("recording_stopped", false);
                    }
                } else {
                    MousePrintRecorder.startRecording();
                    if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("recording_started", false);
                    }
                }
            }
        });
        GeneralUtils.setToolTipDelays();
        if (stringArray.length == 0 && this.trayIcon != null && this.startMinimizedToTrayMenuItem.isSelected()) {
            this.hideMainFrame();
            this.trayIcon.displayMessage(null, Language.getText("trayIcon.startedMinimized", "Sc2gears"), TrayIcon.MessageType.INFO);
        } else {
            this.restoreMainFrame();
        }
        if (Settings.getBoolean("settings.checkUpdatesOnStartup")) {
            this.checkUpdatesMenuItem.doClick(0);
        }
        this.rebuildRecentReplaysMenu();
        if (Settings.getBoolean("settings.showStartPageOnStartup")) {
            this.showStartPage(false);
        }
        try {
            Class.forName(ProfileCache.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        PluginManager.startEnabledPlugins();
        if (Settings.getBoolean("settings.enableGlobalHotkeys")) {
            GlobalHotkeys.activate();
        }
        if (stringArray.length > 0) {
            this.openArguments(stringArray);
        }
        if (this.startPage != null) {
            this.startPage.refresh();
        }
        if (Settings.getBoolean("showNewToSc2gearsDialogOnStartup")) {
            new NewToSc2gearsDialog();
        }
        try {
            Class.forName(ReplayCache.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.setupDropTarget();
        if (Settings.getBoolean("settings.misc.preloadSc2IconsOnStartup")) {
            this.preloadSc2Icons();
        }
    }

    private void showStartPage(boolean bl) {
        if (this.startPage == null) {
            this.startPage = new StartPage();
            this.addNewInternalFrame(this.startPage);
            this.startPage.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    MainFrame.this.startPage = null;
                }
            });
            if (bl) {
                this.startPage.refresh();
            }
        } else {
            this.selectFrame(this.startPage);
        }
    }

    public void openArguments(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    File file = new File(string);
                    if (GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                    } else if (GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                    } else {
                        MainFrame.this.openReplayFile(new File(string));
                    }
                    ++n2;
                }
            }
        });
    }

    private void preloadSc2Icons() {
        Enum enum_;
        Enum[] enumArray = ReplayConsts.Building.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            Icons.getBuildingIcon((ReplayConsts.Building)enum_, IconHandler.Size.BIG);
            ++n2;
        }
        enumArray = ReplayConsts.Unit.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            Icons.getUnitIcon((ReplayConsts.Unit)enum_, IconHandler.Size.BIG);
            ++n2;
        }
        enumArray = ReplayConsts.AbilityGroup.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)enum_, IconHandler.Size.BIG);
            ++n2;
        }
        enumArray = ReplayConsts.Research.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            Icons.getResearchIcon((ReplayConsts.Research)enum_, IconHandler.Size.BIG);
            ++n2;
        }
        enumArray = ReplayConsts.Upgrade.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            Icons.getUpgradeIcon((ReplayConsts.Upgrade)enum_, IconHandler.Size.BIG);
            ++n2;
        }
    }

    private void setupDropTarget() {
        new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor dataFlavor = dataFlavorArray[n2];
                    if (dataFlavor.isFlavorJavaFileListType()) {
                        dropTargetDropEvent.acceptDrop(3);
                        try {
                            List list = (List)transferable.getTransferData(dataFlavor);
                            ArrayList<File> arrayList = new ArrayList<File>();
                            for (File file : list) {
                                if (file.isDirectory()) {
                                    arrayList.add(file);
                                    continue;
                                }
                                if (GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                                    MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                                    continue;
                                }
                                if (GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                                    MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                                    continue;
                                }
                                arrayList.add(file);
                            }
                            if (arrayList.size() == 1 && ((File)arrayList.get(0)).isFile()) {
                                MainFrame.this.openReplayFile((File)arrayList.get(0));
                            } else if (arrayList.size() > 0) {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, null, arrayList.toArray(new File[arrayList.size()])});
                            }
                            dropTargetDropEvent.dropComplete(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            dropTargetDropEvent.rejectDrop();
                        }
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    private void installTrayIcon() {
        if (SystemTray.isSupported()) {
            TrayIcon trayIcon = new TrayIcon(Icons.SC2GEARS.getImage(), Language.getText("trayIcon.running", "Sc2gears"));
            trayIcon.setImageAutoSize(true);
            this.trayIconPopupMenu = new JPopupMenu();
            this.hideTrayMenuItem = new JMenuItem(Language.getText("tray.hide"), Icons.APPLICATION_DOCK_TAB);
            this.hideTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.hideMainFrame();
                }
            });
            this.trayIconPopupMenu.add(this.hideTrayMenuItem);
            this.restoreTrayMenuItem = new JMenuItem(Language.getText("tray.restore"), Icons.APPLICATION_RESIZE);
            this.restoreTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            this.trayIconPopupMenu.add(this.restoreTrayMenuItem);
            this.trayIconPopupMenu.addSeparator();
            this.enableReplayAutoSaveTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.enableReplayAutoSaveMenuItem.doClick();
                }
            });
            this.trayIconPopupMenu.add(this.enableReplayAutoSaveTrayMenuItem);
            if (ApmAlert.supported) {
                this.enableApmAlertTrayMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainFrame.this.enableApmAlertMenuItem.doClick();
                    }
                });
            } else {
                this.enableApmAlertTrayMenuItem.setEnabled(false);
            }
            this.trayIconPopupMenu.add(this.enableApmAlertTrayMenuItem);
            this.trayIconPopupMenu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(Language.getText("tray.openLastReplay"), Icons.CHART);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                    MainFrame.this.openLastReplayFile();
                }
            });
            this.trayIconPopupMenu.add(jMenuItem);
            this.trayIconPopupMenu.addSeparator();
            JMenuItem jMenuItem2 = new JMenuItem(Language.getText("tray.startStarCraft2"), Icons.SC2);
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralUtils.startStarCraftII();
                }
            });
            this.trayIconPopupMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(Language.getText("tray.startStarCraft2Editor"), Icons.SC2_EDITOR);
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralUtils.startStarCraftIIEditor();
                }
            });
            this.trayIconPopupMenu.add(jMenuItem3);
            this.trayIconPopupMenu.addSeparator();
            JMenuItem jMenuItem4 = new JMenuItem(Language.getText("tray.exit"), Icons.DOOR_OPEN_IN);
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.exit(false, new String[0]);
                }
            });
            this.trayIconPopupMenu.add(jMenuItem4);
            try {
                SystemTray.getSystemTray().add(trayIcon);
                this.trayIcon = trayIcon;
                trayIcon.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainFrame.this.restoreMainFrame();
                    }
                });
                final JDialog jDialog = new JDialog();
                jDialog.setUndecorated(true);
                jDialog.setAlwaysOnTop(true);
                this.trayIconPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        jDialog.setVisible(false);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        jDialog.setVisible(false);
                    }
                });
                trayIcon.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            jDialog.setLocation(mouseEvent.getX(), mouseEvent.getY() - ((MainFrame)MainFrame.this).trayIconPopupMenu.getPreferredSize().height);
                            jDialog.setVisible(true);
                            MainFrame.this.trayIconPopupMenu.show(jDialog.getContentPane(), 0, 0);
                            jDialog.toFront();
                        }
                    }
                });
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    private void buildGUI() {
        this.buildNavigationBar();
        this.mainSplitPane.setDividerSize(6);
        this.getContentPane().add(this.mainSplitPane);
        this.arrangeContent();
        this.buildMenuBar();
    }

    private void buildNavigationBar() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.repAnalNode.add(this.newRepAnalNode);
        defaultMutableTreeNode.add(this.repAnalNode);
        this.multiRepAnalNode.add(this.newMultiRepAnalNode);
        defaultMutableTreeNode.add(this.multiRepAnalNode);
        this.repSearchNode.add(this.newRepSearchNode);
        defaultMutableTreeNode.add(this.repSearchNode);
        defaultMutableTreeNode.add(this.repSourcesNode);
        defaultMutableTreeNode.add(this.repListsNode);
        this.refreshNavigationTree();
        ((DefaultTreeModel)this.navigationTree.getModel()).setRoot(defaultMutableTreeNode);
        this.navigationTree.setRootVisible(false);
        this.navigationTree.setShowsRootHandles(true);
        this.navigationTree.getSelectionModel().setSelectionMode(1);
        this.navigationTree.setCellRenderer(this.createTreeCellRenderer());
        if (Settings.getBoolean("navigation.useSmallFont")) {
            this.navigationTree.setFont(new Font(this.navigationTree.getFont().getName(), 0, 10));
        }
        this.expandAllNavigationRow();
        this.navigationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 || mouseEvent.getClickCount() == 2) {
                    TreePath treePath = MainFrame.this.navigationTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    final DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode || defaultMutableTreeNode2 == MainFrame.this.repListsNode) {
                        if (defaultMutableTreeNode == MainFrame.this.emptyRepSourceNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepSource"), new Frame[0]);
                        } else if (defaultMutableTreeNode == MainFrame.this.emptyRepListNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepList"), new Frame[0]);
                        } else {
                            File file;
                            File[] fileArray;
                            if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode) {
                                    fileArray = GeneralUtils.getAutoRepFolderList().toArray(new File[0]);
                                    file = null;
                                } else if (defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    file = new File(Settings.getString("settings.folders.replayAutoSave"));
                                    fileArray = null;
                                } else {
                                    file = new File("User Content/Replay sources", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".sc2repsrc");
                                    fileArray = null;
                                }
                            } else {
                                file = new File("User Content/Replay lists", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".csv");
                                fileArray = null;
                            }
                            if (mouseEvent.getButton() == 3) {
                                Object object;
                                Object object2;
                                MainFrame.this.navigationTree.setSelectionPath(treePath);
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                JMenuItem jMenuItem = new JMenuItem(Icons.CHART_UP_COLOR);
                                GuiUtils.updateButtonText(jMenuItem, "navigationTree.popup.openInMultiRepAnalysis", new Object[0]);
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                            File[] fileArray3;
                                            MainFrame mainFrame = MainFrame.this;
                                            DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newMultiRepAnalNode;
                                            Object[] objectArray = new Object[3];
                                            objectArray[0] = null;
                                            objectArray[1] = null;
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                fileArray3 = fileArray;
                                            } else {
                                                File[] fileArray2 = new File[1];
                                                fileArray3 = fileArray2;
                                                fileArray2[0] = file;
                                            }
                                            objectArray[2] = fileArray3;
                                            mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                        } else if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newMultiRepAnalNode, new Object[]{file, null, null});
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newMultiRepAnalNode, new Object[]{null, file, null});
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem);
                                JMenu jMenu = new JMenu(Language.getText("navigationTree.popup.applyFilter"));
                                jMenu.setIcon(Icons.BINOCULAR_ARROW);
                                String[] stringArray = new File("User Content/Search filters").list(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File file, String string) {
                                        return string.toLowerCase().endsWith(".filters");
                                    }
                                });
                                if (stringArray != null) {
                                    Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                                    object2 = stringArray;
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        object = object2[n2];
                                        JMenuItem jMenuItem2 = new JMenuItem(((String)object).substring(0, ((String)object).lastIndexOf(46)), Icons.EDIT_COLUMN);
                                        jMenuItem2.addActionListener(new ActionListener((String)object, defaultMutableTreeNode2, defaultMutableTreeNode, fileArray, file){
                                            private final /* synthetic */ String val$filterFileName;
                                            private final /* synthetic */ DefaultMutableTreeNode val$parentNode;
                                            private final /* synthetic */ DefaultMutableTreeNode val$clickedNode;
                                            private final /* synthetic */ File[] val$files;
                                            private final /* synthetic */ File val$file;
                                            {
                                                this.val$filterFileName = string;
                                                this.val$parentNode = defaultMutableTreeNode;
                                                this.val$clickedNode = defaultMutableTreeNode2;
                                                this.val$files = fileArray;
                                                this.val$file = file;
                                            }

                                            @Override
                                            public void actionPerformed(ActionEvent actionEvent) {
                                                File file = new File("User Content/Search filters", this.val$filterFileName);
                                                if (this.val$parentNode == MainFrame.this.repSourcesNode) {
                                                    if (this.val$clickedNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || this.val$clickedNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                                        File[] fileArray;
                                                        MainFrame mainFrame = MainFrame.this;
                                                        DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.newRepSearchNode;
                                                        Object[] objectArray = new Object[5];
                                                        objectArray[0] = null;
                                                        objectArray[1] = null;
                                                        if (this.val$clickedNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                            fileArray = this.val$files;
                                                        } else {
                                                            File[] fileArray2 = new File[1];
                                                            fileArray = fileArray2;
                                                            fileArray2[0] = this.val$file;
                                                        }
                                                        objectArray[2] = fileArray;
                                                        objectArray[3] = Boolean.TRUE;
                                                        objectArray[4] = file;
                                                        mainFrame.createNewInternalFrame(defaultMutableTreeNode, objectArray);
                                                    } else {
                                                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{this.val$file, null, null, Boolean.TRUE, file});
                                                    }
                                                } else {
                                                    MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, this.val$file, null, Boolean.TRUE, file});
                                                }
                                            }
                                        });
                                        jMenu.add(jMenuItem2);
                                        ++n2;
                                    }
                                }
                                jPopupMenu.add(jMenu);
                                object = new JMenuItem(Icons.BINOCULAR_ARROW);
                                GuiUtils.updateButtonText((AbstractButton)object, "navigationTree.popup.listAllReplays", new Object[0]);
                                ((AbstractButton)object).addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                                File[] fileArray3;
                                                MainFrame mainFrame = MainFrame.this;
                                                DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                                Object[] objectArray = new Object[3];
                                                objectArray[0] = null;
                                                objectArray[1] = null;
                                                if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                    fileArray3 = fileArray;
                                                } else {
                                                    File[] fileArray2 = new File[1];
                                                    fileArray3 = fileArray2;
                                                    fileArray2[0] = file;
                                                }
                                                objectArray[2] = fileArray3;
                                                mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                            } else {
                                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                                            }
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                                        }
                                    }
                                });
                                jPopupMenu.add((JMenuItem)object);
                                JMenuItem jMenuItem3 = new JMenuItem(Icons.EDIT_COLUMN);
                                GuiUtils.updateButtonText(jMenuItem3, "navigationTree.popup.openInRepSearchForFiltering", new Object[0]);
                                jMenuItem3.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                                File[] fileArray3;
                                                MainFrame mainFrame = MainFrame.this;
                                                DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                                Object[] objectArray = new Object[4];
                                                objectArray[0] = null;
                                                objectArray[1] = null;
                                                if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                    fileArray3 = fileArray;
                                                } else {
                                                    File[] fileArray2 = new File[1];
                                                    fileArray3 = fileArray2;
                                                    fileArray2[0] = file;
                                                }
                                                objectArray[2] = fileArray3;
                                                objectArray[3] = Boolean.FALSE;
                                                mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                            } else {
                                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null, null, Boolean.FALSE});
                                            }
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file, null, Boolean.FALSE});
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem3);
                                jPopupMenu.addSeparator();
                                JMenuItem jMenuItem4 = new JMenuItem(Icons.DOCUMENT_RENAME);
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    jMenuItem4.setEnabled(false);
                                }
                                GuiUtils.updateButtonText(jMenuItem4, "navigationTree.popup.renameItem", new Object[0]);
                                jMenuItem4.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        new RenameItemDialog(defaultMutableTreeNode, file);
                                    }
                                });
                                jPopupMenu.add(jMenuItem4);
                                object2 = new JMenuItem(Icons.CROSS);
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    ((JMenuItem)object2).setEnabled(false);
                                }
                                GuiUtils.updateButtonText((AbstractButton)object2, "navigationTree.popup.deleteItem", new Object[0]);
                                ((AbstractButton)object2).addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (GuiUtils.showConfirmDialog(Language.getText("navigationTree.popup.areYouSureToDelete", GeneralUtils.getFileNameWithoutExt(file)), true, new Frame[0]) == 0 && file.delete()) {
                                            MainFrame.this.refreshNavigationTree();
                                        }
                                    }
                                });
                                jPopupMenu.add((JMenuItem)object2);
                                jPopupMenu.show(MainFrame.this.navigationTree, mouseEvent.getX(), mouseEvent.getY());
                            } else if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    File[] fileArray2;
                                    DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                    Object[] objectArray = new Object[3];
                                    objectArray[0] = null;
                                    objectArray[1] = null;
                                    if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode) {
                                        fileArray2 = fileArray;
                                    } else {
                                        File[] fileArray3 = new File[1];
                                        fileArray2 = fileArray3;
                                        fileArray3[0] = file;
                                    }
                                    objectArray[2] = fileArray2;
                                    MainFrame.this.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                } else {
                                    MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                                }
                            } else {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        MainFrame.this.createNewInternalFrame(defaultMutableTreeNode, new Object[0]);
                    }
                }
            }
        });
        this.navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                if (defaultMutableTreeNode.getUserObject() instanceof JInternalFrame) {
                    MainFrame.this.selectFrame((JInternalFrame)defaultMutableTreeNode.getUserObject());
                }
            }
        });
        this.navigationBar.setViewportView(this.navigationTree);
        this.navigationBox.add(this.navigationBar);
        final JComponent jComponent = new JComponent(){
            private static final int HEIGHT = 20;
            private long allocated;
            private long free;
            private long max;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(1, 20);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 20);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 20);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                Runtime runtime = Runtime.getRuntime();
                this.allocated = runtime.totalMemory();
                this.free = runtime.freeMemory();
                this.max = runtime.maxMemory();
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(ReplayConsts.PlayerColor.GREEN.color);
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(ReplayConsts.PlayerColor.ORANGE.color);
                graphics.fillRect(1, 1, (int)(this.allocated * (long)n / this.max), n2 - 2);
                graphics.setColor(ReplayConsts.PlayerColor.RED.color);
                graphics.fillRect(1, 1, (int)((this.allocated - this.free) * (long)n / this.max), n2 - 2);
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                long l = this.free + (this.max - this.allocated) >> 20;
                return String.valueOf(Language.getText("general.memoryUsage")) + " " + Language.getText("diagnosticTool.test.checkMemory.memoryValues", this.allocated >> 20, this.free >> 20, this.max >> 20, l);
            }
        };
        this.navigationBox.add(jComponent);
        jComponent.setToolTipText("");
        new Timer("Memory Status Timer").schedule(new TimerTask(){

            @Override
            public void run() {
                jComponent.repaint();
            }
        }, 0L, 1500L);
    }

    private void selectFrame(JInternalFrame jInternalFrame) {
        try {
            if (jInternalFrame.isIcon()) {
                jInternalFrame.setIcon(false);
            }
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private TreeCellRenderer createTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode != MainFrame.this.newRepAnalNode && defaultMutableTreeNode != MainFrame.this.newMultiRepAnalNode && defaultMutableTreeNode != MainFrame.this.newRepSearchNode && defaultMutableTreeNode != MainFrame.this.emptyRepSourceNode && defaultMutableTreeNode != MainFrame.this.emptyRepListNode) {
                    if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                        this.setIcon(Icons.FOLDER_BOOKMARK);
                    } else {
                        TreeNode treeNode = defaultMutableTreeNode.getParent();
                        if (treeNode == MainFrame.this.repAnalNode) {
                            this.setIcon(Icons.CHART);
                        } else if (treeNode == MainFrame.this.multiRepAnalNode) {
                            this.setIcon(Icons.CHART_UP_COLOR);
                        } else if (treeNode == MainFrame.this.repSearchNode) {
                            this.setIcon(Icons.BINOCULAR);
                        } else if (treeNode == MainFrame.this.repSourcesNode) {
                            this.setIcon(Icons.FOLDERS_STACK);
                        } else if (treeNode == MainFrame.this.repListsNode) {
                            this.setIcon(Icons.TABLE_EXCEL);
                        }
                    }
                }
                return this;
            }
        };
    }

    private void expandAllNavigationRow() {
        int n = 0;
        while (n < this.navigationTree.getRowCount()) {
            this.navigationTree.expandRow(n);
            ++n;
        }
    }

    public void refreshNavigationTree() {
        int n = 0;
        while (n < 2) {
            String string;
            String string2;
            String[] stringArray;
            DefaultMutableTreeNode defaultMutableTreeNode = n == 0 ? this.repSourcesNode : this.repListsNode;
            defaultMutableTreeNode.removeAllChildren();
            if (defaultMutableTreeNode == this.repSourcesNode) {
                defaultMutableTreeNode.add(this.sc2AutoRepsRepSourceNode);
                defaultMutableTreeNode.add(this.autoSavedRepsRepSourceNode);
            }
            if ((stringArray = new File(string2 = n == 0 ? "User Content/Replay sources" : "User Content/Replay lists").list(new FilenameFilter(string = n == 0 ? ".sc2repsrc" : ".csv"){
                private final /* synthetic */ String val$extension;
                {
                    this.val$extension = string;
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(this.val$extension);
                }
            })) == null || stringArray.length == 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode == this.repSourcesNode ? this.emptyRepSourceNode : this.emptyRepListNode);
            } else {
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray2[n3];
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(string3.substring(0, string3.lastIndexOf(46))));
                    ++n3;
                }
            }
            ((DefaultTreeModel)this.navigationTree.getModel()).reload(defaultMutableTreeNode);
            ++n;
        }
    }

    public void refreshRepAnalNavigationNode() {
        ((DefaultTreeModel)this.navigationTree.getModel()).reload(this.repAnalNode);
    }

    private void buildMenuBar() {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        int n;
        Object object3;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        GuiUtils.updateButtonText(jMenu, "menu.file", new Object[0]);
        JMenuItem jMenuItem2 = new JMenuItem(Icons.CHART);
        GuiUtils.updateButtonText(jMenuItem2, "menu.file.openReplay", new Object[0]);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[0]);
            }
        });
        jMenu.add(jMenuItem2);
        GuiUtils.updateButtonText(this.openLastReplayMenuItem, "menu.file.openLastReplay", new Object[0]);
        this.openLastReplayMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        this.openLastReplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.openLastReplayFile();
            }
        });
        jMenu.add(this.openLastReplayMenuItem);
        JMenuItem jMenuItem3 = new JMenuItem(Icons.DOCUMENT_SHARE);
        GuiUtils.updateButtonText(jMenuItem3, "menu.file.shareReplay", new Object[0]);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ShareReplayDialog(null);
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(Icons.DOCUMENT_SHARE);
        GuiUtils.updateButtonText(jMenuItem4, "menu.file.mySharedReplays", new Object[0]);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MySharedReplaysDialog();
            }
        });
        jMenu.add(jMenuItem4);
        Serializable serializable = new JMenuItem(Icons.BLOCK_ARROW);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.file.importBuildOrders", new Object[0]);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ImportBODialog();
            }
        });
        jMenu.add((JMenuItem)serializable);
        jMenu.addSeparator();
        GuiUtils.updateButtonText(this.recentReplaysMenu, "menu.file.recentReplays", new Object[0]);
        jMenu.add(this.recentReplaysMenu);
        jMenu.addSeparator();
        Object object4 = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.file.startStarCraft2", new Object[0]);
        ((AbstractButton)object4).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.startStarCraftII();
            }
        });
        jMenu.add((JMenuItem)object4);
        JMenuItem jMenuItem5 = new JMenuItem(Icons.SC2_EDITOR);
        GuiUtils.updateButtonText(jMenuItem5, "menu.file.startStarCraft2Editor", new Object[0]);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.startStarCraftIIEditor();
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(Icons.DOOR_OPEN_IN);
        GuiUtils.updateButtonText(jMenuItem6, "menu.file.exit", new Object[0]);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.exit(false, new String[0]);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuBar.add(jMenu);
        jMenuItem2 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem2, "menu.navigation", new Object[0]);
        jMenuItem3 = new JMenuItem(Icons.TOGGLE_EXPAND);
        GuiUtils.updateButtonText(jMenuItem3, "menu.navigation.expandAll", new Object[0]);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.expandAllNavigationRow();
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem3);
        jMenuItem4 = new JMenuItem(Icons.TOGGLE);
        GuiUtils.updateButtonText(jMenuItem4, "menu.navigation.collapseAll", new Object[0]);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < MainFrame.this.navigationTree.getRowCount()) {
                    MainFrame.this.navigationTree.collapseRow(n);
                    ++n;
                }
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem4);
        serializable = new JMenuItem(Icons.ARROW_CIRCLE_315);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.navigation.refreshTree", new Object[0]);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.refreshNavigationTree();
            }
        });
        ((JMenu)jMenuItem2).add((JMenuItem)serializable);
        ((JMenu)jMenuItem2).addSeparator();
        object4 = GuiUtils.createCheckBoxMenuItem("menu.navigation.useSmallFont", "navigation.useSmallFont", Icons.APPLICATION_SIDEBAR_LIST);
        jMenuItem5 = new JMenu();
        jMenuItem6 = GuiUtils.createCheckBoxMenuItem("menu.navigation.showNavbar", "navigation.showNavbar", Icons.APPLICATION_SIDEBAR);
        jMenuItem6.addActionListener(new ActionListener((JCheckBoxMenuItem)jMenuItem6, (JCheckBoxMenuItem)object4, (JMenu)jMenuItem5){
            private int storedLeftComponentWidth = 170;
            private final /* synthetic */ JCheckBoxMenuItem val$showNavigationBarMenuItem;
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            private final /* synthetic */ JMenu val$navigationBarPositionMenu;
            {
                this.val$showNavigationBarMenuItem = jCheckBoxMenuItem;
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem2;
                this.val$navigationBarPositionMenu = jMenu;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.val$showNavigationBarMenuItem.isSelected()) {
                    this.storedLeftComponentWidth = MainFrame.this.mainSplitPane.getLeftComponent().getWidth();
                }
                MainFrame.this.navigationBox.setVisible(this.val$showNavigationBarMenuItem.isSelected());
                this.val$useSmallFontMenuItem.setEnabled(this.val$showNavigationBarMenuItem.isSelected());
                this.val$navigationBarPositionMenu.setEnabled(this.val$showNavigationBarMenuItem.isSelected());
                if (this.val$showNavigationBarMenuItem.isSelected()) {
                    MainFrame.this.mainSplitPane.setDividerLocation(this.storedLeftComponentWidth);
                }
                MainFrame.this.mainSplitPane.validate();
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem6);
        ((JMenuItem)object4).setEnabled(Settings.getBoolean("navigation.showNavbar"));
        ((AbstractButton)object4).addActionListener(new ActionListener((JCheckBoxMenuItem)object4){
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            {
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.navigationTree.setFont(new Font(MainFrame.this.navigationTree.getFont().getName(), 0, this.val$useSmallFontMenuItem.isSelected() ? 10 : 12));
            }
        });
        ((JMenu)jMenuItem2).add((JMenuItem)object4);
        jMenuItem5.setEnabled(Settings.getBoolean("navigation.showNavbar"));
        GuiUtils.updateButtonText(jMenuItem5, "menu.navigation.navbarPosition", new Object[0]);
        Object[] objectArray = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(Icons.APPLICATION_DOCK_180), new JRadioButtonMenuItem(Icons.APPLICATION_DOCK)};
        GuiUtils.updateButtonText(objectArray[0], "menu.navigation.navbarPosition.left", new Object[0]);
        GuiUtils.updateButtonText(objectArray[1], "menu.navigation.navbarPosition.right", new Object[0]);
        objectArray[Settings.getInt("navigation.position")].setSelected(true);
        Serializable serializable2 = new ButtonGroup();
        int n2 = 0;
        while (n2 < objectArray.length) {
            object3 = objectArray[n2];
            ((ButtonGroup)serializable2).add((AbstractButton)object3);
            n = n2++;
            object3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("navigation.position", n);
                    MainFrame.this.arrangeContent();
                }
            });
            ((JMenu)jMenuItem5).add((JMenuItem)object3);
        }
        ((JMenu)jMenuItem2).add(jMenuItem5);
        jMenuBar.add((JMenu)jMenuItem2);
        jMenuItem3 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem3, "menu.settings", new Object[0]);
        jMenuItem4 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem4, "menu.settings.laf", new Object[0]);
        jMenuItem4.setIcon(Icons.UI_FLOW);
        serializable = new ButtonGroup();
        objectArray = GuiUtils.getSortedInstalledLAFInfos();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object4 = objectArray[n4];
            serializable2 = new JRadioButtonMenuItem(((UIManager.LookAndFeelInfo)object4).getName(), ((UIManager.LookAndFeelInfo)object4).getName().equals(UIManager.getLookAndFeel().getName()));
            ((ButtonGroup)serializable).add((AbstractButton)serializable2);
            ((AbstractButton)serializable2).addActionListener(new ActionListener((UIManager.LookAndFeelInfo)object4){
                private final /* synthetic */ UIManager.LookAndFeelInfo val$lookAndFeelInfo;
                {
                    this.val$lookAndFeelInfo = lookAndFeelInfo;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && !Settings.getString("settings.laf").equals(this.val$lookAndFeelInfo.getName())) {
                        Sounds.playSoundSample("changing_theme", false);
                    }
                    if (GuiUtils.setLAF(this.val$lookAndFeelInfo.getName())) {
                        JFrame[] jFrameArray = new JFrame[]{MainFrame.this, MousePrintRecorder.getRecorderFrame()};
                        int n = jFrameArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JFrame jFrame = jFrameArray[n2];
                            if (jFrame != null) {
                                SwingUtilities.updateComponentTreeUI(jFrame);
                                Window[] windowArray = jFrame.getOwnedWindows();
                                int n3 = windowArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Window window = windowArray[n4];
                                    SwingUtilities.updateComponentTreeUI(window);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        if (MainFrame.this.trayIconPopupMenu != null) {
                            SwingUtilities.updateComponentTreeUI(MainFrame.this.trayIconPopupMenu);
                        }
                        MainFrame.this.navigationTree.setCellRenderer(MainFrame.this.createTreeCellRenderer());
                        Settings.set("settings.laf", this.val$lookAndFeelInfo.getName());
                    }
                }
            });
            jMenuItem4.add((Component)serializable2);
            ++n4;
        }
        ((JMenu)jMenuItem3).add(jMenuItem4);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.settings.language", new Object[0]);
        ((AbstractButton)serializable).setIcon(Icons.LOCALE);
        object4 = new ButtonGroup();
        Object object5 = Settings.getString("settings.language");
        String[] stringArray = Language.getAvailableLanguages();
        int n5 = stringArray.length;
        int n6 = 0;
        while (n6 < n5) {
            final String string = stringArray[n6];
            boolean bl = string.equals(object5);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(bl ? String.valueOf('*') + string + '*' : string, Icons.getLanguageIcon(string), bl);
            ((ButtonGroup)object4).add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && !Settings.getString("settings.language").equals(string)) {
                        Sounds.playSoundSample("changing_language", false);
                    }
                    Settings.set("settings.language", string);
                }
            });
            ((JMenu)serializable).add(jRadioButtonMenuItem);
            ++n6;
        }
        ((JMenu)serializable).addSeparator();
        Object object6 = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)object6, "menu.settings.language.leetTranslation", new Object[0]);
        object4 = new ButtonGroup();
        try {
            object2 = LeetTranslator.LeetnessLevel.values()[Settings.getInt("settings.language.leetnessLevel")];
        }
        catch (Exception exception) {
            object2 = LeetTranslator.LeetnessLevel.values()[Settings.getDefaultInt("settings.language.leetnessLevel")];
        }
        Font font = new Font("Monospaced", ((Component)object6).getFont().getStyle(), ((Component)object6).getFont().getSize());
        int n7 = 0;
        Object object7 = LeetTranslator.LeetnessLevel.values();
        int n8 = ((LeetTranslator.LeetnessLevel[])object7).length;
        n = 0;
        while (n < n8) {
            object3 = object7[n];
            n7 = Math.max(n7, object3.toString().length());
            ++n;
        }
        n7 += 2;
        object7 = LeetTranslator.LeetnessLevel.values();
        n8 = ((LeetTranslator.LeetnessLevel[])object7).length;
        n = 0;
        while (n < n8) {
            object3 = object7[n];
            boolean bl = object3 == object2;
            object = String.format("%-" + n7 + "s", bl ? String.valueOf('*') + object3.toString() + '*' : String.valueOf(' ') + object3.toString() + ' ');
            jMenuItem = new JRadioButtonMenuItem(String.valueOf(object) + " - " + object3.getSampleText(), bl);
            jMenuItem.setFont(font);
            ((ButtonGroup)object4).add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener((LeetTranslator.LeetnessLevel)((Object)object3)){
                private final /* synthetic */ LeetTranslator.LeetnessLevel val$leetnessLevel;
                {
                    this.val$leetnessLevel = leetnessLevel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && Settings.getInt("settings.language.leetnessLevel") != this.val$leetnessLevel.ordinal()) {
                        Sounds.playSoundSample("changing_language", false);
                    }
                    Settings.set("settings.language.leetnessLevel", this.val$leetnessLevel.ordinal());
                }
            });
            ((JMenu)object6).add(jMenuItem);
            ++n;
        }
        ((JMenu)serializable).add((JMenuItem)object6);
        ((JMenu)jMenuItem3).add((JMenuItem)serializable);
        object4 = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.settings.voice", new Object[0]);
        ((AbstractButton)object4).setIcon(Icons.MICROPHONE);
        object5 = Settings.getString("settings.voice");
        object6 = new ButtonGroup();
        object3 = Sounds.VOICE_DESCRIPTIONS;
        n7 = Sounds.VOICE_DESCRIPTIONS.length;
        int n9 = 0;
        while (n9 < n7) {
            object2 = object3[n9];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(((Sounds.VoiceDescription)object2).displayName, Icons.getLanguageIcon(((Sounds.VoiceDescription)object2).language), ((Sounds.VoiceDescription)object2).name.equals(object5));
            ((ButtonGroup)object6).add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener((Sounds.VoiceDescription)object2){
                private final /* synthetic */ Sounds.VoiceDescription val$voiceDesc;
                {
                    this.val$voiceDesc = voiceDescription;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("settings.voice", this.val$voiceDesc.name);
                    if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("voice_name", false);
                    }
                }
            });
            ((Container)object4).add(jRadioButtonMenuItem);
            ++n9;
        }
        ((JMenu)jMenuItem3).add((JMenuItem)object4);
        ((JMenu)jMenuItem3).addSeparator();
        object5 = new JMenuItem(Icons.EQUALIZER);
        GuiUtils.updateButtonText((AbstractButton)object5, "menu.settings.miscellaneous", new Object[0]);
        ((JMenuItem)object5).setAccelerator(KeyStroke.getKeyStroke(80, 128));
        ((AbstractButton)object5).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MiscSettingsDialog(null);
            }
        });
        ((JMenu)jMenuItem3).add((JMenuItem)object5);
        ((JMenu)jMenuItem3).addSeparator();
        object6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.enableReplayAutoSaveMenuItem.isSelected()) {
                    MainFrame.this.replayAutoSaver = new ReplayAutoSaver();
                    MainFrame.this.replayAutoSaver.start();
                } else if (MainFrame.this.replayAutoSaver != null) {
                    MainFrame.this.replayAutoSaver.requestToCancel();
                }
                if (MainFrame.this.trayIcon != null) {
                    MainFrame.this.enableReplayAutoSaveTrayMenuItem.setSelected(MainFrame.this.enableReplayAutoSaveMenuItem.isSelected());
                }
                if (Settings.getBoolean("settings.enableVoiceNotifications") && actionEvent != null) {
                    Sounds.playSoundSample(MainFrame.this.enableReplayAutoSaveMenuItem.isSelected() ? "auto_save_on" : "auto_save_off", false);
                }
            }
        };
        object6.actionPerformed(null);
        this.enableReplayAutoSaveMenuItem.addActionListener((ActionListener)object6);
        GlobalHotkeys.addHotkey(new Hotkey(16387, 82){

            @Override
            public void run() {
                MainFrame.this.enableReplayAutoSaveTrayMenuItem.doClick(0);
            }
        });
        ((JMenu)jMenuItem3).add(this.enableReplayAutoSaveMenuItem);
        if (ApmAlert.supported) {
            object2 = new ActionListener(){
                private ApmAlert apmAlert;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.enableApmAlertMenuItem.isSelected()) {
                        this.apmAlert = new ApmAlert();
                        this.apmAlert.start();
                    } else if (this.apmAlert != null) {
                        this.apmAlert.requestToCancel();
                    }
                    if (MainFrame.this.trayIcon != null) {
                        MainFrame.this.enableApmAlertTrayMenuItem.setSelected(MainFrame.this.enableApmAlertMenuItem.isSelected());
                    }
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && actionEvent != null) {
                        Sounds.playSoundSample(MainFrame.this.enableApmAlertMenuItem.isSelected() ? "apm_alert_on" : "apm_alert_off", false);
                    }
                }
            };
            object2.actionPerformed(null);
            this.enableApmAlertMenuItem.addActionListener((ActionListener)object2);
            GlobalHotkeys.addHotkey(new Hotkey(16387, 65){

                @Override
                public void run() {
                    MainFrame.this.enableApmAlertMenuItem.doClick(0);
                }
            });
        } else {
            this.enableApmAlertMenuItem.setEnabled(false);
        }
        ((JMenu)jMenuItem3).add(this.enableApmAlertMenuItem);
        object2 = GuiUtils.createCheckBoxMenuItem("menu.settings.enableVoiceNotifications", "settings.enableVoiceNotifications", Icons.SPEAKER_VOLUME);
        ((JMenu)jMenuItem3).add((JMenuItem)object2);
        final JMenuItem jMenuItem7 = GuiUtils.createCheckBoxMenuItem("menu.settings.enableGlobalHotkeys", "settings.enableGlobalHotkeys", Icons.KEYBOARD);
        if (GlobalHotkeys.supported) {
            jMenuItem7.addActionListener(new ActionListener((JCheckBoxMenuItem)jMenuItem7){
                private final /* synthetic */ JCheckBoxMenuItem val$enableGlobalHotkeysMenuItem;
                {
                    this.val$enableGlobalHotkeysMenuItem = jCheckBoxMenuItem;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$enableGlobalHotkeysMenuItem.isSelected()) {
                        GlobalHotkeys.activate();
                    } else {
                        GlobalHotkeys.deactivate();
                    }
                }
            });
        } else {
            jMenuItem7.setEnabled(false);
        }
        ((JMenu)jMenuItem3).add(jMenuItem7);
        JMenuItem jMenuItem8 = GuiUtils.createCheckBoxMenuItem("menu.settings.showStartPageOnStartup", "settings.showStartPageOnStartup", Icons.NEWSPAPER);
        ((JMenu)jMenuItem3).add(jMenuItem8);
        object3 = GuiUtils.createCheckBoxMenuItem("menu.settings.checkUpdatesOnStartup", "settings.checkUpdatesOnStartup", Icons.ARROW_CIRCLE_DOUBLE);
        ((JMenu)jMenuItem3).add((JMenuItem)object3);
        ((JMenu)jMenuItem3).addSeparator();
        JMenuItem jMenuItem9 = new JMenuItem(Icons.DISK);
        GuiUtils.updateButtonText(jMenuItem9, "menu.settings.saveNow", new Object[0]);
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.saveProperties();
                PluginManager.savePluginSettings();
            }
        });
        ((JMenu)jMenuItem3).add(jMenuItem9);
        JCheckBoxMenuItem jCheckBoxMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.saveOnExit", "settings.saveOnExit", Icons.DISK_ARROW);
        ((JMenu)jMenuItem3).add(jCheckBoxMenuItem);
        jMenuBar.add((JMenu)jMenuItem3);
        jMenuItem4 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem4, "menu.tools", new Object[0]);
        serializable = new JMenuItem(Icons.FINGERPRINT);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.tools.mousePrintRecorder", new Object[0]);
        ((JMenuItem)serializable).setAccelerator(KeyStroke.getKeyStroke(112, 640));
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MousePrintRecorder.showFrame();
            }
        });
        ((JMenu)jMenuItem4).add((JMenuItem)serializable);
        object4 = new JMenuItem(Icons.CALCULATOR);
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.tools.gameTimeRealTimeConverter", new Object[0]);
        ((JMenuItem)object4).setAccelerator(KeyStroke.getKeyStroke(113, 640));
        ((AbstractButton)object4).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GameTimeRealTimeConverterDialog();
            }
        });
        ((JMenu)jMenuItem4).add((JMenuItem)object4);
        object5 = new JMenuItem(Icons.SYSTEM_MONITOR);
        GuiUtils.updateButtonText((AbstractButton)object5, "menu.tools.diagnosticTool", new Object[0]);
        ((JMenuItem)object5).setAccelerator(KeyStroke.getKeyStroke(114, 640));
        ((AbstractButton)object5).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new DiagnosticToolDialog();
            }
        });
        ((JMenu)jMenuItem4).add((JMenuItem)object5);
        object6 = new JMenuItem(Icons.PUZZLE);
        GuiUtils.updateButtonText((AbstractButton)object6, "menu.tools.pluginManager", new Object[0]);
        ((JMenuItem)object6).setAccelerator(KeyStroke.getKeyStroke(115, 640));
        ((AbstractButton)object6).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new PluginManagerDialog();
            }
        });
        ((JMenu)jMenuItem4).add((JMenuItem)object6);
        object2 = new JMenuItem(Icons.SERVER_NETWORK);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.tools.sc2earsDatabaseDownloader", new Object[0]);
        ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(116, 640));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Sc2gearsDatabaseDownloaderDialog();
            }
        });
        ((JMenu)jMenuItem4).add((JMenuItem)object2);
        jMenuBar.add((JMenu)jMenuItem4);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.window", new Object[0]);
        object4 = new JCheckBoxMenuItem(Icons.APPLICATION_RESIZE_FULL);
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.window.fullscreen", new Object[0]);
        ((JMenuItem)object4).setAccelerator(KeyStroke.getKeyStroke(122, 0));
        ((AbstractButton)object4).addActionListener(new ActionListener((JCheckBoxMenuItem)object4){
            private Rectangle storedBounds;
            private final /* synthetic */ JCheckBoxMenuItem val$fullscreenMenuItem;
            {
                this.val$fullscreenMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                    if (this.val$fullscreenMenuItem.isSelected()) {
                        this.storedBounds = MainFrame.this.getBounds();
                    }
                    MainFrame.this.dispose();
                    MainFrame.this.setUndecorated(this.val$fullscreenMenuItem.isSelected());
                    MainFrame.this.setExtendedState(this.val$fullscreenMenuItem.isSelected() ? 6 : 0);
                    if (!this.val$fullscreenMenuItem.isSelected()) {
                        MainFrame.this.setBounds(this.storedBounds);
                    }
                    MainFrame.this.setVisible(true);
                    this.val$fullscreenMenuItem.setIcon(this.val$fullscreenMenuItem.isSelected() ? Icons.APPLICATION_RESIZE_ACTUAL : Icons.APPLICATION_RESIZE_FULL);
                }
            }
        });
        ((JMenu)serializable).add((JMenuItem)object4);
        ((JMenu)serializable).addSeparator();
        object5 = GuiUtils.createCheckBoxMenuItem("menu.window.startMaximized", "window.startMaximized", Icons.APPLICATION_RESIZE);
        ((JMenu)serializable).add((JMenuItem)object5);
        ((JMenu)serializable).addSeparator();
        GuiUtils.updateButtonText(this.minimizeToTrayMenuItem, "menu.window.mimimizeToTray", new Object[0]);
        this.minimizeToTrayMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.minimizeToTrayMenuItem.setEnabled(this.trayIcon != null);
        this.minimizeToTrayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.trayIcon != null) {
                    MainFrame.this.hideMainFrame();
                }
            }
        });
        ((JMenu)serializable).add(this.minimizeToTrayMenuItem);
        ((JMenu)serializable).add(this.startMinimizedToTrayMenuItem);
        object6 = GuiUtils.createCheckBoxMenuItem("menu.window.minimizeToTrayOnMinimize", "window.minimizeToTrayOnMinimize", Icons.APPLICATION_DOCK_TAB);
        ((JMenu)serializable).add((JMenuItem)object6);
        object2 = GuiUtils.createCheckBoxMenuItem("menu.window.minimizeToTrayOnClose", "window.minimizeToTrayOnClose", Icons.APPLICATION_DOCK_TAB);
        ((JMenu)serializable).add((JMenuItem)object2);
        ((JMenu)serializable).addSeparator();
        jMenuItem7 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        jMenuItem8 = new JMenuItem(Icons.APPLICATIONS_STACK);
        object3 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        jMenuItem9 = new JMenuItem(Icons.APPLICATIONS_STACK);
        int n10 = 25;
        object7 = new ActionListener((JMenuItem)object3, jMenuItem8){
            private final /* synthetic */ JMenuItem val$tileVisibleWindowsMenuItem;
            private final /* synthetic */ JMenuItem val$cascadeAllWindowsMenuItem;
            {
                this.val$tileVisibleWindowsMenuItem = jMenuItem2;
                this.val$cascadeAllWindowsMenuItem = jMenuItem3;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                boolean bl = actionEvent.getSource() == jMenuItem7 || actionEvent.getSource() == this.val$tileVisibleWindowsMenuItem;
                boolean bl2 = actionEvent.getSource() == jMenuItem7 || actionEvent.getSource() == this.val$cascadeAllWindowsMenuItem;
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n4 = jInternalFrameArray.length;
                if (!bl2) {
                    JInternalFrame[] jInternalFrameArray2 = jInternalFrameArray;
                    n3 = jInternalFrameArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        JInternalFrame jInternalFrame = jInternalFrameArray2[n2];
                        if (jInternalFrame.isIcon()) {
                            --n4;
                        }
                        ++n2;
                    }
                }
                int n5 = 1;
                n2 = 1;
                if (bl) {
                    n3 = Settings.getBoolean("window.verticalTileStrategy") ? 1 : 0;
                    while (n5 * n2 < n4) {
                        if (n3 != 0) {
                            if (n5 == n2) {
                                ++n2;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        if (n5 == n2) {
                            ++n5;
                            continue;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    n3 = MainFrame.this.desktopPane.getWidth() / n5;
                    n = (MainFrame.this.desktopPane.getHeight() - (bl2 ? 0 : 25)) / n2;
                } else {
                    n3 = MainFrame.this.desktopPane.getWidth() - n4 * 25;
                    n = MainFrame.this.desktopPane.getHeight() - n4 * 25;
                }
                int n6 = 0;
                int n7 = 0;
                while (n6 < jInternalFrameArray.length) {
                    try {
                        JInternalFrame jInternalFrame = jInternalFrameArray[bl ? n6 : jInternalFrameArray.length - n6 - 1];
                        if (bl2 && jInternalFrame.isIcon()) {
                            jInternalFrame.setIcon(false);
                        }
                        if (jInternalFrame.isMaximum()) {
                            jInternalFrame.setMaximum(false);
                        }
                        if (bl2 || !jInternalFrame.isIcon()) {
                            if (bl) {
                                jInternalFrame.setBounds(n7 % n5 * n3, n7 / n5 * n, n3, n);
                            } else {
                                jInternalFrame.setBounds(n7 * 25, n7 * 25, n3, n);
                            }
                            ++n7;
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n6;
                }
            }
        };
        GuiUtils.updateButtonText(jMenuItem7, "menu.window.tileAllWindows", new Object[0]);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        jMenuItem7.addActionListener((ActionListener)object7);
        ((JMenu)serializable).add(jMenuItem7);
        GuiUtils.updateButtonText(jMenuItem8, "menu.window.cascadeAllWindows", new Object[0]);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem8.addActionListener((ActionListener)object7);
        ((JMenu)serializable).add(jMenuItem8);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.window.tileVisibleWindows", new Object[0]);
        object3.setAccelerator(KeyStroke.getKeyStroke(113, 128));
        object3.addActionListener((ActionListener)object7);
        ((JMenu)serializable).add((JMenuItem)object3);
        GuiUtils.updateButtonText(jMenuItem9, "menu.window.cascadeVisibleWindows", new Object[0]);
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(114, 128));
        jMenuItem9.addActionListener((ActionListener)object7);
        ((JMenu)serializable).add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem(Icons.APPLICATION_DIALOG);
        GuiUtils.updateButtonText(jMenuItem10, "menu.window.minimizeAll", new Object[0]);
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)serializable).add(jMenuItem10);
        object = new JMenuItem(Icons.CROSS_BUTTON);
        GuiUtils.updateButtonText((AbstractButton)object, "menu.window.closeAll", new Object[0]);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)serializable).add((JMenuItem)object);
        ((JMenu)serializable).addSeparator();
        jMenuItem = GuiUtils.createCheckBoxMenuItem("menu.window.useVerticalTileStrategy", "window.verticalTileStrategy", Icons.APPLICATION_TILE_VERTICAL);
        ((JMenu)serializable).add(jMenuItem);
        jMenuBar.add((JMenu)serializable);
        object4 = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.help", new Object[0]);
        object5 = new JMenuItem(Icons.HOME_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object5, "menu.help.visitHomePage", new Object[0]);
        ((JMenuItem)object5).setAccelerator(KeyStroke.getKeyStroke(112, 128));
        ((AbstractButton)object5).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://sites.google.com/site/sc2gears/");
            }
        });
        ((JMenu)object4).add((JMenuItem)object5);
        object6 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object6, "menu.help.viewVersionHistory", new Object[0]);
        ((AbstractButton)object6).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://sites.google.com/site/sc2gears/version-history");
            }
        });
        ((JMenu)object4).add((JMenuItem)object6);
        object2 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.help.viewFaq", new Object[0]);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://sites.google.com/site/sc2gears/faq");
            }
        });
        ((JMenu)object4).add((JMenuItem)object2);
        jMenuItem7 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem7, "menu.help.visitForum", new Object[0]);
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://groups.google.com/group/sc2gears");
            }
        });
        ((JMenu)object4).add(jMenuItem7);
        jMenuItem8 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem8, "menu.help.sc2gearsDatabase", new Object[0]);
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://sites.google.com/site/sc2gears/sc2gears-database");
            }
        });
        ((JMenu)object4).add(jMenuItem8);
        object3 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.help.sc2gearsDatabaseUserPage", new Object[0]);
        object3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser(Consts.URL_SC2GEARS_DATABASE_USER_PAGE);
            }
        });
        ((JMenu)object4).add((JMenuItem)object3);
        jMenuItem9 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem9, "menu.help.donate", new Object[0]);
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser("https://sites.google.com/site/sc2gears/donate");
            }
        });
        ((JMenu)object4).add(jMenuItem9);
        ((JMenu)object4).addSeparator();
        GuiUtils.updateButtonText(this.viewSystemMessagesMenuItem, "menu.help.viewSystemMessages", new Object[0]);
        this.viewSystemMessagesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SystemMessagesDialog();
            }
        });
        ((JMenu)object4).add(this.viewSystemMessagesMenuItem);
        ((JMenu)object4).addSeparator();
        GuiUtils.updateButtonText(this.checkUpdatesMenuItem, "menu.help.checkUpdates", new Object[0]);
        this.checkUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new UpdateChecker(MainFrame.this.checkUpdatesMenuItem);
            }
        });
        ((JMenu)object4).add(this.checkUpdatesMenuItem);
        ((JMenu)object4).addSeparator();
        JMenuItem jMenuItem11 = new JMenuItem(Icons.NEWSPAPER);
        GuiUtils.updateButtonText(jMenuItem11, "menu.help.showStartPage", new Object[0]);
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showStartPage(true);
            }
        });
        ((JMenu)object4).add(jMenuItem11);
        object7 = new JMenuItem(Icons.LIGHT_BULB);
        GuiUtils.updateButtonText((AbstractButton)object7, "menu.help.showNewToSc2gearsDialog", "Sc2gears");
        ((AbstractButton)object7).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new NewToSc2gearsDialog();
            }
        });
        ((JMenu)object4).add((JMenuItem)object7);
        jMenuItem10 = new JMenuItem(Icons.LIGHT_BULB);
        GuiUtils.updateButtonText(jMenuItem10, "menu.help.showTips", new Object[0]);
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TipsDialog();
            }
        });
        ((JMenu)object4).add(jMenuItem10);
        object = new JMenuItem(Icons.KEYBOARD);
        GuiUtils.updateButtonText((AbstractButton)object, "menu.help.keyboardShortcuts", new Object[0]);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new KeyboardShortcutsDialog();
            }
        });
        ((JMenu)object4).add((JMenuItem)object);
        ((JMenu)object4).addSeparator();
        jMenuItem = new JMenuItem(Icons.INFORMATION);
        GuiUtils.updateButtonText(jMenuItem, "menu.help.about", "Sc2gears");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AboutDialog();
            }
        });
        ((JMenu)object4).add(jMenuItem);
        jMenuBar.add((JMenu)object4);
        this.setJMenuBar(jMenuBar);
    }

    private void createNewInternalFrame(MutableTreeNode mutableTreeNode, Object ... objectArray) {
        ModuleFrame moduleFrame = null;
        if (mutableTreeNode == this.newRepAnalNode) {
            moduleFrame = new ReplayAnalyzer(objectArray);
        } else if (mutableTreeNode == this.newMultiRepAnalNode) {
            moduleFrame = new MultiRepAnalysis(objectArray);
        } else if (mutableTreeNode == this.newRepSearchNode) {
            moduleFrame = new ReplaySearch(objectArray);
        }
        if (moduleFrame != null && !moduleFrame.isClosed()) {
            final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(moduleFrame);
            ((DefaultTreeModel)this.navigationTree.getModel()).insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)mutableTreeNode.getParent(), 1);
            final TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.navigationTree.setSelectionPath(treePath);
            moduleFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    ((DefaultTreeModel)MainFrame.this.navigationTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (!((JInternalFrame)internalFrameEvent.getSource()).isIcon()) {
                        MainFrame.this.navigationTree.setSelectionPath(treePath);
                        MainFrame.this.navigationTree.scrollPathToVisible(treePath);
                    }
                }
            });
            this.addNewInternalFrame(moduleFrame);
        }
    }

    private void addNewInternalFrame(JInternalFrame jInternalFrame) {
        jInternalFrame.setDefaultCloseOperation(2);
        this.desktopPane.add(jInternalFrame);
        try {
            jInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        jInternalFrame.setVisible(true);
        try {
            jInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public void restartReplayAutoSaver() {
        if (this.replayAutoSaver != null && !this.replayAutoSaver.isCancelRequested()) {
            this.replayAutoSaver.requestToCancel();
            this.replayAutoSaver = new ReplayAutoSaver();
            this.replayAutoSaver.start();
        }
    }

    public void openLastReplayFile() {
        List<File> list = GeneralUtils.getAutoRepFolderList();
        File file = null;
        boolean bl = false;
        for (File file2 : list) {
            if (!file2.exists()) continue;
            bl = true;
            file = GeneralUtils.getLastReplay(file2, file);
        }
        if (file == null) {
            GuiUtils.showErrorDialog(new Object[]{Language.getText(bl ? "misc.autorepFolderEmpty" : "misc.autorepFolderNotExists"), list.get(0).getAbsolutePath(), " ", MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.FOLDERS)}, new Frame[0]);
            return;
        }
        this.openReplayFile(file);
    }

    public void openReplayFile(File file) {
        this.createNewInternalFrame(this.newRepAnalNode, file);
    }

    public void openReplaySpecification(ReplaySpecification replaySpecification) {
        this.createNewInternalFrame(this.newRepAnalNode, null, replaySpecification);
    }

    public void updateRecentReplays(File file) {
        int n = Settings.getInt("recentReplays.count");
        ArrayList<String> arrayList = new ArrayList<String>(n + 1);
        String string = file.getAbsolutePath();
        arrayList.add(string);
        int n2 = 0;
        while (n2 < n) {
            String string2 = Settings.getString("recentReplays.entry." + n2);
            if (!string.equals(string2)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        while (arrayList.size() > 15) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() != n) {
            n = arrayList.size();
            Settings.set("recentReplays.count", n);
        }
        n2 = 0;
        while (n2 < n) {
            Settings.set("recentReplays.entry." + n2, arrayList.get(n2));
            ++n2;
        }
        this.rebuildRecentReplaysMenu();
    }

    public void openReplaysInMultiRepAnalysis(File[] fileArray) {
        this.createNewInternalFrame(this.newMultiRepAnalNode, null, null, fileArray);
    }

    public void openReplaySearch(File[] fileArray, boolean bl) {
        this.createNewInternalFrame(this.newRepSearchNode, null, null, fileArray, bl);
    }

    private void rebuildRecentReplaysMenu() {
        this.recentReplaysMenu.removeAll();
        int n = Settings.getInt("recentReplays.count");
        int n2 = 0;
        while (n2 < n) {
            final File file = new File(Settings.getString("recentReplays.entry." + n2));
            JMenuItem jMenuItem = new JMenuItem(String.valueOf(n2 + 1) + " " + file.getName(), Icons.CHART);
            if (n2 < 9) {
                jMenuItem.setMnemonic(49 + n2);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.openReplayFile(file);
                }
            });
            this.recentReplaysMenu.add(jMenuItem);
            ++n2;
        }
    }

    private void arrangeContent() {
        this.mainSplitPane.setLeftComponent(null);
        this.mainSplitPane.setRightComponent(null);
        if (Settings.getInt("navigation.position") == 0) {
            if (this.navigationBar.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.navigationBar.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.navigationBox);
            this.mainSplitPane.setRightComponent(this.desktopPane);
        } else {
            if (this.desktopPane.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.desktopPane.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.desktopPane);
            this.mainSplitPane.setRightComponent(this.navigationBox);
        }
    }

    public void hideMainFrame() {
        this.setVisible(false);
        this.hideTrayMenuItem.setEnabled(false);
        this.restoreTrayMenuItem.setEnabled(true);
    }

    public void restoreMainFrame() {
        if (this.windowSizeInitialized) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            this.setState(0);
            this.toFront();
        } else {
            this.windowSizeInitialized = true;
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            this.setBounds(rectangle.x + insets.left + 10, rectangle.y + insets.top + 10, rectangle.width - insets.left - insets.right - 20, rectangle.height - insets.top - insets.bottom - 20);
            if (Settings.getBoolean("window.startMaximized")) {
                this.setExtendedState(6);
            }
            this.setVisible(true);
            this.toFront();
            double d = (double)Settings.getInt("settings.misc.navBarInitialWidth") / (double)this.getWidth();
            if (d > 1.0) {
                d = 1.0;
            }
            this.mainSplitPane.setDividerLocation(Settings.getInt("navigation.position") == 0 ? d : 1.0 - d);
        }
        if (this.trayIcon != null) {
            this.hideTrayMenuItem.setEnabled(true);
            this.restoreTrayMenuItem.setEnabled(false);
        }
    }

    public static void registerBackgroundJob() {
        backgroundJobsCount.incrementAndGet();
    }

    public static void removeBackgroundJob() {
        backgroundJobsCount.decrementAndGet();
    }

    public void exit(boolean bl, String ... stringArray) {
        int n = backgroundJobsCount.get();
        if (n > 0 && GuiUtils.showConfirmDialog(Language.getText("general.activeJobsSureToExit", n), true, new Frame[0]) != 0) {
            return;
        }
        PluginManager.disposePlugins();
        if (this.replayAutoSaver != null) {
            this.replayAutoSaver.requestToCancel();
        }
        if (Settings.getBoolean("settings.saveOnExit")) {
            Settings.saveProperties();
            PluginManager.savePluginSettings();
        }
        GlobalHotkeys.deactivate();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (bl) {
            try {
                Runtime.getRuntime().exec("java -cp lib-updater/Sc2gearsUpdater.jar hu/belicza/andras/sc2gearsupdater/Updater " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
            }
            catch (IOException iOException) {
                System.err.println("Failed to start Sc2gears Updater!");
                iOException.printStackTrace();
            }
        }
        System.exit(0);
    }
}

