/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.charts;

import hu.belicza.andras.sc2gears.ui.charts.BaseChartParams;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;

public class BaseChartPainter {
    public static final Color COLOR_BACKGROUND = Color.BLACK;
    public static final Color COLOR_AXIS = Color.YELLOW;
    public static final Color COLOR_ASSIST_LINES = new Color(60, 60, 60);
    public static final Color COLOR_AXIS_LABELS = Color.CYAN;
    public static final Color COLOR_PLAYER_DEFAULT = Color.WHITE;
    public static final int ASSIST_LINES_MIN_DISTANCE = 20;
    public static final int TIME_LABELS_MIN_DISTANCE = 100;
    protected static final Stroke STROKE_DEFAULT = new BasicStroke();
    protected static final Stroke STROKE_DASHED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 1.0f);
    protected static final Stroke STROKE_DASHED_DOUBLE = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{5.0f}, 1.0f);
    protected static final Stroke STROKE_DOUBLE_WIDTH = new BasicStroke(2.0f);
    protected static final Stroke STROKE_DOUBLE_WIDTH_ROUNDED = new BasicStroke(2.0f, 0, 1);
    protected static final Stroke STROKE_ROUNDED = new BasicStroke(1.0f, 0, 1);
    protected final BaseChartParams params;
    protected final Graphics2D g2;
    private int[] xPoints;
    private int[] yPoints;

    public BaseChartPainter(BaseChartParams baseChartParams) {
        this.g2 = baseChartParams.g2;
        this.params = baseChartParams;
    }

    public void paintChart() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setBackground(COLOR_BACKGROUND);
        this.g2.clearRect(0, 0, this.params.width, this.params.height);
    }

    public void drawCubicCurve2D(int[] nArray, int[] nArray2, int n, int n2) {
        if (nArray.length < 2) {
            return;
        }
        CubicCurve2D.Float float_ = new CubicCurve2D.Float();
        this.xPoints = nArray;
        this.yPoints = nArray2;
        Point2D.Float float_2 = new Point2D.Float();
        Point2D.Float float_3 = new Point2D.Float();
        Point2D.Float float_4 = new Point2D.Float();
        Point2D.Float float_5 = new Point2D.Float();
        float f = 0.25f;
        this.getCP(n, float_2);
        this.getCP(n + 1, float_3);
        this.getCP(n + 2, float_4);
        int n3 = n;
        while (n3 < n2) {
            this.getCP(n3 + 3, float_5);
            if (nArray2[n3] < 0 || nArray2[n3 + 1] < 0) {
                this.g2.setStroke(STROKE_DASHED_DOUBLE);
            }
            float_.setCurve(float_3.x, float_3.y, -0.25f * float_2.x + float_3.x + 0.25f * float_4.x, -0.25f * float_2.y + float_3.y + 0.25f * float_4.y, 0.25f * float_3.x + float_4.x - 0.25f * float_5.x, 0.25f * float_3.y + float_4.y - 0.25f * float_5.y, float_4.x, float_4.y);
            this.g2.draw(float_);
            if (nArray2[n3] < 0 || nArray2[n3 + 1] < 0) {
                this.g2.setStroke(STROKE_DOUBLE_WIDTH);
            }
            Point2D.Float float_6 = float_2;
            float_2 = float_3;
            float_3 = float_4;
            float_4 = float_5;
            float_5 = float_6;
            ++n3;
        }
    }

    private void getCP(int n, Point2D.Float float_) {
        if (n == 0) {
            float_.setLocation(-0.5f * (float)this.xPoints[0] + 1.5f * (float)this.xPoints[1], -0.5f * (float)Math.abs(this.yPoints[0]) + 1.5f * (float)Math.abs(this.yPoints[1]));
        } else {
            int n2 = this.xPoints.length;
            if (n == n2 + 1) {
                float_.setLocation(-0.5f * (float)this.xPoints[n2 - 1] + 1.5f * (float)this.xPoints[n2 - 2], -0.5f * (float)Math.abs(this.yPoints[n2 - 1]) + 1.5f * (float)Math.abs(this.yPoints[n2 - 2]));
            } else {
                float_.setLocation(this.xPoints[n - 1], Math.abs(this.yPoints[n - 1]));
            }
        }
    }
}

