/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.components;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.components.CustomMenuItemSpec;
import hu.belicza.andras.sc2gears.ui.dialogs.PlayerProfileDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.ObjectRegistry;
import hu.belicza.andras.sc2gearspluginapi.api.enums.Gateway;
import hu.belicza.andras.sc2gearspluginapi.api.enums.PlayerType;
import hu.belicza.andras.sc2gearspluginapi.api.enums.Region;
import hu.belicza.andras.sc2gearspluginapi.api.listener.PlayerPopupMenuItemListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PlayerPopupMenu
extends JPopupMenu
implements ActionListener {
    private static final ObjectRegistry<CustomPlayerMenuItemSpec> customMenuItemRegistry = new ObjectRegistry();
    private final Details.PlayerId playerId;
    private final ReplayConsts.PlayerType playerType;
    private final JMenuItem showProfileInfoInPopupMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.showProfileInfoInPopup"), Icons.PROFILE);
    private final JMenuItem viewSc2ranksProfileMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.viewSc2ranksProfile"), Icons.SC2RANKS);
    private final JMenuItem viewCharacterProfileMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.viewCharacterProfile"), Icons.PROFILE);
    private final JMenuItem addToFavoredPlayerListMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.addToFavoredPlayerList"), Icons.USER_PLUS);
    private final JMenuItem removeFromFavoredPlayerListMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.removeFromFavoredPlayerList"), Icons.USER_MINUS);
    private final JMenuItem copyFullNameMenuItem;

    public static Integer addPlayerPopupMenuItem(String string, Icon icon, PlayerPopupMenuItemListener playerPopupMenuItemListener) {
        CustomPlayerMenuItemSpec customPlayerMenuItemSpec = new CustomPlayerMenuItemSpec(string, icon, playerPopupMenuItemListener);
        customMenuItemRegistry.add(customPlayerMenuItemSpec);
        return customPlayerMenuItemSpec.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlayerPopupMenuItem(Integer n) {
        ObjectRegistry<CustomPlayerMenuItemSpec> objectRegistry = customMenuItemRegistry;
        synchronized (objectRegistry) {
            for (CustomPlayerMenuItemSpec customPlayerMenuItemSpec : customMenuItemRegistry) {
                if (!customPlayerMenuItemSpec.handler.equals(n)) continue;
                customMenuItemRegistry.remove(customPlayerMenuItemSpec);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerPopupMenu(final Details.PlayerId playerId, final ReplayConsts.PlayerType playerType) {
        List<Object> list;
        boolean bl;
        this.playerId = playerId;
        this.playerType = playerType;
        boolean bl2 = bl = playerId.gateway == ReplayConsts.Gateway.UNKNOWN || playerId.gateway == ReplayConsts.Gateway.PUBLIC_TEST || playerType != ReplayConsts.PlayerType.HUMAN || playerId.battleNetId == 0;
        if (bl) {
            this.showProfileInfoInPopupMenuItem.setEnabled(false);
        }
        this.showProfileInfoInPopupMenuItem.addActionListener(this);
        this.add(this.showProfileInfoInPopupMenuItem);
        this.addSeparator();
        if (bl) {
            this.viewSc2ranksProfileMenuItem.setEnabled(false);
        }
        this.viewSc2ranksProfileMenuItem.addActionListener(this);
        this.add(this.viewSc2ranksProfileMenuItem);
        if (bl) {
            this.viewCharacterProfileMenuItem.setEnabled(false);
        }
        this.viewCharacterProfileMenuItem.addActionListener(this);
        this.add(this.viewCharacterProfileMenuItem);
        JMenu jMenu = new JMenu(Language.getText("module.repAnalyzer.tab.charts.playerMenu.viewCharacterProfileInLanguage"));
        jMenu.setIcon(Icons.PROFILE);
        if (bl) {
            jMenu.setEnabled(false);
        } else {
            list = new ArrayList<ReplayConsts.BnetLanguage>(playerId.gateway.availableLanguageSet);
            Collections.sort(list);
            for (final ReplayConsts.BnetLanguage bnetLanguage : list) {
                JMenuItem objectRegistry2 = new JMenuItem(bnetLanguage.stringValue, Icons.getLanguageIcon(Language.getDefaultText(bnetLanguage.textKey)));
                objectRegistry2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GeneralUtils.showURLInBrowser(playerId.getBnetProfileUrl(bnetLanguage));
                    }
                });
                jMenu.add(objectRegistry2);
            }
        }
        this.add(jMenu);
        this.addSeparator();
        list = GeneralUtils.getFavoredPlayerList();
        boolean bl3 = list.contains(playerId.name);
        this.addToFavoredPlayerListMenuItem.setEnabled(!bl3);
        this.addToFavoredPlayerListMenuItem.addActionListener(this);
        this.add(this.addToFavoredPlayerListMenuItem);
        JMenu jMenu2 = new JMenu(Language.getText("module.repAnalyzer.tab.charts.playerMenu.insertToFavoredPlayerList"));
        jMenu2.setIcon(Icons.USER_PLUS);
        jMenu2.setEnabled(!bl3);
        if (!bl3) {
            for (final String string : list) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List<String> list2 = GeneralUtils.getFavoredPlayerList();
                        int n = list2.indexOf(string);
                        if (n >= 0) {
                            list.add(n, playerId.name);
                            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(list));
                        }
                    }
                });
                jMenu2.add(jMenuItem);
            }
        }
        this.add(jMenu2);
        this.removeFromFavoredPlayerListMenuItem.setEnabled(bl3);
        this.removeFromFavoredPlayerListMenuItem.addActionListener(this);
        this.add(this.removeFromFavoredPlayerListMenuItem);
        this.addSeparator();
        this.copyFullNameMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.copyFullName", playerId.getFullName()), Icons.CLIPBOARD_SIGN);
        this.copyFullNameMenuItem.addActionListener(this);
        this.add(this.copyFullNameMenuItem);
        ObjectRegistry<CustomPlayerMenuItemSpec> objectRegistry = customMenuItemRegistry;
        synchronized (objectRegistry) {
            if (!customMenuItemRegistry.isEmpty()) {
                this.addSeparator();
                for (final CustomPlayerMenuItemSpec customPlayerMenuItemSpec : customMenuItemRegistry) {
                    JMenuItem jMenuItem = new JMenuItem(customPlayerMenuItemSpec.text, customPlayerMenuItemSpec.icon);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            customPlayerMenuItemSpec.listener.actionPerformed(new PlayerInfoImpl(playerId, playerType), customPlayerMenuItemSpec.handler);
                        }
                    });
                    this.add(jMenuItem);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.showProfileInfoInPopupMenuItem) {
            new PlayerProfileDialog(this.playerId, this.playerType);
        } else if (actionEvent.getSource() == this.viewCharacterProfileMenuItem) {
            GeneralUtils.showURLInBrowser(this.playerId.getBnetProfileUrl(ReplayConsts.BnetLanguage.values()[Settings.getInt("settings.misc.preferredBnetLanguage")]));
        } else if (actionEvent.getSource() == this.viewSc2ranksProfileMenuItem) {
            GeneralUtils.showURLInBrowser(this.playerId.getSc2ranksProfileUrl());
        } else if (actionEvent.getSource() == this.addToFavoredPlayerListMenuItem) {
            List<String> list = GeneralUtils.getFavoredPlayerList();
            list.add(this.playerId.name);
            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(list));
        } else if (actionEvent.getSource() == this.removeFromFavoredPlayerListMenuItem) {
            List<String> list = GeneralUtils.getFavoredPlayerList();
            list.remove(this.playerId.name);
            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(list));
        } else if (actionEvent.getSource() == this.copyFullNameMenuItem) {
            GeneralUtils.copyToClipboard(this.playerId.getFullName());
        }
    }

    private static String getFavoredPlayerListString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static class CustomPlayerMenuItemSpec
    extends CustomMenuItemSpec {
        public final PlayerPopupMenuItemListener listener;

        public CustomPlayerMenuItemSpec(String string, Icon icon, PlayerPopupMenuItemListener playerPopupMenuItemListener) {
            super(string, icon);
            this.listener = playerPopupMenuItemListener;
        }
    }

    private static class PlayerInfoImpl
    implements PlayerPopupMenuItemListener.PlayerInfo {
        private final String name;
        private final Gateway gateway;
        private final Region region;
        private final int battleNetId;
        private final PlayerType playerType;

        public PlayerInfoImpl(Details.PlayerId playerId, ReplayConsts.PlayerType playerType) {
            this.name = playerId.name;
            this.battleNetId = playerId.battleNetId;
            switch (playerId.gateway) {
                case AMERICA: {
                    this.gateway = Gateway.AMERICA;
                    break;
                }
                case ASIA: {
                    this.gateway = Gateway.ASIA;
                    break;
                }
                case CHINA: {
                    this.gateway = Gateway.CHINA;
                    break;
                }
                case EUROPE: {
                    this.gateway = Gateway.EUROPE;
                    break;
                }
                case SOUTHEAST_ASIA: {
                    this.gateway = Gateway.SOUTHEAST_ASIA;
                    break;
                }
                case PUBLIC_TEST: {
                    this.gateway = Gateway.PUBLIC_TEST;
                    break;
                }
                default: {
                    this.gateway = Gateway.UNKNOWN;
                }
            }
            switch (playerId.getRegion()) {
                case NORTH_AMERICA: {
                    this.region = Region.NORTH_AMERICA;
                    break;
                }
                case LATIN_AMERICA: {
                    this.region = Region.LATIN_AMERICA;
                    break;
                }
                case CHINA: {
                    this.region = Region.CHINA;
                    break;
                }
                case EUROPE: {
                    this.region = Region.EUROPE;
                    break;
                }
                case RUSSIA: {
                    this.region = Region.RUSSIA;
                    break;
                }
                case KOREA: {
                    this.region = Region.KOREA;
                    break;
                }
                case TAIWAN: {
                    this.region = Region.TAIWAN;
                    break;
                }
                case SOUTHEAST_ASIA: {
                    this.region = Region.SOUTHEAST_ASIA;
                    break;
                }
                default: {
                    this.region = Region.UNKNOWN;
                }
            }
            switch (playerType) {
                case HUMAN: {
                    this.playerType = PlayerType.HUMAN;
                    break;
                }
                case COMPUTER: {
                    this.playerType = PlayerType.COMPUTER;
                    break;
                }
                default: {
                    this.playerType = PlayerType.UNKNOWN;
                }
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Gateway getGateway() {
            return this.gateway;
        }

        @Override
        public Region getRegion() {
            return this.region;
        }

        @Override
        public int getBattleNetId() {
            return this.battleNetId;
        }

        @Override
        public PlayerType getPlayerType() {
            return this.playerType;
        }
    }
}

