/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.components;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import java.awt.Dimension;
import java.io.File;
import java.util.Date;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ReplayInfoBox
extends JScrollPane {
    private final JLabel versionLabel = new JLabel();
    private final JLabel dateLabel = new JLabel();
    private final JLabel lengthLabel = new JLabel();
    private final JLabel speedLabel = new JLabel();
    private final JLabel typeLabel = new JLabel();
    private final JLabel formatLabel = new JLabel();
    private final JLabel gatewayLabel = new JLabel();
    private final JLabel mapLabel = new JLabel();
    private final JLabel playersLabel = new JLabel();
    private final JLabel mapPreviewLabel = new JLabel();

    public ReplayInfoBox() {
        this((File)null);
    }

    public ReplayInfoBox(File file) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(Language.getText("module.repAnalyzer.tab.gameInfo.title")));
        box.add(this.versionLabel);
        box.add(this.dateLabel);
        box.add(this.lengthLabel);
        box.add(this.speedLabel);
        box.add(this.typeLabel);
        box.add(this.formatLabel);
        box.add(this.gatewayLabel);
        box.add(this.mapLabel);
        box.add(this.playersLabel);
        box.add(this.mapPreviewLabel);
        box.setPreferredSize(new Dimension(300, 440));
        this.setViewportView(box);
        if (file != null) {
            this.setReplayFile(file);
        }
    }

    public void setReplayFile(File file) {
        Replay replay = ReplayFactory.parseReplay(file.getAbsolutePath(), EnumSet.of(ReplayFactory.ReplayContent.INIT_DATA, ReplayFactory.ReplayContent.DETAILS, ReplayFactory.ReplayContent.ATTRIBUTES_EVENTS, ReplayFactory.ReplayContent.MAP_INFO));
        if (replay == null) {
            this.versionLabel.setText(Language.getText("fileChooser.failedToParseRepaly"));
            this.dateLabel.setText("");
            this.lengthLabel.setText("");
            this.speedLabel.setText("");
            this.typeLabel.setText("");
            this.formatLabel.setText("");
            this.gatewayLabel.setText("");
            this.playersLabel.setText("");
            this.mapLabel.setText("");
            this.mapPreviewLabel.setIcon(null);
        } else {
            this.versionLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.version", replay.version));
            this.dateLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.date", Language.formatDateTime(new Date(replay.details.saveTime))));
            this.lengthLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(replay.gameLength * 500, replay.converterGameSpeed)));
            this.speedLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{replay.initData.gameSpeed}));
            this.typeLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{replay.initData.gameType}));
            this.formatLabel.setText(replay.initData.format == null ? "" : Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{replay.initData.format}));
            this.gatewayLabel.setText(replay.initData.gateway == null ? "" : Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{replay.initData.gateway}));
            this.playersLabel.setText(String.valueOf(Language.getText("module.repAnalyzer.tab.gameInfo.players")) + " " + replay.details.getPlayerNames());
            this.mapLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", replay.details.mapName));
            this.mapPreviewLabel.setIcon(replay.mapInfo == null ? null : replay.mapInfo.previewIcon);
        }
    }
}

