/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.components;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.CustomMenuItemSpec;
import hu.belicza.andras.sc2gears.ui.dialogs.ProgressDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ReplayRenameDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ShareReplayDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.ObjectRegistry;
import hu.belicza.andras.sc2gearspluginapi.api.listener.ReplayOpCallback;
import hu.belicza.andras.sc2gearspluginapi.api.listener.ReplayOpsPopupMenuItemListener;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ReplayOperationsPopupMenu
extends JPopupMenu
implements ActionListener {
    private static final ObjectRegistry<CustomReplayOpsMenuItemSpec> customMenuItemRegistry = new ObjectRegistry();
    private final JMenuItem openInAnalyzerMenuItem = new JMenuItem(Language.getText("replayops.openInAnalyzer"), Icons.CHART);
    private final JMenuItem openInMultiRepAnalMenuItem = new JMenuItem(Language.getText("replayops.openInMultiRepAnal"), Icons.CHART_UP_COLOR);
    private final JMenuItem watchReplayMenuItem = new JMenuItem(Language.getText("replayops.watchReplay"), Icons.WATCH_REPLAY);
    private final JMenuItem copyReplaysMenuItem = new JMenuItem(Language.getText("replayops.copyReplays"), Icons.DOCUMENT_COPY);
    private final JMenuItem moveReplaysMenuItem = new JMenuItem(Language.getText("replayops.moveReplays"), Icons.DOCUMENT_EXPORT);
    private final JMenuItem packReplaysMenuItem = new JMenuItem(Language.getText("replayops.packReplays"), Icons.DOCUMENT_ZIPPER);
    private final JMenuItem renameReplaysMenuItem = new JMenuItem(Language.getText("replayops.renameReplays"), Icons.DOCUMENT_RENAME);
    public final JMenuItem deleteReplaysMenuItem = new JMenuItem(Language.getText("replayops.deleteReplays"), Icons.CROSS);
    private final JMenuItem openReplaysFolderMenuItem = new JMenuItem(Language.getText("replayops.openReplaysFolder"), Icons.FOLDER_OPEN);
    private final JMenuItem storeReplaysMenuItem = new JMenuItem(Language.getText("replayops.storeReplays"), Icons.SERVER_NETWORK);
    private final JMenuItem shareReplayMenuItem = new JMenuItem(Language.getText("replayops.shareReplay"), Icons.DOCUMENT_SHARE);
    private final JMenuItem exportActionsMenuItem = new JMenuItem(Language.getText("replayops.exportActions"), Icons.NOTEBOOK_ARROW);
    private final File[] files;
    private final ReplayOpCallback replayOpCallback;

    public static Integer addReplayOpsPopupMenuItem(String string, Icon icon, ReplayOpsPopupMenuItemListener replayOpsPopupMenuItemListener) {
        CustomReplayOpsMenuItemSpec customReplayOpsMenuItemSpec = new CustomReplayOpsMenuItemSpec(string, icon, replayOpsPopupMenuItemListener);
        customMenuItemRegistry.add(customReplayOpsMenuItemSpec);
        return customReplayOpsMenuItemSpec.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeReplayOpsPopupMenuItem(Integer n) {
        ObjectRegistry<CustomReplayOpsMenuItemSpec> objectRegistry = customMenuItemRegistry;
        synchronized (objectRegistry) {
            for (CustomReplayOpsMenuItemSpec customReplayOpsMenuItemSpec : customMenuItemRegistry) {
                if (!customReplayOpsMenuItemSpec.handler.equals(n)) continue;
                customMenuItemRegistry.remove(customReplayOpsMenuItemSpec);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplayOperationsPopupMenu(final File[] fileArray, final ReplayOpCallback replayOpCallback) {
        this.files = fileArray;
        this.replayOpCallback = replayOpCallback;
        this.openInAnalyzerMenuItem.addActionListener(this);
        this.add(this.openInAnalyzerMenuItem);
        this.openInMultiRepAnalMenuItem.addActionListener(this);
        this.add(this.openInMultiRepAnalMenuItem);
        this.watchReplayMenuItem.addActionListener(this);
        this.add(this.watchReplayMenuItem);
        this.addSeparator();
        this.copyReplaysMenuItem.addActionListener(this);
        this.add(this.copyReplaysMenuItem);
        this.moveReplaysMenuItem.addActionListener(this);
        this.add(this.moveReplaysMenuItem);
        this.packReplaysMenuItem.addActionListener(this);
        this.add(this.packReplaysMenuItem);
        this.renameReplaysMenuItem.addActionListener(this);
        this.add(this.renameReplaysMenuItem);
        this.deleteReplaysMenuItem.addActionListener(this);
        this.add(this.deleteReplaysMenuItem);
        this.addSeparator();
        this.openReplaysFolderMenuItem.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
        this.openReplaysFolderMenuItem.addActionListener(this);
        this.add(this.openReplaysFolderMenuItem);
        this.addSeparator();
        this.storeReplaysMenuItem.addActionListener(this);
        this.add(this.storeReplaysMenuItem);
        this.shareReplayMenuItem.addActionListener(this);
        this.add(this.shareReplayMenuItem);
        this.addSeparator();
        this.exportActionsMenuItem.addActionListener(this);
        this.add(this.exportActionsMenuItem);
        ObjectRegistry<CustomReplayOpsMenuItemSpec> objectRegistry = customMenuItemRegistry;
        synchronized (objectRegistry) {
            if (!customMenuItemRegistry.isEmpty()) {
                this.addSeparator();
                for (final CustomReplayOpsMenuItemSpec customReplayOpsMenuItemSpec : customMenuItemRegistry) {
                    JMenuItem jMenuItem = new JMenuItem(customReplayOpsMenuItemSpec.text, customReplayOpsMenuItemSpec.icon);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            customReplayOpsMenuItemSpec.listener.actionPerformed(fileArray, replayOpCallback, customReplayOpsMenuItemSpec.handler);
                        }
                    });
                    this.add(jMenuItem);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openInAnalyzerMenuItem) {
            MainFrame.INSTANCE.openReplayFile(this.files[0]);
            return;
        } else if (actionEvent.getSource() == this.openInMultiRepAnalMenuItem) {
            MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(this.files);
            return;
        } else if (actionEvent.getSource() == this.watchReplayMenuItem) {
            GeneralUtils.launchReplay(this.files[0]);
            return;
        } else if (actionEvent.getSource() == this.copyReplaysMenuItem || actionEvent.getSource() == this.moveReplaysMenuItem || actionEvent.getSource() == this.deleteReplaysMenuItem) {
            File file;
            boolean bl;
            boolean bl2 = actionEvent.getSource() == this.copyReplaysMenuItem;
            final boolean bl3 = actionEvent.getSource() == this.moveReplaysMenuItem;
            final boolean bl4 = actionEvent.getSource() == this.deleteReplaysMenuItem;
            final boolean bl5 = bl2 || bl3;
            boolean bl6 = bl = bl3 || bl4;
            if (bl5) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle(Language.getText(bl2 ? "replayops.selectCopyTargetFolder" : "replayops.selectMoveTargetFolder"));
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) return;
                file = jFileChooser.getSelectedFile();
            } else {
                file = null;
                if (GuiUtils.showConfirmDialog(Language.getText("replayops.deleteConfirmation", this.files.length), true, new Frame[0]) != 0) {
                    return;
                }
            }
            final ProgressDialog progressDialog = new ProgressDialog(bl2 ? "replayops.copyingReplays" : (bl3 ? "replayops.movingReplays" : "replayops.deletingReplays"), bl2 ? Icons.DOCUMENT_COPY : (bl3 ? Icons.DOCUMENT_EXPORT : Icons.CROSS), this.files.length);
            new NormalThread(bl2 ? "Replay copier" : (bl3 ? "Replay mover" : "Replay deleter")){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    var1_1 = bl4 != false ? null : new byte[16384];
                    var2_2 = 0;
                    var3_3 = 0;
                    var4_4 = 0;
                    while (var4_4 < ReplayOperationsPopupMenu.access$0(ReplayOperationsPopupMenu.this).length) {
                        var5_5 = ReplayOperationsPopupMenu.access$0(ReplayOperationsPopupMenu.this)[var4_4];
                        if (!bl5) ** GOTO lbl14
                        if (!GeneralUtils.copyFile(var5_5, file, var1_1, null)) {
                            progressDialog.incrementFailed();
                            progressDialog.incrementProcessed();
                            progressDialog.updateProgressBar();
                        } else {
                            ++var2_2;
lbl14:
                            // 2 sources

                            if (bl) {
                                if (var5_5.delete()) {
                                    if (!bl3 && ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this) != null) {
                                        ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this).replayDeleted(var5_5, var4_4);
                                    }
                                    ++var3_3;
                                } else if (bl4) {
                                    progressDialog.incrementFailed();
                                }
                                if (bl3 && ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this) != null) {
                                    ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this).replayMoved(var5_5, file, var4_4);
                                }
                            }
                            progressDialog.incrementProcessed();
                            progressDialog.updateProgressBar();
                        }
                        ++var4_4;
                    }
                    if (ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this) != null) {
                        ReplayOperationsPopupMenu.access$1(ReplayOperationsPopupMenu.this).moveRenameDeleteEnded();
                    }
                    progressDialog.taskFinished();
                    if (bl3 && var3_3 < var2_2) {
                        progressDialog.setCustomMessage(Language.getText("replayops.moveReplaysResult", new Object[]{var2_2, var2_2 - var3_3}));
                    }
                }
            }.start();
            return;
        } else if (actionEvent.getSource() == this.packReplaysMenuItem) {
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(Language.getText("replayops.selectFileToPackTo"));
            jFileChooser.setFileFilter(GuiUtils.ZIP_FILE_FILTER);
            jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            final JCheckBox jCheckBox = GuiUtils.createCheckBox("replayops.includePathInZip", "module.repSearch.results.includePathInZip");
            jFileChooser.setAccessory(jCheckBox);
            if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) != 0) return;
            final ProgressDialog progressDialog = new ProgressDialog("replayops.packingReplays", Icons.DOCUMENT_ZIPPER, this.files.length);
            new NormalThread("Replay packer"){

                @Override
                public void run() {
                    block32: {
                        File file = jFileChooser.getSelectedFile();
                        if (!GuiUtils.ZIP_FILE_FILTER.accept(file)) {
                            file = new File(String.valueOf(file.getAbsolutePath()) + ".zip");
                        }
                        ZipOutputStream zipOutputStream = null;
                        try {
                            try {
                                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                                boolean bl = jCheckBox.isSelected();
                                byte[] byArray = new byte[16384];
                                File[] fileArray = ReplayOperationsPopupMenu.this.files;
                                int n = fileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    block30: {
                                        File file2 = fileArray[n2];
                                        if (progressDialog.isAborted()) break;
                                        ZipEntry zipEntry = new ZipEntry(bl ? file2.getAbsolutePath() : file2.getName());
                                        zipEntry.setTime(file2.lastModified());
                                        zipOutputStream.putNextEntry(zipEntry);
                                        FileInputStream fileInputStream = null;
                                        try {
                                            try {
                                                int n3;
                                                fileInputStream = new FileInputStream(file2);
                                                while ((n3 = fileInputStream.read(byArray)) > 0) {
                                                    zipOutputStream.write(byArray, 0, n3);
                                                }
                                                fileInputStream.close();
                                            }
                                            catch (Exception exception) {
                                                progressDialog.incrementFailed();
                                                exception.printStackTrace();
                                                if (fileInputStream != null) {
                                                    try {
                                                        fileInputStream.close();
                                                    }
                                                    catch (IOException iOException) {}
                                                }
                                                break block30;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (fileInputStream != null) {
                                                try {
                                                    fileInputStream.close();
                                                }
                                                catch (IOException iOException) {
                                                    // empty catch block
                                                }
                                            }
                                            throw throwable;
                                        }
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    zipOutputStream.closeEntry();
                                    progressDialog.incrementProcessed();
                                    progressDialog.updateProgressBar();
                                    ++n2;
                                }
                                zipOutputStream.flush();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (zipOutputStream != null) {
                                    try {
                                        zipOutputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block32;
                            }
                        }
                        catch (Throwable throwable) {
                            if (zipOutputStream != null) {
                                try {
                                    zipOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    progressDialog.taskFinished();
                }
            }.start();
            return;
        } else if (actionEvent.getSource() == this.renameReplaysMenuItem) {
            new ReplayRenameDialog(this.replayOpCallback, this.files);
            return;
        } else if (actionEvent.getSource() == this.openReplaysFolderMenuItem) {
            try {
                Desktop.getDesktop().open(this.files[0].getParentFile());
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        } else if (actionEvent.getSource() == this.storeReplaysMenuItem) {
            final String string = GeneralUtils.checkKeyBeforeStoringOrDownloading(new Frame[0]);
            if (string == null) {
                return;
            }
            final ProgressDialog progressDialog = new ProgressDialog("replayops.storingReplays", Icons.SERVER_NETWORK, this.files.length);
            new NormalThread("Replay storer"){

                @Override
                public void run() {
                    File[] fileArray = ReplayOperationsPopupMenu.this.files;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (progressDialog.isAborted()) break;
                        if (!GeneralUtils.storeReplay(file, string)) {
                            progressDialog.incrementFailed();
                        }
                        progressDialog.incrementProcessed();
                        progressDialog.updateProgressBar();
                        ++n2;
                    }
                    progressDialog.taskFinished();
                }
            }.start();
            return;
        } else if (actionEvent.getSource() == this.shareReplayMenuItem) {
            new ShareReplayDialog(this.files[0]);
            return;
        } else {
            if (actionEvent.getSource() != this.exportActionsMenuItem) return;
            final ProgressDialog progressDialog = new ProgressDialog("replayops.exportingActions", Icons.NOTEBOOK_ARROW, this.files.length);
            new NormalThread("Actions exporter"){

                @Override
                public void run() {
                    File[] fileArray = ReplayOperationsPopupMenu.this.files;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block12: {
                            File file = fileArray[n2];
                            if (progressDialog.isAborted()) break;
                            Replay replay = ReplayFactory.parseReplay(file.getAbsolutePath(), ReplayFactory.GENERAL_DATA_CONTENT);
                            if (replay == null) {
                                progressDialog.incrementFailed();
                            } else {
                                File file2 = GeneralUtils.generateUniqueName(new File(file.getParent(), String.valueOf(GeneralUtils.getFileNameWithoutExt(file)) + ".txt"));
                                PrintWriter printWriter = null;
                                try {
                                    try {
                                        printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"), false);
                                        GameEvents.Action[] actionArray = replay.gameEvents.actions;
                                        int n3 = replay.gameEvents.actions.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            GameEvents.Action action = actionArray[n4];
                                            printWriter.println(action.toString());
                                            ++n4;
                                        }
                                        printWriter.flush();
                                    }
                                    catch (Exception exception) {
                                        progressDialog.incrementFailed();
                                        exception.printStackTrace();
                                        if (printWriter != null) {
                                            printWriter.close();
                                        }
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (printWriter != null) {
                                        printWriter.close();
                                    }
                                    throw throwable;
                                }
                                if (printWriter != null) {
                                    printWriter.close();
                                }
                            }
                        }
                        progressDialog.incrementProcessed();
                        progressDialog.updateProgressBar();
                        ++n2;
                    }
                    progressDialog.taskFinished();
                }
            }.start();
        }
    }

    static /* synthetic */ ReplayOpCallback access$1(ReplayOperationsPopupMenu replayOperationsPopupMenu) {
        return replayOperationsPopupMenu.replayOpCallback;
    }

    private static class CustomReplayOpsMenuItemSpec
    extends CustomMenuItemSpec {
        public final ReplayOpsPopupMenuItemListener listener;

        public CustomReplayOpsMenuItemSpec(String string, Icon icon, ReplayOpsPopupMenuItemListener replayOpsPopupMenuItemListener) {
            super(string, icon);
            this.listener = replayOpsPopupMenuItemListener;
        }
    }
}

