/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.components;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.util.TextFilter;
import hu.belicza.andras.sc2gearspluginapi.api.ui.ITableBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableBox
extends Box
implements ITableBox {
    private final JButton clearFiltersButton = new JButton();

    public TableBox(JTable jTable, JComponent jComponent) {
        super(1);
        this.add(this.createTableFilterComponent(jTable, jComponent));
        this.add(jTable.getTableHeader());
        this.add(new JScrollPane(jTable));
    }

    private JComponent createTableFilterComponent(final JTable jTable, JComponent jComponent) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(3));
        final JLabel jLabel = new JLabel(Language.getText("general.tableFilter.filterRows"));
        jLabel.setOpaque(true);
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(3));
        final JTextField jTextField = new JTextField(15);
        jTextField.setToolTipText(Language.getText("general.tableFilter.filterRowsToolTip"));
        box.add(jTextField);
        box.add(Box.createHorizontalStrut(3));
        final JLabel jLabel2 = new JLabel(Language.getText("general.tableFilter.filterOutRows"));
        jLabel2.setOpaque(true);
        box.add(jLabel2);
        box.add(Box.createHorizontalStrut(3));
        final JTextField jTextField2 = new JTextField(15);
        jTextField2.setToolTipText(Language.getText("general.tableFilter.filterOutRowsToolTip"));
        box.add(jTextField2);
        box.add(Box.createHorizontalStrut(3));
        GuiUtils.updateButtonText(this.clearFiltersButton, "general.tableFilter.clearFiltersButton", new Object[0]);
        this.clearFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.setText(null);
                jTextField2.setText(null);
            }
        });
        box.add(this.clearFiltersButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(new JLabel(Language.getText("general.tableFilter.rows")));
        box.add(Box.createHorizontalStrut(3));
        final JLabel jLabel3 = new JLabel();
        box.add(jLabel3);
        box.add(Box.createHorizontalStrut(3));
        box.add(new JPanel(new BorderLayout()));
        box.add(new JLabel("<html></html>"));
        box.add(new JLabel("<html></html>"));
        box.setMaximumSize(new Dimension(box.getMaximumSize().width, 1));
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                jLabel3.setText(String.valueOf(jTable.getRowCount()) + " / " + jTable.getModel().getRowCount());
            }
        };
        final DefaultRowSorter defaultRowSorter = (DefaultRowSorter)jTable.getRowSorter();
        defaultRowSorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent rowSorterEvent) {
                runnable.run();
            }
        });
        jTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                runnable.run();
            }
        });
        runnable.run();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setFilter();
            }

            private void setFilter() {
                final Vector<Vector> vector = ((DefaultTableModel)jTable.getModel()).getDataVector();
                final TextFilter textFilter = new TextFilter(jTextField.getText().toLowerCase(), jTextField2.getText().toLowerCase());
                jLabel.setBackground(textFilter.isIncludeFilterActive() ? Color.GREEN : null);
                jLabel2.setBackground(textFilter.isExcludeFilterActive() ? Color.GREEN : null);
                if (textFilter.isFilterSpecified()) {
                    defaultRowSorter.setRowFilter(new RowFilter<TableModel, Integer>(){
                        private final StringBuilder rowStringBuilder = new StringBuilder();

                        @Override
                        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                            this.rowStringBuilder.setLength(0);
                            for (Object e : (Vector)vector.get(entry.getIdentifier())) {
                                if (e == null) continue;
                                this.rowStringBuilder.append(e.toString()).append(' ');
                            }
                            return textFilter.isIncluded(this.rowStringBuilder.toString().toLowerCase());
                        }
                    });
                } else {
                    defaultRowSorter.setRowFilter(null);
                }
            }
        };
        jTextField.getDocument().addDocumentListener(documentListener);
        jTextField2.getDocument().addDocumentListener(documentListener);
        InputMap inputMap = jComponent.getInputMap(1);
        ActionMap actionMap = jComponent.getActionMap();
        Object object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(70, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.requestFocusInWindow();
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(84, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.requestFocusInWindow();
            }
        });
        return box;
    }

    @Override
    public void clearFilters() {
        this.clearFiltersButton.doClick(0);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

