/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.util.Holder;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

class BaseDialog
extends JDialog {
    public BaseDialog(String string, ImageIcon imageIcon) {
        super(MainFrame.INSTANCE, Language.getText(string), true);
        this.completeInit(imageIcon);
    }

    public BaseDialog(Frame frame, String string, ImageIcon imageIcon) {
        super(frame, Language.getText(string), true);
        this.completeInit(imageIcon);
    }

    public BaseDialog(Dialog dialog, String string, ImageIcon imageIcon) {
        super(dialog, Language.getText(string));
        this.completeInit(imageIcon);
    }

    public BaseDialog(Holder<String> holder, ImageIcon imageIcon) {
        super(MainFrame.INSTANCE, (String)holder.value, true);
        this.completeInit(imageIcon);
    }

    public BaseDialog(Frame frame, Holder<String> holder, ImageIcon imageIcon) {
        super(frame, (String)holder.value, true);
        this.completeInit(imageIcon);
    }

    public BaseDialog(Dialog dialog, Holder<String> holder, ImageIcon imageIcon) {
        super(dialog, (String)holder.value);
        this.completeInit(imageIcon);
    }

    public BaseDialog(String string, Object[] objectArray) {
        super(MainFrame.INSTANCE, Language.getText(string, objectArray), true);
        this.completeInit(null);
    }

    public BaseDialog(String string, Object[] objectArray, ImageIcon imageIcon) {
        super(MainFrame.INSTANCE, Language.getText(string, objectArray), true);
        this.completeInit(imageIcon);
    }

    private void completeInit(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.setDefaultCloseOperation(2);
    }

    protected void packAndShow(final JComponent jComponent, boolean bl) {
        this.pack();
        GuiUtils.centerWindowToWindow(this, MainFrame.INSTANCE);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jComponent.requestFocusInWindow();
                }
            });
        } else {
            jComponent.requestFocusInWindow();
        }
        this.setVisible(true);
    }

    protected JButton createCloseButton(String string) {
        JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, string, new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.dispose();
            }
        });
        return jButton;
    }
}

