/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.services.plugins.PluginControl;
import hu.belicza.andras.sc2gears.services.plugins.PluginManager;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DiagnosticToolDialog
extends BaseDialog {
    private final JTextArea detailsArea = new JTextArea();

    public DiagnosticToolDialog() {
        super("diagnosticTool.title", Icons.SYSTEM_MONITOR);
        Serializable serializable;
        IntHolder intHolder;
        Object object;
        List<DiagnosticTest> list = this.createDiagnosticTestList();
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        Box box2 = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(Language.getText("diagnosticTool.summary"));
        GuiUtils.changeFontToBold(jLabel);
        jLabel.setFont(jLabel.getFont().deriveFont(24.0f));
        box2.add(jLabel);
        box2.add(Box.createHorizontalStrut(10));
        JLabel jLabel2 = new JLabel();
        GuiUtils.changeFontToBold(jLabel2);
        jLabel2.setFont(jLabel2.getFont().deriveFont(24.0f));
        box2.add(jLabel2);
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        Box box3 = Box.createHorizontalBox();
        box.add(box3);
        this.getContentPane().add((Component)box, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        String[] stringArray = new String[]{"diagnosticTool.header.testName", "diagnosticTool.header.result", "diagnosticTool.header.details"};
        Vector<String> vector = new Vector<String>(stringArray.length);
        vector.add("#");
        Object object2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            vector.add(Language.getText((String)object));
            ++n2;
        }
        object = GuiUtils.createNonEditableTable();
        Vector vector2 = new Vector();
        DiagnosticTest.Result result = DiagnosticTest.Result.OK;
        object2 = new EnumMap(DiagnosticTest.Result.class);
        int n3 = 0;
        while (n3 < list.size()) {
            DiagnosticTest diagnosticTest = list.get(n3);
            diagnosticTest.execute();
            if (diagnosticTest.result.ordinal() < result.ordinal()) {
                result = diagnosticTest.result;
            }
            if ((intHolder = (IntHolder)object2.get((Object)diagnosticTest.result)) == null) {
                object2.put(diagnosticTest.result, new IntHolder(1));
            } else {
                ++intHolder.value;
            }
            serializable = new Vector<Object>();
            ((Vector)serializable).add(n3 + 1);
            ((Vector)serializable).add(diagnosticTest.name);
            ((Vector)serializable).add(diagnosticTest.result);
            ((Vector)serializable).add(diagnosticTest.details);
            vector2.add(serializable);
            ++n3;
        }
        jLabel2.setIcon(result.iconBig);
        jLabel2.setText(result.stringValue);
        DiagnosticTest.Result[] resultArray = DiagnosticTest.Result.values();
        int n4 = resultArray.length - 1;
        while (n4 >= 0) {
            intHolder = (IntHolder)object2.get((Object)resultArray[n4]);
            if (intHolder != null) {
                if (box3.getComponentCount() > 0) {
                    box3.add(Box.createHorizontalStrut(15));
                }
                serializable = new JLabel(String.valueOf(resultArray[n4].stringValue) + ":  " + intHolder.value + " / " + list.size() + "  (" + intHolder.value * 100 / list.size() + "%)", resultArray[n4].icon, 2);
                box3.add((Component)serializable);
            }
            --n4;
        }
        ((JTable)object).setModel(new DefaultTableModel(vector2, vector){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 2) {
                    return DiagnosticTest.Result.class;
                }
                return super.getColumnClass(n);
            }
        });
        ((JTable)object).setDefaultRenderer(DiagnosticTest.Result.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                DiagnosticTest.Result result = (DiagnosticTest.Result)((Object)object);
                jLabel.setText(result.stringValue);
                jLabel.setIcon(result.icon);
                return jLabel;
            }
        });
        ((JTable)object).setSelectionMode(0);
        ((JTable)object).setPreferredScrollableViewportSize(new Dimension(1000, 300));
        ((JTable)object).getSelectionModel().addListSelectionListener(new ListSelectionListener((JTable)object, list, vector){
            private final /* synthetic */ JTable val$testTable;
            private final /* synthetic */ List val$diagnosticTestList;
            private final /* synthetic */ Vector val$columnNameVector;
            {
                this.val$testTable = jTable;
                this.val$diagnosticTestList = list;
                this.val$columnNameVector = vector;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = this.val$testTable.getSelectedRow();
                if (n < 0) {
                    DiagnosticToolDialog.this.detailsArea.setText("");
                } else {
                    DiagnosticTest diagnosticTest = (DiagnosticTest)this.val$diagnosticTestList.get(n);
                    DiagnosticToolDialog.this.detailsArea.setText(String.valueOf((String)this.val$columnNameVector.get(0)) + ": " + (n + 1) + "\n" + (String)this.val$columnNameVector.get(1) + ": " + diagnosticTest.name + "\n" + (String)this.val$columnNameVector.get(2) + ": " + diagnosticTest.result.stringValue + "\n" + (String)this.val$columnNameVector.get(3) + ": " + (diagnosticTest.details == null ? "" : diagnosticTest.details));
                    DiagnosticToolDialog.this.detailsArea.setCaretPosition(0);
                }
            }
        });
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        GuiUtils.packTable((JTable)object, nArray);
        jPanel.add((Component)new JScrollPane((Component)object), "Center");
        this.detailsArea.setEditable(false);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setRows(7);
        JScrollPane jScrollPane = new JScrollPane(this.detailsArea);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Language.getText("diagnosticTool.detailsTitle")));
        jPanel.add((Component)jScrollPane, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        serializable = new JPanel();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
        JButton jButton = this.createCloseButton("button.close");
        ((Container)serializable).add(jButton);
        this.getContentPane().add((Component)serializable, "South");
        this.packAndShow(jButton, false);
    }

    private List<DiagnosticTest> createDiagnosticTestList() {
        ArrayList<DiagnosticTest> arrayList = new ArrayList<DiagnosticTest>();
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkMemory.name", new Object[]{"Sc2gears"}){

            @Override
            public void execute() {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.totalMemory();
                long l2 = runtime.freeMemory();
                long l3 = runtime.maxMemory();
                long l4 = l2 + (l3 - l) >> 20;
                int n = 10;
                int n2 = 50;
                if (l4 < 10L) {
                    this.result = DiagnosticTest.Result.FAIL;
                    this.details = Language.getText("diagnosticTool.test.checkMemory.fail", 10, "Sc2gears");
                } else if (l4 < 50L) {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkMemory.warning", 50, "Sc2gears");
                } else {
                    this.result = DiagnosticTest.Result.OK;
                }
                String string = Language.getText("diagnosticTool.test.checkMemory.memoryValues", l >> 20, l2 >> 20, l3 >> 20, l4);
                this.details = this.details == null ? string : String.valueOf(this.details) + " (" + string + ")";
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkJavaVersion.name", new Object[0]){

            @Override
            public void execute() {
                int n;
                int n2;
                String string = System.getProperty("java.version");
                try {
                    int n3 = string.indexOf(46);
                    n2 = Integer.parseInt(string.substring(0, n3));
                    n = Integer.parseInt(string.substring(n3 + 1, string.indexOf(46, n3 + 1)));
                }
                catch (Exception exception) {
                    this.result = DiagnosticTest.Result.ERROR;
                    this.details = Language.getText("diagnosticTool.test.checkJavaVersion.error");
                    return;
                }
                String string2 = String.valueOf(string) + " - " + System.getProperty("java.vendor");
                if (n2 >= 6 || n2 == 1 && n >= 6 || n2 >= 2) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = string2;
                } else {
                    this.result = DiagnosticTest.Result.FAIL;
                    this.details = Language.getText("diagnosticTool.test.checkJavaVersion.fail", string2);
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkAutoCheckUpdatesSetting.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.checkUpdatesOnStartup")) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.enabled");
                } else {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkAutoCheckUpdatesSetting.warning", "Sc2gears");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkUserContentFolders.name", new Object[]{"Sc2gears"}){

            @Override
            public void execute() {
                String[] stringArray = Consts.USER_CONTENT_FOLDERS;
                int n = Consts.USER_CONTENT_FOLDERS.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    File file = new File(string);
                    if (!this.checkFileExist(file) || !this.checkFolderWritePermission(file)) break;
                    ++n2;
                }
                if (this.result == null && this.checkFreeSpace(new File(Consts.USER_CONTENT_FOLDERS[0]))) {
                    this.result = DiagnosticTest.Result.OK;
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkSc2InstallFolder.name", new Object[0]){

            @Override
            public void execute() {
                File file = new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isMac() ? "StarCraft II.app/Contents/MacOS/StarCraft II" : "StarCraft II.exe");
                if (this.checkFileExist(file)) {
                    this.result = DiagnosticTest.Result.OK;
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkSc2AutoRepFolder.name", new Object[0]){

            @Override
            public void execute() {
                List<File> list = GeneralUtils.getAutoRepFolderList();
                int n = 0;
                this.details = "";
                for (File file : list) {
                    if (file.exists()) {
                        ++n;
                        continue;
                    }
                    if (this.details.length() > 0) {
                        this.details = String.valueOf(this.details) + ", ";
                    }
                    this.details = String.valueOf(this.details) + '\"' + file.getAbsolutePath() + '\"';
                }
                DiagnosticTest.Result result = n == 0 ? DiagnosticTest.Result.FAIL : (this.result = n == list.size() ? DiagnosticTest.Result.OK : DiagnosticTest.Result.WARNING);
                if (this.result == DiagnosticTest.Result.FAIL) {
                    this.details = String.valueOf(Language.getText("diagnosticTool.test.checkSc2AutoRepFolder.fail")) + " (" + this.details + ")";
                } else if (this.result == DiagnosticTest.Result.WARNING) {
                    this.details = String.valueOf(Language.getText("diagnosticTool.test.checkSc2AutoRepFolder.warning")) + " (" + this.details + ")";
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkSc2MapsFolder.name", new Object[0]){

            @Override
            public void execute() {
                File file = new File(Settings.getString("settings.folders.sc2Maps"));
                if (this.checkFileExist(file)) {
                    this.result = DiagnosticTest.Result.OK;
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkReplayAutoSaveFolder.name", new Object[0]){

            @Override
            public void execute() {
                File file = new File(Settings.getString("settings.folders.replayAutoSave"));
                if (this.checkFileExist(file) && this.checkFolderWritePermission(file) && this.checkFreeSpace(file)) {
                    this.result = DiagnosticTest.Result.OK;
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkMousePrintOutputFolder.name", new Object[0]){

            @Override
            public void execute() {
                File file = new File(Settings.getString("settings.folders.mousePrintOutput"));
                if (this.checkFileExist(file) && this.checkFolderWritePermission(file) && this.checkFreeSpace(file)) {
                    this.result = DiagnosticTest.Result.OK;
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkReplayAutoSaveNameTemplate.name", new Object[0]){

            @Override
            public void execute() {
                try {
                    new TemplateEngine(Settings.getString("settings.misc.repAutoSaveNameTemplate"));
                    this.result = DiagnosticTest.Result.OK;
                }
                catch (Exception exception) {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkReplayAutoSaveNameTemplate.warning");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkInternalReplayCacheSetting.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.misc.cachePreprocessedReplays")) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.enabled");
                } else {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkInternalReplayCacheSetting.warning");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkReplayAutoSaveSetting.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.enableReplayAutoSave")) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.enabled");
                } else {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkReplayAutoSaveSetting.warning");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkMousePrintAutoSave.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.misc.saveMousePrints")) {
                    if (Settings.getBoolean("settings.enableApmAlert")) {
                        this.result = DiagnosticTest.Result.OK;
                        this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoSave.ok");
                    } else {
                        this.result = DiagnosticTest.Result.FAIL;
                        this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoSave.fail");
                    }
                } else {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoSave.warning");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkReplayAutoStoreSetting.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.misc.autoStoreNewReplays")) {
                    if (Settings.getBoolean("settings.enableReplayAutoSave")) {
                        this.result = DiagnosticTest.Result.OK;
                        this.details = Language.getText("diagnosticTool.test.checkReplayAutoStoreSetting.ok");
                    } else {
                        this.result = DiagnosticTest.Result.FAIL;
                        this.details = Language.getText("diagnosticTool.test.checkReplayAutoStoreSetting.fail");
                    }
                } else if (Settings.getString("settings.misc.authorizationKey").length() > 0) {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkReplayAutoStoreSetting.warning");
                } else {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.disabled");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkMousePrintAutoStoreSetting.name", new Object[0]){

            @Override
            public void execute() {
                if (Settings.getBoolean("settings.misc.storeMousePrints")) {
                    if (Settings.getBoolean("settings.misc.saveMousePrints")) {
                        this.result = DiagnosticTest.Result.OK;
                        this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoStoreSetting.ok");
                    } else {
                        this.result = DiagnosticTest.Result.FAIL;
                        this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoStoreSetting.fail");
                    }
                } else if (Settings.getString("settings.misc.authorizationKey").length() > 0) {
                    this.result = DiagnosticTest.Result.WARNING;
                    this.details = Language.getText("diagnosticTool.test.checkMousePrintAutoStoreSetting.warning");
                } else {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.disabled");
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkAuthorizationKey.name", new Object[0]){

            @Override
            public void execute() {
                String string = Settings.getString("settings.misc.authorizationKey");
                if (string.length() == 0) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = Language.getText("diagnosticTool.test.checkAuthorizationKey.notSet");
                } else {
                    Boolean bl = GeneralUtils.checkAuthorizationKey(string);
                    if (bl == null) {
                        this.result = DiagnosticTest.Result.WARNING;
                        this.details = Language.getText("diagnosticTool.test.checkAuthorizationKey.warning");
                    } else if (bl.booleanValue()) {
                        this.result = DiagnosticTest.Result.OK;
                        this.details = Language.getText("diagnosticTool.test.checkAuthorizationKey.ok");
                    } else {
                        this.result = DiagnosticTest.Result.FAIL;
                        this.details = Language.getText("diagnosticTool.test.checkAuthorizationKey.fail");
                    }
                }
            }
        });
        arrayList.add(new DiagnosticTest("diagnosticTool.test.checkPlugins.name", new Object[0]){

            @Override
            public void execute() {
                int n = 0;
                int n2 = 0;
                for (PluginControl pluginControl : PluginManager.getPluginControlVector()) {
                    if (!pluginControl.isEnabled) continue;
                    ++n;
                    if (pluginControl.status != PluginControl.Status.FAILED) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    this.result = DiagnosticTest.Result.OK;
                    this.details = n == 0 ? Language.getText("diagnosticTool.test.checkPlugins.noEnabledPlugins") : Language.getText("diagnosticTool.test.checkPlugins.ok", n);
                } else {
                    this.result = DiagnosticTest.Result.FAIL;
                    this.details = Language.getText("diagnosticTool.test.checkPlugins.fail", n2, n);
                }
            }
        });
        return arrayList;
    }

    protected static abstract class DiagnosticTest {
        public final String name;
        public Result result;
        public String details;

        public DiagnosticTest(String string, Object ... objectArray) {
            this.name = objectArray.length == 0 ? Language.getText(string) : Language.getText(string, objectArray);
        }

        public abstract void execute();

        protected boolean checkFileExist(File file) {
            if (file.exists()) {
                return true;
            }
            this.result = Result.FAIL;
            this.details = Language.getText("diagnosticTool.wasNotFound", file.getAbsolutePath());
            return false;
        }

        protected boolean checkFolderWritePermission(File file) {
            File file2 = GeneralUtils.generateUniqueName(new File(file, "test" + (int)(Math.random() * 2.147483647E9) + ".txt"));
            try {
                if (file2.createNewFile()) {
                    return true;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                file2.delete();
            }
            this.result = Result.FAIL;
            this.details = Language.getText("diagnosticTool.noPermissionInFolder", file.getAbsolutePath());
            return false;
        }

        protected boolean checkFreeSpace(File file) {
            long l = 10L;
            if (file.getFreeSpace() > 0xA00000L) {
                return true;
            }
            this.result = Result.WARNING;
            this.details = Language.getText("diagnosticTool.freeSpaceWarning", 10L);
            return false;
        }

        public static enum Result {
            ERROR("diagnosticTool.result.error", Icons.BURN, Icons.BURN),
            FAIL("diagnosticTool.result.fail", Icons.CROSS, Icons.CROSS_BIG),
            WARNING("diagnosticTool.result.warning", Icons.EXCLAMATION, Icons.EXCLAMATION_BIG),
            OK("diagnosticTool.result.ok", Icons.TICK, Icons.TICK_BIG);

            public final String stringValue;
            public final Icon icon;
            public final Icon iconBig;

            private Result(String string2, Icon icon, Icon icon2) {
                this.stringValue = Language.getText(string2);
                this.icon = icon;
                this.iconBig = icon2;
            }
        }
    }
}

