/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class GameTimeRealTimeConverterDialog
extends BaseDialog {
    public GameTimeRealTimeConverterDialog() {
        super("gameTimeRealTimeConverer.title", Icons.CALCULATOR);
        this.setModal(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Vector<ReplayConsts.GameSpeed> vector = new Vector<ReplayConsts.GameSpeed>(EnumSet.complementOf(EnumSet.of(ReplayConsts.GameSpeed.UNKNOWN)));
        Collections.sort(vector, Collections.reverseOrder());
        final JComboBox<ReplayConsts.GameSpeed> jComboBox = new JComboBox<ReplayConsts.GameSpeed>(vector);
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(100, 0, Integer.MAX_VALUE, 1));
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(100, 0, Integer.MAX_VALUE, 1));
        final JTextField jTextField = new JTextField("00:01:00", 10);
        final JTextField jTextField2 = new JTextField(10);
        final JButton jButton = new JButton(Icons.ARROW);
        final JButton jButton2 = new JButton(Icons.ARROW_180);
        final JButton jButton3 = new JButton(Icons.ARROW);
        final JButton jButton4 = new JButton(Icons.ARROW_180);
        final Holder<JButton> holder = new Holder<JButton>(jButton);
        final Holder<JButton> holder2 = new Holder<JButton>(jButton3);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplayConsts.GameSpeed gameSpeed = (ReplayConsts.GameSpeed)((Object)jComboBox.getSelectedItem());
                if (actionEvent.getSource() == jButton) {
                    jSpinner2.setValue(gameSpeed.convertToGameTime((Integer)jSpinner.getValue()));
                    if ((Integer)jSpinner2.getValue() < 0) {
                        jSpinner2.setValue(0);
                    }
                    holder.value = jButton;
                } else if (actionEvent.getSource() == jButton2) {
                    jSpinner.setValue(gameSpeed.convertToRealTime((Integer)jSpinner2.getValue()));
                    if ((Integer)jSpinner.getValue() < 0) {
                        jSpinner.setValue(0);
                    }
                    holder.value = jButton2;
                } else if (actionEvent.getSource() == jButton3) {
                    Integer n = GeneralUtils.parseSeconds(jTextField.getText());
                    jTextField2.setText(n == null ? "" : ReplayUtils.formatMs(n * 1000, gameSpeed));
                    holder2.value = jButton3;
                } else if (actionEvent.getSource() == jButton4) {
                    Integer n = GeneralUtils.parseSeconds(jTextField2.getText());
                    jTextField.setText(n == null ? "" : ReplayUtils.formatMs(gameSpeed.convertToGameTime(n) * 1000, ReplayConsts.GameSpeed.NORMAL));
                    holder2.value = jButton4;
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jButton4.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(Language.getText("gameTimeRealTimeConverer.gameSpeed")));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)holder.value).doClick(0);
                ((JButton)holder2.value).doClick(0);
            }
        });
        jComboBox.setSelectedIndex(0);
        jPanel.add(jComboBox);
        box.add(jPanel);
        Box box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(Language.getText("gameTimeRealTimeConverer.apmConverter")));
        box2.add(new JLabel(Language.getText("gameTimeRealTimeConverer.ingameApm")));
        box2.add(jSpinner);
        box2.add(Box.createHorizontalStrut(20));
        GuiUtils.updateButtonText(jButton, "gameTimeRealTimeConverer.toRealApmButton", new Object[0]);
        box2.add(jButton);
        GuiUtils.updateButtonText(jButton2, "gameTimeRealTimeConverer.toGameApmButton", new Object[0]);
        jButton2.setHorizontalTextPosition(2);
        box2.add(jButton2);
        box2.add(Box.createHorizontalStrut(20));
        box2.add(new JLabel(Language.getText("gameTimeRealTimeConverer.realApm")));
        box2.add(jSpinner2);
        box.add(box2);
        Box box3 = Box.createHorizontalBox();
        box3.setBorder(BorderFactory.createTitledBorder(Language.getText("gameTimeRealTimeConverer.timeConverter")));
        box3.add(new JLabel(Language.getText("gameTimeRealTimeConverer.ingameTime")));
        jTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
        box3.add(jTextField);
        box3.add(Box.createHorizontalStrut(20));
        GuiUtils.updateButtonText(jButton3, "gameTimeRealTimeConverer.toRealTimeButton", new Object[0]);
        box3.add(jButton3);
        GuiUtils.updateButtonText(jButton4, "gameTimeRealTimeConverer.toGameTimeButton", new Object[0]);
        jButton4.setHorizontalTextPosition(2);
        box3.add(jButton4);
        box3.add(Box.createHorizontalStrut(20));
        box3.add(new JLabel(Language.getText("gameTimeRealTimeConverer.realTime")));
        jTextField2.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
        box3.add(jTextField2);
        box.add(box3);
        Box[] boxArray = new Box[]{box2, box3};
        int n = box3.getComponentCount() - 1;
        while (n >= 0) {
            Box box4;
            int n2 = 0;
            Box[] boxArray2 = boxArray;
            int n3 = boxArray.length;
            int n4 = 0;
            while (n4 < n3) {
                box4 = boxArray2[n4];
                n2 = Math.max(box4.getComponent((int)n).getPreferredSize().width, n2);
                ++n4;
            }
            boxArray2 = boxArray;
            n3 = boxArray.length;
            n4 = 0;
            while (n4 < n3) {
                box4 = boxArray2[n4];
                box4.getComponent(n).setPreferredSize(new Dimension(n2, box4.getComponent((int)n).getPreferredSize().height));
                ++n4;
            }
            --n;
        }
        JButton jButton5 = this.createCloseButton("button.close");
        box.add(GuiUtils.wrapInPanel(jButton5));
        this.getContentPane().add(box);
        this.packAndShow(jButton5, false);
    }
}

