/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.importing.ReplaySpecification;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gearspluginapi.impl.PlayerSpecification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ImportBODialog
extends BaseDialog {
    private static final int MAX_BUILD_ORDERS = 8;

    public ImportBODialog() {
        super("importBuildOrders.title", Icons.BLOCK_ARROW);
        this.setModal(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel(Language.getText("importBuildOrders.info", "Sc2gears"));
        GuiUtils.changeFontToBold(jLabel);
        box.add(GuiUtils.wrapInPanel(jLabel));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(Language.getText("importBuildOrders.info2")));
        jPanel.add(GeneralUtils.createLinkLabel(Language.getText("importBuildOrders.boTextFormatSpecification"), "https://sites.google.com/site/sc2gears/features/build-order-import"));
        box.add(jPanel);
        jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jLabel.getForeground()));
        box.add(jPanel);
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createHorizontalBox();
        box3.add(new JLabel(Language.getText("importBuildOrders.replayVersionToSimulate")));
        final JComboBox<SimulatedVersion> jComboBox = new JComboBox<SimulatedVersion>(SimulatedVersion.values());
        box3.add(jComboBox);
        box2.add(box3);
        box3 = Box.createHorizontalBox();
        box3.add(new JLabel(Language.getText("importBuildOrders.gameSpeed")));
        Vector<ReplayConsts.GameSpeed> vector = new Vector<ReplayConsts.GameSpeed>(EnumSet.complementOf(EnumSet.of(ReplayConsts.GameSpeed.UNKNOWN)));
        Collections.sort(vector, Collections.reverseOrder());
        final JComboBox<ReplayConsts.GameSpeed> jComboBox2 = new JComboBox<ReplayConsts.GameSpeed>(vector);
        box3.add(jComboBox2);
        box2.add(box3);
        GuiUtils.alignBox(box2, 2);
        box.add(GuiUtils.wrapInPanel(box2));
        this.add((Component)box, "North");
        final ImportPanel[] importPanelArray = new ImportPanel[8];
        JPanel jPanel2 = new JPanel(new GridLayout(3, 3));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        int n = 0;
        while (n < importPanelArray.length) {
            importPanelArray[n] = new ImportPanel(n + 1);
            jPanel2.add(importPanelArray[n]);
            ++n;
        }
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JButton jButton = new JButton(Icons.CHART);
        GuiUtils.updateButtonText(jButton, "importBuildOrders.openBuildOrdersButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<PlayerSpecification> arrayList = new ArrayList<PlayerSpecification>(8);
                int n = 0;
                while (n < importPanelArray.length) {
                    ImportPanel importPanel = importPanelArray[n];
                    String string = importPanel.buildOrderTextArea.getText();
                    if (string.length() > 0) {
                        PlayerSpecification playerSpecification = new PlayerSpecification();
                        playerSpecification.name = "BO" + (n + 1);
                        playerSpecification.team = (Integer)importPanel.teamComboBox.getSelectedItem();
                        playerSpecification.buildOrderText = string;
                        arrayList.add(playerSpecification);
                    }
                    ++n;
                }
                ReplaySpecification replaySpecification = new ReplaySpecification();
                replaySpecification.version = ((SimulatedVersion)((Object)jComboBox.getSelectedItem())).version;
                replaySpecification.gameSpeed = (ReplayConsts.GameSpeed)((Object)jComboBox2.getSelectedItem());
                replaySpecification.playerSpecifications = arrayList.toArray(new PlayerSpecification[arrayList.size()]);
                MainFrame.INSTANCE.openReplaySpecification(replaySpecification);
                ImportBODialog.this.dispose();
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = this.createCloseButton("button.cancel");
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.packAndShow(jButton, false);
    }

    private static class ImportPanel
    extends JPanel {
        private final JTextArea buildOrderTextArea = new JTextArea(1, 14);
        private final JComboBox teamComboBox = new JComboBox();

        public ImportPanel(int n) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(Language.getText("importBuildOrders.importPanelTitle", n)));
            this.add((Component)new JScrollPane(this.buildOrderTextArea), "Center");
            JPanel jPanel = new JPanel(new GridLayout(3, 1));
            JButton jButton = new JButton(Language.getText("importBuildOrders.loadFromFileButton"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block15: {
                        JFileChooser jFileChooser = new JFileChooser(Settings.getString("importBO.latestImportFolder"));
                        jFileChooser.setDialogTitle(Language.getText("importBuildOrders.loadFromFileTitle"));
                        jFileChooser.setFileFilter(GuiUtils.TEXT_FILE_FILTER);
                        if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                            File file = jFileChooser.getSelectedFile();
                            String string = file.getParent();
                            if (string != null) {
                                Settings.set("importBO.latestImportFolder", file.getParent());
                            }
                            FileInputStream fileInputStream = null;
                            try {
                                try {
                                    fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
                                    byte[] byArray = new byte[(int)file.length()];
                                    if (fileInputStream.read(byArray) > 0) {
                                        ImportPanel.this.buildOrderTextArea.setText(new String(byArray, "UTF-8").replace("\r\n", "\n"));
                                    }
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    if (fileInputStream == null) break block15;
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                            }
                            finally {
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    }
                }
            });
            jPanel.add(jButton);
            JButton jButton2 = new JButton(Language.getText("importBuildOrders.clearButton"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImportPanel.this.buildOrderTextArea.setText("");
                }
            });
            jPanel.add(jButton2);
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(Language.getText("importBuildOrders.team")));
            int n2 = 1;
            while (n2 <= 8) {
                this.teamComboBox.addItem(n2);
                ++n2;
            }
            this.teamComboBox.setSelectedIndex(n - 1);
            box.add(this.teamComboBox);
            jPanel.add(box);
            this.add((Component)jPanel, "East");
        }
    }

    private static final class SimulatedVersion
    extends Enum<SimulatedVersion> {
        public static final /* enum */ SimulatedVersion V_1_3_4 = new SimulatedVersion("1.3.4", new int[]{1, 3, 4, 18701});
        public static final /* enum */ SimulatedVersion V_1_3_2 = new SimulatedVersion("1.3.2", new int[]{1, 3, 2, 18317});
        public static final /* enum */ SimulatedVersion V_1_2;
        public static final /* enum */ SimulatedVersion V_1_1;
        public static final /* enum */ SimulatedVersion V_1_0;
        public final String stringValue;
        public final int[] version;
        private static final /* synthetic */ SimulatedVersion[] ENUM$VALUES;

        static {
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[1] = 2;
            nArray[3] = 17811;
            V_1_2 = new SimulatedVersion("1.2", nArray);
            V_1_1 = new SimulatedVersion("1.1", new int[]{1, 1, 3, 16939});
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = 3;
            nArray2[3] = 16291;
            V_1_0 = new SimulatedVersion("1.0", nArray2);
            ENUM$VALUES = new SimulatedVersion[]{V_1_3_4, V_1_3_2, V_1_2, V_1_1, V_1_0};
        }

        private SimulatedVersion(String string2, int[] nArray) {
            this.stringValue = string2;
            this.version = nArray;
        }

        public String toString() {
            return this.stringValue;
        }

        public static SimulatedVersion[] values() {
            SimulatedVersion[] simulatedVersionArray = ENUM$VALUES;
            int n = simulatedVersionArray.length;
            SimulatedVersion[] simulatedVersionArray2 = new SimulatedVersion[n];
            System.arraycopy(ENUM$VALUES, 0, simulatedVersionArray2, 0, n);
            return simulatedVersionArray2;
        }

        public static SimulatedVersion valueOf(String string) {
            return Enum.valueOf(SimulatedVersion.class, string);
        }
    }
}

