/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.components.TableBox;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ReplayLinkPanel;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class MySharedReplaysDialog
extends BaseDialog {
    private static final File MY_SHARED_REPLAYS_FILE = new File("User Content", "My shared replays.csv");
    private static final String[] SHARED_REPLAYS_HEADER_KEYS = new String[]{"mySharedReplays.header.uploadedAt", "mySharedReplays.header.replaySite", "mySharedReplays.header.userName", "mySharedReplays.header.reportedName", "mySharedReplays.header.description", "mySharedReplays.header.replayUrl"};
    private static final int COLUMN_UPLOADED_AT;
    private static final int COLUMN_REPLAY_URL;
    private static final Vector<String> SHARED_REPLAYS_HEADER_NAME_VECTOR;

    static {
        SHARED_REPLAYS_HEADER_NAME_VECTOR = new Vector(SHARED_REPLAYS_HEADER_KEYS.length);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < SHARED_REPLAYS_HEADER_KEYS.length) {
            SHARED_REPLAYS_HEADER_NAME_VECTOR.addElement(Language.getText(SHARED_REPLAYS_HEADER_KEYS[n3]));
            if ("mySharedReplays.header.uploadedAt".equals(SHARED_REPLAYS_HEADER_KEYS[n3])) {
                n = n3;
            } else if ("mySharedReplays.header.replayUrl".equals(SHARED_REPLAYS_HEADER_KEYS[n3])) {
                n2 = n3;
            }
            ++n3;
        }
        COLUMN_UPLOADED_AT = n;
        COLUMN_REPLAY_URL = n2;
    }

    public MySharedReplaysDialog() {
        super("mySharedReplays.title", Icons.DOCUMENT_SHARE);
        final Vector<Vector<String>> vector = MySharedReplaysDialog.getSharedRepInfo();
        if (vector == null) {
            return;
        }
        this.setModal(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Language.getText("mySharedReplays.numberOfSharedReplays", vector.size()), 0);
        GuiUtils.changeFontToBold(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        final ReplayLinkPanel replayLinkPanel = new ReplayLinkPanel();
        jPanel.add((Component)replayLinkPanel, "Center");
        this.getContentPane().add((Component)jPanel, "North");
        final JTable jTable = GuiUtils.createNonEditableTable();
        ((DefaultTableModel)jTable.getModel()).setDataVector(vector, SHARED_REPLAYS_HEADER_NAME_VECTOR);
        jTable.setAutoCreateRowSorter(true);
        jTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(COLUMN_UPLOADED_AT, SortOrder.DESCENDING)));
        jTable.setPreferredScrollableViewportSize(new Dimension(950, 500));
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && jTable.getSelectedRow() >= 0) {
                    RowSorter<? extends TableModel> rowSorter = jTable.getRowSorter();
                    replayLinkPanel.setUrl((String)((Vector)vector.get(rowSorter.convertRowIndexToModel(jTable.getSelectedRow()))).get(COLUMN_REPLAY_URL), false, false);
                }
            }
        });
        TableBox tableBox = new TableBox(jTable, this.getLayeredPane());
        JScrollPane jScrollPane = new JScrollPane(tableBox);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton jButton = this.createCloseButton("button.close");
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.packAndShow(jButton, false);
    }

    private static Vector<Vector<String>> getSharedRepInfo() {
        if (!MY_SHARED_REPLAYS_FILE.exists()) {
            return new Vector<Vector<String>>(0);
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(MY_SHARED_REPLAYS_FILE), "UTF-8"));
            bufferedReader.readLine();
            String[] stringArray = bufferedReader.readLine().split(";");
            int[] nArray = new int[SHARED_REPLAYS_HEADER_KEYS.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = -1;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (SHARED_REPLAYS_HEADER_KEYS[n].equals(stringArray[n3])) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                nArray[n] = n2;
                ++n;
            }
            Vector<Vector<String>> vector = new Vector<Vector<String>>();
            while ((string = bufferedReader.readLine()) != null) {
                Vector<String> vector2 = new Vector<String>(SHARED_REPLAYS_HEADER_KEYS.length);
                String[] stringArray2 = GeneralUtils.splitBySemicolon(string);
                int n4 = 0;
                while (n4 < SHARED_REPLAYS_HEADER_KEYS.length) {
                    vector2.addElement(nArray[n4] < 0 ? "" : stringArray2[nArray[n4]]);
                    ++n4;
                }
                vector.addElement(vector2);
            }
            Vector<Vector<String>> vector3 = vector;
            return vector3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("mySharedReplays.failedToLoadSharedReplayList"), new Frame[0]);
            return null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static synchronized void saveSharedRepInfo(String string, String string2, String string3, String string4, String string5) {
        boolean bl = MY_SHARED_REPLAYS_FILE.exists();
        PrintWriter printWriter = null;
        try {
            try {
                int n;
                int n2;
                String[] stringArray;
                String string62;
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(MY_SHARED_REPLAYS_FILE, true), "UTF-8"));
                if (!bl) {
                    for (String string62 : SHARED_REPLAYS_HEADER_NAME_VECTOR) {
                        printWriter.print(string62.replace(';', '_'));
                        printWriter.print(';');
                    }
                    printWriter.println();
                    stringArray = SHARED_REPLAYS_HEADER_KEYS;
                    n2 = SHARED_REPLAYS_HEADER_KEYS.length;
                    n = 0;
                    while (n < n2) {
                        string62 = stringArray[n];
                        printWriter.print(string62);
                        printWriter.print(';');
                        ++n;
                    }
                    printWriter.println();
                }
                stringArray = new String[]{Language.formatDateTime(new Date()), string, string2, string3, string4, string5};
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    string62 = stringArray[n];
                    printWriter.print(string62.replace("\n\r", " ").replace('\n', ' ').replace('\r', ' ').replace(';', '_'));
                    printWriter.print(';');
                    ++n;
                }
                printWriter.println();
                printWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

