/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.TableBox;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Pair;
import hu.belicza.andras.sc2gears.util.ProfileCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class PlayerProfileDialog
extends BaseDialog {
    private static final String[] ALL_LEAGUES_HEADER_KEYS = new String[]{"module.repAnalyzer.tab.charts.players.portraitToolTip.format", "module.repAnalyzer.tab.charts.players.portraitToolTip.league", "module.repAnalyzer.tab.charts.players.portraitToolTip.rank", "module.repAnalyzer.tab.charts.players.portraitToolTip.teamMembers"};
    private static final Set<Integer> DEFAULT_DESCENDING_SORTING_COLUMN_SET = new HashSet<Integer>();
    private static final int COLUMN_LEAGUE;
    private static final Vector<String> ALL_LEAGUES_HEADER_NAME_VECTOR;

    static {
        ALL_LEAGUES_HEADER_NAME_VECTOR = new Vector(ALL_LEAGUES_HEADER_KEYS.length);
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, "module.repAnalyzer.tab.charts.players.portraitToolTip.league");
        int n = 0;
        int n2 = 0;
        while (n2 < ALL_LEAGUES_HEADER_KEYS.length) {
            String string = ALL_LEAGUES_HEADER_KEYS[n2];
            ALL_LEAGUES_HEADER_NAME_VECTOR.addElement(Language.getText(string));
            if ("module.repAnalyzer.tab.charts.players.portraitToolTip.league".equals(string)) {
                n = n2;
            }
            if (hashSet.contains(string)) {
                DEFAULT_DESCENDING_SORTING_COLUMN_SET.add(n2);
            }
            ++n2;
        }
        COLUMN_LEAGUE = n;
    }

    public PlayerProfileDialog(final Details.PlayerId playerId, ReplayConsts.PlayerType playerType) {
        super("playerProfile.title", Icons.PROFILE);
        JComponent jComponent;
        Object object;
        this.setModal(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        final JLabel jLabel = new JLabel(playerType == ReplayConsts.PlayerType.COMPUTER ? Icons.PORTRAIT_COMPUTER_ICON : Icons.PORTRAIT_HIGH_LOADING_ICON);
        jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.add(jLabel);
        final Boolean bl = ProfileCache.queryCustomPortrait(playerId, true, new ProfileCache.CustomPortraitListener(){

            @Override
            public void customPortraitReady(ImageIcon imageIcon) {
                jLabel.setIcon(imageIcon == null ? Icons.PORTRAIT_HIGH_NA_ICON : imageIcon);
            }
        });
        Box box2 = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel(playerId.name);
        jLabel2.setFont(jLabel2.getFont().deriveFont(1, 24.0f));
        box2.add(jLabel2);
        final JLabel jLabel3 = new JLabel(" ", Icons.ACHIEVEMENT, 2);
        jLabel3.setFont(jLabel3.getFont().deriveFont(1, 20.0f));
        box2.add(jLabel3);
        box2.add(Box.createVerticalStrut(4));
        Box box3 = Box.createVerticalBox();
        box3.setAlignmentX(0.0f);
        Box box4 = Box.createHorizontalBox();
        box4.add(new JLabel(Language.getText("playerProfile.gateway")));
        box4.add(Box.createHorizontalStrut(4));
        box4.add(new JLabel(playerId.gateway.stringValue));
        box4.add(Box.createGlue());
        box3.add(box4);
        box4 = Box.createHorizontalBox();
        box4.add(new JLabel(Language.getText("playerProfile.region")));
        box4.add(Box.createHorizontalStrut(4));
        box4.add(new JLabel(ReplayConsts.Region.getFromGatewayAndSubId((ReplayConsts.Gateway)playerId.gateway, (int)playerId.battleNetSubid).stringValue));
        box4.add(Box.createGlue());
        box3.add(box4);
        box2.add(box3);
        GuiUtils.alignBox(box3, 2);
        jPanel2.add(box2);
        jPanel.add((Component)jPanel2, "West");
        JLabel jLabel4 = GeneralUtils.createLinkLabel(Language.getText("playerProfile.customPortraits"), "https://sites.google.com/site/sc2gears/custom-portraits");
        jLabel4.setHorizontalAlignment(0);
        GuiUtils.changeFontToItalic(jLabel4);
        jPanel.add((Component)jLabel4, "Center");
        jPanel2 = new JPanel(new GridLayout(2, 2, 5, 0));
        jPanel2.add(GuiUtils.changeFontToItalic(new JLabel(Language.getText("playerProfile.updatedAt"), 4)));
        final JLabel jLabel5 = new JLabel(Icons.HOURGLASS);
        GuiUtils.changeFontToItalic(jLabel5);
        jPanel2.add(jLabel5);
        jPanel2.add(new JLabel());
        final JLabel jLabel6 = GeneralUtils.createLinkStyledLabel(Language.getText("playerProfile.retrieveNow"));
        jLabel6.setEnabled(false);
        final String string = Language.getText("playerProfile.retreivingProfile");
        final String string2 = jLabel6.getText();
        jLabel6.setText(string);
        jLabel6.setHorizontalAlignment(4);
        GuiUtils.changeFontToItalic(jLabel6);
        jPanel2.add(jLabel6);
        jPanel.add((Component)GuiUtils.wrapInPanel(jPanel2), "East");
        box.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2 = new JPanel(new GridLayout(5, 3));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Language.getText("playerProfile.bestLeagues")));
        final JLabel[][] jLabelArray = new JLabel[5][7];
        jLabelArray[0] = new JLabel[]{new JLabel(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.league"), 0), new JLabel(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.format"), 0), new JLabel(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.rank"), 0)};
        int n = 0;
        while (n < jLabelArray[0].length) {
            GuiUtils.changeFontToBold(jLabelArray[0][n]);
            ++n;
        }
        n = 1;
        while (n < jLabelArray.length) {
            jLabelArray[n] = new JLabel[]{new JLabel(Icons.LEAGUE_LOADING_ICON), new JLabel(Icons.HOURGLASS), new JLabel(Icons.HOURGLASS)};
            ++n;
        }
        Object object2 = jLabelArray;
        int n2 = jLabelArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JLabel[] jLabelArray2 = object2[n3];
            object = jLabelArray2;
            int n4 = jLabelArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                jComponent = object[n5];
                jPanel2.add(jComponent);
                ++n5;
            }
            ++n3;
        }
        box.add(jPanel2);
        jPanel3.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel(new GridLayout(5, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel7 = new JLabel(Language.getText("playerProfile.leagueWins"), 0);
        jLabel7.setFont(jLabel7.getFont().deriveFont(14.0f));
        jPanel2.add(jLabel7);
        final JLabel jLabel8 = new JLabel(Icons.HOURGLASS, 0);
        jLabel8.setFont(jLabel8.getFont().deriveFont(1, 24.0f));
        jPanel2.add(jLabel8);
        jPanel2.add(new JLabel());
        jLabel7 = new JLabel(Language.getText("playerProfile.favoriteRace"), 0);
        jLabel7.setFont(jLabel7.getFont().deriveFont(14.0f));
        jPanel2.add(jLabel7);
        final JLabel jLabel9 = new JLabel(Icons.HOURGLASS, 0);
        jLabel9.setFont(jLabel9.getFont().deriveFont(1, 14.0f));
        jPanel2.add(jLabel9);
        jPanel3.add((Component)GuiUtils.wrapInPanel(jPanel2), "East");
        box.add(jPanel3);
        this.getContentPane().add((Component)box, "North");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Language.getText("playerProfile.allLeagues")));
        object2 = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                if (n3 == COLUMN_LEAGUE) {
                    Pair pair = (Pair)object;
                    this.setIcon(((Icons.League)((Object)pair.value1)).getIconForRank((Integer)pair.value2));
                    this.setText(((Icons.League)((Object)pair.value1)).stringValue);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        jComponent = new JTable((DefaultTableCellRenderer)object2){
            private final /* synthetic */ DefaultTableCellRenderer val$customTableCellRenderer;
            {
                this.val$customTableCellRenderer = defaultTableCellRenderer;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return this.val$customTableCellRenderer;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((JTable)jComponent).setModel(new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                int n2 = this.getRowCount();
                if (n2 == 0) {
                    return super.getColumnClass(n);
                }
                if (n2 > 10) {
                    n2 = 10;
                }
                int n3 = 0;
                while (n3 < n2) {
                    Object object = this.getValueAt(n3, n);
                    if (object != null) {
                        return object.getClass();
                    }
                    ++n3;
                }
                return Object.class;
            }
        });
        ((JTable)jComponent).setRowHeight(Icons.League.GRANDMASTER.getIconForRank(1).getIconHeight());
        ((DefaultTableModel)((JTable)jComponent).getModel()).setColumnIdentifiers(ALL_LEAGUES_HEADER_NAME_VECTOR);
        ((JTable)jComponent).setAutoCreateRowSorter(true);
        ((JTable)jComponent).setPreferredScrollableViewportSize(new Dimension(650, 220));
        ((JTable)jComponent).setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>(((JTable)jComponent).getModel()){

            @Override
            public void toggleSortOrder(int n) {
                ArrayList<RowSorter.SortKey> arrayList;
                if (DEFAULT_DESCENDING_SORTING_COLUMN_SET.contains(n) && ((arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys())).isEmpty() || ((RowSorter.SortKey)arrayList.get(0)).getColumn() != n)) {
                    arrayList.add(0, new RowSorter.SortKey(n, SortOrder.DESCENDING));
                    if (arrayList.size() > this.getMaxSortKeys()) {
                        arrayList.remove(this.getMaxSortKeys());
                    }
                    this.setSortKeys(arrayList);
                    return;
                }
                super.toggleSortOrder(n);
            }
        });
        TableBox tableBox = new TableBox((JTable)jComponent, this.getLayeredPane());
        jPanel2.add(tableBox);
        this.getContentPane().add((Component)jPanel2, "Center");
        JButton jButton = this.createCloseButton("button.close");
        this.getContentPane().add((Component)GuiUtils.wrapInPanel(jButton), "South");
        object = new MouseAdapter((JTable)jComponent){
            private final /* synthetic */ JTable val$allLeaguesTable;
            {
                this.val$allLeaguesTable = jTable;
            }

            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                if (mouseEvent != null) {
                    if (jLabel6.isEnabled()) {
                        jLabel6.setEnabled(false);
                        jLabel6.setText(string);
                    } else {
                        return;
                    }
                }
                ProfileCache.queryProfile(playerId, new ProfileCache.ProfileListener(){

                    @Override
                    public void profileReady(ProfileCache.Profile profile, boolean bl2) {
                        if (profile == null) {
                            jLabel5.setIcon(Icons.NA);
                        } else {
                            jLabel5.setIcon(null);
                            jLabel5.setText(Language.formatDateTime(profile.updatedAt));
                        }
                        if (bl == null) {
                            jLabel.setIcon(profile == null ? Icons.PORTRAIT_HIGH_NA_ICON : Icons.getPortraitHighIcon(profile.portraitGroup, profile.portraitRow, profile.portraitColumn));
                        }
                        if (profile == null) {
                            jLabel3.setIcon(Icons.NA);
                            jLabel8.setIcon(Icons.NA);
                            jLabel9.setIcon(Icons.NA);
                        } else {
                            jLabel3.setText(Integer.toString(profile.achievementPoints));
                            jLabel8.setText(Integer.toString(profile.leagueWins));
                            jLabel8.setIcon(null);
                            jLabel9.setText(profile.favoriteRace.stringValue);
                            jLabel9.setIcon(Icons.getRaceIcon(profile.favoriteRace));
                        }
                        int n = 0;
                        while (n < 4) {
                            int n2;
                            JLabel[] jLabelArray2 = jLabelArray[n + 1];
                            if (profile == null) {
                                jLabelArray2[0].setIcon(Icons.LEAGUE_NA_ICON);
                                n2 = 1;
                                while (n2 < jLabelArray2.length) {
                                    jLabelArray2[n2].setIcon(Icons.NA);
                                    ++n2;
                                }
                            } else {
                                n2 = 0;
                                if (profile.bestRanks.length > 0) {
                                    ProfileCache.Profile.TeamRank teamRank = profile.bestRanks[n];
                                    jLabelArray2[n2++].setIcon(teamRank == null ? Icons.League.UNRANKED.getIconForRank(0) : teamRank.league.getIconForRank(teamRank.divisionRank));
                                    jLabelArray2[n2].setIcon(null);
                                    jLabelArray2[n2++].setText(String.valueOf(n + 1) + "v" + (n + 1));
                                    jLabelArray2[n2].setIcon(null);
                                    jLabelArray2[n2++].setText(teamRank == null ? "-" : Integer.toString(teamRank.divisionRank));
                                }
                            }
                            ++n;
                        }
                        final Vector vector = new Vector();
                        if (profile != null) {
                            int n3 = 0;
                            while (n3 < profile.allRankss.length) {
                                ProfileCache.Profile.TeamRank[] teamRankArray = profile.allRankss[n3];
                                if (teamRankArray != null) {
                                    int n4 = 0;
                                    while (n4 < teamRankArray.length) {
                                        final ProfileCache.Profile.TeamRank teamRank = teamRankArray[n4];
                                        Vector<Object> vector2 = new Vector<Object>();
                                        vector2.add(String.valueOf(n3 + 1) + "v" + (n3 + 1));
                                        vector2.add(new Pair<Icons.League, Integer>(teamRank.league, Integer.valueOf(teamRank.divisionRank)){

                                            public String toString() {
                                                return teamRank.league.toString();
                                            }
                                        });
                                        vector2.add(teamRank.divisionRank);
                                        StringBuilder stringBuilder = new StringBuilder();
                                        String[] stringArray = teamRank.teamMembers;
                                        int n5 = teamRank.teamMembers.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            String string = stringArray[n6];
                                            if (stringBuilder.length() > 0) {
                                                stringBuilder.append(", ");
                                            }
                                            stringBuilder.append(string);
                                            ++n6;
                                        }
                                        vector2.add(stringBuilder.toString());
                                        vector.add(vector2);
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        if (!bl2) {
                            jLabel6.setText(string2);
                            jLabel6.setEnabled(true);
                        }
                        if (mouseEvent == null) {
                            GuiUtils.centerWindowToWindow(PlayerProfileDialog.this, MainFrame.INSTANCE);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((DefaultTableModel)val$allLeaguesTable.getModel()).setDataVector(vector, ALL_LEAGUES_HEADER_NAME_VECTOR);
                                GuiUtils.packTable(val$allLeaguesTable);
                                ((TableRowSorter)val$allLeaguesTable.getRowSorter()).setComparator(COLUMN_LEAGUE, new Comparator<Pair<Icons.League, Integer>>(){

                                    @Override
                                    public int compare(Pair<Icons.League, Integer> pair, Pair<Icons.League, Integer> pair2) {
                                        int n = ((Icons.League)((Object)pair2.value1)).compareTo((Icons.League)((Object)pair.value1));
                                        if (n != 0) {
                                            return n;
                                        }
                                        return (Integer)pair2.value2 - (Integer)pair.value2;
                                    }
                                });
                            }
                        });
                    }
                }, true, mouseEvent != null);
            }
        };
        object.mouseClicked(null);
        jLabel6.addMouseListener((MouseListener)object);
        this.packAndShow(jButton, false);
    }
}

