/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.services.plugins.PluginControl;
import hu.belicza.andras.sc2gears.services.plugins.PluginDescriptorImpl;
import hu.belicza.andras.sc2gears.services.plugins.PluginManager;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.components.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class PluginManagerDialog
extends BaseDialog {
    public PluginManagerDialog() {
        this((PluginControl)null);
    }

    public PluginManagerDialog(PluginControl pluginControl) {
        super("pluginManager.title", Icons.PUZZLE);
        this.setModal(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        final JButton jButton = new JButton(Icons.PLUG_CONNECT);
        GuiUtils.updateButtonText(jButton, "pluginManager.enableAllPluginsButton", new Object[0]);
        jPanel.add(jButton);
        final JButton jButton2 = new JButton(Icons.PLUG_DISCCONNECT);
        GuiUtils.updateButtonText(jButton2, "pluginManager.disableAllPluginsButton", new Object[0]);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        final Vector<PluginControl> vector = PluginManager.getPluginControlVector();
        final JList<PluginControl> jList = new JList<PluginControl>(PluginManager.getPluginControlVector());
        if (pluginControl != null) {
            jList.setSelectedValue(pluginControl, true);
        }
        jList.setOpaque(false);
        jList.setCellRenderer(new BaseLabelListCellRenderer(2, jList){

            @Override
            public Icon getIcon(Object object) {
                boolean bl = ((PluginControl)object).isEnabled;
                PluginControl.Status status = ((PluginControl)object).status;
                return !bl ? Icons.EXCLAMATION_OCTAGON_FRAME : (status == PluginControl.Status.STARTED ? Icons.TICK : Icons.CROSS);
            }
        });
        jList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Language.getText("pluginManager.installedPlugins")));
        jScrollPane.setPreferredSize(new Dimension(250, 10));
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Language.getText("pluginManager.pluginDetails")));
        final JTable jTable = GuiUtils.createNonEditableTable();
        Object[][] objectArray = new Object[7][];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = Language.getText("pluginManager.details.name");
        objectArray[0] = objectArray2;
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = Language.getText("pluginManager.details.author");
        objectArray[1] = objectArray3;
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = Language.getText("pluginManager.details.email");
        objectArray[2] = objectArray4;
        Object[] objectArray5 = new Object[2];
        objectArray5[0] = Language.getText("pluginManager.details.version");
        objectArray[3] = objectArray5;
        Object[] objectArray6 = new Object[2];
        objectArray6[0] = Language.getText("pluginManager.details.releaseDate");
        objectArray[4] = objectArray6;
        Object[] objectArray7 = new Object[2];
        objectArray7[0] = Language.getText("pluginManager.details.apiVersion");
        objectArray[5] = objectArray7;
        Object[] objectArray8 = new Object[2];
        objectArray8[0] = Language.getText("pluginManager.details.homePage");
        objectArray[6] = objectArray8;
        final Object[][] objectArray9 = objectArray;
        ((DefaultTableModel)jTable.getModel()).setDataVector(objectArray9, new Object[]{"Property", "Value"});
        GuiUtils.packTable(jTable, new int[1]);
        jPanel4.add((Component)new JScrollPane(GuiUtils.wrapInBorderPanel(jTable)), "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        final JButton jButton3 = new JButton(Icons.PLUG_CONNECT);
        GuiUtils.updateButtonText(jButton3, "pluginManager.details.enablePluginButton", new Object[0]);
        jPanel6.add(jButton3);
        final JButton jButton4 = new JButton(Icons.PLUG_DISCCONNECT);
        GuiUtils.updateButtonText(jButton4, "pluginManager.details.disablePluginButton", new Object[0]);
        jPanel6.add(jButton4);
        final JLabel jLabel = GeneralUtils.createLinkStyledLabel(Language.getText("pluginManager.details.visitPluginHome"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jLabel.isEnabled()) {
                    GeneralUtils.showURLInBrowser(((PluginControl)jList.getSelectedValue()).pluginDescriptor.getHomePage());
                }
            }
        });
        jLabel.setIcon(Icons.GLOBE_ARROW);
        jPanel6.add(jLabel);
        jPanel5.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel(new FlowLayout(1, 10, 10));
        final JLabel jLabel2 = new JLabel();
        GuiUtils.changeFontToBold(jLabel2);
        jLabel2.setFont(jLabel2.getFont().deriveFont(1, (float)jLabel2.getFont().getSize() + 3.0f));
        jPanel7.add(jLabel2);
        final JLabel jLabel3 = GuiUtils.createErrorDetailsLink();
        jPanel7.add(jLabel3);
        jPanel5.add((Component)jPanel7, "South");
        jPanel4.add((Component)jPanel5, "South");
        jPanel3.add((Component)jPanel4, "East");
        jPanel2.add(jPanel3);
        final JEditorPane jEditorPane = GuiUtils.createEditorPane();
        jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Language.getText("pluginManager.pluginDescription")));
        jPanel2.add(jScrollPane);
        final ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                PluginControl pluginControl = (PluginControl)jList.getSelectedValue();
                if (pluginControl == null) {
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                    jLabel.setEnabled(false);
                    jLabel2.setText(Language.getText("pluginManager.details.selectPlugin"));
                    jLabel2.setIcon(null);
                    jLabel2.setForeground(null);
                    jLabel3.setVisible(false);
                    int n = 0;
                    while (n < objectArray9.length) {
                        objectArray9[n][1] = null;
                        ++n;
                    }
                    jEditorPane.setText(null);
                } else {
                    jButton3.setEnabled(!pluginControl.isEnabled);
                    jButton4.setEnabled(pluginControl.isEnabled);
                    jLabel.setEnabled(true);
                    jLabel2.setText(Language.getText(!pluginControl.isEnabled ? "pluginManager.details.pluginDisabled" : (pluginControl.status == PluginControl.Status.STARTED ? "pluginManager.details.pluginEnabled" : "pluginManager.details.pluginError")));
                    jLabel2.setIcon(!pluginControl.isEnabled ? Icons.EXCLAMATION_OCTAGON_FRAME : (pluginControl.status == PluginControl.Status.STARTED ? Icons.TICK : Icons.CROSS));
                    jLabel2.setForeground(!pluginControl.isEnabled ? null : (pluginControl.status == PluginControl.Status.STARTED ? new Color(0, 150, 0) : Color.RED));
                    jLabel3.setVisible(pluginControl.isEnabled && pluginControl.status == PluginControl.Status.FAILED);
                    PluginDescriptorImpl pluginDescriptorImpl = pluginControl.pluginDescriptor;
                    int n = 0;
                    objectArray9[n++][1] = pluginDescriptorImpl.getName();
                    objectArray9[n++][1] = Language.formatPersonName(pluginDescriptorImpl.getAuthorFirstName(), pluginDescriptorImpl.getAuthorLastName());
                    objectArray9[n++][1] = pluginDescriptorImpl.getAuthorEmail();
                    objectArray9[n++][1] = pluginDescriptorImpl.getVersion();
                    objectArray9[n++][1] = Language.formatDate(pluginDescriptorImpl.getReleaseDate());
                    objectArray9[n++][1] = pluginDescriptorImpl.getApiVersion();
                    objectArray9[n++][1] = pluginDescriptorImpl.getHomePage();
                    jEditorPane.setContentType(pluginDescriptorImpl.isHtmlDescription() ? "text/html" : "text/plain");
                    jEditorPane.setText(pluginDescriptorImpl.getDescription());
                }
                ((DefaultTableModel)jTable.getModel()).setDataVector(objectArray9, new Object[]{"Property", "Value"});
                GuiUtils.packTable(jTable, new int[1]);
            }
        };
        jList.addListSelectionListener(listSelectionListener);
        listSelectionListener.valueChanged(null);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                if (actionEvent.getSource() == jButton) {
                    for (Object object2 : vector) {
                        ((PluginControl)object2).isEnabled = true;
                        ((PluginControl)object2).startPlugin();
                    }
                } else if (actionEvent.getSource() == jButton2) {
                    for (Object object2 : vector) {
                        ((PluginControl)object2).isEnabled = false;
                        ((PluginControl)object2).disposePlugin();
                    }
                } else if (actionEvent.getSource() == jButton3) {
                    ((PluginControl)jList.getSelectedValue()).isEnabled = true;
                    ((PluginControl)jList.getSelectedValue()).startPlugin();
                } else if (actionEvent.getSource() == jButton4) {
                    ((PluginControl)jList.getSelectedValue()).isEnabled = false;
                    ((PluginControl)jList.getSelectedValue()).disposePlugin();
                }
                object2 = new HashSet();
                for (Object object3 : vector) {
                    if (!((PluginControl)object3).isEnabled) continue;
                    object2.add(((PluginControl)object3).pluginDescriptor.getMainClass());
                }
                Settings.setEnabledPluginSet((Set<String>)object2);
                jList.repaint();
                listSelectionListener.valueChanged(null);
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jButton4.addActionListener(actionListener);
        this.getContentPane().add((Component)jPanel2, "Center");
        JButton jButton5 = this.createCloseButton("button.close");
        JPanel jPanel8 = GuiUtils.wrapInPanel(jButton5);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.getContentPane().add((Component)jPanel8, "South");
        this.packAndShow(jButton5, false);
    }
}

