/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gearspluginapi.api.ui.IProgressDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends BaseDialog
implements ActionListener,
IProgressDialog {
    private static final Color FAILED_COLOR = new Color(220, 100, 100);
    private final JLabel elapsedTimeLabel = new JLabel(" ");
    private final JLabel estRemainingTimeLabel = new JLabel(" ");
    private final JLabel estTotalTimeLabel = new JLabel(" ");
    private final JCheckBox alertWhenDoneCheckBox = GuiUtils.createCheckBox("progressDialog.alertWhenDone", "progressDialog.alertWhenDone");
    private final JProgressBar progressBar = new JProgressBar();
    private final JPanel infoPanel = new JPanel(new BorderLayout());
    private final JLabel failedLabel = new JLabel();
    private final JButton button = new JButton(Icons.CROSS_OCTAGON);
    private final int total;
    private int processed;
    private int failed;
    private long startTime;
    private volatile boolean aborted;
    private volatile boolean closeable;
    private boolean wasFailedBefore;

    public ProgressDialog(String string, ImageIcon imageIcon, int n) {
        super(string, imageIcon);
        this.total = n;
        this.completeInit();
    }

    public ProgressDialog(Holder<String> holder, ImageIcon imageIcon, int n) {
        super(holder, imageIcon);
        this.total = n;
        this.completeInit();
    }

    public ProgressDialog(Frame frame, Holder<String> holder, ImageIcon imageIcon, int n) {
        super(frame, holder, imageIcon);
        this.total = n;
        this.completeInit();
    }

    public ProgressDialog(Dialog dialog, Holder<String> holder, ImageIcon imageIcon, int n) {
        super(dialog, holder, imageIcon);
        this.total = n;
        this.completeInit();
    }

    private void completeInit() {
        this.setModal(false);
        this.setDefaultCloseOperation(0);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        ProgressDialog.addInfoBoxRow(box, "progressDialog.elapsedTime", this.elapsedTimeLabel);
        ProgressDialog.addInfoBoxRow(box, "progressDialog.estRemainingTime", this.estRemainingTimeLabel);
        ProgressDialog.addInfoBoxRow(box, "progressDialog.estTotalTime", this.estTotalTimeLabel);
        box.add(Box.createVerticalStrut(2));
        box.add(GuiUtils.wrapInPanel(this.alertWhenDoneCheckBox));
        this.getContentPane().add((Component)GuiUtils.wrapInPanel(box), "North");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(450, this.progressBar.getPreferredSize().height));
        this.progressBar.setMaximum(this.total);
        box2.add(this.progressBar);
        box2.add(Box.createVerticalStrut(2));
        this.failedLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.failedLabel.setOpaque(true);
        this.infoPanel.add((Component)this.failedLabel, "West");
        box2.add(this.infoPanel);
        this.getContentPane().add((Component)box2, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        GuiUtils.updateButtonText(this.button, "button.abort", new Object[0]);
        this.button.addActionListener(this);
        jPanel.add(this.button);
        this.getContentPane().add((Component)jPanel, "South");
        this.startTime = new Date().getTime();
        this.updateProgressBar();
        GuiUtils.alignBox(box, 4);
        MainFrame.registerBackgroundJob();
        this.packAndShow(this.button, false);
    }

    private static void addInfoBoxRow(Box box, String string, JLabel jLabel) {
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText(string)));
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createHorizontalStrut(15));
        box2.add(jLabel);
        box.add(box2);
    }

    @Override
    public void incrementProcessed() {
        ++this.processed;
    }

    @Override
    public void incrementFailed() {
        ++this.failed;
    }

    @Override
    public int getProcessed() {
        return this.processed;
    }

    @Override
    public int getFailed() {
        return this.failed;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.closeable) {
            this.dispose();
        } else {
            this.button.setEnabled(false);
            this.aborted = true;
        }
    }

    @Override
    public void updateProgressBar() {
        long l = new Date().getTime() - this.startTime;
        this.elapsedTimeLabel.setText(GeneralUtils.formatLongSeconds(l / 1000L));
        if (this.processed > 0) {
            this.estRemainingTimeLabel.setText(GeneralUtils.formatLongSeconds(l * (long)(this.total - this.processed) / (long)this.processed / 1000L));
            this.estTotalTimeLabel.setText(GeneralUtils.formatLongSeconds(l * (long)this.total / (long)this.processed / 1000L));
        }
        this.progressBar.setValue(this.processed);
        this.progressBar.setString(Language.getText("progressDialog.progressBar.status", this.processed, this.failed, this.total, this.total == 0 ? 100 : 100 * this.processed / this.total));
        this.failedLabel.setText(Language.getText("progressDialog.progressBar.failed", this.failed));
        if (!this.wasFailedBefore && this.failed > 0) {
            this.wasFailedBefore = true;
            this.failedLabel.setBackground(FAILED_COLOR);
            this.infoPanel.add((Component)GuiUtils.createErrorDetailsLink(), "East");
            this.pack();
        }
        if (this.aborted) {
            this.progressBar.setString(String.valueOf(Language.getText("progressDialog.progressBar.aborted")) + " [" + this.progressBar.getString() + "]");
        } else if (this.closeable) {
            this.progressBar.setString(String.valueOf(Language.getText("progressDialog.progressBar.done")) + " [" + this.progressBar.getString() + "]");
        }
    }

    @Override
    public void taskFinished() {
        MainFrame.removeBackgroundJob();
        this.setDefaultCloseOperation(2);
        this.closeable = true;
        this.button.setEnabled(true);
        this.button.setIcon(null);
        GuiUtils.updateButtonText(this.button, "button.close", new Object[0]);
        this.button.requestFocusInWindow();
        this.updateProgressBar();
        if (!this.aborted && this.alertWhenDoneCheckBox.isSelected()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void setCustomMessage(String string) {
        this.infoPanel.add((Component)GuiUtils.wrapInPanel(new JLabel(string)), "South");
        this.pack();
    }
}

