/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ReplayLinkPanel
extends JPanel {
    private final JLabel replayLinkLabel = new JLabel(Language.getText("shareReplay.replayLink"));
    private final JTextField replayLinkTextField = new JTextField(10);
    private final JButton copyUrlButton = new JButton(Icons.CLIPBOARD_SIGN);
    private final JButton copyForumLinkButton = new JButton(Icons.CLIPBOARD_SIGN);
    private final JButton copyHtmlLinkButton = new JButton(Icons.CLIPBOARD_SIGN);
    private final JButton visitReplayLinkButton = new JButton(Icons.GLOBE_ARROW);

    public ReplayLinkPanel() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.replayLinkLabel.setOpaque(true);
        this.add((Component)this.replayLinkLabel, "West");
        this.replayLinkTextField.setEditable(false);
        this.add((Component)this.replayLinkTextField, "Center");
        Box box = Box.createHorizontalBox();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ReplayLinkPanel.this.replayLinkTextField.getText();
                if (actionEvent.getSource() == ReplayLinkPanel.this.copyForumLinkButton) {
                    string = "[url=" + string + "]Replay[/url]";
                } else if (actionEvent.getSource() == ReplayLinkPanel.this.copyHtmlLinkButton) {
                    string = "<a href=\"" + string + "\">Replay</a>";
                }
                GeneralUtils.copyToClipboard(string);
            }
        };
        this.copyUrlButton.setEnabled(false);
        GuiUtils.updateButtonText(this.copyUrlButton, "shareReplay.copyUrlButton", new Object[0]);
        this.copyUrlButton.addActionListener(actionListener);
        box.add(this.copyUrlButton);
        this.copyForumLinkButton.setEnabled(false);
        GuiUtils.updateButtonText(this.copyForumLinkButton, "shareReplay.copyForumLinkButton", new Object[0]);
        this.copyForumLinkButton.addActionListener(actionListener);
        box.add(this.copyForumLinkButton);
        this.copyHtmlLinkButton.setEnabled(false);
        GuiUtils.updateButtonText(this.copyHtmlLinkButton, "shareReplay.copyHtmlLinkButton", new Object[0]);
        this.copyHtmlLinkButton.addActionListener(actionListener);
        box.add(this.copyHtmlLinkButton);
        this.visitReplayLinkButton.setEnabled(false);
        GuiUtils.updateButtonText(this.visitReplayLinkButton, "shareReplay.visitReplayLinkButton", new Object[0]);
        this.visitReplayLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.showURLInBrowser(ReplayLinkPanel.this.replayLinkTextField.getText());
            }
        });
        box.add(this.visitReplayLinkButton);
        this.add((Component)box, "East");
    }

    public void setUrl(String string, boolean bl, boolean bl2) {
        if (bl) {
            this.replayLinkLabel.setBackground(Color.GREEN);
        }
        this.replayLinkTextField.setText(string);
        this.replayLinkTextField.selectAll();
        this.copyUrlButton.setEnabled(true);
        this.copyForumLinkButton.setEnabled(true);
        this.copyHtmlLinkButton.setEnabled(true);
        this.visitReplayLinkButton.setEnabled(true);
        if (bl2) {
            this.copyUrlButton.requestFocusInWindow();
        }
    }
}

