/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import hu.belicza.andras.sc2gearspluginapi.api.listener.ReplayOpCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReplayRenameDialog
extends BaseDialog {
    public ReplayRenameDialog(final ReplayOpCallback replayOpCallback, final File[] fileArray) {
        super("replayops.renameDialog.title", Icons.DOCUMENT_RENAME);
        JPanel jPanel = new JPanel(new BorderLayout());
        final JComboBox jComboBox = GuiUtils.createPredefinedListComboBox(Settings.PredefinedList.REP_RENAME_TEMPLATE);
        jComboBox.setSelectedItem(Settings.getString("module.repSearch.results.renameTemplate"));
        jPanel.add((Component)GuiUtils.createNameTemplateEditor(jComboBox, "/Fx"), "Center");
        JPanel jPanel2 = new JPanel();
        final JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "replayops.renameDialog.previewButton", new Object[0]);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton();
        GuiUtils.updateButtonText(jButton2, "replayops.renameDialog.renameButton", new Object[0]);
        jPanel2.add(jButton2);
        JButton jButton3 = this.createCloseButton("button.cancel");
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel, "North");
        final JTextArea jTextArea = new JTextArea(10, 50);
        jTextArea.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = actionEvent.getSource() == jButton;
                if (bl) {
                    jTextArea.setText("");
                }
                int n = 0;
                try {
                    try {
                        TemplateEngine templateEngine = new TemplateEngine(jComboBox.getSelectedItem().toString());
                        int n2 = 0;
                        while (n2 < fileArray.length) {
                            File file = fileArray[n2];
                            String string = templateEngine.applyToReplay(file, file.getParentFile());
                            if (string == null) {
                                ++n;
                            } else if (bl) {
                                jTextArea.append(String.valueOf(string) + "\n");
                            } else {
                                File file2 = GeneralUtils.generateUniqueName(new File(file.getParent(), string));
                                File file3 = file2.getParentFile();
                                boolean bl3 = false;
                                if (!file3.exists()) {
                                    boolean bl4 = bl3 = !file3.mkdirs();
                                }
                                if (file.renameTo(file2)) {
                                    if (replayOpCallback != null) {
                                        replayOpCallback.replayRenamed(file, file2, n2);
                                    }
                                } else {
                                    System.out.println("Failed to rename replay file" + (file2.exists() ? " (target file already exists)" : (bl3 ? " (failed to create sub-folders)" : "")) + "!");
                                    ++n;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"), new Frame[0]);
                        jComboBox.requestFocusInWindow();
                        return;
                    }
                }
                finally {
                    jComboBox.requestFocusInWindow();
                }
                if (bl) {
                    jTextArea.setCaretPosition(0);
                } else {
                    if (replayOpCallback != null) {
                        replayOpCallback.moveRenameDeleteEnded();
                    }
                    Settings.set("module.repSearch.results.renameTemplate", jComboBox.getSelectedItem().toString());
                    if (n == 0) {
                        GuiUtils.showInfoDialog(Language.getText("replayops.renameDialog.successfullyRenamed", fileArray.length), new Frame[0]);
                    } else {
                        GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.renameDialog.successfullyRenamed", fileArray.length - n), Language.getText("replayops.renameDialog.failedToRename", n)}, new Frame[0]);
                    }
                    ReplayRenameDialog.this.dispose();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton.doClick();
        this.packAndShow(jComboBox, false);
    }
}

