/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ProgressDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.HttpPost;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Sc2gearsDatabaseDownloaderDialog
extends BaseDialog {
    private static final int MAX_SC2GEARS_DATABASE_DOWNLOAD_RETRIES = 3;
    private volatile boolean cancelPressed;

    public Sc2gearsDatabaseDownloaderDialog() {
        super("sc2gearsDatabaseDownloader.title", Icons.SERVER_NETWORK);
        final Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 15));
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("sc2gearsDatabaseDownloader.selectFileType")));
        final JComboBox jComboBox = GuiUtils.createComboBox(new Vector<String>(Arrays.asList("SC2Replay", "smpd")), "sc2gearsDatabaseDownloader.fileType", false);
        jComboBox.setMaximumRowCount(jComboBox.getModel().getSize());
        jComboBox.setRenderer(new BaseLabelListCellRenderer(2, jComboBox){

            @Override
            public Icon getIcon(Object object) {
                if ("SC2Replay".equals(object)) {
                    return Icons.SC2;
                }
                if ("smpd".equals(object)) {
                    return Icons.FINGERPRINT;
                }
                return null;
            }
        });
        box2.add(jComboBox);
        box2.add(new JLabel());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("sc2gearsDatabaseDownloader.onlyAfterDate")));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(2, -1);
        final JTextField jTextField = new JTextField(Language.formatDate(gregorianCalendar.getTime()), 30);
        box2.add(jTextField);
        box2.add(new JLabel());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("sc2gearsDatabaseDownloader.targetFolder")));
        final JTextField jTextField2 = new JTextField(Settings.getString("sc2gearsDatabaseDownloader.targetFolder"), 30);
        box2.add(jTextField2);
        JButton jButton = new JButton(Icons.FOLDERS);
        GuiUtils.updateButtonText(jButton, "sc2gearsDatabaseDownloader.chooseFolderButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(jTextField2.getText());
                jFileChooser.setDialogTitle(Language.getText("sc2gearsDatabaseDownloader.selectTargetFolder"));
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    jTextField2.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        box2.add(jButton);
        box.add(box2);
        GuiUtils.alignBox(box, 3);
        this.getContentPane().add((Component)box, "Center");
        Box box3 = Box.createVerticalBox();
        box3.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
        final JLabel jLabel = new JLabel(" ");
        JPanel jPanel = new JPanel();
        final JButton jButton2 = new JButton(Icons.DRIVE_DOWNLOAD);
        GuiUtils.updateButtonText(jButton2, "sc2gearsDatabaseDownloader.downloadFilesButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                Date date = Language.parseDateTime(string, true);
                if (date == null) {
                    date = Language.parseDate(string);
                }
                if (date == null) {
                    GuiUtils.showErrorDialog(Language.getText("sc2gearsDatabaseDownloader.invalidDate"), new Frame[0]);
                    jTextField.requestFocusInWindow();
                    return;
                }
                final Date date2 = date;
                if (jTextField2.getText().length() == 0) {
                    GuiUtils.showErrorDialog(Language.getText("sc2gearsDatabaseDownloader.missingTargetFolder"), new Frame[0]);
                    jTextField2.requestFocusInWindow();
                    return;
                }
                Settings.set("sc2gearsDatabaseDownloader.targetFolder", jTextField2.getText());
                final String string2 = GeneralUtils.checkKeyBeforeStoringOrDownloading(new Frame[0]);
                if (string2 == null) {
                    return;
                }
                File file = new File(jTextField2.getText());
                if (!file.exists() && !file.mkdirs()) {
                    GuiUtils.showErrorDialog(Language.getText("sc2gearsDatabaseDownloader.failedToCreateTargetFolder"), new Frame[0]);
                    jTextField2.requestFocusInWindow();
                    return;
                }
                jButton2.setEnabled(false);
                GuiUtils.setComponentTreeEnabled(box, false);
                jLabel.setText(Language.getText("sc2gearsDatabaseDownloader.retrievingFileList"));
                new NormalThread("Sc2gears Database file downloader", jComboBox, file){
                    final String fileType;
                    final HttpPost.FileProvider fileProvider;
                    private Map<String, String> paramsMap;
                    {
                        super(string);
                        this.fileType = (String)jComboBox.getSelectedItem();
                        this.fileProvider = new HttpPost.FileProvider(){

                            @Override
                            public File getFile(HttpURLConnection httpURLConnection) {
                                String string = httpURLConnection.getHeaderField("X-Sc2gears-file-name");
                                if (string == null) {
                                    string = "new file." + fileType;
                                }
                                try {
                                    string = URLDecoder.decode(string, "UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    unsupportedEncodingException.printStackTrace();
                                }
                                return GeneralUtils.generateUniqueName(new File(file, string));
                            }

                            @Override
                            public Long getLastModified(HttpURLConnection httpURLConnection) {
                                try {
                                    String string = httpURLConnection.getHeaderField("X-Sc2gears-file-date");
                                    return string == null ? null : Long.valueOf(string);
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                        };
                    }

                    @Override
                    public void run() {
                        HttpPost httpPost = null;
                        try {
                            this.paramsMap = new HashMap<String, String>();
                            this.paramsMap.put("protVer", "1");
                            this.paramsMap.put("authKey", string2);
                            this.paramsMap.put("op", "rfl");
                            this.paramsMap.put("fileType", this.fileType);
                            this.paramsMap.put("afterDate", Long.toString(date2.getTime()));
                            httpPost = new HttpPost(Consts.URL_SC2GEARS_DATABASE_FILE_SERVLET, this.paramsMap);
                            if (httpPost.connect() && httpPost.doPost()) {
                                List<String> list = httpPost.getResponseLines();
                                httpPost.close();
                                httpPost = null;
                                if (list == null) {
                                    throw new Exception("Failed to retrieve file list!");
                                }
                                if (Sc2gearsDatabaseDownloaderDialog.this.cancelPressed) {
                                    return;
                                }
                                Sc2gearsDatabaseDownloaderDialog.this.dispose();
                                this.paramsMap = new HashMap<String, String>();
                                this.paramsMap.put("protVer", "1");
                                this.paramsMap.put("authKey", string2);
                                this.paramsMap.put("op", "dl");
                                this.paramsMap.put("fileType", this.fileType);
                                ProgressDialog progressDialog = new ProgressDialog("sc2gearsDatabaseDownloader.downloadingFiles", Icons.SERVER_NETWORK, list.size());
                                byte[] byArray = new byte[204800];
                                for (String string : list) {
                                    if (progressDialog.isAborted()) break;
                                    if (!this.downloadFile(string, byArray)) {
                                        progressDialog.incrementFailed();
                                    }
                                    progressDialog.incrementProcessed();
                                    progressDialog.updateProgressBar();
                                }
                                progressDialog.taskFinished();
                                return;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (httpPost != null) {
                                httpPost.close();
                            }
                        }
                        GuiUtils.showErrorDialog(Language.getText("sc2gearsDatabaseDownloader.failedToRetrieveFileList"), new Frame[0]);
                        jLabel.setText(" ");
                        GuiUtils.setComponentTreeEnabled(box, true);
                        jButton2.setEnabled(true);
                    }

                    private boolean downloadFile(String string, byte[] byArray) {
                        this.paramsMap.put("sha1", string);
                        int n = 0;
                        while (n < 3) {
                            if (n > 0) {
                                System.out.println("Retrying file download... (" + (n + 1) + ")");
                            }
                            HttpPost httpPost = null;
                            try {
                                httpPost = new HttpPost(Consts.URL_SC2GEARS_DATABASE_FILE_SERVLET, this.paramsMap);
                                if (httpPost.connect() && httpPost.doPost() && httpPost.saveAttachmentToFile(this.fileProvider, new byte[][]{byArray})) {
                                    return true;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            finally {
                                if (httpPost != null) {
                                    httpPost.close();
                                }
                            }
                            System.out.println("Failed to download a file from the Sc2gears Database!");
                            ++n;
                        }
                        return false;
                    }
                }.start();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = this.createCloseButton("button.cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sc2gearsDatabaseDownloaderDialog.this.cancelPressed = true;
            }
        });
        jPanel.add(jButton3);
        box3.add(jPanel);
        box3.add(GuiUtils.wrapInPanel(jLabel));
        this.getContentPane().add((Component)box3, "South");
        this.packAndShow(jComboBox, false);
    }
}

