/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.components.CustomComboBoxModel;
import hu.belicza.andras.sc2gears.ui.components.ReplayInfoBox;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MySharedReplaysDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ReplayLinkPanel;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.Base64;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.HttpPost;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class ShareReplayDialog
extends BaseDialog {
    private static final String PARAM_VALUE_REQUEST_VERSION = "1.0";
    private static final String PARAM_NAME_REQUEST_VERSION = "requestVersion";
    private static final String PARAM_NAME_USER_NAME = "userName";
    private static final String PARAM_NAME_PASSWORD = "password";
    private static final String PARAM_NAME_DESCRIPTION = "description";
    private static final String PARAM_NAME_FILE_NAME = "fileName";
    private static final String PARAM_NAME_FILE_SIZE = "fileSize";
    private static final String PARAM_NAME_FILE_MD5 = "fileMd5";
    private static final String PARAM_NAME_FILE_CONTENT = "fileContent";
    private static final Icon NULL_ICON;
    public static final List<ReplayUploadSite> STATIC_REPLAY_UPLOAD_SITE_LIST;

    static {
        STATIC_REPLAY_UPLOAD_SITE_LIST = new ArrayList<ReplayUploadSite>();
        STATIC_REPLAY_UPLOAD_SITE_LIST.add(new ReplayUploadSite("drop.sc", "http://drop.sc", "http://drop.sc/api/upload?source=sc2gears", Icons.getReplaySiteIcon("DROP_SC")));
        STATIC_REPLAY_UPLOAD_SITE_LIST.add(new ReplayUploadSite("ReplayFu.com", "http://replayfu.com/", "http://replayfu.com/api/upload?key=49b752508fcccf95af720b162dfba9a0&requestType=xml", Icons.getReplaySiteIcon("REPLAYFU_COM")));
        STATIC_REPLAY_UPLOAD_SITE_LIST.add(new ReplayUploadSite("SC-Replay.com", "http://www.sc-replay.com/", "http://www.sc-replay.com/sc2gears/", Icons.getReplaySiteIcon("SC_REPLAY_COM")));
        STATIC_REPLAY_UPLOAD_SITE_LIST.add(new ReplayUploadSite("TopReplays.com", "http://topreplays.com/", "http://topreplays.com/Replays/InsertFromSc2Gears", Icons.getReplaySiteIcon("TOPREPLAYS_COM")));
        NULL_ICON = Icons.getNullIcon(STATIC_REPLAY_UPLOAD_SITE_LIST.get(0).icon.getIconWidth(), STATIC_REPLAY_UPLOAD_SITE_LIST.get(0).icon.getIconWidth());
    }

    public ShareReplayDialog(File file) {
        super("shareReplay.title", Icons.DOCUMENT_SHARE);
        Serializable serializable;
        this.setModal(false);
        if (file == null) {
            serializable = new JFileChooser(GeneralUtils.getDefaultReplayFolder());
            ((JFileChooser)serializable).setDialogTitle(Language.getText("shareReplay.openTitle"));
            ((JFileChooser)serializable).setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            ((JFileChooser)serializable).setAccessory(GuiUtils.createReplayFilePreviewAccessory((JFileChooser)serializable));
            ((JFileChooser)serializable).setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            if (((JFileChooser)serializable).showOpenDialog(MainFrame.INSTANCE) == 0) {
                file = ((JFileChooser)serializable).getSelectedFile();
            } else {
                this.dispose();
                return;
            }
        }
        serializable = file;
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(Language.getText("shareReplay.info1", "Sc2gears"));
        GuiUtils.changeFontToBold(jLabel);
        box.add(GuiUtils.wrapInPanelLeftAligned(jLabel));
        jLabel = new JLabel(Language.getText("shareReplay.info2"));
        GuiUtils.changeFontToBold(jLabel);
        JPanel jPanel = GuiUtils.wrapInPanelLeftAligned(jLabel);
        box.add(jPanel);
        JLabel jLabel2 = GeneralUtils.createLinkLabel(Language.getText("shareReplay.wantYourSiteListed"), "https://sites.google.com/site/sc2gears/features/replay-sharing");
        jPanel = GuiUtils.createRightAlignedInfoWrapperPanel(jLabel2, 5);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jLabel.getForeground()));
        box.add(jPanel);
        box.add(Box.createVerticalStrut(10));
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.replayToShare")));
        JTextField jTextField = new JTextField(file.getAbsolutePath(), 35);
        jTextField.setCaretPosition(0);
        jTextField.setEnabled(false);
        box2.add(jTextField);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.replayNameToReport")));
        final JTextField jTextField2 = new JTextField(file.getName(), 35);
        jTextField2.setCaretPosition(0);
        box2.add(jTextField2);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.replayDescription")));
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(7);
        box2.add(new JScrollPane(jTextArea));
        box.add(box2);
        final JLabel jLabel3 = GeneralUtils.createLinkStyledLabel(Language.getText("shareReplay.visitThisReplaySite"));
        final JButton jButton = new JButton(Icons.DRIVE_UPLOAD);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.chooseReplaySite")));
        final Vector<Object> vector = new Vector<Object>();
        ShareReplayDialog.constructReplayUploadSiteVector(vector);
        final JComboBox jComboBox = GuiUtils.createComboBox(vector, "shareRep.replaySite", false);
        GuiUtils.addEditListLinkToComboBoxPopup(jComboBox, new Runnable(){

            @Override
            public void run() {
                new MiscSettingsDialog(MiscSettingsDialog.SettingsTab.CUSTOM_REPLAY_SITES);
                vector.clear();
                ShareReplayDialog.constructReplayUploadSiteVector(vector);
                if (jComboBox.getModel() instanceof CustomComboBoxModel) {
                    ((CustomComboBoxModel)jComboBox.getModel()).fireContentsChanged(jComboBox);
                }
                jComboBox.setSelectedIndex(0);
            }
        });
        jComboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                Icon icon = object instanceof ReplayUploadSite ? ((ReplayUploadSite)object).icon : null;
                return icon == null ? NULL_ICON : icon;
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(jComboBox.getSelectedIndex() != 0);
                jLabel3.setEnabled(jComboBox.getSelectedIndex() != 0);
            }
        };
        actionListener.actionPerformed(null);
        jComboBox.addActionListener(actionListener);
        box2.add(jComboBox);
        box.add(box2);
        jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (jComboBox.getSelectedIndex() != 0) {
                    ReplayUploadSite replayUploadSite = (ReplayUploadSite)jComboBox.getSelectedItem();
                    GeneralUtils.showURLInBrowser(replayUploadSite.homePage);
                }
            }
        });
        box.add(GuiUtils.createRightAlignedInfoWrapperPanel(jLabel3, 0));
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.userName")));
        final JComboBox jComboBox2 = GuiUtils.createPredefinedListComboBox(Settings.PredefinedList.REP_SHARE_USER_NAME);
        jComboBox2.setSelectedItem(Settings.getString("shareRep.userName"));
        box2.add(jComboBox2);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("shareReplay.password")));
        final JPasswordField jPasswordField = new JPasswordField();
        box2.add(jPasswordField);
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        jLabel = new JLabel(Language.getText("shareReplay.info3", "Sc2gears"));
        GuiUtils.changeFontToItalic(jLabel);
        box.add(GuiUtils.wrapInPanelLeftAligned(jLabel));
        jLabel = new JLabel(Language.getText("shareReplay.info4"));
        GuiUtils.changeFontToItalic(jLabel);
        box.add(GuiUtils.wrapInPanelLeftAligned(jLabel));
        GuiUtils.alignBox(box, 2);
        this.getContentPane().add((Component)GuiUtils.wrapInPanel(box), "Center");
        ReplayInfoBox replayInfoBox = new ReplayInfoBox(file);
        replayInfoBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        this.getContentPane().add((Component)replayInfoBox, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        this.getContentPane().add((Component)jPanel3, "South");
        final JButton jButton2 = this.createCloseButton("button.close");
        final JTextArea jTextArea2 = new JTextArea();
        ReplayLinkPanel replayLinkPanel = new ReplayLinkPanel();
        GuiUtils.updateButtonText(jButton, "shareReplay.uploadButton", new Object[0]);
        jButton.addActionListener(new ActionListener((File)serializable, replayLinkPanel){
            private final /* synthetic */ File val$replayFile;
            private final /* synthetic */ ReplayLinkPanel val$replayLinkPanel;
            {
                this.val$replayFile = file;
                this.val$replayLinkPanel = replayLinkPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                JComponent[] jComponentArray;
                String string = jComboBox2.getSelectedItem().toString();
                Settings.set("shareRep.userName", string);
                ShareReplayDialog.this.setDefaultCloseOperation(0);
                Object object2 = jComponentArray = new JComponent[]{jTextField2, jTextArea, jComboBox, jComboBox2, jPasswordField, jButton, jButton2};
                int n = jComponentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = object2[n2];
                    ((JComponent)object).setEnabled(false);
                    ++n2;
                }
                object = (ReplayUploadSite)jComboBox.getSelectedItem();
                String string2 = jTextField2.getText();
                String string3 = jTextArea.getText();
                object2 = new String(jPasswordField.getPassword());
                new NormalThread("Replay uploader", (ReplayUploadSite)object, jComponentArray, this.val$replayFile, string2, string3, string, (String)object2, this.val$replayLinkPanel){
                    private final /* synthetic */ ReplayUploadSite val$replayUploadSite;
                    private final /* synthetic */ JComponent[] val$componentList;
                    private final /* synthetic */ File val$replayFile;
                    private final /* synthetic */ String val$reportedName;
                    private final /* synthetic */ String val$description;
                    private final /* synthetic */ String val$userName;
                    private final /* synthetic */ String val$password;
                    private final /* synthetic */ ReplayLinkPanel val$replayLinkPanel;
                    {
                        this.val$replayUploadSite = replayUploadSite;
                        this.val$componentList = jComponentArray;
                        this.val$replayFile = file;
                        this.val$reportedName = string2;
                        this.val$description = string3;
                        this.val$userName = string4;
                        this.val$password = string5;
                        this.val$replayLinkPanel = replayLinkPanel;
                        super(string);
                    }

                    /*
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        GuiUtils.appendNewLine(jTextArea2, "");
                        GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.preparingForUpload", new Object[]{this.val$replayUploadSite.displayName}));
                        var1_1 = null;
                        try {
                            var2_2 = GeneralUtils.calculateFileMd5(this.val$replayFile);
                            if (var2_2 == null || var2_2.length() == 0) {
                                System.err.println("MD5 could not be calculated (" + this.val$replayFile + ")!");
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.preparationFailed"));
                            }
                            var3_31 = Base64.encodeFile(this.val$replayFile);
                            if (var3_31 == null) {
                                System.err.println("Base64 encoding could not be performed (" + this.val$replayFile + ")!");
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.preparationFailed"));
                            }
                            var4_32 = new HashMap<String, String>();
                            var4_32.put("requestVersion", "1.0");
                            var4_32.put("fileName", this.val$reportedName);
                            var4_32.put("fileSize", Long.toString(this.val$replayFile.length()));
                            var4_32.put("description", this.val$description);
                            var4_32.put("userName", this.val$userName);
                            var4_32.put("password", this.val$password);
                            var4_32.put("fileMd5", var2_2);
                            var4_32.put("fileContent", var3_31);
                            var1_1 = new HttpPost(this.val$replayUploadSite.uploadUrl, var4_32);
                            GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.connecting", new Object[]{this.val$replayUploadSite.displayName}));
                            if (!var1_1.connect()) {
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.failedToConnect"));
                            }
                            GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.connectionEstabilished"));
                            GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.sendingReplay"));
                            if (!var1_1.doPost()) {
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.failedToSendReplay"));
                            }
                            GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.replaySentSuccessfully"));
                            GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.waitingServerResponse"));
                            var5_33 = var1_1.getResponse();
                            if (var5_33 == null) {
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.failedToParseServerResponse"));
                            }
                            try {
                                var6_34 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(var5_33.getBytes("UTF-8")));
                                var7_36 = var6_34.getDocumentElement();
                                var8_37 = Integer.parseInt(((Element)var7_36.getElementsByTagName("errorCode").item(0)).getTextContent().trim());
                                if (var8_37 == 0) {
                                    var9_38 = ((Element)var7_36.getElementsByTagName("replayUrl").item(0)).getTextContent().trim();
                                    GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.uploadSucceeded"));
                                    System.out.println("Uploaded replay \"" + this.val$replayFile.getAbsolutePath() + "\" to site " + this.val$replayUploadSite.displayName + ", replay URL: " + var9_38);
                                    this.val$replayLinkPanel.setUrl(var9_38, true, true);
                                    MySharedReplaysDialog.saveSharedRepInfo(this.val$replayUploadSite.displayName, this.val$userName, this.val$reportedName, this.val$description, var9_38);
                                }
                                var9_38 = ((Element)var7_36.getElementsByTagName("message").item(0)).getTextContent().trim();
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.uploadFailed"));
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.errorCode", new Object[]{var8_37}));
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.errorMessage", new Object[]{var9_38}));
                            }
                            catch (Exception var6_35) {
                                GuiUtils.appendNewLineWithTimestamp(jTextArea2, Language.getText("shareReplay.uploadProcess.failedToParseServerResponse"));
                                var6_35.printStackTrace();
                            }
                        }
                        finally {
                            if (var1_1 != null) {
                                var1_1.close();
                            }
                            5.access$0(this).setDefaultCloseOperation(2);
                            var14_3 = this.val$componentList;
                            var13_10 = this.val$componentList.length;
                            var12_17 = 0;
                            ** while (var12_17 < var13_10)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var11_24 = var14_3[var12_17];
                            var11_24.setEnabled(true);
                            ++var12_17;
                            continue;
                        }
lbl75:
                        // 1 sources

                    }
                }.start();
            }

            static /* synthetic */ ShareReplayDialog access$0(5 var0) {
                return var0.ShareReplayDialog.this;
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "North");
        jTextArea2.setRows(10);
        jTextArea2.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea2);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Language.getText("shareReplay.uploadProgressTitle")));
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)replayLinkPanel, "South");
        this.getContentPane().add((Component)jPanel2, "South");
        this.packAndShow(jTextArea, false);
    }

    private static void constructReplayUploadSiteVector(Vector<Object> vector) {
        vector.add(" ");
        vector.addAll(STATIC_REPLAY_UPLOAD_SITE_LIST);
        if (Settings.getBoolean("settings.misc.customReplaySitesAcknowledged")) {
            vector.addAll(Settings.getCustomReplayUploadSiteList());
        }
    }

    public static class ReplayUploadSite {
        public String displayName;
        public String homePage;
        public String uploadUrl;
        private final Icon icon;

        private ReplayUploadSite(String string, String string2, String string3, Icon icon) {
            this.displayName = string;
            this.homePage = string2;
            this.uploadUrl = string3;
            this.icon = icon;
        }

        public ReplayUploadSite() {
            this.icon = null;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

