/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.icons;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Icons {
    private static final String FLAG_ICONS_FOLDER_NAME = "flags";
    private static final Map<String, ImageIcon> LANGUAGE_FLAG_ICON_MAP = new HashMap<String, ImageIcon>();
    public static final ImageIcon SC2GEARS = new ImageIcon(Icons.class.getResource("my/sc2gears.png"));
    public static final ImageIcon SC2GEARS_LOGO = new ImageIcon(Icons.class.getResource("my/sc2gears_logo.png"));
    public static final ImageIcon FORMAT = new ImageIcon(Icons.class.getResource("my/format.png"));
    public static final ImageIcon SC2 = new ImageIcon(Icons.class.getResource("sc2/misc/sc2.png"));
    public static final ImageIcon SC2_EDITOR = new ImageIcon(Icons.class.getResource("sc2/misc/sc2_editor.png"));
    public static final ImageIcon WATCH_REPLAY = new ImageIcon(Icons.class.getResource("sc2/misc/watch_replay.png"));
    public static final ImageIcon PROFILE = new ImageIcon(Icons.class.getResource("sc2/misc/profile.png"));
    public static final URL RESOURCE_ACHIEVEMENT = Icons.class.getResource("sc2/misc/achievement.png");
    public static final ImageIcon ACHIEVEMENT = new ImageIcon(RESOURCE_ACHIEVEMENT);
    public static final ImageIcon ALARM_CLOCK = new ImageIcon(Icons.class.getResource("fugue/alarm-clock.png"));
    public static final ImageIcon APPLICATION_DIALOG = new ImageIcon(Icons.class.getResource("fugue/application-dialog.png"));
    public static final ImageIcon APPLICATION_DOCK_180 = new ImageIcon(Icons.class.getResource("fugue/application-dock-180.png"));
    public static final ImageIcon APPLICATION_DOCK_TAB = new ImageIcon(Icons.class.getResource("fugue/application-dock-tab.png"));
    public static final ImageIcon APPLICATION_DOCK = new ImageIcon(Icons.class.getResource("fugue/application-dock.png"));
    public static final ImageIcon APPLICATION_RESIZE_FULL = new ImageIcon(Icons.class.getResource("fugue/application-resize-full.png"));
    public static final ImageIcon APPLICATION_RESIZE = new ImageIcon(Icons.class.getResource("fugue/application-resize.png"));
    public static final ImageIcon APPLICATION_RESIZE_ACTUAL = new ImageIcon(Icons.class.getResource("fugue/application-resize-actual.png"));
    public static final ImageIcon APPLICATION_SIDEBAR_LIST = new ImageIcon(Icons.class.getResource("fugue/application-sidebar-list.png"));
    public static final ImageIcon APPLICATION_SIDEBAR = new ImageIcon(Icons.class.getResource("fugue/application-sidebar.png"));
    public static final ImageIcon APPLICATION_SPLIT_TILE = new ImageIcon(Icons.class.getResource("fugue/application-split-tile.png"));
    public static final ImageIcon APPLICATION_TILE_VERTICAL = new ImageIcon(Icons.class.getResource("fugue/application-tile-vertical.png"));
    public static final ImageIcon APPLICATIONS_STACK = new ImageIcon(Icons.class.getResource("fugue/applications-stack.png"));
    public static final ImageIcon ARROW_180 = new ImageIcon(Icons.class.getResource("fugue/arrow-180.png"));
    public static final ImageIcon ARROW_CIRCLE_315 = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-315.png"));
    public static final ImageIcon ARROW_CIRCLE_DOUBLE = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-double.png"));
    public static final ImageIcon ARROW_CURVE_180 = new ImageIcon(Icons.class.getResource("fugue/arrow-curve-180.png"));
    public static final ImageIcon ARROW = new ImageIcon(Icons.class.getResource("fugue/arrow.png"));
    public static final ImageIcon BALLOONS = new ImageIcon(Icons.class.getResource("fugue/balloons.png"));
    public static final ImageIcon BINOCULAR_ARROW = new ImageIcon(Icons.class.getResource("fugue/binocular--arrow.png"));
    public static final ImageIcon BINOCULAR = new ImageIcon(Icons.class.getResource("fugue/binocular.png"));
    public static final ImageIcon BLOCK = new ImageIcon(Icons.class.getResource("fugue/block.png"));
    public static final ImageIcon BLOCK_ARROW = new ImageIcon(Icons.class.getResource("fugue/block--arrow.png"));
    public static final ImageIcon BROOM = new ImageIcon(Icons.class.getResource("fugue/broom.png"));
    public static final ImageIcon BURN = new ImageIcon(Icons.class.getResource("fugue/burn.png"));
    public static final ImageIcon CALCULATOR = new ImageIcon(Icons.class.getResource("fugue/calculator.png"));
    public static final ImageIcon CALENDAR_BLUE = new ImageIcon(Icons.class.getResource("fugue/calendar-blue.png"));
    public static final ImageIcon CALENDAR_SELECT = new ImageIcon(Icons.class.getResource("fugue/calendar-select.png"));
    public static final ImageIcon CARD = new ImageIcon(Icons.class.getResource("fugue/card.png"));
    public static final ImageIcon CHART_PLUS = new ImageIcon(Icons.class.getResource("fugue/chart--plus.png"));
    public static final ImageIcon CHART_UP_COLOR = new ImageIcon(Icons.class.getResource("fugue/chart-up-color.png"));
    public static final ImageIcon CHART_UP = new ImageIcon(Icons.class.getResource("fugue/chart-up.png"));
    public static final ImageIcon CHART = new ImageIcon(Icons.class.getResource("fugue/chart.png"));
    public static final ImageIcon CLIPBOARD_SIGN = new ImageIcon(Icons.class.getResource("fugue/clipboard-sign.png"));
    public static final ImageIcon CLOCK = new ImageIcon(Icons.class.getResource("fugue/clock.png"));
    public static final ImageIcon COLOR = new ImageIcon(Icons.class.getResource("fugue/color.png"));
    public static final ImageIcon COMPUTER = new ImageIcon(Icons.class.getResource("fugue/computer.png"));
    public static final ImageIcon CONTROL_DOUBLE = new ImageIcon(Icons.class.getResource("fugue/control-double.png"));
    public static final ImageIcon CONTROL_DOUBLE_180 = new ImageIcon(Icons.class.getResource("fugue/control-double-180.png"));
    public static final ImageIcon CONTROL_PAUSE = new ImageIcon(Icons.class.getResource("fugue/control-pause.png"));
    public static final ImageIcon CONTROL_RECORD = new ImageIcon(Icons.class.getResource("fugue/control-record.png"));
    public static final ImageIcon CONTROL_SKIP_180 = new ImageIcon(Icons.class.getResource("fugue/control-skip-180.png"));
    public static final ImageIcon CONTROL_SKIP = new ImageIcon(Icons.class.getResource("fugue/control-skip.png"));
    public static final ImageIcon CONTROL_STOP_SQUARE = new ImageIcon(Icons.class.getResource("fugue/control-stop-square.png"));
    public static final ImageIcon CONTROL = new ImageIcon(Icons.class.getResource("fugue/control.png"));
    public static final ImageIcon COUNTER_COUNT_UP = new ImageIcon(Icons.class.getResource("fugue/counter-count-up.png"));
    public static final ImageIcon COUNTER_RESET = new ImageIcon(Icons.class.getResource("fugue/counter-reset.png"));
    public static final ImageIcon CROSS_BUTTON = new ImageIcon(Icons.class.getResource("fugue/cross-button.png"));
    public static final ImageIcon CROSS_OCTAGON = new ImageIcon(Icons.class.getResource("fugue/cross-octagon.png"));
    public static final ImageIcon CROSS_SMALL = new ImageIcon(Icons.class.getResource("fugue/cross-small.png"));
    public static final ImageIcon CROSS = new ImageIcon(Icons.class.getResource("fugue/cross.png"));
    public static final ImageIcon CROSS_WHITE = new ImageIcon(Icons.class.getResource("fugue/cross-white.png"));
    public static final ImageIcon DOCUMENT_BINARY = new ImageIcon(Icons.class.getResource("fugue/document-binary.png"));
    public static final ImageIcon DOCUMENT_COPY = new ImageIcon(Icons.class.getResource("fugue/document-copy.png"));
    public static final ImageIcon DOCUMENT_EXPORT = new ImageIcon(Icons.class.getResource("fugue/document-export.png"));
    public static final ImageIcon DOCUMENT_RENAME = new ImageIcon(Icons.class.getResource("fugue/document-rename.png"));
    public static final ImageIcon DOCUMENT_SHARE = new ImageIcon(Icons.class.getResource("fugue/document-share.png"));
    public static final ImageIcon DOCUMENT_ZIPPER = new ImageIcon(Icons.class.getResource("fugue/document-zipper.png"));
    public static final ImageIcon DOCUMENT = new ImageIcon(Icons.class.getResource("fugue/document.png"));
    public static final ImageIcon DOCUMENTS_STACK = new ImageIcon(Icons.class.getResource("fugue/documents-stack.png"));
    public static final ImageIcon DISK_ARROW = new ImageIcon(Icons.class.getResource("fugue/disk--arrow.png"));
    public static final ImageIcon DISK = new ImageIcon(Icons.class.getResource("fugue/disk.png"));
    public static final ImageIcon DOOR_OPEN_IN = new ImageIcon(Icons.class.getResource("fugue/door-open-in.png"));
    public static final ImageIcon DRIVE_DOWNLOAD = new ImageIcon(Icons.class.getResource("fugue/drive-download.png"));
    public static final ImageIcon DRIVE_UPLOAD = new ImageIcon(Icons.class.getResource("fugue/drive-upload.png"));
    public static final ImageIcon EDIT_COLUMN = new ImageIcon(Icons.class.getResource("fugue/edit-column.png"));
    public static final ImageIcon EQUALIZER = new ImageIcon(Icons.class.getResource("fugue/equalizer.png"));
    public static final ImageIcon EXCLAMATION_OCTAGON_FRAME = new ImageIcon(Icons.class.getResource("fugue/exclamation-octagon-frame.png"));
    public static final ImageIcon EXCLAMATION = new ImageIcon(Icons.class.getResource("fugue/exclamation.png"));
    public static final ImageIcon FINGERPRINT = new ImageIcon(Icons.class.getResource("fugue/fingerprint.png"));
    public static final ImageIcon FOLDER = new ImageIcon(Icons.class.getResource("fugue/folder.png"));
    public static final ImageIcon FOLDER_MINUS = new ImageIcon(Icons.class.getResource("fugue/folder--minus.png"));
    public static final ImageIcon FOLDER_BOOKMARK = new ImageIcon(Icons.class.getResource("fugue/folder-bookmark.png"));
    public static final ImageIcon FOLDER_OPEN = new ImageIcon(Icons.class.getResource("fugue/folder-open.png"));
    public static final ImageIcon FOLDER_TREE = new ImageIcon(Icons.class.getResource("fugue/folder-tree.png"));
    public static final ImageIcon FOLDERS_STACK = new ImageIcon(Icons.class.getResource("fugue/folders-stack.png"));
    public static final ImageIcon FOLDERS = new ImageIcon(Icons.class.getResource("fugue/folders.png"));
    public static final ImageIcon GLOBE_ARROW = new ImageIcon(Icons.class.getResource("fugue/globe--arrow.png"));
    public static final ImageIcon GRID = new ImageIcon(Icons.class.getResource("fugue/grid.png"));
    public static final ImageIcon HOME_ARROW = new ImageIcon(Icons.class.getResource("fugue/home--arrow.png"));
    public static final ImageIcon HOURGLASS = new ImageIcon(Icons.class.getResource("fugue/hourglass.png"));
    public static final ImageIcon IMAGE = new ImageIcon(Icons.class.getResource("fugue/image.png"));
    public static final ImageIcon INFORMATION = new ImageIcon(Icons.class.getResource("fugue/information.png"));
    public static final ImageIcon KEYBOARD = new ImageIcon(Icons.class.getResource("fugue/keyboard.png"));
    public static final ImageIcon LICENSE_KEY = new ImageIcon(Icons.class.getResource("fugue/license-key.png"));
    public static final ImageIcon LIGHT_BULB = new ImageIcon(Icons.class.getResource("fugue/light-bulb.png"));
    public static final ImageIcon INFORMATION_BALLOON = new ImageIcon(Icons.class.getResource("fugue/information-balloon.png"));
    public static final ImageIcon LOCALE = new ImageIcon(Icons.class.getResource("fugue/locale.png"));
    public static final ImageIcon MAP_PENCIL = new ImageIcon(Icons.class.getResource("fugue/map--pencil.png"));
    public static final ImageIcon MAP = new ImageIcon(Icons.class.getResource("fugue/map.png"));
    public static final ImageIcon MAPS_STACK = new ImageIcon(Icons.class.getResource("fugue/maps-stack.png"));
    public static final ImageIcon MICROPHONE = new ImageIcon(Icons.class.getResource("fugue/microphone.png"));
    public static final ImageIcon MINUS_SMALL = new ImageIcon(Icons.class.getResource("fugue/minus-small.png"));
    public static final ImageIcon MINUS = new ImageIcon(Icons.class.getResource("fugue/minus.png"));
    public static final ImageIcon NA = new ImageIcon(Icons.class.getResource("fugue/na.png"));
    public static final ImageIcon NEWSPAPER = new ImageIcon(Icons.class.getResource("fugue/newspaper.png"));
    public static final ImageIcon NOTEBOOK_ARROW = new ImageIcon(Icons.class.getResource("fugue/notebook--arrow.png"));
    public static final ImageIcon PLUG_CONNECT = new ImageIcon(Icons.class.getResource("fugue/plug-connect.png"));
    public static final ImageIcon PLUG_DISCCONNECT = new ImageIcon(Icons.class.getResource("fugue/plug-disconnect.png"));
    public static final ImageIcon PLUS_SMALL = new ImageIcon(Icons.class.getResource("fugue/plus-small.png"));
    public static final ImageIcon PLUS = new ImageIcon(Icons.class.getResource("fugue/plus.png"));
    public static final ImageIcon PUZZLE = new ImageIcon(Icons.class.getResource("fugue/puzzle.png"));
    public static final ImageIcon QUESTION = new ImageIcon(Icons.class.getResource("fugue/question.png"));
    public static final ImageIcon REPORT_EXCLAMATION = new ImageIcon(Icons.class.getResource("fugue/report--exclamation.png"));
    public static final ImageIcon SERVER_NETWORK = new ImageIcon(Icons.class.getResource("fugue/server-network.png"));
    public static final ImageIcon SORT_ALPHABET = new ImageIcon(Icons.class.getResource("fugue/sort-alphabet.png"));
    public static final ImageIcon SPEAKER_VOLUME = new ImageIcon(Icons.class.getResource("fugue/speaker-volume.png"));
    public static final ImageIcon SYSTEM_MONITOR = new ImageIcon(Icons.class.getResource("fugue/system-monitor.png"));
    public static final ImageIcon TABLE_DELETE_ROW = new ImageIcon(Icons.class.getResource("fugue/table-delete-row.png"));
    public static final ImageIcon TABLE_EXCEL = new ImageIcon(Icons.class.getResource("fugue/table-excel.png"));
    public static final ImageIcon TABLE_EXPORT = new ImageIcon(Icons.class.getResource("fugue/table-export.png"));
    public static final ImageIcon TABLE_SELECT_ROW = new ImageIcon(Icons.class.getResource("fugue/table-select-row.png"));
    public static final ImageIcon TABLE = new ImageIcon(Icons.class.getResource("fugue/table.png"));
    public static final ImageIcon TICK = new ImageIcon(Icons.class.getResource("fugue/tick.png"));
    public static final ImageIcon TOGGLE = new ImageIcon(Icons.class.getResource("fugue/toggle.png"));
    public static final ImageIcon TOGGLE_EXPAND = new ImageIcon(Icons.class.getResource("fugue/toggle-expand.png"));
    public static final ImageIcon TROPHY = new ImageIcon(Icons.class.getResource("fugue/trophy.png"));
    public static final ImageIcon UI_COMBO_BOX_BLUE = new ImageIcon(Icons.class.getResource("fugue/ui-combo-box-blue.png"));
    public static final ImageIcon UI_FLOW = new ImageIcon(Icons.class.getResource("fugue/ui-flow.png"));
    public static final ImageIcon UI_LAYOUT_PANEL = new ImageIcon(Icons.class.getResource("fugue/ui-layout-panel.png"));
    public static final ImageIcon UI_SCROLL_PANE_LIST = new ImageIcon(Icons.class.getResource("fugue/ui-scroll-pane-list.png"));
    public static final ImageIcon USER_ARROW = new ImageIcon(Icons.class.getResource("fugue/user--arrow.png"));
    public static final ImageIcon USER_PLUS = new ImageIcon(Icons.class.getResource("fugue/user--plus.png"));
    public static final ImageIcon USER_MINUS = new ImageIcon(Icons.class.getResource("fugue/user--minus.png"));
    public static final ImageIcon USER = new ImageIcon(Icons.class.getResource("fugue/user.png"));
    public static final ImageIcon USERS = new ImageIcon(Icons.class.getResource("fugue/users.png"));
    public static final ImageIcon WRENCH = new ImageIcon(Icons.class.getResource("fugue/wrench.png"));
    public static final ImageIcon CROSS_BIG = new ImageIcon(Icons.class.getResource("fugue/24/cross.png"));
    public static final ImageIcon EXCLAMATION_BIG = new ImageIcon(Icons.class.getResource("fugue/24/exclamation.png"));
    public static final ImageIcon TICK_BIG = new ImageIcon(Icons.class.getResource("fugue/24/tick.png"));
    public static final ImageIcon RACE_TERRAN = new ImageIcon(Icons.class.getResource("sc2/races/terran.png"));
    public static final ImageIcon RACE_PROTOSS = new ImageIcon(Icons.class.getResource("sc2/races/protoss.png"));
    public static final ImageIcon RACE_ZERG = new ImageIcon(Icons.class.getResource("sc2/races/zerg.png"));
    public static final ImageIcon RACE_RANDOM = new ImageIcon(Icons.class.getResource("sc2/races/random.png"));
    public static final ImageIcon RACE_ANY = new ImageIcon(Icons.class.getResource("sc2/races/any.png"));
    public static final ImageIcon RACE_ALL = new ImageIcon(Icons.class.getResource("sc2/races/all.png"));
    public static final ImageIcon CHART_CURVE = new ImageIcon(Icons.class.getResource("famfamfam/chart_curve.png"));
    public static final ImageIcon DATABASE_SAVE = new ImageIcon(Icons.class.getResource("famfamfam/database_save.png"));
    public static final ImageIcon GROUP_LINK = new ImageIcon(Icons.class.getResource("famfamfam/group_link.png"));
    public static final ImageIcon HANDICAP = new ImageIcon(Icons.class.getResource("misc/handicap.gif"));
    public static final ImageIcon SC2RANKS = new ImageIcon(Icons.class.getResource("misc/sc2ranks.png"));
    private static final Map<ReplayConsts.Building, IconHandler> buildingIcons = new EnumMap<ReplayConsts.Building, IconHandler>(ReplayConsts.Building.class);
    private static final Map<ReplayConsts.Unit, IconHandler> unitIcons = new EnumMap<ReplayConsts.Unit, IconHandler>(ReplayConsts.Unit.class);
    private static final Map<ReplayConsts.Upgrade, IconHandler> upgradeIcons = new EnumMap<ReplayConsts.Upgrade, IconHandler>(ReplayConsts.Upgrade.class);
    private static final Map<ReplayConsts.Research, IconHandler> researchIcons = new EnumMap<ReplayConsts.Research, IconHandler>(ReplayConsts.Research.class);
    private static final Map<ReplayConsts.AbilityGroup, IconHandler> abilityGroupIcons = new EnumMap<ReplayConsts.AbilityGroup, IconHandler>(ReplayConsts.AbilityGroup.class);
    private static final Map<MiscObject, IconHandler> miscObjectIcons = new EnumMap<MiscObject, IconHandler>(MiscObject.class);
    private static final BufferedImage[] PORTRAIT_GROUP_IMAGES = new BufferedImage[4];
    private static final Map<Integer, Icon> portraitKeyIconMap = new HashMap<Integer, Icon>();
    public static final int PORTRAIT_ICON_WIDTH = 45;
    public static final int PORTRAIT_ICON_HEIGHT = 45;
    public static final int PORTRAIT_HIGH_ICON_WIDTH = 90;
    public static final int PORTRAIT_HIGH_ICON_HEIGHT = 90;
    public static final Icon PORTRAIT_NULL_ICON = Icons.getNullIcon(45, 45);
    public static final Icon PORTRAIT_LOADING_ICON = Icons.getCustomIcon(HOURGLASS, 45, 45, 2);
    public static final Icon PORTRAIT_NA_ICON = Icons.getCustomIcon(NA, 45, 45, 2);
    public static final Icon PORTRAIT_COMPUTER_ICON = Icons.getCustomIcon(COMPUTER, 45, 45, 2);
    public static final Icon PORTRAIT_HIGH_NULL_ICON = Icons.getNullIcon(90, 90);
    public static final Icon PORTRAIT_HIGH_LOADING_ICON = Icons.getCustomIcon(HOURGLASS, 90, 90, 4);
    public static final Icon PORTRAIT_HIGH_NA_ICON = Icons.getCustomIcon(NA, 90, 90, 4);
    public static final Icon LEAGUE_NULL_ICON = Icons.getNullIcon(27, 27);
    public static final Icon LEAGUE_LOADING_ICON = Icons.getCustomIcon(HOURGLASS, 27, 27, 1);
    public static final Icon LEAGUE_NA_ICON = Icons.getCustomIcon(NA, 27, 27, 1);

    private Icons() {
    }

    public static ImageIcon getLanguageIcon(String string) {
        ImageIcon imageIcon = LANGUAGE_FLAG_ICON_MAP.get(string);
        if (imageIcon == null) {
            URL uRL = Icons.class.getResource("flags/" + string + ".gif");
            if (uRL == null) {
                try {
                    uRL = new File("Languages/" + string + ".gif").toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            imageIcon = uRL == null ? new ImageIcon() : new ImageIcon(uRL);
            LANGUAGE_FLAG_ICON_MAP.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static Icon getBuildingIcon(ReplayConsts.Building building, IconHandler.Size size) {
        IconHandler iconHandler = buildingIcons.get((Object)building);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/buildings/" + building.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            buildingIcons.put(building, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUnitIcon(ReplayConsts.Unit unit, IconHandler.Size size) {
        IconHandler iconHandler = unitIcons.get((Object)unit);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/units/" + unit.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            unitIcons.put(unit, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUpgradeIcon(ReplayConsts.Upgrade upgrade, IconHandler.Size size) {
        IconHandler iconHandler = upgradeIcons.get((Object)upgrade);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/upgrades/" + upgrade.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            upgradeIcons.put(upgrade, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getResearchIcon(ReplayConsts.Research research, IconHandler.Size size) {
        IconHandler iconHandler = researchIcons.get((Object)research);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/researches/" + research.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            researchIcons.put(research, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getAbilityGroupIcon(ReplayConsts.AbilityGroup abilityGroup, IconHandler.Size size) {
        if (abilityGroup == null) {
            return IconHandler.NULL.get((Object)size);
        }
        IconHandler iconHandler = abilityGroupIcons.get((Object)abilityGroup);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/abilitygroups/" + abilityGroup.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            abilityGroupIcons.put(abilityGroup, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getMiscObjectIcon(MiscObject miscObject, IconHandler.Size size) {
        if (miscObject == null) {
            return IconHandler.NULL.get((Object)size);
        }
        IconHandler iconHandler = miscObjectIcons.get((Object)miscObject);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/miscobjects/" + miscObject.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            miscObjectIcons.put(miscObject, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getEntityIcon(Object object, IconHandler.Size size) {
        if (object instanceof ReplayConsts.Unit) {
            return Icons.getUnitIcon((ReplayConsts.Unit)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Building) {
            return Icons.getBuildingIcon((ReplayConsts.Building)((Object)object), size);
        }
        if (object instanceof ReplayConsts.AbilityGroup) {
            return Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Research) {
            return Icons.getResearchIcon((ReplayConsts.Research)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Upgrade) {
            return Icons.getUpgradeIcon((ReplayConsts.Upgrade)((Object)object), size);
        }
        if (object instanceof MiscObject) {
            return Icons.getMiscObjectIcon((MiscObject)((Object)object), size);
        }
        return IconHandler.NULL.get((Object)size);
    }

    public static ImageIcon getRaceIcon(ReplayConsts.Race race) {
        if (race == null) {
            return null;
        }
        switch (race) {
            case TERRAN: {
                return RACE_TERRAN;
            }
            case PROTOSS: {
                return RACE_PROTOSS;
            }
            case ZERG: {
                return RACE_ZERG;
            }
            case RANDOM: {
                return RACE_RANDOM;
            }
        }
        return null;
    }

    public static URL getRaceIconResource(ReplayConsts.Race race) {
        if (race == null) {
            return null;
        }
        switch (race) {
            case TERRAN: {
                return Icons.class.getResource("sc2/races/terran.png");
            }
            case PROTOSS: {
                return Icons.class.getResource("sc2/races/protoss.png");
            }
            case ZERG: {
                return Icons.class.getResource("sc2/races/zerg.png");
            }
            case RANDOM: {
                return Icons.class.getResource("sc2/races/random.png");
            }
        }
        return null;
    }

    public static ImageIcon getReplaySiteIcon(String string) {
        return new ImageIcon(Icons.class.getResource("replaysites/" + string + ".png"));
    }

    public static Icon getNullIcon(final int n, final int n2) {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
            }

            @Override
            public int getIconWidth() {
                return n;
            }

            @Override
            public int getIconHeight() {
                return n2;
            }
        };
    }

    public static Icon getCustomIcon(final ImageIcon imageIcon, final int n, final int n2, final int n3) {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n5, int n22) {
                if (n3 == 1) {
                    graphics.drawImage(imageIcon.getImage(), n5 + (n - imageIcon.getIconWidth() >> 1), n22 + (n2 - imageIcon.getIconHeight() >> 1), null);
                } else {
                    int n32 = imageIcon.getIconWidth() * n3;
                    int n4 = imageIcon.getIconHeight() * n3;
                    graphics.drawImage(imageIcon.getImage(), n5 + (n - n32 >> 1), n22 + (n2 - n4 >> 1), n32, n4, null);
                }
            }

            @Override
            public int getIconWidth() {
                return n;
            }

            @Override
            public int getIconHeight() {
                return n2;
            }
        };
    }

    public static Icon getPortraitIcon(int n, int n2, int n3) {
        Integer n4 = n << 16 | n2 << 8 | n3;
        Icon icon = portraitKeyIconMap.get(n4);
        if (icon == null) {
            if (n < 0 || n >= PORTRAIT_GROUP_IMAGES.length) {
                return PORTRAIT_NULL_ICON;
            }
            if (PORTRAIT_GROUP_IMAGES[n] == null) {
                URL uRL = Icons.class.getResource("sc2/portraits/" + n + ".jpg");
                if (uRL == null) {
                    return PORTRAIT_NULL_ICON;
                }
                ImageIcon imageIcon = new ImageIcon(uRL);
                Icons.PORTRAIT_GROUP_IMAGES[n] = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
                PORTRAIT_GROUP_IMAGES[n].createGraphics().drawImage(imageIcon.getImage(), 0, 0, null);
            }
            int n5 = n3 * 45;
            int n6 = n2 * 45;
            if (n5 < 0 || n6 < 0 || n5 + 45 > PORTRAIT_GROUP_IMAGES[n].getWidth() || n6 + 45 > PORTRAIT_GROUP_IMAGES[n].getHeight()) {
                return PORTRAIT_NULL_ICON;
            }
            icon = new ImageIcon(PORTRAIT_GROUP_IMAGES[n].getSubimage(n5, n6, 45, 45));
            portraitKeyIconMap.put(n4, icon);
        }
        return icon;
    }

    public static Icon getPortraitHighIcon(int n, int n2, int n3) {
        URL uRL = Icons.class.getResource("sc2/portraits-high/" + n + "/" + (n2 + 1) + "-" + (n3 + 1) + ".jpg");
        return uRL == null ? PORTRAIT_HIGH_NULL_ICON : new ImageIcon(uRL);
    }

    public static enum League {
        GRANDMASTER("module.repAnalyzer.tab.charts.players.league.grandmaster", "grandmaster"),
        MASTER("module.repAnalyzer.tab.charts.players.league.master", "master"),
        DIAMOND("module.repAnalyzer.tab.charts.players.league.diamond", "diamond"),
        PLATINUM("module.repAnalyzer.tab.charts.players.league.platinum", "platinum"),
        GOLD("module.repAnalyzer.tab.charts.players.league.gold", "gold"),
        SILVER("module.repAnalyzer.tab.charts.players.league.silver", "silver"),
        BRONZE("module.repAnalyzer.tab.charts.players.league.bronze", "bronze"),
        UNRANKED("module.repAnalyzer.tab.charts.players.league.unranked", ""),
        UNKNOWN("general.unknown", "");

        public final String stringValue;
        public final String bnetString;
        private final Icon[] icons = new Icon[4];
        private final URL[] iconResources = new URL[4];

        private League(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.bnetString = string3;
        }

        public Icon getIconForRank(int n) {
            int n2 = this.getIconIndexForRank(n);
            return this.icons[n2];
        }

        public URL getIconResourceForRank(int n) {
            int n2 = this.getIconIndexForRank(n);
            return this.iconResources[n2];
        }

        private int getIconIndexForRank(int n) {
            int n2;
            if (this == UNRANKED || this == UNKNOWN) {
                n2 = 0;
            } else {
                if (this != GRANDMASTER) {
                    n <<= 1;
                }
                n2 = n > 100 ? 0 : (n > 50 ? 1 : (n > 16 ? 2 : 3));
            }
            if (this.icons[n2] == null) {
                if (this == UNKNOWN) {
                    this.icons[n2] = Icons.getNullIcon(27, 27);
                } else {
                    this.iconResources[n2] = Icons.class.getResource("sc2/leagues/" + this.name() + "-" + (n2 + 1) + ".png");
                    this.icons[n2] = new ImageIcon(this.iconResources[n2]);
                }
            }
            return n2;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MiscObject {
        MINERAL_FIELD,
        RICH_MINERAL_FIELD,
        BANELING_COCOON,
        OVERSEER_COCOON,
        BROOD_LORD_COCOON,
        INFESTED_SWARM_EGG,
        XEL_NAGA_TOWER,
        VESPENE_GEYSER,
        SPACE_PLATFORM_GEYSER,
        DESTRUCTIBLE_DEBRIS,
        DESTRUCTIBLE_ROCK,
        MENGSK_STATUE_ALONE,
        MENGSK_STATUE,
        WOLF_STATUE,
        GLOBE_STATUE,
        LYOTE,
        URUBU,
        MALE_KARAK,
        FEMALE_KARAK,
        MALE_URSADAK,
        FEMALE_URSADAK,
        AUTOMATON_2000,
        SCANTIPEDE;

    }
}

