/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.ui.charts.BaseChartPainter;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartSegmentStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.LadderSeason;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MultiRepAnalysis;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;

class ChartPainter
extends BaseChartPainter {
    private static final Map<ReplayConsts.Race, Color> RACE_COLOR_MAP = new EnumMap<ReplayConsts.Race, Color>(ReplayConsts.Race.class);
    private static final Map<ReplayConsts.GameType, Color> GAME_TYPE_COLOR_MAP = new EnumMap<ReplayConsts.GameType, Color>(ReplayConsts.GameType.class);
    private static final Map<ReplayConsts.Format, Color> FORMAT_COLOR_MAP = new EnumMap<ReplayConsts.Format, Color>(ReplayConsts.Format.class);
    private static final Color MISSING_COLOR;
    private static final Color COLOR_GENERAL_CHART;
    private static final Color COLOR_AVERAGE_MARKER;
    protected final ChartParams params;
    private int yAxisLabelEndPos;

    static {
        RACE_COLOR_MAP.put(ReplayConsts.Race.PROTOSS, ReplayConsts.PlayerColor.BLUE.color);
        RACE_COLOR_MAP.put(ReplayConsts.Race.TERRAN, ReplayConsts.PlayerColor.GREEN.color);
        RACE_COLOR_MAP.put(ReplayConsts.Race.ZERG, ReplayConsts.PlayerColor.ORANGE.color);
        RACE_COLOR_MAP.put(ReplayConsts.Race.UNKNOWN, Color.LIGHT_GRAY);
        GAME_TYPE_COLOR_MAP.put(ReplayConsts.GameType.AMM, ReplayConsts.PlayerColor.GREEN.color);
        GAME_TYPE_COLOR_MAP.put(ReplayConsts.GameType.PRIVATE, ReplayConsts.PlayerColor.BLUE.color);
        GAME_TYPE_COLOR_MAP.put(ReplayConsts.GameType.PUBLIC, ReplayConsts.PlayerColor.ORANGE.color);
        GAME_TYPE_COLOR_MAP.put(ReplayConsts.GameType.SINGLE_PLAYER, ReplayConsts.PlayerColor.LIGHT_PINK.color);
        GAME_TYPE_COLOR_MAP.put(ReplayConsts.GameType.UNKNOWN, Color.LIGHT_GRAY);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.ONE_VS_ONE, ReplayConsts.PlayerColor.GREEN.color);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.TWO_VS_TWO, ReplayConsts.PlayerColor.BLUE.color);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.THREE_VS_THREE, ReplayConsts.PlayerColor.ORANGE.color);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.FOUR_VS_FOUR, ReplayConsts.PlayerColor.LIGHT_PINK.color);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.FREE_FOR_ALL, ReplayConsts.PlayerColor.TEAL.color);
        FORMAT_COLOR_MAP.put(ReplayConsts.Format.UNKNOWN, Color.LIGHT_GRAY);
        MISSING_COLOR = Color.DARK_GRAY;
        COLOR_GENERAL_CHART = new Color(180, 20, 30);
        COLOR_AVERAGE_MARKER = new Color(40, 100, 255);
    }

    public ChartPainter(ChartParams chartParams) {
        super(chartParams);
        this.params = chartParams;
        this.params.calcualteDerivedData();
    }

    @Override
    public void paintChart() {
        super.paintChart();
        if (this.params.chartDX <= 0) {
            return;
        }
        this.paintAxis();
        switch (this.params.chartType) {
            case ACTIVITY: {
                this.paintActivityChart();
                break;
            }
            case APM_DEVELOPMENT: {
                this.paintApmDevelopmentChart();
                break;
            }
            case WIN_RATIO_DEVELOPMENT: {
                this.paintWinRatioDevelopmentChart();
                break;
            }
            case RACE_DISTRIBUTION: 
            case GAME_TYPE_DISTRIBUTION: 
            case FORMAT_DISTRIBUTION: {
                this.paintDistributionChart();
            }
        }
    }

    private void paintAxis() {
        int n;
        int n2;
        int n3;
        this.g2.setColor(COLOR_AXIS);
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        String string = Language.getText(this.params.chartType.yAxisLabelKey, new Object[]{this.params.chartGranularity});
        this.g2.drawString(string, 31, this.g2.getFontMetrics().getAscent() - 2);
        this.yAxisLabelEndPos = 31 + this.g2.getFontMetrics().stringWidth(string);
        this.g2.setFont(font);
        this.g2.drawLine(30, this.params.chartY1, 30, this.params.chartY2);
        this.g2.drawLine(30, this.params.chartY2 + 1, this.params.chartX2, this.params.chartY2 + 1);
        int n4 = this.params.segmentStats.length - 1;
        int n5 = this.g2.getFontMetrics().getAscent();
        int n6 = n3 = this.params.chartWidth < 100 ? 1 : this.params.chartWidth / 100;
        if (n3 == 1) {
            n2 = n4;
        } else {
            n2 = 1;
            n = n4;
            while (n > n3) {
                n = n4 / ++n2;
            }
        }
        n = n4;
        while (n >= 0) {
            if (n - n2 < 0) {
                n = 0;
            }
            int n7 = this.params.chartX1 + n * this.params.chartDX / n4;
            String string2 = this.params.chartGranularity == MultiRepAnalysis.ChartGranularity.LADDER_SEASON ? LadderSeason.getByStartDate((Date)this.params.segmentStats[n].lowerDate).stringValue : Language.formatDate(this.params.segmentStats[n].lowerDate);
            this.g2.setColor(COLOR_AXIS);
            this.g2.drawLine(n7, this.params.chartY2 + 1, n7, this.params.chartY2 + 3);
            this.g2.setColor(COLOR_AXIS_LABELS);
            this.g2.drawString(string2, n7 - (this.g2.getFontMetrics().stringWidth(string2) >> (n == n4 ? 0 : (n == 0 ? 2 : 1))), this.params.chartY2 + n5);
            if (n > 0) {
                this.g2.setColor(COLOR_ASSIST_LINES);
                this.g2.setStroke(STROKE_DASHED);
                this.g2.drawLine(n7, this.params.chartY1, n7, this.params.chartY2);
                this.g2.setStroke(STROKE_DEFAULT);
            }
            n -= n2;
        }
    }

    private void paintActivityChart() {
        float f;
        int n;
        ChartSegmentStatistics[] chartSegmentStatisticsArray = this.params.segmentStats;
        int[] nArray = new int[chartSegmentStatisticsArray.length];
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            nArray[n2] = n = chartSegmentStatisticsArray[n2].record.totalGames;
            --n2;
        }
        if (this.params.chartGranularity == MultiRepAnalysis.ChartGranularity.LADDER_SEASON) {
            n = 0;
            ChartSegmentStatistics[] chartSegmentStatisticsArray2 = chartSegmentStatisticsArray;
            int n3 = chartSegmentStatisticsArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ChartSegmentStatistics chartSegmentStatistics = chartSegmentStatisticsArray2[n4];
                if (chartSegmentStatistics.record.totalGames > 0) {
                    ++n;
                }
                ++n4;
            }
            int n5 = n == 1 ? 1 : (chartSegmentStatisticsArray.length == 0 ? 1 : chartSegmentStatisticsArray.length);
            f = this.params.playerStatistics.record.totalGames / n5;
        } else {
            f = this.params.playerStatistics.getAvgGamesPerDay();
            switch (this.params.chartGranularity) {
                case WEEK: {
                    f *= 7.0f;
                    break;
                }
                case MONTH: {
                    f *= 30.4375f;
                    break;
                }
                case YEAR: {
                    f *= 365.25f;
                }
            }
        }
        this.paintGraphChart(nArray, f);
    }

    private void paintApmDevelopmentChart() {
        ChartSegmentStatistics[] chartSegmentStatisticsArray = this.params.segmentStats;
        int[] nArray = new int[chartSegmentStatisticsArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = chartSegmentStatisticsArray[n].totalTimeSecInGames == 0L ? -1 : chartSegmentStatisticsArray[n].getAvgApm();
            --n;
        }
        this.paintGraphChart(nArray, this.params.playerStatistics.getAvgApm());
    }

    private void paintDistributionChart() {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        int n3;
        int n4;
        int n5;
        Map<Enum, Color> map;
        Enum[] enumArray;
        int n6;
        int n7;
        switch (this.params.chartType) {
            case RACE_DISTRIBUTION: {
                n7 = 0;
                n6 = 3;
                enumArray = ReplayConsts.Race.values();
                map = RACE_COLOR_MAP;
                break;
            }
            case GAME_TYPE_DISTRIBUTION: {
                n7 = 1;
                n6 = 4;
                enumArray = ReplayConsts.GameType.values();
                map = GAME_TYPE_COLOR_MAP;
                break;
            }
            case FORMAT_DISTRIBUTION: {
                n7 = 2;
                n6 = 4;
                enumArray = ReplayConsts.Format.values();
                map = FORMAT_COLOR_MAP;
                break;
            }
            default: {
                throw new RuntimeException("Invalid type!");
            }
        }
        ChartSegmentStatistics[] chartSegmentStatisticsArray = this.params.segmentStats;
        if (this.params.chartWidth < 3 * chartSegmentStatisticsArray.length) {
            this.g2.setColor(Color.WHITE);
            Font font = this.g2.getFont();
            this.g2.setFont(font.deriveFont(1));
            String string = Language.getText("module.multiRepAnal.tab.player.tab.charts.notEnoughSpace");
            int n8 = this.params.chartX1 + (this.params.chartDX - this.g2.getFontMetrics().stringWidth(string)) / 2;
            if (n8 < 33) {
                n8 = 33;
            }
            this.g2.drawString(string, n8, this.params.chartY1 + this.params.chartDY / 2);
            this.g2.setFont(font);
            return;
        }
        int n9 = this.g2.getFontMetrics().getAscent();
        this.g2.setStroke(STROKE_DASHED);
        int n10 = n6 - 1;
        while (n10 >= 0) {
            n5 = this.params.chartY1 + n10 * this.params.chartDY / n6;
            this.g2.setColor(COLOR_ASSIST_LINES);
            this.g2.drawLine(this.params.chartX1 - 5, n5, this.params.chartX2, n5);
            this.g2.setColor(COLOR_AXIS_LABELS);
            n4 = (n6 - n10) * 100 / n6;
            this.g2.drawString(Integer.toString(n4), 0, n5 + (n9 >> 1) - 1);
            --n10;
        }
        this.g2.setStroke(STROKE_DEFAULT);
        IntHolder[] intHolderArray = new IntHolder[enumArray.length];
        n5 = (this.params.chartWidth - chartSegmentStatisticsArray.length - 3) / chartSegmentStatisticsArray.length;
        n4 = chartSegmentStatisticsArray.length - 1;
        while (n4 >= 0) {
            Map<Enum, IntHolder> map2;
            switch (n7) {
                case 0: {
                    map2 = chartSegmentStatisticsArray[n4].raceDistributionMap;
                    break;
                }
                case 1: {
                    map2 = chartSegmentStatisticsArray[n4].gameTypeDistributionMap;
                    break;
                }
                case 2: {
                    map2 = chartSegmentStatisticsArray[n4].formatDistributionMap;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type!");
                }
            }
            n3 = enumArray.length - 1;
            while (n3 >= 0) {
                intHolderArray[n3] = map2.get(enumArray[n3]);
                --n3;
            }
            n3 = 0;
            object3 = intHolderArray;
            n2 = intHolderArray.length;
            n = 0;
            while (n < n2) {
                object2 = object3[n];
                if (object2 != null) {
                    n3 += ((IntHolder)object2).value;
                }
                ++n;
            }
            if (n3 != 0) {
                int n11 = 2 + this.params.chartX1 + n4 * this.params.chartDX / chartSegmentStatisticsArray.length;
                n = 0;
                n2 = this.params.chartY1;
                int n12 = intHolderArray.length - 1;
                while (n12 >= 0) {
                    object3 = intHolderArray[n12];
                    if (object3 != null) {
                        object = map.get(enumArray[n12]);
                        this.g2.setColor((Color)(object == null ? MISSING_COLOR : object));
                        int n13 = this.params.chartY1 + (n += object3.value) * this.params.chartHeight / n3;
                        this.g2.fillRect(n11, n2, n5, n13 - n2);
                        n2 = n13;
                    }
                    --n12;
                }
            }
            --n4;
        }
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        int n14 = this.yAxisLabelEndPos + 15;
        n3 = 11;
        object3 = enumArray;
        n2 = enumArray.length;
        n = 0;
        while (n < n2) {
            object2 = object3[n];
            Color color = map.get(object2);
            if (color != null) {
                this.g2.setColor(color);
                this.g2.fillRoundRect(n14, 1, 11, 11, 5, 5);
                this.g2.setColor(COLOR_AXIS);
                object = ((Enum)object2).toString();
                this.g2.drawString((String)object, (n14 += 13) + 1, this.g2.getFontMetrics().getAscent() - 2);
                n14 += this.g2.getFontMetrics().stringWidth((String)object) + 15;
            }
            ++n;
        }
        this.g2.setFont(font);
    }

    private void paintWinRatioDevelopmentChart() {
        ChartSegmentStatistics[] chartSegmentStatisticsArray = this.params.segmentStats;
        int[] nArray = new int[chartSegmentStatisticsArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            Integer n2 = (Integer)chartSegmentStatisticsArray[n].record.getWinRatio().value;
            nArray[n] = n2 == null ? -1 : n2;
            --n;
        }
        Integer n3 = (Integer)this.params.playerStatistics.record.getWinRatio().value;
        this.paintGraphChart(nArray, n3 == null ? 0 : n3);
    }

    private void paintGraphChart(int[] nArray, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = GeneralUtils.maxValue(nArray);
        int n6 = n5 == 0 ? 1 : n5;
        int n7 = 0;
        while (n7 < nArray.length) {
            nArray[n7] = nArray[n7] < 0 ? -1 : this.params.chartY2 - this.params.chartHeight * nArray[n7] / n6;
            n4 = nArray[n7];
            if (n4 > 0) {
                n3 = n7 - 1;
                while (n3 >= 0 && nArray[n3] < 0) {
                    --n3;
                }
                if (n7 > n3 + 1) {
                    if (n3 < 0) {
                        Arrays.fill(nArray, n3 + 1, n7, -n4);
                    } else {
                        n2 = nArray[n3];
                        n = n3 + 1;
                        while (n < n7) {
                            nArray[n] = -(n2 + (n4 - n2) * (n - n3) / (n7 - n3));
                            ++n;
                        }
                    }
                }
            }
            ++n7;
        }
        if (nArray[nArray.length - 1] < 0) {
            n7 = nArray.length - 2;
            while (n7 >= 0 && nArray[n7] < 0) {
                --n7;
            }
            if (n7 < 0) {
                Arrays.fill(nArray, -this.params.chartY2);
            } else {
                Arrays.fill(nArray, n7 + 1, nArray.length, -nArray[n7]);
            }
        }
        n7 = this.g2.getFontMetrics().getAscent();
        n4 = this.params.chartHeight < 20 ? 1 : this.params.chartHeight / 20;
        this.g2.setStroke(STROKE_DASHED);
        n3 = n4 - 1;
        while (n3 >= 0) {
            n2 = this.params.chartY1 + n3 * this.params.chartDY / n4;
            this.g2.setColor(COLOR_ASSIST_LINES);
            this.g2.drawLine(this.params.chartX1 + 1, n2, this.params.chartX2, n2);
            this.g2.setColor(COLOR_AXIS_LABELS);
            n = (n4 - n3) * n6 / n4;
            this.g2.drawString(Integer.toString(n), 0, n2 + (n7 >> 1) - 1);
            --n3;
        }
        this.g2.setStroke(STROKE_DEFAULT);
        this.g2.setColor(COLOR_AVERAGE_MARKER);
        n3 = this.params.chartY2 - (int)((float)this.params.chartDY * f / (float)n6);
        this.g2.drawLine(this.params.chartX1 + 1, n3, this.params.chartX2, n3);
        this.g2.setColor(COLOR_GENERAL_CHART);
        this.g2.setStroke(this.params.graphApproximation == ChartUtils.GraphApproximation.LINEAR ? STROKE_DOUBLE_WIDTH_ROUNDED : STROKE_DOUBLE_WIDTH);
        n2 = nArray.length - 1;
        switch (this.params.graphApproximation) {
            case LINEAR: {
                n = this.params.chartX2;
                int n8 = n2 - 1;
                while (n8 >= 0) {
                    int n9 = n;
                    n = this.params.chartX1 + n8 * this.params.chartDX / n2;
                    if (nArray[n8] < 0 || nArray[n8 + 1] < 0) {
                        this.g2.setStroke(STROKE_DASHED_DOUBLE);
                        this.g2.drawLine(n, Math.abs(nArray[n8]), n9, Math.abs(nArray[n8 + 1]));
                        this.g2.setStroke(STROKE_DOUBLE_WIDTH_ROUNDED);
                    } else {
                        this.g2.drawLine(n, nArray[n8], n9, nArray[n8 + 1]);
                    }
                    --n8;
                }
                break;
            }
            case CUBIC: {
                Rectangle rectangle = this.g2.getClipBounds();
                if (rectangle == null) {
                    this.g2.setClip(this.params.chartX1, this.params.chartY1, this.params.chartWidth, this.params.chartHeight);
                } else {
                    this.g2.setClip(rectangle.intersection(new Rectangle(this.params.chartX1, this.params.chartY1, this.params.chartWidth, this.params.chartHeight)));
                }
                int[] nArray2 = new int[nArray.length];
                int n10 = n2;
                while (n10 >= 0) {
                    nArray2[n10] = this.params.chartX1 + n10 * this.params.chartDX / n2;
                    --n10;
                }
                this.drawCubicCurve2D(nArray2, nArray, 0, n2);
                this.g2.setClip(rectangle);
            }
        }
        this.g2.setStroke(STROKE_DEFAULT);
        this.g2.setColor(COLOR_AVERAGE_MARKER);
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        String string = Language.getText("module.multiRepAnal.tab.player.tab.charts.averageMarker", this.params.chartType == MultiRepAnalysis.ChartType.ACTIVITY ? String.format(Locale.US, "%.3f", Float.valueOf(f)) : Integer.valueOf((int)f));
        this.g2.drawString(string, this.params.chartX2 - this.g2.getFontMetrics().stringWidth(string) - 5, n3 == this.params.chartY1 ? n3 + n7 : n3 - 3);
        this.g2.setFont(font);
    }
}

