/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.language.Language;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public enum LadderSeason {
    UNKNOWN("1970-01-01"),
    BETA("2010-02-16"),
    SEASON1("2010-07-26"),
    SEASON2("2011-03-30"),
    SEASON3("2011-07-19"),
    SEASON4("2099-01-01");

    public final Date startDate;
    public final String stringValue;

    private LadderSeason(String string2) {
        try {
            this.startDate = new SimpleDateFormat("yyyy-MM-dd").parse(string2);
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Fix the ladder season dates!", parseException);
        }
        int n2 = this.ordinal();
        this.stringValue = n2 > 1 ? Language.getText("module.multiRepAnal.tab.player.tab.charts.granularity.ladderSeason.season", n2 - 1) : (n2 == 1 ? Language.getText("module.multiRepAnal.tab.player.tab.charts.granularity.ladderSeason.beta") : Language.getText("general.unknown"));
    }

    public static LadderSeason getByStartDate(Date date) {
        LadderSeason[] ladderSeasonArray = LadderSeason.values();
        int n = ladderSeasonArray.length;
        int n2 = 0;
        while (n2 < n) {
            LadderSeason ladderSeason = ladderSeasonArray[n2];
            if (Math.abs(ladderSeason.startDate.getTime() - date.getTime()) < 259200000L) {
                return ladderSeason;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static LadderSeason getByDate(Date date) {
        LadderSeason[] ladderSeasonArray = LadderSeason.values();
        int n = LadderSeason.values().length - 1;
        while (n >= 0) {
            if (!date.before(ladderSeasonArray[n].startDate)) {
                return ladderSeasonArray[n];
            }
            --n;
        }
        return UNKNOWN;
    }

    public static LadderSeason getNextSeason(LadderSeason ladderSeason) {
        LadderSeason[] ladderSeasonArray = LadderSeason.values();
        if (ladderSeason.ordinal() == ladderSeasonArray.length - 1) {
            return null;
        }
        return ladderSeasonArray[ladderSeason.ordinal() + 1];
    }

    public static LadderSeason getPreviousSeason(LadderSeason ladderSeason) {
        LadderSeason[] ladderSeasonArray = LadderSeason.values();
        if (ladderSeason.ordinal() == 0) {
            return null;
        }
        return ladderSeasonArray[ladderSeason.ordinal() - 1];
    }

    public String toString() {
        return this.stringValue;
    }
}

