/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.components.PlayerPopupMenu;
import hu.belicza.andras.sc2gears.ui.components.TableBox;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.BuildOrderStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartData;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.DateRangeStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MapStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerGameParticipationStats;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlaymateStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.Record;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.TrendPainter;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.TrendParams;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.WordStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.NullAwareComparable;
import hu.belicza.andras.sc2gears.util.ReplayCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MultiRepAnalysis
extends ModuleFrame {
    private static final String[] DAY_TEXT_KEYS;
    private static final String[] MONTH_TEXT_KEYS;
    private static final String[] PLAYERS_HEADER_KEYS;
    private static final String[] PLAYER_MAPS_HEADER_KEYS;
    private static final String[] BUILD_ORDERS_1V1_HEADER_KEYS;
    private static final String[] CHAT_WORDS_HEADER_KEYS;
    private static final String[] PLAYMATES_HEADER_KEYS;
    private static final Vector<String> PLAYERS_HEADER_NAME_VECTOR;
    private static final Vector<String> MAPS_HEADER_NAME_VECTOR;
    private static final Vector<String> BUILD_ORDERS_1V1_HEADER_NAME_VECTOR;
    private static final Vector<String> BUILD_ORDERS_NON_1V1_HEADER_NAME_VECTOR;
    private static final Vector<String> CHAT_WORDS_HEADER_NAME_VECTOR;
    private static final Vector<String> TYPE_RECORDS_HEADER_NAME_VECTOR;
    private static final Vector<String> FORMAT_RECORDS_HEADER_NAME_VECTOR;
    private static final Vector<String> MATCHUP_RECORDS_HEADER_NAME_VECTOR;
    private static final Vector<String> PLAYER_MAPS_HEADER_NAME_VECTOR;
    private static final Vector<String> PLAYMATES_HEADER_NAME_VECTOR;
    private static final AtomicInteger counter;
    private final File[] files;
    private final JCheckBox autoOpenFirstPlayerCheckBox = GuiUtils.createCheckBox("module.multiRepAnal.autoOpenFirstPlayer", "module.multiRepAnal.autoOpenFirstPlayer");
    private final JCheckBox stretchToWindowCheckBox = GuiUtils.createCheckBox("module.multiRepAnal.stretchToWindow", "module.multiRepAnal.stretchToWindow");
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int replaysIncludedInAnalysis;
    private final Map<String, PlayerStatistics> playerStatisticsMap = new HashMap<String, PlayerStatistics>();
    private final Map<String, MapStatistics> mapStatisticsMap = new HashMap<String, MapStatistics>();
    private final Map<ReplayConsts.Format, Map<String, BuildOrderStatistics>> formatBuildOrderStatisticsMap = new EnumMap<ReplayConsts.Format, Map<String, BuildOrderStatistics>>(ReplayConsts.Format.class);
    private final Map<String, WordStatistics> chatWordsStatisticsMap = new HashMap<String, WordStatistics>();
    private String firstPlayerName;
    private final MouseListener playersTableMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            if (mouseEvent.getButton() == 1) {
                if (jTable.getSelectedRow() >= 0 && mouseEvent.getClickCount() == 2) {
                    String string = (String)jTable.getValueAt(jTable.rowAtPoint(mouseEvent.getPoint()), jTable.convertColumnIndexToView(0));
                    MultiRepAnalysis.this.openPlayer(string);
                }
            } else if (mouseEvent.getButton() == 3) {
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                jTable.getSelectionModel().setSelectionInterval(n, n);
                final String string = (String)jTable.getValueAt(n, jTable.convertColumnIndexToView(0));
                PlayerStatistics playerStatistics = (PlayerStatistics)MultiRepAnalysis.this.playerStatisticsMap.get(string);
                if (playerStatistics != null) {
                    PlayerPopupMenu playerPopupMenu = new PlayerPopupMenu(playerStatistics.playerId, playerStatistics.playerType);
                    playerPopupMenu.addSeparator();
                    JMenuItem jMenuItem = new JMenuItem(Language.getText("module.multiRepAnal.playerMenu.openPlayer"), Icons.CHART_UP);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MultiRepAnalysis.this.openPlayer(string);
                        }
                    });
                    playerPopupMenu.add(jMenuItem);
                    playerPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    };

    static {
        Vector vector;
        Vector vector2;
        DAY_TEXT_KEYS = new String[]{"general.day.sunday", "general.day.monday", "general.day.tuesday", "general.day.wednesday", "general.day.thursday", "general.day.friday", "general.day.saturday"};
        MONTH_TEXT_KEYS = new String[]{"general.month.january", "general.month.february", "general.month.march", "general.month.april", "general.month.may", "general.month.june", "general.month.july", "general.month.august", "general.month.september", "general.month.october", "general.month.november", "general.month.december"};
        PLAYERS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.players.header.playerName", "module.multiRepAnal.tab.players.header.replays", "module.multiRepAnal.tab.players.header.avgApm", "module.multiRepAnal.tab.players.header.record", "module.multiRepAnal.tab.players.header.winRatio", "module.multiRepAnal.tab.players.header.raceDistribution", "module.multiRepAnal.tab.players.header.totalTimeInGames", "module.multiRepAnal.tab.players.header.avgGameLength", "module.multiRepAnal.tab.players.header.presence", "module.multiRepAnal.tab.players.header.avgGamesPerDay", "module.multiRepAnal.tab.players.header.firstGame", "module.multiRepAnal.tab.players.header.lastGame"};
        PLAYER_MAPS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.maps.header.mapName", "module.multiRepAnal.tab.maps.header.replays", "module.multiRepAnal.tab.maps.header.replaysRatio", "module.multiRepAnal.tab.maps.header.record", "module.multiRepAnal.tab.maps.header.winRatio", "module.multiRepAnal.tab.maps.header.1v1PWinRatio", "module.multiRepAnal.tab.maps.header.1v1TWinRatio", "module.multiRepAnal.tab.maps.header.1v1ZWinRatio", "module.multiRepAnal.tab.maps.header.avgGameLength", "module.multiRepAnal.tab.maps.header.firstPlayed", "module.multiRepAnal.tab.maps.header.lastPlayed"};
        BUILD_ORDERS_1V1_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.1v1BuildOrders.header.race", "module.multiRepAnal.tab.1v1BuildOrders.header.buildOrder", "module.multiRepAnal.tab.1v1BuildOrders.header.occurrences", "module.multiRepAnal.tab.1v1BuildOrders.header.record", "module.multiRepAnal.tab.1v1BuildOrders.header.winRatio", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsP", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsT", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsZ", "module.multiRepAnal.tab.1v1BuildOrders.header.firstUsed", "module.multiRepAnal.tab.1v1BuildOrders.header.lastUsed"};
        CHAT_WORDS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.chatWords.header.word", "module.multiRepAnal.tab.1v1BuildOrders.header.occurrences", "module.multiRepAnal.tab.maps.header.replays", "module.multiRepAnal.tab.maps.header.replaysRatio", "module.multiRepAnal.tab.1v1BuildOrders.header.firstUsed", "module.multiRepAnal.tab.1v1BuildOrders.header.lastUsed"};
        PLAYMATES_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.player.tab.playmates.header.playmate", "module.multiRepAnal.tab.player.tab.playmates.header.commonGames", "module.multiRepAnal.tab.player.tab.playmates.header.gamesAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.gamesAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.recordAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.winRatioAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.recordAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.winRatioAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.totalTimeTogether", "module.multiRepAnal.tab.player.tab.playmates.header.firstCommonGame", "module.multiRepAnal.tab.player.tab.playmates.header.lastCommonGame"};
        PLAYERS_HEADER_NAME_VECTOR = new Vector(PLAYERS_HEADER_KEYS.length);
        MAPS_HEADER_NAME_VECTOR = new Vector(PLAYER_MAPS_HEADER_KEYS.length - 2);
        BUILD_ORDERS_1V1_HEADER_NAME_VECTOR = new Vector(BUILD_ORDERS_1V1_HEADER_KEYS.length);
        BUILD_ORDERS_NON_1V1_HEADER_NAME_VECTOR = new Vector(BUILD_ORDERS_1V1_HEADER_KEYS.length - 3);
        CHAT_WORDS_HEADER_NAME_VECTOR = new Vector(CHAT_WORDS_HEADER_KEYS.length);
        PLAYER_MAPS_HEADER_NAME_VECTOR = new Vector(PLAYER_MAPS_HEADER_KEYS.length);
        PLAYMATES_HEADER_NAME_VECTOR = new Vector(PLAYMATES_HEADER_KEYS.length);
        int n = 0;
        while (n < PLAYERS_HEADER_KEYS.length) {
            PLAYERS_HEADER_NAME_VECTOR.addElement(Language.getText(PLAYERS_HEADER_KEYS[n]));
            ++n;
        }
        n = 0;
        while (n < BUILD_ORDERS_1V1_HEADER_KEYS.length) {
            BUILD_ORDERS_1V1_HEADER_NAME_VECTOR.addElement(Language.getText(BUILD_ORDERS_1V1_HEADER_KEYS[n]));
            ++n;
        }
        n = 0;
        while (n < BUILD_ORDERS_1V1_HEADER_NAME_VECTOR.size()) {
            if (!("module.multiRepAnal.tab.1v1BuildOrders.header.recordVsP".equals(BUILD_ORDERS_1V1_HEADER_KEYS[n]) || "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsT".equals(BUILD_ORDERS_1V1_HEADER_KEYS[n]) || "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsZ".equals(BUILD_ORDERS_1V1_HEADER_KEYS[n]))) {
                BUILD_ORDERS_NON_1V1_HEADER_NAME_VECTOR.addElement(BUILD_ORDERS_1V1_HEADER_NAME_VECTOR.get(n));
            }
            ++n;
        }
        n = 0;
        while (n < CHAT_WORDS_HEADER_KEYS.length) {
            CHAT_WORDS_HEADER_NAME_VECTOR.addElement(Language.getText(CHAT_WORDS_HEADER_KEYS[n]));
            ++n;
        }
        TYPE_RECORDS_HEADER_NAME_VECTOR = vector2 = (Vector)PLAYERS_HEADER_NAME_VECTOR.clone();
        TYPE_RECORDS_HEADER_NAME_VECTOR.set(0, Language.getText("module.multiRepAnal.tab.player.tab.typeRecords.header.type"));
        FORMAT_RECORDS_HEADER_NAME_VECTOR = vector = (Vector)PLAYERS_HEADER_NAME_VECTOR.clone();
        FORMAT_RECORDS_HEADER_NAME_VECTOR.set(0, Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.header.format"));
        MATCHUP_RECORDS_HEADER_NAME_VECTOR = new Vector(PLAYERS_HEADER_KEYS.length - 1);
        MATCHUP_RECORDS_HEADER_NAME_VECTOR.addElement(Language.getText("module.multiRepAnal.tab.player.tab.matchupRecords.header.matchup"));
        int n2 = 1;
        while (n2 < PLAYERS_HEADER_NAME_VECTOR.size()) {
            if (!"module.multiRepAnal.tab.players.header.raceDistribution".equals(PLAYERS_HEADER_KEYS[n2])) {
                MATCHUP_RECORDS_HEADER_NAME_VECTOR.addElement(Language.getText(PLAYERS_HEADER_KEYS[n2]));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < PLAYER_MAPS_HEADER_KEYS.length) {
            PLAYER_MAPS_HEADER_NAME_VECTOR.addElement(Language.getText(PLAYER_MAPS_HEADER_KEYS[n2]));
            ++n2;
        }
        n2 = 0;
        while (n2 < PLAYER_MAPS_HEADER_NAME_VECTOR.size()) {
            if (!"module.multiRepAnal.tab.maps.header.record".equals(PLAYER_MAPS_HEADER_KEYS[n2]) && !"module.multiRepAnal.tab.maps.header.winRatio".equals(PLAYER_MAPS_HEADER_KEYS[n2])) {
                MAPS_HEADER_NAME_VECTOR.addElement(PLAYER_MAPS_HEADER_NAME_VECTOR.get(n2));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < PLAYMATES_HEADER_KEYS.length) {
            PLAYMATES_HEADER_NAME_VECTOR.addElement(Language.getText(PLAYMATES_HEADER_KEYS[n2]));
            ++n2;
        }
        counter = new AtomicInteger();
    }

    /*
     * Unable to fully structure code
     */
    public MultiRepAnalysis(Object ... var1_1) {
        super(var1_1.length == 0 ? Language.getText("module.multiRepAnal.opening") : null);
        this.setFrameIcon(Icons.CHART_UP_COLOR);
        if (var1_1.length != 0) ** GOTO lbl25
        var2_2 = new JFileChooser(GeneralUtils.getDefaultReplayFolder());
        var2_2.setDialogTitle(Language.getText("module.multiRepAnal.openTitle"));
        var2_2.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
        var2_2.setAccessory(GuiUtils.createReplayFilePreviewAccessory(var2_2));
        var2_2.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
        var2_2.setFileSelectionMode(2);
        var2_2.setMultiSelectionEnabled(true);
        if (var2_2.showOpenDialog(MainFrame.INSTANCE) == 0) {
            this.files = var2_2.getSelectedFiles();
        } else {
            this.dispose();
            this.files = null;
            return;
lbl25:
            // 1 sources

            if (var1_1.length > 0 && var1_1[0] != null) {
                this.files = MultiRepAnalysis.loadReplaySourceFile((File)var1_1[0]);
            } else if (var1_1.length > 1 && var1_1[1] != null) {
                var2_3 = ReplaySearch.loadReplayListFile((File)var1_1[1]);
                this.files = new File[var2_3.size()];
                var3_4 = var2_3.size() - 1;
                while (var3_4 >= 0) {
                    this.files[var3_4] = new File((String)var2_3.get(var3_4)[ReplaySearch.COLUMN_FILE_NAME]);
                    --var3_4;
                }
            } else if (var1_1.length > 2 && var1_1[2] != null) {
                this.files = (File[])var1_1[2];
            } else {
                throw new RuntimeException("The source for Multi-rep analysis is incorrectly specified!");
            }
        }
        this.setTitle(Language.getText("module.multiRepAnal.title", new Object[]{MultiRepAnalysis.counter.incrementAndGet()}));
        this.buildGUI();
    }

    private static File[] loadReplaySourceFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            ArrayList<File> arrayList = new ArrayList<File>();
            while (bufferedReader.ready()) {
                arrayList.add(new File(bufferedReader.readLine()));
            }
            File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
            return fileArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToLoadRepSource"), new Frame[0]);
            File[] fileArray = new File[]{};
            return fileArray;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void buildGUI() {
        Box box = Box.createVerticalBox();
        final Box box2 = Box.createHorizontalBox();
        final JButton jButton = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText(jButton, "module.multiRepAnal.abortAnalysisButton", new Object[0]);
        box2.add(jButton);
        this.autoOpenFirstPlayerCheckBox.setToolTipText(Language.getText("module.multiRepAnal.autoOpenFirstPlayerToolTip"));
        box2.add(this.autoOpenFirstPlayerCheckBox);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.stretchToWindowCheckBox);
        box2.add(Box.createHorizontalStrut(15));
        box2.add(MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.ANALYZER));
        box2.add(Box.createHorizontalStrut(15));
        box2.add(MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.ALIASES));
        box.add(GuiUtils.wrapInPanel(box2));
        final JProgressBar jProgressBar = new JProgressBar();
        box.add(jProgressBar);
        this.getContentPane().add((Component)box, "North");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        final NormalThread normalThread = new NormalThread("Multi-replay analysis"){
            private volatile boolean aborted;
            private int replaysCount;
            private int analyzedCount;
            private int skippedCount;
            private final boolean useRealTime;
            private final int timeLimitToBeIncluded;
            private final int buildOrderLength;
            private final int timeExclusionForApm;
            private final boolean cacheEnabled;
            private final Map<String, Object> playerNameClonesMap;
            final List<String> helperPlayerList;
            final List<Character> raceLetterList;
            final StringBuilder teamCompositionBuilder;
            {
                super(string);
                this.useRealTime = Settings.getBoolean("settings.misc.useRealTimeMeasurement");
                this.timeLimitToBeIncluded = Settings.getInt("settings.misc.timeLimitForMultiRepAnalysis");
                this.buildOrderLength = Settings.getInt("settings.misc.buildOrderLength");
                this.timeExclusionForApm = Settings.getInt("settings.misc.initialTimeToExcludeFromApm") << 6;
                this.cacheEnabled = Settings.getBoolean("settings.misc.cachePreprocessedReplays");
                this.playerNameClonesMap = new HashMap<String, Object>();
                this.helperPlayerList = Arrays.asList("");
                this.raceLetterList = new ArrayList<Character>(4);
                this.teamCompositionBuilder = new StringBuilder(5);
            }

            @Override
            public void run() {
                File file;
                InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        jButton.doClick();
                    }
                };
                MultiRepAnalysis.this.addInternalFrameListener(internalFrameAdapter);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                        aborted = true;
                    }
                });
                jProgressBar.setStringPainted(true);
                jProgressBar.setString(Language.getText("module.multiRepAnal.countingReplays"));
                File[] fileArray = MultiRepAnalysis.this.files;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    file = fileArray[n2];
                    if (this.aborted) break;
                    this.replaysCount += this.countReplays(file);
                    ++n2;
                }
                if (this.aborted) {
                    jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                } else {
                    jProgressBar.setMaximum(this.replaysCount);
                    this.updateProgressBar();
                    fileArray = MultiRepAnalysis.this.files;
                    n = fileArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        file = fileArray[n2];
                        if (this.aborted) break;
                        this.analyzeReplays(file);
                        ++n2;
                    }
                    if (this.aborted) {
                        jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                    } else {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                    }
                    MultiRepAnalysis.this.replaysIncludedInAnalysis = this.analyzedCount - this.skippedCount;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.players.title"), Icons.USERS, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createPlayersTab(), false, null);
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createMapsTab(), false, null);
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.buildOrders.title"), Icons.BLOCK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createBuildOrdersTab(), false, null);
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.chatWords.title"), Icons.BALLOONS, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createChatWordsTab(), false, null);
                                if (MultiRepAnalysis.this.autoOpenFirstPlayerCheckBox.isSelected() && MultiRepAnalysis.this.firstPlayerName != null) {
                                    MultiRepAnalysis.this.openPlayer(MultiRepAnalysis.this.firstPlayerName);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                MultiRepAnalysis.this.removeInternalFrameListener(internalFrameAdapter);
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] fileArray = file.listFiles();
                int n = 0;
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        if (this.aborted) {
                            return 0;
                        }
                        n += this.countReplays(file2);
                        ++n3;
                    }
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            private void analyzeReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.analyzedCount;
                        Replay replay = ReplayCache.getReplay(file, this.buildOrderLength, this.timeExclusionForApm, this.cacheEnabled, this.cacheEnabled, null);
                        if (replay != null && replay.gameLength >= this.timeLimitToBeIncluded << 1) {
                            Object object;
                            Object object2;
                            int n;
                            GameEvents.Action[] actionArray;
                            int n2;
                            int n3;
                            HashSet<Object> hashSet;
                            Object object3;
                            Object object4;
                            Date date = new Date(replay.details.saveTime);
                            Details.Player[] playerArray = replay.details.players;
                            ReplayConsts.Format format = replay.initData.format;
                            String[] stringArray = new String[playerArray.length];
                            int n4 = 0;
                            while (n4 < playerArray.length) {
                                ArrayList<Details.PlayerId> arrayList;
                                object4 = playerArray[n4];
                                object3 = object4.playerId = Settings.getAliasGroupPlayerId(object4.playerId);
                                int n5 = -1;
                                hashSet = this.playerNameClonesMap.get(object3.name);
                                if (hashSet == null) {
                                    this.playerNameClonesMap.put(object4.playerId.name, object3);
                                    n5 = 0;
                                } else if (hashSet instanceof List) {
                                    arrayList = (ArrayList<Details.PlayerId>)((Object)hashSet);
                                    int n6 = 0;
                                    while (n6 < arrayList.size()) {
                                        if (object3.equals(arrayList.get(n6))) {
                                            n5 = n6;
                                            break;
                                        }
                                        ++n6;
                                    }
                                    if (n5 < 0) {
                                        n5 = arrayList.size();
                                        arrayList.add((Details.PlayerId)object3);
                                    }
                                } else if (object3.equals((Details.PlayerId)((Object)hashSet))) {
                                    n5 = 0;
                                } else {
                                    arrayList = new ArrayList<Details.PlayerId>(2);
                                    arrayList.add((Details.PlayerId)((Object)hashSet));
                                    arrayList.add((Details.PlayerId)object3);
                                    n5 = 1;
                                    this.playerNameClonesMap.put(object3.name, arrayList);
                                }
                                stringArray[n4] = n5 == 0 ? object3.name : String.valueOf(object3.name) + " (#" + (n5 + 1) + ")";
                                ++n4;
                            }
                            Map<String, IntHolder>[] mapArray = replay.messageEvents.getWordCountMaps(replay.initData.clientNames == null ? playerArray.length : replay.initData.clientNames.length);
                            object4 = null;
                            object3 = null;
                            PlayerGameParticipationStats[] playerGameParticipationStatsArray = new PlayerGameParticipationStats[playerArray.length];
                            hashSet = new HashSet<Object>();
                            int n7 = 0;
                            while (n7 < playerArray.length) {
                                Details.Player player = playerArray[n7];
                                n3 = player.lastActionFrame >> 6;
                                if (this.useRealTime) {
                                    n3 = replay.initData.gameSpeed.convertToRealTime(n3);
                                }
                                if (n3 >= this.timeLimitToBeIncluded) {
                                    n2 = Math.max(0, player.lastActionFrame - replay.excludedInitialFrames) >> 6;
                                    if (this.useRealTime) {
                                        n2 = replay.initData.gameSpeed.convertToRealTime(n2);
                                    }
                                    if ((actionArray = (GameEvents.Action[])MultiRepAnalysis.this.playerStatisticsMap.get(stringArray[n7])) == null) {
                                        actionArray = new PlayerStatistics(stringArray[n7], player);
                                        MultiRepAnalysis.this.playerStatisticsMap.put(stringArray[n7], actionArray);
                                    }
                                    String[] stringArray2 = this.getTeamCompositions(replay.details, player, format);
                                    playerGameParticipationStatsArray[n7] = new PlayerGameParticipationStats(date, format, n3, n2, player, playerArray.length > 1 ? playerArray[playerArray[0] == player ? 1 : 0].finalRace : ReplayConsts.Race.UNKNOWN, replay.details.mapName, stringArray2, replay.initData.gameType, mapArray[n7]);
                                    actionArray.buildInPlayerGameParticipation(playerGameParticipationStatsArray[n7]);
                                    if (format == ReplayConsts.Format.ONE_VS_ONE && player.isWinner != null) {
                                        if (player.isWinner.booleanValue()) {
                                            object4 = player.finalRace;
                                        } else {
                                            object3 = player.finalRace;
                                        }
                                    }
                                    int n8 = 0;
                                    while (n8 < playerArray.length) {
                                        if (n8 != n7) {
                                            (player.team != Integer.MAX_VALUE && player.team == playerArray[n8].team ? playerGameParticipationStatsArray[n7].allyList : playerGameParticipationStatsArray[n7].opponentList).add(stringArray[n8]);
                                        }
                                        ++n8;
                                    }
                                    actionArray.playerGameParticipationStatsList.add(playerGameParticipationStatsArray[n7]);
                                }
                                ++n7;
                            }
                            MapStatistics mapStatistics = (MapStatistics)MultiRepAnalysis.this.mapStatisticsMap.get(replay.details.mapName);
                            if (mapStatistics == null) {
                                mapStatistics = new MapStatistics(replay.details.mapName);
                                MultiRepAnalysis.this.mapStatisticsMap.put(replay.details.mapName, mapStatistics);
                            }
                            ++mapStatistics.record.totalGames;
                            mapStatistics.totalTimeSecInGames = mapStatistics.totalTimeSecInGames + (long)(this.useRealTime ? replay.initData.gameSpeed.convertToRealTime(replay.gameLengthSec) : replay.gameLengthSec);
                            mapStatistics.registerDate(date);
                            if (object4 != null) {
                                Record record = mapStatistics.getRaceRecord((ReplayConsts.Race)((Object)object4));
                                ++record.totalGames;
                                ++record.wins;
                            }
                            if (object3 != null) {
                                Record record = mapStatistics.getRaceRecord((ReplayConsts.Race)((Object)object3));
                                ++record.totalGames;
                                ++record.losses;
                            }
                            int[] nArray = new int[playerArray.length];
                            n3 = 0;
                            n2 = 0;
                            while (n2 < playerGameParticipationStatsArray.length) {
                                if (playerGameParticipationStatsArray[n2] == null) {
                                    nArray[n2] = this.buildOrderLength;
                                    ++n3;
                                }
                                ++n2;
                            }
                            ReplayConsts.Building[][] buildingArray = new ReplayConsts.Building[playerArray.length][this.buildOrderLength];
                            actionArray = replay.gameEvents.actions;
                            int n9 = actionArray.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                GameEvents.Action action = actionArray[n10];
                                if (action instanceof GameEvents.BuildAction && nArray[action.player] < this.buildOrderLength) {
                                    buildingArray[action.player][nArray[action.player]] = ((GameEvents.BuildAction)action).building;
                                    byte by = action.player;
                                    nArray[by] = nArray[by] + 1;
                                    if (nArray[by] == this.buildOrderLength && ++n3 == nArray.length) break;
                                }
                                ++n10;
                            }
                            n10 = buildingArray.length - 1;
                            while (n10 >= 0) {
                                if (playerGameParticipationStatsArray[n10] != null) {
                                    ReplayConsts.Building[] buildingArray2 = buildingArray[n10];
                                    n = nArray[n10];
                                    if (n != 0) {
                                        String object5;
                                        void var23_45;
                                        object2 = new StringBuilder();
                                        boolean n11 = false;
                                        while (var23_45 < n) {
                                            if (((StringBuilder)object2).length() > 0) {
                                                ((StringBuilder)object2).append(", ");
                                            }
                                            ((StringBuilder)object2).append(buildingArray2[var23_45].stringValue);
                                            ++var23_45;
                                        }
                                        playerGameParticipationStatsArray[n10].buildOrder = object5 = ((StringBuilder)object2).toString();
                                        Map<String, BuildOrderStatistics> map = (Map)MultiRepAnalysis.this.formatBuildOrderStatisticsMap.get((Object)replay.initData.format);
                                        if (map == null) {
                                            map = new HashMap<String, BuildOrderStatistics>();
                                            MultiRepAnalysis.this.formatBuildOrderStatisticsMap.put(replay.initData.format, map);
                                        }
                                        if ((object = (BuildOrderStatistics)map.get(object5)) == null) {
                                            object = new BuildOrderStatistics(object5, playerGameParticipationStatsArray[n10].race, replay.initData.format);
                                            map.put(object5, (BuildOrderStatistics)object);
                                        }
                                        ((BuildOrderStatistics)object).buildInPlayerGameParticipation(playerGameParticipationStatsArray[n10]);
                                    }
                                }
                                --n10;
                            }
                            object2 = mapArray;
                            n = mapArray.length;
                            int n12 = 0;
                            while (n12 < n) {
                                Map<String, IntHolder> map = object2[n12];
                                if (map != null) {
                                    for (Map.Entry<String, IntHolder> entry : map.entrySet()) {
                                        object = entry.getKey();
                                        WordStatistics wordStatistics = (WordStatistics)MultiRepAnalysis.this.chatWordsStatisticsMap.get(object);
                                        if (wordStatistics == null) {
                                            wordStatistics = new WordStatistics(entry.getKey());
                                            MultiRepAnalysis.this.chatWordsStatisticsMap.put(object, wordStatistics);
                                        }
                                        wordStatistics.registerDate(date);
                                        wordStatistics.count += entry.getValue().value;
                                        if (!hashSet.add(object)) continue;
                                        ++wordStatistics.replays;
                                    }
                                }
                                ++n12;
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n13 = 0;
                        while (n13 < n) {
                            File file2 = fileArray2[n13];
                            if (this.aborted) {
                                return;
                            }
                            this.analyzeReplays(file2);
                            ++n13;
                        }
                    }
                }
            }

            private String[] getTeamCompositions(Details details, Details.Player player, ReplayConsts.Format format) {
                String[] stringArray;
                if (details.players.length == 0) {
                    return new String[0];
                }
                if (format == ReplayConsts.Format.ONE_VS_ONE) {
                    return new String[]{Character.toString(player.finalRace.letter), Character.toString((details.players.length > 1 ? details.players[details.players[0] == player ? 1 : 0].finalRace : ReplayConsts.Race.UNKNOWN).letter)};
                }
                this.helperPlayerList.set(0, player.playerId.name);
                details.rearrangePlayers(this.helperPlayerList);
                int[] nArray = details.getTeamOrderPlayerIndices();
                this.raceLetterList.clear();
                if (format == ReplayConsts.Format.FREE_FOR_ALL) {
                    stringArray = new String[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        this.raceLetterList.add(Character.valueOf(details.players[nArray[n]].raceLetter()));
                        ++n;
                    }
                    Collections.sort(this.raceLetterList);
                    n = nArray.length - 1;
                    while (n >= 0) {
                        stringArray[n] = Character.toString(this.raceLetterList.get(n).charValue());
                        --n;
                    }
                } else {
                    int n;
                    int n2 = 1;
                    int n3 = details.players[nArray[0]].team;
                    int n4 = 1;
                    while (n4 < nArray.length) {
                        n = details.players[nArray[n4]].team;
                        if (n != n3) {
                            n3 = n;
                            ++n2;
                        }
                        ++n4;
                    }
                    stringArray = new String[n2];
                    this.teamCompositionBuilder.setLength(0);
                    this.teamCompositionBuilder.append(details.players[nArray[0]].raceLetter());
                    this.teamCompositionBuilder.append('+');
                    n2 = 0;
                    n3 = details.players[nArray[0]].team;
                    n4 = 1;
                    while (n4 < nArray.length) {
                        n = details.players[nArray[n4]].team;
                        if (n != n3) {
                            Collections.sort(this.raceLetterList);
                            for (Character c : this.raceLetterList) {
                                this.teamCompositionBuilder.append(c);
                            }
                            stringArray[n2++] = this.teamCompositionBuilder.toString();
                            this.teamCompositionBuilder.setLength(0);
                            this.raceLetterList.clear();
                            n3 = n;
                        }
                        this.raceLetterList.add(Character.valueOf(details.players[nArray[n4]].raceLetter()));
                        ++n4;
                    }
                    Collections.sort(this.raceLetterList);
                    for (Character c : this.raceLetterList) {
                        this.teamCompositionBuilder.append(c);
                    }
                    stringArray[stringArray.length - 1] = this.teamCompositionBuilder.toString();
                }
                return stringArray;
            }

            private void updateProgressBar() {
                jProgressBar.setValue(this.analyzedCount);
                jProgressBar.setString(Language.getText("module.multiRepAnal.analysisStatus", this.analyzedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.analyzedCount / this.replaysCount));
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                normalThread.start();
            }
        });
    }

    private JComponent createPlayersTab() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(this.playerStatisticsMap.size());
        for (PlayerStatistics playerStatistics : this.playerStatisticsMap.values()) {
            Vector vector2 = new Vector(13);
            vector2.add(playerStatistics.playerDisplayName);
            vector2.add(playerStatistics.record.totalGames);
            vector2.add(playerStatistics.getAvgApm());
            vector2.add(playerStatistics.record);
            vector2.add(playerStatistics.record.getWinRatio());
            vector2.add(playerStatistics.getRaceDistributionString());
            vector2.add(playerStatistics.getFormattedTotalTimeInGames());
            vector2.add(ReplayUtils.formatMs(playerStatistics.getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
            vector2.add(playerStatistics.getPresence());
            vector2.add(Float.valueOf(playerStatistics.getAvgGamesPerDay()));
            vector2.add(Language.formatDate(playerStatistics.firstDate));
            vector2.add(Language.formatDate(playerStatistics.lastDate));
            vector2.add(vector.add(vector2));
        }
        if (this.autoOpenFirstPlayerCheckBox.isSelected()) {
            boolean bl = false;
            for (Vector vector3 : vector) {
                int n;
                if (n >= (Integer)vector3.get(1)) continue;
                this.firstPlayerName = (String)vector3.get(0);
                n = (Integer)vector3.get(1);
            }
        }
        Holder<JTable> holder = new Holder<JTable>();
        int[] nArray = new int[2];
        nArray[0] = 1;
        JComponent jComponent = this.createStatisticsTableTab("module.multiRepAnal.tab.players.info", new Object[]{this.playerStatisticsMap.size()}, 0, nArray, vector, PLAYERS_HEADER_NAME_VECTOR, holder, null);
        ((JTable)holder.value).addMouseListener(this.playersTableMouseListener);
        this.registerEnterToOpenPlayer((JTable)holder.value);
        return jComponent;
    }

    private void registerEnterToOpenPlayer(final JTable jTable) {
        Object object = new Object();
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), object);
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 64), object);
        jTable.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.getSelectedRow() >= 0) {
                    String string = (String)jTable.getValueAt(jTable.getSelectedRow(), jTable.convertColumnIndexToView(0));
                    MultiRepAnalysis.this.openPlayer(string);
                }
            }
        });
    }

    private void openPlayer(String string) {
        PlayerStatistics playerStatistics = this.playerStatisticsMap.get(string);
        if (playerStatistics == null) {
            return;
        }
        final Holder<JComponent> holder = new Holder<JComponent>();
        final ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
        GuiUtils.addNewTab(string, Icons.USER, true, this.tabbedPane, this.createPlayerTab(playerStatistics, holder, arrayList), false, new Runnable(){

            @Override
            public void run() {
                for (ActionListener actionListener : arrayList) {
                    MultiRepAnalysis.this.stretchToWindowCheckBox.removeActionListener(actionListener);
                }
                MultiRepAnalysis.this.tabbedPane.setSelectedIndex(0);
            }
        });
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JComponent)holder.value).requestFocusInWindow();
            }
        });
    }

    private JComponent createMapsTab() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(this.mapStatisticsMap.size());
        NullAwareComparable<Integer> nullAwareComparable = NullAwareComparable.getPercent(null);
        for (MapStatistics mapStatistics : this.mapStatisticsMap.values()) {
            Record record = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            Record record2 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            Record record3 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            Vector<Object> vector2 = new Vector<Object>(9);
            vector2.add(mapStatistics.name);
            vector2.add(mapStatistics.record.totalGames);
            vector2.add(NullAwareComparable.getPercent(mapStatistics.record.totalGames * 100 / this.replaysIncludedInAnalysis));
            vector2.add(record == null ? nullAwareComparable : record.getWinRatio());
            vector2.add(record2 == null ? nullAwareComparable : record2.getWinRatio());
            vector2.add(record3 == null ? nullAwareComparable : record3.getWinRatio());
            vector2.add(ReplayUtils.formatMs(mapStatistics.getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
            vector2.add(Language.formatDate(mapStatistics.firstDate));
            vector2.add(Language.formatDate(mapStatistics.lastDate));
            vector.add(vector2);
        }
        int[] nArray = new int[2];
        nArray[0] = 1;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.maps.info", new Object[]{this.mapStatisticsMap.size()}, 0, nArray, vector, MAPS_HEADER_NAME_VECTOR, null, null);
    }

    private JComponent createBuildOrdersTab() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        ReplayConsts.Format[] formatArray = ReplayConsts.Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReplayConsts.Format format = formatArray[n2];
            Map<String, BuildOrderStatistics> map = this.formatBuildOrderStatisticsMap.get((Object)format);
            if (map != null) {
                JPanel jPanel = new JPanel(new BorderLayout());
                Vector<Vector<Object>> vector = new Vector<Vector<Object>>(map.size());
                for (BuildOrderStatistics buildOrderStatistics : map.values()) {
                    Object object;
                    if (format == ReplayConsts.Format.ONE_VS_ONE) {
                        object = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.PROTOSS);
                        Record record = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.TERRAN);
                        Record record2 = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.ZERG);
                        Vector<Object> vector2 = new Vector<Object>(10);
                        vector2.add((Object)buildOrderStatistics.race);
                        vector2.add(buildOrderStatistics.buildOrder);
                        vector2.add(buildOrderStatistics.record.totalGames);
                        vector2.add(buildOrderStatistics.record);
                        vector2.add(buildOrderStatistics.record.getWinRatio());
                        vector2.add(object == null ? new Record() : object);
                        vector2.add(record == null ? new Record() : record);
                        vector2.add(record2 == null ? new Record() : record2);
                        vector2.add(Language.formatDate(buildOrderStatistics.firstDate));
                        vector2.add(Language.formatDate(buildOrderStatistics.lastDate));
                        vector.add(vector2);
                        continue;
                    }
                    object = new Vector(7);
                    ((Vector)object).add(buildOrderStatistics.race);
                    ((Vector)object).add(buildOrderStatistics.buildOrder);
                    ((Vector)object).add(buildOrderStatistics.record.totalGames);
                    ((Vector)object).add(buildOrderStatistics.record);
                    ((Vector)object).add(buildOrderStatistics.record.getWinRatio());
                    ((Vector)object).add(Language.formatDate(buildOrderStatistics.firstDate));
                    ((Vector)object).add(Language.formatDate(buildOrderStatistics.lastDate));
                    vector.add((Vector<Object>)object);
                }
                int[] nArray = new int[3];
                nArray[0] = 2;
                nArray[2] = 4;
                jPanel.add(this.createStatisticsTableTab("module.multiRepAnal.tab.buildOrders.info", new Object[]{map.size()}, 1, nArray, vector, format == ReplayConsts.Format.ONE_VS_ONE ? BUILD_ORDERS_1V1_HEADER_NAME_VECTOR : BUILD_ORDERS_NON_1V1_HEADER_NAME_VECTOR, null, null));
                GuiUtils.addNewTab(format.stringValue, null, false, jTabbedPane, jPanel, false, null);
            }
            ++n2;
        }
        return jTabbedPane;
    }

    private JComponent createChatWordsTab() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(this.chatWordsStatisticsMap.size());
        for (WordStatistics wordStatistics : this.chatWordsStatisticsMap.values()) {
            Vector<Object> vector2 = new Vector<Object>(6);
            vector2.add(wordStatistics.word);
            vector2.add(wordStatistics.count);
            vector2.add(wordStatistics.replays);
            vector2.add(NullAwareComparable.getPercent(wordStatistics.replays * 100 / this.replaysIncludedInAnalysis));
            vector2.add(Language.formatDate(wordStatistics.firstDate));
            vector2.add(Language.formatDate(wordStatistics.lastDate));
            vector.add(vector2);
        }
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.chatWords.info", new Object[]{this.chatWordsStatisticsMap.size()}, 0, nArray, vector, CHAT_WORDS_HEADER_NAME_VECTOR, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private JComponent createPlayerTab(PlayerStatistics playerStatistics, Holder<JComponent> holder, List<ActionListener> list) {
        Object object;
        Object object2;
        Object n;
        Object n6;
        Object object3;
        Map.Entry n112;
        Object object4;
        Object object5;
        JPanel jPanel = new JPanel(new BorderLayout());
        EnumMap<ReplayConsts.Format, PlayerStatistics> enumMap = new EnumMap<ReplayConsts.Format, PlayerStatistics>(ReplayConsts.Format.class);
        EnumMap<ReplayConsts.GameType, PlayerStatistics> enumMap2 = new EnumMap<ReplayConsts.GameType, PlayerStatistics>(ReplayConsts.GameType.class);
        EnumMap enumMap3 = new EnumMap(ReplayConsts.Format.class);
        HashMap<String, MapStatistics> hashMap = new HashMap<String, MapStatistics>();
        EnumMap enumMap4 = new EnumMap(ReplayConsts.Format.class);
        HashMap<String, PlaymateStatistics> hashMap2 = new HashMap<String, PlaymateStatistics>();
        HashMap<String, WordStatistics> hashMap3 = new HashMap<String, WordStatistics>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int[] nArray = new int[24];
        int[] nArray2 = new int[7];
        int[] nArray3 = new int[12];
        for (PlayerGameParticipationStats object82 : playerStatistics.playerGameParticipationStatsList) {
            block47: {
                int n2;
                block46: {
                    gregorianCalendar.setTime(object82.date);
                    int n3 = gregorianCalendar.get(11);
                    nArray[n3] = nArray[n3] + 1;
                    int n4 = gregorianCalendar.get(7) - 1;
                    nArray2[n4] = nArray2[n4] + 1;
                    int n5 = gregorianCalendar.get(2);
                    nArray3[n5] = nArray3[n5] + 1;
                    object5 = (PlayerStatistics)enumMap2.get((Object)object82.gameType);
                    if (object5 == null) {
                        object5 = new PlayerStatistics(null, null);
                        enumMap2.put(object82.gameType, (PlayerStatistics)object5);
                    }
                    ((PlayerStatistics)object5).buildInPlayerGameParticipation(object82);
                    object5 = (PlayerStatistics)enumMap.get((Object)object82.format);
                    if (object5 == null) {
                        object5 = new PlayerStatistics(null, null);
                        enumMap.put(object82.format, (PlayerStatistics)object5);
                    }
                    ((PlayerStatistics)object5).buildInPlayerGameParticipation(object82);
                    object4 = (Map)enumMap3.get((Object)object82.format);
                    if (object4 == null) {
                        object4 = new HashMap<Object, PlayerStatistics>();
                        enumMap3.put(object82.format, object4);
                    }
                    if (object82.format != ReplayConsts.Format.FREE_FOR_ALL && object82.format != ReplayConsts.Format.UNKNOWN) break block46;
                    n112 = new StringBuilder();
                    object3 = object82.teamCompositions;
                    int string = object82.teamCompositions.length;
                    n2 = 0;
                    while (n2 < string) {
                        n6 = object3[n2];
                        if (((StringBuilder)((Object)n112)).length() > 0) {
                            ((StringBuilder)((Object)n112)).append('v');
                        }
                        ((StringBuilder)((Object)n112)).append((String)n6);
                        ++n2;
                    }
                    n6 = ((StringBuilder)((Object)n112)).toString();
                    object5 = (PlayerStatistics)object4.get(n6);
                    if (object5 == null) {
                        object5 = new PlayerStatistics(null, null);
                        object4.put(n6, object5);
                    }
                    ((PlayerStatistics)object5).buildInPlayerGameParticipation(object82);
                    if (object82.format == ReplayConsts.Format.FREE_FOR_ALL) {
                        n6 = String.valueOf(object82.teamCompositions[0]) + "v" + ReplayConsts.Race.ANY.letter;
                        object5 = (PlayerStatistics)object4.get(n6);
                        if (object5 == null) {
                            object5 = new PlayerStatistics(null, null);
                            object4.put(n6, object5);
                        }
                        ((PlayerStatistics)object5).buildInPlayerGameParticipation(object82);
                    }
                    break block47;
                }
                n112 = object82.format == ReplayConsts.Format.ONE_VS_ONE ? "v" : " vs ";
                int n7 = object82.format == ReplayConsts.Format.ONE_VS_ONE ? 3 : 4;
                n2 = 0;
                while (n2 < n7) {
                    block50: {
                        void var23_43;
                        block49: {
                            block48: {
                                if (object82.teamCompositions.length <= 1) break block48;
                                switch (n2) {
                                    case 0: {
                                        String string = String.valueOf(object82.teamCompositions[0]) + (String)((Object)n112) + object82.teamCompositions[1];
                                        break block49;
                                    }
                                    case 1: {
                                        String string = String.valueOf(object82.teamCompositions[0]) + (String)((Object)n112) + ReplayConsts.Race.ANY.letter;
                                        break block49;
                                    }
                                    case 2: {
                                        String entry2 = String.valueOf(ReplayConsts.Race.ANY.letter) + (String)((Object)n112) + object82.teamCompositions[1];
                                        break block49;
                                    }
                                    case 3: {
                                        if (object82.teamCompositions[0].length() < 3 || object82.teamCompositions[0].charAt(1) != '+') break block50;
                                        String object9 = String.valueOf(object82.teamCompositions[0].charAt(0)) + "+" + ReplayConsts.Race.ANY.letter + (String)((Object)n112) + ReplayConsts.Race.ANY.letter;
                                        break block49;
                                    }
                                    default: {
                                        throw new RuntimeException("Fix the cycle!");
                                    }
                                }
                            }
                            if (n2 > 0) break;
                            String string = object82.teamCompositions.length == 1 ? object82.teamCompositions[0] : Language.getText("general.unknown");
                        }
                        object5 = (PlayerStatistics)object4.get(var23_43);
                        if (object5 == null) {
                            object5 = new PlayerStatistics(null, null);
                            object4.put(var23_43, object5);
                        }
                        ((PlayerStatistics)object5).buildInPlayerGameParticipation(object82);
                    }
                    ++n2;
                }
            }
            if ((n112 = (MapStatistics)hashMap.get(object82.mapName)) == null) {
                n112 = new MapStatistics(object82.mapName);
                hashMap.put(object82.mapName, (MapStatistics)((Object)n112));
            }
            ++((MapStatistics)((Object)n112)).record.totalGames;
            ((MapStatistics)((Object)n112)).totalTimeSecInGames += (long)object82.timeSecInGame;
            if (object82.isWinner != null) {
                if (object82.isWinner.booleanValue()) {
                    ++((MapStatistics)((Object)n112)).record.wins;
                } else {
                    ++((MapStatistics)((Object)n112)).record.losses;
                }
            }
            ((DateRangeStatistics)((Object)n112)).registerDate(object82.date);
            if (object82.format == ReplayConsts.Format.ONE_VS_ONE && object82.isWinner != null) {
                Record n10 = ((MapStatistics)((Object)n112)).getRaceRecord(object82.race);
                ++n10.totalGames;
                if (object82.isWinner.booleanValue()) {
                    ++n10.wins;
                } else {
                    ++n10.losses;
                }
            }
            if ((n6 = (Map)enumMap4.get((Object)object82.format)) == null) {
                n6 = new HashMap<String, BuildOrderStatistics>();
                enumMap4.put(object82.format, n6);
            }
            if ((n = (BuildOrderStatistics)n6.get(object82.buildOrder)) == null) {
                n = new BuildOrderStatistics(object82.buildOrder, object82.race, object82.format);
                n6.put(object82.buildOrder, n);
            }
            ((BuildOrderStatistics)n).buildInPlayerGameParticipation(object82);
            for (String string : object82.allyList) {
                object2 = (PlaymateStatistics)hashMap2.get(string);
                if (object2 == null) {
                    object2 = new PlaymateStatistics(string);
                    hashMap2.put(string, (PlaymateStatistics)object2);
                }
                ((PlaymateStatistics)object2).buildInPlayerGameParticipation(object82, true);
            }
            for (String string : object82.opponentList) {
                object2 = (PlaymateStatistics)hashMap2.get(string);
                if (object2 == null) {
                    object2 = new PlaymateStatistics(string);
                    hashMap2.put(string, (PlaymateStatistics)object2);
                }
                ((PlaymateStatistics)object2).buildInPlayerGameParticipation(object82, false);
            }
            if (object82.wordCountMap == null) continue;
            for (Map.Entry entry : object82.wordCountMap.entrySet()) {
                object2 = (WordStatistics)hashMap3.get(entry.getKey());
                if (object2 == null) {
                    object2 = new WordStatistics((String)entry.getKey());
                    hashMap3.put((String)entry.getKey(), (WordStatistics)object2);
                }
                ((WordStatistics)object2).buildInCount(((IntHolder)entry.getValue()).value, object82.date);
            }
        }
        JLabel jLabel = new JLabel(Language.getText("module.multiRepAnal.tab.player.info", playerStatistics.playerDisplayName, playerStatistics.record.totalGames));
        GuiUtils.changeFontToBold(jLabel);
        jPanel.add((Component)jLabel, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        object5 = new JPanel(new BorderLayout());
        holder.value = object5;
        Collections.sort(playerStatistics.playerGameParticipationStatsList);
        object4 = new Holder();
        n112 = new ActionListener((Holder)object4){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            {
                this.val$chartCanvasHolder = holder;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)this.val$chartCanvasHolder.value).repaint();
            }
        };
        n6 = Box.createHorizontalBox();
        ((Container)n6).add(new JPanel(new BorderLayout()));
        ((Container)n6).add(new JLabel(Language.getText("charts.chartType")));
        n = GuiUtils.createComboBox((Object[])ChartType.values(), "module.multiRepAnal.charts.chartType");
        ((JComponent)n).setToolTipText(Language.getText("charts.chartTypeToolTip"));
        ((JComboBox)n).addActionListener((ActionListener)((Object)n112));
        ((Container)n6).add((Component)n);
        ((Container)n6).add(Box.createHorizontalStrut(5));
        ((Container)n6).add(new JLabel(Language.getText("module.multiRepAnal.tab.player.tab.charts.granularity")));
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])ChartGranularity.values(), "module.multiRepAnal.charts.chartGranularity");
        object3 = new Holder();
        object2 = new ActionListener((Holder)object3, playerStatistics){
            private final /* synthetic */ Holder val$chartDataHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            {
                this.val$chartDataHolder = holder;
                this.val$ps = playerStatistics;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChartGranularity chartGranularity = (ChartGranularity)((Object)jComboBox.getSelectedItem());
                if (this.val$chartDataHolder.value == null || ((ChartData)this.val$chartDataHolder.value).chartGranularity != chartGranularity) {
                    this.val$chartDataHolder.value = new ChartData(this.val$ps, chartGranularity);
                }
            }
        };
        jComboBox.addActionListener((ActionListener)object2);
        jComboBox.addActionListener((ActionListener)((Object)n112));
        ((Container)n6).add(jComboBox);
        ((Container)n6).add(Box.createHorizontalStrut(5));
        ((Container)n6).add(new JLabel(Language.getText("charts.graphApproximation")));
        JComboBox jComboBox2 = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.multiRepAnal.charts.graphApproximation");
        jComboBox2.addActionListener((ActionListener)((Object)n112));
        ((Container)n6).add(jComboBox2);
        object2.actionPerformed(null);
        ((Container)n6).add(new JPanel(new BorderLayout()));
        ((Container)object5).add((Component)n6, "North");
        ((Holder)object4).value = new JComponent((Holder)object4, playerStatistics, (Holder)object3, (JComboBox)n, jComboBox, jComboBox2){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            private final /* synthetic */ Holder val$chartDataHolder;
            private final /* synthetic */ JComboBox val$chartTypeComboBox;
            private final /* synthetic */ JComboBox val$chartGranularityComboBox;
            private final /* synthetic */ JComboBox val$graphApproximationComboBox;
            {
                this.val$chartCanvasHolder = holder;
                this.val$ps = playerStatistics;
                this.val$chartDataHolder = holder2;
                this.val$chartTypeComboBox = jComboBox;
                this.val$chartGranularityComboBox = jComboBox2;
                this.val$graphApproximationComboBox = jComboBox3;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                ChartParams chartParams = new ChartParams();
                chartParams.chartCanvas = (JComponent)this.val$chartCanvasHolder.value;
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.playerStatistics = this.val$ps;
                chartParams.segmentStats = ((ChartData)this.val$chartDataHolder.value).segmentStats;
                chartParams.chartType = (ChartType)((Object)this.val$chartTypeComboBox.getSelectedItem());
                chartParams.chartGranularity = (ChartGranularity)((Object)this.val$chartGranularityComboBox.getSelectedItem());
                chartParams.graphApproximation = (ChartUtils.GraphApproximation)((Object)this.val$graphApproximationComboBox.getSelectedItem());
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                new ChartPainter(chartParams).paintChart();
            }
        };
        JComponent jComponent = ((Holder)object4).value;
        jComponent.setFocusable(true);
        ((Container)object5).add((Component)jComponent, "Center");
        Object object6 = new Object();
        ChartType[] chartTypeArray = ChartType.values();
        int n8 = chartTypeArray.length;
        int n9 = 0;
        while (n9 < n8) {
            object = chartTypeArray[n9];
            object6 = new Object();
            ((JComponent)object5).getInputMap(1).put(((ChartType)((Object)object)).keyStroke, object6);
            ((JComponent)object5).getActionMap().put(object6, new AbstractAction((JComboBox)n, (ChartType)((Object)object)){
                private final /* synthetic */ JComboBox val$chartTypeComboBox;
                private final /* synthetic */ ChartType val$chartType;
                {
                    this.val$chartTypeComboBox = jComboBox;
                    this.val$chartType = chartType;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$chartTypeComboBox.setSelectedItem((Object)this.val$chartType);
                }
            });
            ++n9;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.charts.title"), Icons.CHART_UP_COLOR, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Holder();
        n112 = new ActionListener((Holder)object4){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            {
                this.val$chartCanvasHolder = holder;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)this.val$chartCanvasHolder.value).repaint();
            }
        };
        n6 = Box.createHorizontalBox();
        ((Container)n6).add(new JPanel(new BorderLayout()));
        ((Container)n6).add(new JLabel(Language.getText("module.multiRepAnal.tab.player.tab.trends.type")));
        n = GuiUtils.createComboBox((Object[])TrendType.values(), "module.multiRepAnal.trends.trendType");
        ((JComponent)n).setToolTipText(Language.getText("charts.chartTypeToolTip"));
        ((JComboBox)n).addActionListener((ActionListener)((Object)n112));
        ((Container)n6).add((Component)n);
        ((Container)n6).add(new JPanel(new BorderLayout()));
        ((Container)object5).add((Component)n6, "North");
        ((Holder)object4).value = new JComponent((Holder)object4, (JComboBox)n, nArray, nArray2, nArray3){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            private final /* synthetic */ JComboBox val$trendTypeComboBox;
            private final /* synthetic */ int[] val$hourlyActivities;
            private final /* synthetic */ int[] val$dailyActivities;
            private final /* synthetic */ int[] val$monthlyActivities;
            {
                this.val$chartCanvasHolder = holder;
                this.val$trendTypeComboBox = jComboBox;
                this.val$hourlyActivities = nArray;
                this.val$dailyActivities = nArray2;
                this.val$monthlyActivities = nArray3;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                TrendParams trendParams = new TrendParams();
                trendParams.chartCanvas = (JComponent)this.val$chartCanvasHolder.value;
                trendParams.g2 = (Graphics2D)graphics;
                trendParams.trendType = (TrendType)((Object)this.val$trendTypeComboBox.getSelectedItem());
                switch (trendParams.trendType) {
                    case HOURLY: {
                        trendParams.activityData = this.val$hourlyActivities;
                        break;
                    }
                    case DAILY: {
                        trendParams.activityData = this.val$dailyActivities;
                        break;
                    }
                    case MONTHLY: {
                        trendParams.activityData = this.val$monthlyActivities;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Insert proper activity data here!");
                    }
                }
                trendParams.width = this.getWidth();
                trendParams.height = this.getHeight();
                new TrendPainter(trendParams).paintChart();
            }
        };
        JComponent jComponent2 = ((Holder)object4).value;
        ((Container)object5).add((Component)jComponent2, "Center");
        object3 = new Object();
        object6 = TrendType.values();
        int n10 = ((TrendType[])object6).length;
        int n12 = 0;
        while (n12 < n10) {
            object2 = object6[n12];
            object3 = new Object();
            ((JComponent)object5).getInputMap(1).put(((TrendType)((Object)object2)).keyStroke, object3);
            ((JComponent)object5).getActionMap().put(object3, new AbstractAction((JComboBox)n, (TrendType)((Object)object2)){
                private final /* synthetic */ JComboBox val$trendTypeComboBox;
                private final /* synthetic */ TrendType val$trendType;
                {
                    this.val$trendTypeComboBox = jComboBox;
                    this.val$trendType = trendType;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$trendTypeComboBox.setSelectedItem((Object)this.val$trendType);
                }
            });
            ++n12;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.trends.title"), Icons.CHART, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Vector<Vector<Object>>(hashMap2.size());
        for (Map.Entry n112 : hashMap2.entrySet()) {
            n = (PlaymateStatistics)n112.getValue();
            Vector<Object> vector = new Vector<Object>(11);
            vector.add(n112.getKey());
            vector.add(((PlaymateStatistics)n).recordAsAllies.totalGames + ((PlaymateStatistics)n).recordAsOpponents.totalGames);
            vector.add(((PlaymateStatistics)n).recordAsAllies.totalGames);
            vector.add(((PlaymateStatistics)n).recordAsOpponents.totalGames);
            vector.add(((PlaymateStatistics)n).recordAsAllies);
            vector.add(((PlaymateStatistics)n).recordAsAllies.getWinRatio());
            vector.add(((PlaymateStatistics)n).recordAsOpponents);
            vector.add(((PlaymateStatistics)n).recordAsOpponents.getWinRatio());
            vector.add(((PlaymateStatistics)n).getFormattedTotalTimeInGames());
            vector.add(Language.formatDate(((PlaymateStatistics)n).firstDate));
            vector.add(Language.formatDate(((PlaymateStatistics)n).lastDate));
            object4.add(vector);
        }
        n112 = new Holder();
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        n6 = this.createStatisticsTableTab("module.multiRepAnal.tab.players.info", new Object[]{hashMap2.size()}, 0, nArray4, (Vector<Vector<Object>>)object4, PLAYMATES_HEADER_NAME_VECTOR, (Holder<JTable>)((Object)n112), list);
        ((JTable)((Holder)((Object)n112)).value).addMouseListener(this.playersTableMouseListener);
        this.registerEnterToOpenPlayer((JTable)((Holder)((Object)n112)).value);
        ((Container)object5).add((Component)n6);
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.playmates.title"), Icons.GROUP_LINK, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Vector(enumMap2.size());
        for (Map.Entry n112 : enumMap2.entrySet()) {
            n = (PlayerStatistics)n112.getValue();
            Vector<Object> vector = new Vector<Object>(12);
            vector.add(n112.getKey());
            vector.add(((PlayerStatistics)n).record.totalGames);
            vector.add(((PlayerStatistics)n).getAvgApm());
            vector.add(((PlayerStatistics)n).record);
            vector.add(((PlayerStatistics)n).record.getWinRatio());
            vector.add(((PlayerStatistics)n).getRaceDistributionString());
            vector.add(((PlayerStatistics)n).getFormattedTotalTimeInGames());
            vector.add(ReplayUtils.formatMs(((PlayerStatistics)n).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
            vector.add(((DateRangeStatistics)n).getPresence());
            vector.add(Float.valueOf(((PlayerStatistics)n).getAvgGamesPerDay()));
            vector.add(Language.formatDate(((PlayerStatistics)n).firstDate));
            vector.add(Language.formatDate(((PlayerStatistics)n).lastDate));
            object4.add(vector);
        }
        int[] nArray5 = new int[2];
        nArray5[0] = 1;
        ((Container)object5).add(this.createStatisticsTableTab(null, null, 0, nArray5, (Vector<Vector<Object>>)object4, TYPE_RECORDS_HEADER_NAME_VECTOR, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.typeRecords.title"), null, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Vector(enumMap.size());
        for (Map.Entry n112 : enumMap.entrySet()) {
            n = (PlayerStatistics)n112.getValue();
            Vector<Object> vector = new Vector<Object>(12);
            vector.add(n112.getKey());
            vector.add(((PlayerStatistics)n).record.totalGames);
            vector.add(((PlayerStatistics)n).getAvgApm());
            vector.add(((PlayerStatistics)n).record);
            vector.add(((PlayerStatistics)n).record.getWinRatio());
            vector.add(((PlayerStatistics)n).getRaceDistributionString());
            vector.add(((PlayerStatistics)n).getFormattedTotalTimeInGames());
            vector.add(ReplayUtils.formatMs(((PlayerStatistics)n).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
            vector.add(((DateRangeStatistics)n).getPresence());
            vector.add(Float.valueOf(((PlayerStatistics)n).getAvgGamesPerDay()));
            vector.add(Language.formatDate(((PlayerStatistics)n).firstDate));
            vector.add(Language.formatDate(((PlayerStatistics)n).lastDate));
            object4.add(vector);
        }
        int[] nArray6 = new int[2];
        nArray6[0] = 1;
        ((Container)object5).add(this.createStatisticsTableTab(null, null, 0, nArray6, (Vector<Vector<Object>>)object4, FORMAT_RECORDS_HEADER_NAME_VECTOR, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.title"), Icons.FORMAT, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JTabbedPane();
        n = ReplayConsts.Format.values();
        int mapStatistics = ((ReplayConsts.Format[])n).length;
        int nullAwareComparable = 0;
        while (nullAwareComparable < mapStatistics) {
            object4 = n[nullAwareComparable];
            Map map = (Map)enumMap3.get(object4);
            if (map != null) {
                object3 = new JPanel(new BorderLayout());
                object2 = new Vector<Vector<Object>>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    object6 = (PlayerStatistics)entry.getValue();
                    object = new Vector(11);
                    ((Vector)object).add(entry.getKey());
                    ((Vector)object).add(((PlayerStatistics)object6).record.totalGames);
                    ((Vector)object).add(((PlayerStatistics)object6).getAvgApm());
                    ((Vector)object).add(((PlayerStatistics)object6).record);
                    ((Vector)object).add(((PlayerStatistics)object6).record.getWinRatio());
                    ((Vector)object).add(((PlayerStatistics)object6).getFormattedTotalTimeInGames());
                    ((Vector)object).add(ReplayUtils.formatMs(((PlayerStatistics)object6).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
                    ((Vector)object).add(((DateRangeStatistics)object6).getPresence());
                    ((Vector)object).add(Float.valueOf(((PlayerStatistics)object6).getAvgGamesPerDay()));
                    ((Vector)object).add(Language.formatDate(((PlayerStatistics)object6).firstDate));
                    ((Vector)object).add(Language.formatDate(((PlayerStatistics)object6).lastDate));
                    ((Vector)object2).add(object);
                }
                int[] nArray7 = new int[2];
                nArray7[0] = 1;
                ((Container)object3).add(this.createStatisticsTableTab(null, null, 0, nArray7, (Vector<Vector<Object>>)object2, MATCHUP_RECORDS_HEADER_NAME_VECTOR, null, list));
                GuiUtils.addNewTab(((ReplayConsts.Format)((Object)object4)).stringValue, null, false, (JTabbedPane)object5, (JComponent)object3, false, null);
            }
            ++nullAwareComparable;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.matchupRecords.title"), Icons.RACE_ANY, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Vector(hashMap.size());
        NullAwareComparable<Integer> n13 = NullAwareComparable.getPercent(null);
        for (MapStatistics n122 : hashMap.values()) {
            Record record = n122.raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            object3 = n122.raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            object2 = n122.raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            Vector<Object> vector = new Vector<Object>(11);
            vector.add(n122.name);
            vector.add(n122.record.totalGames);
            vector.add(NullAwareComparable.getPercent(n122.record.totalGames * 100 / playerStatistics.playerGameParticipationStatsList.size()));
            vector.add(n122.record);
            vector.add(n122.record.getWinRatio());
            vector.add(record == null ? n13 : record.getWinRatio());
            vector.add(object3 == null ? n13 : ((Record)object3).getWinRatio());
            vector.add(object2 == null ? n13 : ((Record)object2).getWinRatio());
            vector.add(ReplayUtils.formatMs(n122.getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL));
            vector.add(Language.formatDate(n122.firstDate));
            vector.add(Language.formatDate(n122.lastDate));
            object4.add(vector);
        }
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        ((Container)object5).add(this.createStatisticsTableTab("module.multiRepAnal.tab.maps.info", new Object[]{hashMap.size()}, 0, nArray8, (Vector<Vector<Object>>)object4, PLAYER_MAPS_HEADER_NAME_VECTOR, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JTabbedPane();
        n = ReplayConsts.Format.values();
        int n14 = ((ReplayConsts.Format[])n).length;
        int n15 = 0;
        while (n15 < n14) {
            object4 = n[n15];
            Map map = (Map)enumMap4.get(object4);
            if (map != null) {
                object3 = new JPanel(new BorderLayout());
                object2 = new Vector<Vector<Object>>(map.size());
                for (BuildOrderStatistics buildOrderStatistics : map.values()) {
                    if (object4 == ReplayConsts.Format.ONE_VS_ONE) {
                        object6 = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.PROTOSS);
                        object = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.TERRAN);
                        Record record = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.ZERG);
                        Vector<Object> vector = new Vector<Object>(10);
                        vector.add((Object)buildOrderStatistics.race);
                        vector.add(buildOrderStatistics.buildOrder);
                        vector.add(buildOrderStatistics.record.totalGames);
                        vector.add(buildOrderStatistics.record);
                        vector.add(buildOrderStatistics.record.getWinRatio());
                        vector.add(object6 == null ? new Record() : object6);
                        vector.add(object == null ? new Record() : object);
                        vector.add(record == null ? new Record() : record);
                        vector.add(Language.formatDate(buildOrderStatistics.firstDate));
                        vector.add(Language.formatDate(buildOrderStatistics.lastDate));
                        ((Vector)object2).add(vector);
                        continue;
                    }
                    object6 = new Vector(7);
                    ((Vector)object6).add(buildOrderStatistics.race);
                    ((Vector)object6).add(buildOrderStatistics.buildOrder);
                    ((Vector)object6).add(buildOrderStatistics.record.totalGames);
                    ((Vector)object6).add(buildOrderStatistics.record);
                    ((Vector)object6).add(buildOrderStatistics.record.getWinRatio());
                    ((Vector)object6).add(Language.formatDate(buildOrderStatistics.firstDate));
                    ((Vector)object6).add(Language.formatDate(buildOrderStatistics.lastDate));
                    ((Vector)object2).add((Vector<Object>)object6);
                }
                int[] nArray9 = new int[3];
                nArray9[0] = 2;
                nArray9[2] = 4;
                ((Container)object3).add(this.createStatisticsTableTab("module.multiRepAnal.tab.buildOrders.info", new Object[]{map.size()}, 1, nArray9, (Vector<Vector<Object>>)object2, object4 == ReplayConsts.Format.ONE_VS_ONE ? BUILD_ORDERS_1V1_HEADER_NAME_VECTOR : BUILD_ORDERS_NON_1V1_HEADER_NAME_VECTOR, null, null));
                GuiUtils.addNewTab(((ReplayConsts.Format)((Object)object4)).stringValue, null, false, (JTabbedPane)object5, (JComponent)object3, false, null);
            }
            ++n15;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.buildOrders.title"), Icons.BLOCK, false, jTabbedPane, (JComponent)object5, null);
        object5 = new JPanel(new BorderLayout());
        object4 = new Vector(hashMap3.size());
        for (WordStatistics wordStatistics : hashMap3.values()) {
            n = new Vector(6);
            ((Vector)n).add(wordStatistics.word);
            ((Vector)n).add(wordStatistics.count);
            ((Vector)n).add(wordStatistics.replays);
            ((Vector)n).add(NullAwareComparable.getPercent(wordStatistics.replays * 100 / playerStatistics.playerGameParticipationStatsList.size()));
            ((Vector)n).add(Language.formatDate(wordStatistics.firstDate));
            ((Vector)n).add(Language.formatDate(wordStatistics.lastDate));
            object4.add((Vector<Object>)n);
        }
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[1] = 2;
        ((Container)object5).add(this.createStatisticsTableTab("module.multiRepAnal.tab.chatWords.info", new Object[]{hashMap3.size()}, 0, nArray10, (Vector<Vector<Object>>)object4, CHAT_WORDS_HEADER_NAME_VECTOR, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.chatWords.title"), Icons.BALLOONS, false, jTabbedPane, (JComponent)object5, null);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    private JComponent createStatisticsTableTab(String string, Object[] objectArray, final int n, int[] nArray, Vector<Vector<Object>> vector, Vector<String> vector2, Holder<JTable> holder, List<ActionListener> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (string != null) {
            jPanel.add((Component)new JLabel(Language.getText(string, objectArray)), "North");
        }
        final JTable jTable = GuiUtils.createNonEditableTable();
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                int n2 = this.getRowCount();
                if (n2 == 0) {
                    return super.getColumnClass(n);
                }
                if (n2 > 10) {
                    n2 = 10;
                }
                int n3 = 0;
                while (n3 < n2) {
                    Object object = this.getValueAt(n3, n);
                    if (object != null) {
                        return object.getClass();
                    }
                    ++n3;
                }
                return Object.class;
            }
        };
        defaultTableModel.setDataVector(vector, vector2);
        jTable.setModel(defaultTableModel);
        jTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)defaultTableModel, nArray){
            {
                super(tableModel);
                ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    arrayList.add(new RowSorter.SortKey(n4, (n4 = nArray2[n3]) == n5 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
                    ++n3;
                }
                this.setSortKeys(arrayList);
                this.setMaxSortKeys(3);
            }

            @Override
            public void toggleSortOrder(int n2) {
                ArrayList<RowSorter.SortKey> arrayList;
                if (n2 != n && ((arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys())).isEmpty() || ((RowSorter.SortKey)arrayList.get(0)).getColumn() != n2)) {
                    arrayList.add(0, new RowSorter.SortKey(n2, SortOrder.DESCENDING));
                    if (arrayList.size() > this.getMaxSortKeys()) {
                        arrayList.remove(this.getMaxSortKeys());
                    }
                    this.setSortKeys(arrayList);
                    return;
                }
                super.toggleSortOrder(n2);
            }
        });
        TableBox tableBox = new TableBox(jTable, jPanel);
        jPanel.add((Component)tableBox, "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setAutoResizeMode(MultiRepAnalysis.this.stretchToWindowCheckBox.isSelected() ? 4 : 0);
            }
        };
        actionListener.actionPerformed(null);
        this.stretchToWindowCheckBox.addActionListener(actionListener);
        if (list != null) {
            list.add(actionListener);
        }
        if (holder != null) {
            holder.value = jTable;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiUtils.packTable(jTable);
            }
        });
        return jPanel;
    }

    public static enum ChartGranularity {
        DAY("module.multiRepAnal.tab.player.tab.charts.granularity.day"),
        WEEK("module.multiRepAnal.tab.player.tab.charts.granularity.week"),
        MONTH("module.multiRepAnal.tab.player.tab.charts.granularity.month"),
        YEAR("module.multiRepAnal.tab.player.tab.charts.granularity.year"),
        LADDER_SEASON("module.multiRepAnal.tab.player.tab.charts.granularity.ladderSeason");

        private final String stringValue;

        private ChartGranularity(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ChartType {
        ACTIVITY("module.multiRepAnal.tab.player.tab.charts.chartType.activity", "module.multiRepAnal.tab.player.tab.charts.chartType.activity.yAxisLabel"),
        APM_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment.yAxisLabel"),
        WIN_RATIO_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment.yAxisLabel"),
        RACE_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution.yAxisLabel#2"),
        GAME_TYPE_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.gameTypeDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.gameTypeDistribution.yAxisLabel"),
        FORMAT_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.formatDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.formatDistribution.yAxisLabel");

        public final String stringValue;
        public final String yAxisLabelKey;
        public final KeyStroke keyStroke;

        private ChartType(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.yAxisLabelKey = string3;
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum TrendType {
        HOURLY("module.multiRepAnal.tab.player.tab.trends.hourly"),
        DAILY("module.multiRepAnal.tab.player.tab.trends.daily"),
        MONTHLY("module.multiRepAnal.tab.player.tab.trends.monthly");

        public final String stringValue;
        public final KeyStroke keyStroke;
        public final String[] labels;

        private TrendType(String string2) {
            this.stringValue = Language.getText(string2);
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
            if ("module.multiRepAnal.tab.player.tab.trends.hourly".equals(string2)) {
                this.labels = new String[24];
                int n2 = 0;
                while (n2 < 24) {
                    this.labels[n2] = Integer.toString(n2);
                    ++n2;
                }
            } else if ("module.multiRepAnal.tab.player.tab.trends.daily".equals(string2)) {
                this.labels = new String[DAY_TEXT_KEYS.length];
                int n3 = 0;
                while (n3 < DAY_TEXT_KEYS.length) {
                    this.labels[n3] = Language.getText(DAY_TEXT_KEYS[n3]);
                    ++n3;
                }
            } else if ("module.multiRepAnal.tab.player.tab.trends.monthly".equals(string2)) {
                this.labels = new String[MONTH_TEXT_KEYS.length];
                int n4 = 0;
                while (n4 < MONTH_TEXT_KEYS.length) {
                    this.labels[n4] = Language.getText(MONTH_TEXT_KEYS[n4]);
                    ++n4;
                }
            } else {
                throw new RuntimeException("Set the labels for the trend: " + this.stringValue);
            }
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

