/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.Task;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Animator
implements Runnable {
    private final JComponent controlUIComponent;
    private final JProgressBar currentTimeProgressBar = new JProgressBar();
    private final Replay replay;
    private final ActionListener chartCanvasRepainterListener;
    private final Holder<ChartParams> chartParamsHolder;
    private final Holder<Integer> markerXHolder;
    private final Holder<Integer> markerFrameHolder;
    private final Task<Integer> syncActionListToFrameTask;
    private volatile int currentTimeMs;
    private final JLabel playPauseLabel = GuiUtils.createIconLabelButton(Icons.CONTROL, "module.repAnalyzer.tab.charts.animate.playToolTip");
    private ControlledThread animatorThread;

    public Animator(Replay replay, ActionListener actionListener, JLayeredPane jLayeredPane, Holder<ChartParams> holder, Holder<Integer> holder2, Holder<Integer> holder3, Task<Integer> task) {
        this.replay = replay;
        this.chartCanvasRepainterListener = actionListener;
        this.chartParamsHolder = holder;
        this.markerXHolder = holder2;
        this.markerFrameHolder = holder3;
        this.syncActionListToFrameTask = task;
        this.controlUIComponent = this.buildControlUI(jLayeredPane);
        this.setCurrentTime(0);
    }

    private JComponent buildControlUI(JLayeredPane jLayeredPane) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(2));
        box.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.animate.animate")));
        box.add(Box.createHorizontalStrut(3));
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.handlePlayPause();
            }
        };
        this.playPauseLabel.addMouseListener(mouseAdapter);
        box.add(this.playPauseLabel);
        box.add(Box.createHorizontalStrut(3));
        JLabel jLabel = GuiUtils.createIconLabelButton(Icons.CONTROL_SKIP_180, "module.repAnalyzer.tab.charts.animate.jumpToBeginningToolTip");
        final MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.setCurrentTime(0);
                Animator.this.syncChartToCurrentFrame();
            }
        };
        jLabel.addMouseListener(mouseAdapter2);
        box.add(jLabel);
        JLabel jLabel2 = GuiUtils.createIconLabelButton(Icons.CONTROL_DOUBLE_180, "module.repAnalyzer.tab.charts.animate.jumpBackwardToolTip");
        final MouseAdapter mouseAdapter3 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.jumpTime(Settings.getInt("settings.misc.animatorJumpTime") * -1000 - 1);
            }
        };
        jLabel2.addMouseListener(mouseAdapter3);
        box.add(jLabel2);
        this.currentTimeProgressBar.setCursor(Cursor.getPredefinedCursor(12));
        this.currentTimeProgressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.setCurrentTime(((Animator)Animator.this).replay.gameLength * 500 * mouseEvent.getX() / Animator.this.currentTimeProgressBar.getWidth());
                Animator.this.syncChartToCurrentFrame();
            }
        });
        this.currentTimeProgressBar.setMaximum(this.replay.converterGameSpeed.convertToRealTime(this.replay.gameLength * 500));
        this.currentTimeProgressBar.setStringPainted(true);
        box.add(this.currentTimeProgressBar);
        JLabel jLabel3 = GuiUtils.createIconLabelButton(Icons.CONTROL_DOUBLE, "module.repAnalyzer.tab.charts.animate.jumpForwardToolTip");
        final MouseAdapter mouseAdapter4 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.jumpTime(Settings.getInt("settings.misc.animatorJumpTime") * 1000 + 1);
            }
        };
        jLabel3.addMouseListener(mouseAdapter4);
        box.add(jLabel3);
        JLabel jLabel4 = GuiUtils.createIconLabelButton(Icons.CONTROL_SKIP, "module.repAnalyzer.tab.charts.animate.jumpToEndToolTip");
        final MouseAdapter mouseAdapter5 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Animator.this.setCurrentFrame(((Animator)Animator.this).replay.gameEvents.actions.length > 0 ? ((Animator)Animator.this).replay.gameEvents.actions[((Animator)Animator.this).replay.gameEvents.actions.length - 1].frame : 0);
                Animator.this.syncChartToCurrentFrame();
            }
        };
        jLabel4.addMouseListener(mouseAdapter5);
        box.add(jLabel4);
        box.add(Box.createHorizontalStrut(8));
        box.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.animate.speed")));
        box.add(Box.createHorizontalStrut(2));
        final JLabel jLabel5 = GuiUtils.createIconLabelButton(Icons.MINUS_SMALL, "module.repAnalyzer.tab.charts.animate.slowDownToolTip");
        final JLabel jLabel6 = GuiUtils.createIconLabelButton(Icons.PLUS_SMALL, "module.repAnalyzer.tab.charts.animate.speedUpToolTip");
        final JLabel jLabel7 = new JLabel();
        final Task<Integer> task = new Task<Integer>(){

            @Override
            public void execute(Integer n) {
                jLabel7.setText(Speed.values()[n.intValue()].stringValue);
                jLabel5.setEnabled(n > 0);
                jLabel6.setEnabled(n < Speed.values().length - 1);
            }
        };
        task.execute(Settings.getInt("settings.misc.animatorSpeed"));
        final MouseAdapter mouseAdapter6 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = Settings.getInt("settings.misc.animatorSpeed");
                if (n > 0) {
                    Settings.set("settings.misc.animatorSpeed", n - 1);
                    task.execute(n - 1);
                }
            }
        };
        jLabel5.addMouseListener(mouseAdapter6);
        box.add(jLabel5);
        box.add(jLabel7);
        final MouseAdapter mouseAdapter7 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = Settings.getInt("settings.misc.animatorSpeed");
                if (n < Speed.values().length - 1) {
                    Settings.set("settings.misc.animatorSpeed", n + 1);
                    task.execute(n + 1);
                }
            }
        };
        jLabel6.addMouseListener(mouseAdapter7);
        box.add(jLabel6);
        InputMap inputMap = jLayeredPane.getInputMap(1);
        ActionMap actionMap = jLayeredPane.getActionMap();
        Object object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(81, 3), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter2.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(81, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter3.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(87, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(69, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter4.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(69, 3), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter5.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(82, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter6.mousePressed(null);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(82, 3), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mouseAdapter7.mousePressed(null);
            }
        });
        return box;
    }

    private void handlePlayPause() {
        if (this.animatorThread == null) {
            this.playPauseLabel.setIcon(Icons.CONTROL_PAUSE);
            this.playPauseLabel.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.animate.pauseToolTip"));
            this.animatorThread = new ControlledThread("Animator"){

                @Override
                public void run() {
                    int n;
                    int n2 = n = ((Animator)Animator.this).replay.gameEvents.actions.length > 0 ? ((Animator)Animator.this).replay.gameEvents.actions[((Animator)Animator.this).replay.gameEvents.actions.length - 1].frame * 125 >> 3 : 0;
                    if (Animator.this.currentTimeMs >= n) {
                        Animator.this.setCurrentTime(0);
                    }
                    while (!this.requestedToCancel) {
                        try {
                            SwingUtilities.invokeLater(Animator.this);
                            17.sleep(1000 / Settings.getInt("settings.misc.animatorFps"));
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            };
            this.animatorThread.start();
        } else {
            this.animatorThread.requestToCancel();
            this.animatorThread = null;
            this.playPauseLabel.setIcon(Icons.CONTROL);
            this.playPauseLabel.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.animate.playToolTip"));
        }
    }

    public JComponent getControlUIComponent() {
        return this.controlUIComponent;
    }

    public void setCurrentFrame(int n) {
        this.setCurrentTime(n * 125 >> 3);
    }

    private void setCurrentTime(int n) {
        this.currentTimeMs = n;
        this.currentTimeProgressBar.setValue(this.replay.converterGameSpeed.convertToRealTime(n));
        this.currentTimeProgressBar.setString(ReplayUtils.formatMs(n, this.replay.converterGameSpeed));
    }

    private void syncChartToCurrentFrame() {
        int n = (this.currentTimeMs << 3) / 125;
        this.markerXHolder.value = ((ChartParams)this.chartParamsHolder.value).frameToX(n);
        this.markerFrameHolder.value = null;
        this.chartCanvasRepainterListener.actionPerformed(null);
        this.syncActionListToFrameTask.execute(n);
    }

    private boolean jumpTime(int n) {
        boolean bl;
        int n2 = this.currentTimeMs + this.replay.converterGameSpeed.convertToGameTime(n);
        if (n > 0) {
            int n3 = this.replay.gameEvents.actions.length > 0 ? this.replay.gameEvents.actions[this.replay.gameEvents.actions.length - 1].frame * 125 >> 3 : 0;
            bl = n2 > n3;
            if (bl) {
                n2 = n3;
            }
        } else {
            bl = false;
            if (n2 < 0) {
                n2 = 0;
            }
        }
        this.setCurrentTime(n2);
        this.syncChartToCurrentFrame();
        return bl;
    }

    @Override
    public void run() {
        if (this.jumpTime(Speed.values()[Settings.getInt("settings.misc.animatorSpeed")].getPlayTimeBetweenFrames(1000 / Settings.getInt("settings.misc.animatorFps")))) {
            this.handlePlayPause();
        }
    }

    public void requestToCancel() {
        if (this.animatorThread != null) {
            this.animatorThread.requestToCancel();
        }
    }

    public static enum Speed {
        QUARTER("x1/4", -2),
        HALF("x1/2", -1),
        ONE("x1", 0),
        TWO("x2", 1),
        FOUR("x4", 2),
        EIGHT("x8", 3),
        SIXTEEN("x16", 4),
        THIRTY_TWO("x32", 5);

        public final String stringValue;
        private final int bitShift;

        private Speed(String string2, int n2) {
            this.stringValue = string2;
            this.bitShift = n2;
        }

        public int getPlayTimeBetweenFrames(int n) {
            return this.bitShift >= 0 ? n << this.bitShift : n >> -this.bitShift;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

