/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2map.MapParser;
import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.EntityParams;
import hu.belicza.andras.sc2gears.sc2replay.PlayerSelectionTracker;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.MapInfo;
import hu.belicza.andras.sc2gears.ui.charts.BaseChartPainter;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.GridParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.Pair;
import hu.belicza.andras.sc2gears.util.Producer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class ChartPainter
extends BaseChartPainter {
    private static final String[] NUMBER_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final Color COLOR_CHART_MARKER = new Color(150, 150, 255);
    private static final Color COLOR_GRID = COLOR_AXIS;
    private static final Map<MapInfo.MapObject, Color> MAP_OBJECT_COLOR_MAP = new EnumMap<MapInfo.MapObject, Color>(MapInfo.MapObject.class);
    private final StringBuilder[] descriptionBuilders;
    protected final ChartParams params;
    private static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType;
    private static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race;

    static {
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.MINERAL_FIELD, new Color(130, 130, 255));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.RICH_MINERAL_FIELD, new Color(180, 180, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.VESPENE_GEYSER, new Color(100, 220, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.SPACE_PLATFORM_GEYSER, new Color(100, 220, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.XEL_NAGA_TOWER, new Color(255, 255, 255));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_4X4, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_6X6, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_2X6_VERTICAL, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_2X6_HORIZONTAL, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_DEBRIS_4X4, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_DEBRIS_6X6, new Color(92, 51, 23));
    }

    public ChartPainter(ChartParams chartParams) {
        super(chartParams);
        this.params = chartParams;
        this.params.calcualteDerivedData(COLOR_PLAYER_DEFAULT);
        this.descriptionBuilders = new StringBuilder[this.params.chartPlayerIndices.length];
    }

    @Override
    public void paintChart() {
        super.paintChart();
        if (this.params.chartPlayerIndices.length == 0 || this.params.chartDX <= 0 || this.params.replay.frames == 0) {
            return;
        }
        if (this.params.chartType != ReplayAnalyzer.ChartType.MAP_VIEW) {
            Details.Player[] playerArray = this.params.replay.details.players;
            int n = 0;
            while (n < this.descriptionBuilders.length) {
                this.descriptionBuilders[n] = new StringBuilder();
                if (this.params.groupByTeam) {
                    this.descriptionBuilders[n].append(Language.getText("module.repAnalyzer.tab.charts.chartText.team", this.params.teamList.get(n))).append(" [");
                    int n2 = 0;
                    int[] nArray = this.params.playerIndices;
                    int n3 = this.params.playerIndices.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = nArray[n4];
                        if (this.params.playerChartIndices[n5] == n) {
                            Details.Player player = playerArray[n5];
                            if (n2++ > 0) {
                                this.descriptionBuilders[n].append(", ");
                            }
                            this.descriptionBuilders[n].append(player.playerId.name).append(" (").append(player.raceLetter()).append(')');
                        }
                        ++n4;
                    }
                    this.descriptionBuilders[n].append("]");
                } else {
                    Details.Player player = playerArray[this.params.chartPlayerIndices[n]];
                    this.descriptionBuilders[n].append(player.playerId.name).append(" (").append(player.raceLetter()).append(')');
                }
                ++n;
            }
            if (this.params.gridParams != null) {
                this.paintGrid();
            }
            this.paintAxis();
        }
        switch (this.params.chartType) {
            case APM: {
                this.paintApmChart();
                break;
            }
            case HOTKEYS: {
                this.paintHotkeysChart();
                break;
            }
            case BUILDS_TECH: {
                this.paintBuildsTechChart();
                break;
            }
            case BUILDS_TECH_STAT: {
                this.paintBuildsTechStatChart();
                break;
            }
            case UNIT_TIERS: {
                this.paintUnitTiersChart();
                break;
            }
            case MAP_VIEW: {
                this.paintMapViewChart();
                break;
            }
            case MAIN_BUILDING_CONTROL: {
                this.paintMainBuildingControl();
                break;
            }
            case PRODUCTIONS: {
                this.paintProductionsChart();
                break;
            }
            case PLAYER_SELECTIONS: {
                this.paintPlayerSelectionsChart();
                break;
            }
            case RESOURCES_SPENT: {
                this.paintResourcesSpentChart();
                break;
            }
            case PRODUCED_ARMY_SUPPLY: {
                this.paintProducedArmySupplyChart();
            }
        }
        if (this.params.chartType != ReplayAnalyzer.ChartType.MAP_VIEW) {
            this.paintChartDescriptions();
            if (this.params.markerX == null && this.params.markerFrame != null) {
                this.params.markerX = this.params.frameToX(this.params.markerFrame);
            }
            if (this.params.markerX != null) {
                this.g2.setColor(COLOR_CHART_MARKER);
                this.g2.setStroke(STROKE_DASHED);
                this.g2.drawLine(this.params.markerX, 0, this.params.markerX, this.params.height - 1);
                this.g2.setStroke(STROKE_DEFAULT);
            }
        }
    }

    private void paintGrid() {
        int n;
        Float f = null;
        float f2 = 0.0f;
        block0 : switch (this.params.gridParams.predefinedGrid) {
            case SPAWN_LARVA: {
                GameEvents.Action action;
                GameEvents.Action[] actionArray = this.params.replay.gameEvents.actions;
                n = this.params.replay.gameEvents.actions.length;
                int n2 = 0;
                while (n2 < n) {
                    action = actionArray[n2];
                    if (action instanceof GameEvents.TrainAction && ((GameEvents.TrainAction)action).unit == ReplayConsts.Unit.QUEEN && this.params.playerChartIndices[action.player] >= 0) {
                        f = Float.valueOf(action.frame + (this.params.replay.gameEvents.abilityCodes.UNIT_PARAMS.get((Object)((Object)ReplayConsts.Unit.QUEEN)).time << 6));
                        f2 = GridParams.getFrame(25, GridParams.TimeUnit.ENERGY_REGENERATION, this.params.replay.converterGameSpeed);
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
            case CALLDOWN_MULE: {
                GameEvents.Action action;
                GameEvents.Action[] actionArray = this.params.replay.gameEvents.actions;
                n = this.params.replay.gameEvents.actions.length;
                int n2 = 0;
                while (n2 < n) {
                    action = actionArray[n2];
                    if (action instanceof GameEvents.UseBuildingAbilityAction && ((GameEvents.UseBuildingAbilityAction)action).abilityGroup == ReplayConsts.AbilityGroup.UPGRADE_TO_ORBITAL_COMMAND && this.params.playerChartIndices[action.player] >= 0) {
                        f = Float.valueOf(action.frame + (this.params.replay.gameEvents.abilityCodes.BUILDING_ABILITY_PARAMS.get((Object)((Object)ReplayConsts.BuildingAbility.UPGRADE_TO_ORBITAL_COMMAND)).time << 6));
                        f2 = GridParams.getFrame(50, GridParams.TimeUnit.ENERGY_REGENERATION, this.params.replay.converterGameSpeed);
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
            case CHRONO_BOOST: {
                f = Float.valueOf(0.0f);
                f2 = GridParams.getFrame(25, GridParams.TimeUnit.ENERGY_REGENERATION, this.params.replay.converterGameSpeed);
                break;
            }
            case CUSTOM: {
                f2 = GridParams.getFrame(((IntHolder)this.params.gridParams.repeatMarker.value1).value, (GridParams.TimeUnit)((Object)((Holder)this.params.gridParams.repeatMarker.value2).value), this.params.replay.converterGameSpeed);
                f = Float.valueOf(GridParams.getFrame(((IntHolder)this.params.gridParams.firstMarker.value1).value, (GridParams.TimeUnit)((Object)((Holder)this.params.gridParams.firstMarker.value2).value), this.params.replay.converterGameSpeed));
            }
        }
        if (f != null) {
            this.g2.setColor(COLOR_GRID);
            this.g2.setStroke(STROKE_DASHED);
            float f3 = this.params.replay.frames;
            float f4 = f.floatValue();
            while (f4 < f3) {
                n = this.params.frameToX((int)f4);
                this.g2.drawLine(n, 0, n, this.params.height - 1);
                f4 += f2;
            }
            this.g2.setStroke(STROKE_DEFAULT);
        }
    }

    private void paintAxis() {
        this.g2.setColor(COLOR_AXIS);
        int n = this.params.chartsCount - 1;
        while (n >= 0) {
            this.g2.drawLine(25 + this.params.visibleRectangle.x, this.params.chartY1s[n], 25 + this.params.visibleRectangle.x, this.params.chartY2s[n]);
            this.g2.drawLine(25, this.params.chartY2s[n] + 1, this.params.chartX2, this.params.chartY2s[n] + 1);
            --n;
        }
        n = this.g2.getFontMetrics().getAscent();
        int n2 = this.params.chartWidth < 100 ? 1 : this.params.chartWidth / 100;
        int n3 = this.params.chartsCount - 1;
        while (n3 >= 0) {
            int n4 = n2;
            while (n4 >= 0) {
                int n5 = this.params.chartX1 + n4 * this.params.chartDX / n2;
                int n6 = n4 == 0 ? 0 : (n4 == n2 ? this.params.replay.frames : this.params.xToFrame(n5));
                String string = this.params.displayInSeconds ? ReplayUtils.formatFramesShort(n6, this.params.replay.converterGameSpeed) : Integer.toString(n6);
                this.g2.setColor(COLOR_AXIS);
                this.g2.drawLine(n5, this.params.chartY2s[n3] + 1, n5, this.params.chartY2s[n3] + 3);
                this.g2.setColor(COLOR_AXIS_LABELS);
                this.g2.drawString(string, n5 - (this.g2.getFontMetrics().stringWidth(string) >> (n4 == n2 ? 0 : 1)), this.params.chartY2s[n3] + n);
                --n4;
            }
            --n3;
        }
    }

    private void paintApmChart() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PlayerSelectionTracker[] playerSelectionTrackerArray;
        GameEvents.Action[] actionArray = this.params.actions;
        int n8 = this.params.width / this.params.apmGranularity + (this.params.width % this.params.apmGranularity != 0 ? 1 : 0);
        int[][] nArray = new int[this.params.chartPlayerIndices.length][n8];
        int[][] nArray2 = this.params.showMicroMacroApm ? new int[this.params.chartPlayerIndices.length][n8] : null;
        int[] nArray3 = new int[this.params.chartPlayerIndices.length];
        int[] nArray4 = new int[this.params.chartPlayerIndices.length];
        int[] nArray5 = this.params.showMicroMacroApm ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray6 = this.params.showMicroMacroApm ? new int[this.params.chartPlayerIndices.length] : null;
        int n9 = this.params.replay.excludedInitialFrames;
        PlayerSelectionTracker[] playerSelectionTrackerArray2 = playerSelectionTrackerArray = this.params.showMicroMacroApm ? new PlayerSelectionTracker[this.params.playerColors.length] : null;
        if (playerSelectionTrackerArray != null) {
            int n10 = 0;
            while (n10 < playerSelectionTrackerArray.length) {
                playerSelectionTrackerArray[n10] = this.params.playerChartIndices[n10] < 0 ? null : new PlayerSelectionTracker();
                ++n10;
            }
        }
        AbilityCodes abilityCodes = this.params.replay.gameEvents.abilityCodes;
        int n11 = actionArray.length;
        int n12 = 0;
        while (n12 < n11) {
            int n13;
            GameEvents.Action action = actionArray[n12];
            if (action.type != ReplayConsts.ActionType.INACTION && (n13 = this.params.playerChartIndices[action.player]) >= 0) {
                int n14 = (this.params.frameToX(action.frame) - 25) / this.params.apmGranularity;
                int[] nArray7 = nArray[n13];
                int n15 = n14;
                nArray7[n15] = nArray7[n15] + 1;
                int n16 = n13;
                nArray3[n16] = nArray3[n16] + 1;
                if (action.frame < n9) {
                    int n17 = n13;
                    nArray4[n17] = nArray4[n17] + 1;
                }
                if (playerSelectionTrackerArray != null) {
                    if (action instanceof GameEvents.SelectAction) {
                        playerSelectionTrackerArray[action.player].processSelectAction((GameEvents.SelectAction)action);
                        n7 = PlayerSelectionTracker.isSelectionMacro(playerSelectionTrackerArray[action.player].currentSelection, abilityCodes) ? 1 : 0;
                    } else if (action instanceof GameEvents.HotkeyAction) {
                        playerSelectionTrackerArray[action.player].processHotkeyAction((GameEvents.HotkeyAction)action);
                        n7 = PlayerSelectionTracker.isSelectionMacro(playerSelectionTrackerArray[action.player].hotkeySelectionLists[((GameEvents.HotkeyAction)action).getNumber()], abilityCodes) ? 1 : 0;
                    } else {
                        n7 = action.isMacro() ? 1 : 0;
                    }
                    if (n7 == 0) {
                        int[] nArray8 = nArray2[n13];
                        int n18 = n14;
                        nArray8[n18] = nArray8[n18] + 1;
                        int n19 = n13;
                        nArray5[n19] = nArray5[n19] + 1;
                        if (action.frame < n9) {
                            int n20 = n13;
                            nArray6[n20] = nArray6[n20] + 1;
                        }
                    }
                }
            }
            ++n12;
        }
        n12 = 0;
        while (n12 < nArray3.length) {
            n7 = this.getChartLastActionFrame(n12);
            this.descriptionBuilders[n12].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.actions", nArray3[n12])).append(",        ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.apm", n7 == 0 ? 0 : ReplayUtils.calculateApm(nArray3[n12] - nArray4[n12], this.params.replay.converterGameSpeed.convertToRealTime(n7 - n9))));
            if (nArray2 != null) {
                this.descriptionBuilders[n12].append(",        ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.microApm", n7 == 0 ? 0 : ReplayUtils.calculateApm(nArray5[n12] - nArray6[n12], this.params.replay.converterGameSpeed.convertToRealTime(n7 - n9)))).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.macroApm", n7 == 0 ? 0 : ReplayUtils.calculateApm(nArray3[n12] - nArray5[n12] - (nArray4[n12] - nArray6[n12]), this.params.replay.converterGameSpeed.convertToRealTime(n7 - n9))));
            }
            ++n12;
        }
        int[] nArray9 = new int[this.params.chartPlayerIndices.length];
        n7 = 0;
        while (n7 < nArray.length) {
            nArray9[n7] = GeneralUtils.maxValue(nArray[n7]);
            ++n7;
        }
        if (this.params.allPlayersOnOneChart) {
            Arrays.fill(nArray9, GeneralUtils.maxValue(nArray9));
        }
        int n21 = 0;
        while (n21 < nArray.length) {
            n6 = this.params.chartY2s[n21];
            n5 = nArray9[n21];
            n4 = nArray2 == null ? 0 : 1;
            while (n4 >= 0) {
                int[] nArray10;
                int[] nArray11 = nArray10 = n4 == 0 ? nArray[n21] : nArray2[n21];
                if (n5 > 0) {
                    int n22 = nArray10.length - 1;
                    while (n22 >= 0) {
                        nArray10[n22] = n6 - this.params.chartHeight * nArray10[n22] / n5;
                        --n22;
                    }
                } else {
                    Arrays.fill(nArray10, n6);
                }
                --n4;
            }
            ++n21;
        }
        n21 = this.params.xToFrame(25 + this.params.apmGranularity - 1);
        n6 = this.params.chartHeight < 20 ? 1 : this.params.chartHeight / 20;
        n5 = this.params.chartsCount - 1;
        while (n5 >= 0) {
            n4 = this.params.replay.converterGameSpeed.convertToGameTime((int)(n21 < 1 ? 1L : (long)nArray9[n5] * 3840L / (long)n21));
            Font font = null;
            if (n4 > 999) {
                font = this.g2.getFont();
                this.g2.setFont(font.deriveFont(10.0f));
            }
            n3 = this.g2.getFontMetrics().getAscent();
            this.g2.setStroke(STROKE_DASHED);
            n2 = n6 - 1;
            while (n2 >= 0) {
                n = this.params.chartY1s[n5] + n2 * this.params.chartDY / n6;
                this.g2.setColor(COLOR_ASSIST_LINES);
                this.g2.drawLine(this.params.chartX1 + 1 + this.params.visibleRectangle.x, n, this.params.chartX2, n);
                this.g2.setColor(COLOR_AXIS_LABELS);
                int n23 = (int)(n21 < 1 ? 1L : (long)(n6 - n2) * (long)nArray9[n5] * 3840L / (long)(n6 * n21));
                n23 = this.params.replay.converterGameSpeed.convertToGameTime(n23);
                this.g2.drawString(Integer.toString(n23), this.params.visibleRectangle.x, n + (n3 >> 1) - 1);
                --n2;
            }
            if (n4 > 999) {
                this.g2.setFont(font);
            }
            --n5;
        }
        int[] nArray12 = new int[n8];
        n4 = 25 - this.params.apmGranularity;
        int n24 = 0;
        while (n24 < nArray12.length) {
            nArray12[n24] = n4 += this.params.apmGranularity;
            ++n24;
        }
        n24 = 0;
        while (n24 < nArray.length) {
            n3 = Math.max(0, (this.params.visibleRectangle.x - 25) / this.params.apmGranularity);
            n2 = Math.min(nArray12.length - 1, (this.params.visibleRectangle.x + this.params.visibleRectangle.width - 1) / this.params.apmGranularity + 1);
            n = nArray2 == null ? 0 : 1;
            while (n >= 0) {
                int[] nArray13;
                if (n == 0) {
                    nArray13 = nArray[n24];
                    this.g2.setStroke(this.params.apmApproximation == ChartUtils.GraphApproximation.LINEAR ? STROKE_DOUBLE_WIDTH_ROUNDED : STROKE_DOUBLE_WIDTH);
                    this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[n24]]);
                } else {
                    nArray13 = nArray2[n24];
                    this.g2.setStroke(this.params.apmApproximation == ChartUtils.GraphApproximation.LINEAR ? STROKE_ROUNDED : STROKE_DEFAULT);
                    this.g2.setColor(this.params.replay.details.players[this.params.chartPlayerIndices[n24]].getBrighterColor());
                }
                switch (this.params.apmApproximation) {
                    case LINEAR: {
                        int n25 = n3;
                        while (n25 < n2) {
                            this.g2.drawLine(nArray12[n25], nArray13[n25], nArray12[n25 + 1], nArray13[n25 + 1]);
                            ++n25;
                        }
                        break;
                    }
                    case CUBIC: {
                        Rectangle rectangle = this.g2.getClipBounds();
                        if (rectangle == null) {
                            this.g2.setClip(this.params.chartX1, this.params.chartY1s[n24], this.params.chartWidth, this.params.chartHeight);
                        } else {
                            this.g2.setClip(rectangle.intersection(new Rectangle(this.params.chartX1, this.params.chartY1s[n24], this.params.chartWidth, this.params.chartHeight)));
                        }
                        this.drawCubicCurve2D(nArray12, nArray13, n3, n2);
                        this.g2.setClip(rectangle);
                    }
                }
                --n;
            }
            ++n24;
        }
        this.g2.setStroke(STROKE_DEFAULT);
    }

    private int getChartLastActionFrame(int n) {
        if (this.params.groupByTeam) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.params.playerChartIndices.length) {
                if (this.params.playerChartIndices[n3] == n) {
                    n2 = Math.max(n2, this.params.replay.details.players[n3].lastActionFrame);
                }
                ++n3;
            }
            return n2;
        }
        return this.params.replay.details.players[this.params.chartPlayerIndices[n]].lastActionFrame;
    }

    private void paintHotkeysChart() {
        Color color;
        int n = this.g2.getFontMetrics().getAscent();
        int n2 = this.g2.getFontMetrics().charWidth('8');
        boolean bl = this.params.chartHeight >= 10 * n;
        Color[] colorArray = new Color[this.params.playerColors.length];
        int n3 = 0;
        while (n3 < colorArray.length) {
            color = this.params.playerColors[n3];
            if (color != null) {
                colorArray[n3] = GeneralUtils.getInvertedColor(color);
            }
            ++n3;
        }
        int[] nArray = new int[this.params.chartPlayerIndices.length];
        color = this.params.showSelectHotkeys ? new int[this.params.chartPlayerIndices.length] : null;
        GameEvents.Action[] actionArray = this.params.actions;
        ArrayList<Pair<Rectangle, String>> arrayList = new ArrayList<Pair<Rectangle, String>>(64);
        Map<Short, String> map = this.params.replay.gameEvents.abilityCodes.UNIT_TYPE_NAME;
        PlayerSelectionTracker[] playerSelectionTrackerArray = new PlayerSelectionTracker[this.params.playerColors.length];
        int n4 = 0;
        while (n4 < playerSelectionTrackerArray.length) {
            playerSelectionTrackerArray[n4] = this.params.playerChartIndices[n4] < 0 ? null : new PlayerSelectionTracker();
            ++n4;
        }
        n4 = n + (bl ? this.params.chartHeight / 10 - n >> 1 : 0) - 2;
        int n5 = actionArray.length;
        int n6 = 0;
        while (n6 < n5) {
            GameEvents.Action action = actionArray[n6];
            int n7 = this.params.playerChartIndices[action.player];
            if (n7 >= 0) {
                if (action instanceof GameEvents.SelectAction) {
                    playerSelectionTrackerArray[action.player].processSelectAction((GameEvents.SelectAction)action);
                } else if (action instanceof GameEvents.HotkeyAction) {
                    playerSelectionTrackerArray[action.player].processHotkeyAction((GameEvents.HotkeyAction)action);
                    boolean bl2 = ((GameEvents.HotkeyAction)action).isSelect();
                    int n8 = ((GameEvents.HotkeyAction)action).getNumber();
                    List<Short> list = playerSelectionTrackerArray[action.player].hotkeySelectionLists[n8];
                    if (this.params.showSelectHotkeys || !bl2) {
                        this.g2.setColor(this.params.playerColors[action.player]);
                        int n9 = this.params.frameToX(action.frame);
                        int n10 = n8 == 0 ? 9 : n8 - 1;
                        int n11 = this.params.chartY1s[n7] + (bl ? n10 * this.params.chartHeight / 10 : n10 * (this.params.chartHeight - n) / 9) + n4;
                        if (bl2) {
                            this.g2.setColor(this.params.replay.details.players[action.player].getBrighterColor());
                        } else {
                            this.g2.fillRect(n9, n11 - n + 2, n2, n);
                            this.g2.setColor(colorArray[action.player]);
                            arrayList.add(new Pair<Rectangle, String>(new Rectangle(n9, n11 - n + 2, n2, n), PlayerSelectionTracker.getSelectionString(list, map)));
                        }
                        this.g2.drawString(NUMBER_STRINGS[n8], n9, n11);
                        Object object = bl2 ? color : (Object)nArray;
                        int n12 = n7;
                        object[n12] = object[n12] + true;
                    }
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.descriptionBuilders.length) {
            if (this.params.showSelectHotkeys) {
                this.descriptionBuilders[n6].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeys", nArray[n6] + color[n6])).append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.assign", nArray[n6])).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.select", (int)color[n6])).append(')');
            } else {
                this.descriptionBuilders[n6].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeysAssign", nArray[n6]));
            }
            ++n6;
        }
        this.params.toolTipProvider = new ChartParams.StaticToolTipProvider(arrayList);
    }

    private void paintBuildsTechChart() {
        EntityParams entityParams;
        int n;
        GameEvents.Action action;
        GameEvents.Action[] actionArray = this.params.actions;
        EnumSet<ReplayConsts.ActionType> enumSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
        if (this.params.showBuilds) {
            enumSet.add(ReplayConsts.ActionType.BUILD);
        }
        if (this.params.showTrains) {
            enumSet.add(ReplayConsts.ActionType.TRAIN);
        }
        if (this.params.showResearches) {
            enumSet.add(ReplayConsts.ActionType.RESEARCH);
        }
        if (this.params.showUpgrades) {
            enumSet.add(ReplayConsts.ActionType.UPGRADE);
        }
        if (this.params.showAbilityGroups) {
            enumSet.add(ReplayConsts.ActionType.OTHER);
        }
        int n2 = this.params.iconSizes == IconHandler.Size.HIDDEN ? this.g2.getFontMetrics().getAscent() : Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, this.params.iconSizes).getIconHeight() + 2;
        int n3 = Math.max(1, (this.params.chartDY - 7) / n2);
        int[] nArray = this.params.showBuilds ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray2 = this.params.showTrains ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray3 = this.params.showWorkers ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray4 = this.params.showResearches ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray5 = this.params.showUpgrades ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray6 = this.params.showAbilityGroups ? new int[this.params.chartPlayerIndices.length] : null;
        ArrayList<Pair<Rectangle, String>> arrayList = this.params.iconSizes == IconHandler.Size.HIDDEN ? null : new ArrayList<Pair<Rectangle, String>>(64);
        int[] nArray7 = new int[this.params.allPlayersOnOneChart ? 1 : this.params.chartsCount];
        if (n3 > 2) {
            Arrays.fill(nArray7, 1);
        }
        ReplayConsts.AbilityGroup abilityGroup = null;
        int n4 = actionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            block33: {
                ReplayConsts.Unit unit;
                block35: {
                    block34: {
                        action = actionArray[n5];
                        n = this.params.playerChartIndices[action.player];
                        if (n < 0 || !enumSet.contains((Object)action.type)) break block33;
                        if (action.type != ReplayConsts.ActionType.TRAIN) break block34;
                        unit = ((GameEvents.TrainAction)action).unit;
                        if (unit != ReplayConsts.Unit.SCV && unit != ReplayConsts.Unit.DRONE && unit != ReplayConsts.Unit.PROBE) break block35;
                        if (!this.params.showWorkers) break block33;
                        int n6 = n;
                        nArray3[n6] = nArray3[n6] + 1;
                        break block35;
                    }
                    if (action.type == ReplayConsts.ActionType.OTHER && (!(action instanceof GameEvents.UseUnitAbilityAction) && !(action instanceof GameEvents.UseBuildingAbilityAction) || (abilityGroup = ((GameEvents.BaseUseAbilityAction)action).abilityGroup) == null)) break block33;
                }
                unit = action.type == ReplayConsts.ActionType.TRAIN ? ((GameEvents.TrainAction)action).unit : (action.type == ReplayConsts.ActionType.BUILD ? ((GameEvents.BuildAction)action).building : (action.type == ReplayConsts.ActionType.RESEARCH ? ((GameEvents.ResearchAction)action).research : (action.type == ReplayConsts.ActionType.UPGRADE ? ((GameEvents.UpgradeAction)action).upgrade : abilityGroup)));
                String string = ((Object)((Object)unit)).toString();
                int[] nArray8 = action.type == ReplayConsts.ActionType.TRAIN ? nArray2 : (action.type == ReplayConsts.ActionType.BUILD ? nArray : (action.type == ReplayConsts.ActionType.RESEARCH ? nArray4 : (action.type == ReplayConsts.ActionType.UPGRADE ? nArray5 : nArray6)));
                int n7 = n;
                nArray8[n7] = nArray8[n7] + 1;
                this.g2.setColor(action.type == ReplayConsts.ActionType.RESEARCH || action.type == ReplayConsts.ActionType.UPGRADE ? this.params.replay.details.players[action.player].getBrighterColor() : (action.type == ReplayConsts.ActionType.OTHER ? this.params.replay.details.players[action.player].getDarkerColor() : this.params.playerColors[action.player]));
                this.g2.setStroke(action.type == ReplayConsts.ActionType.TRAIN ? STROKE_DASHED : STROKE_DEFAULT);
                if (this.params.allPlayersOnOneChart) {
                    n = 0;
                }
                int n8 = this.params.frameToX(action.frame);
                int n9 = this.params.chartY2s[n] - 7 - nArray7[n] * n2;
                int n10 = n;
                nArray7[n10] = nArray7[n10] + 1;
                if (nArray7[n10] == n3) {
                    nArray7[n] = 0;
                }
                this.g2.drawLine(n8, n9 + 1, n8, this.params.chartY2s[n]);
                if (this.params.iconSizes == IconHandler.Size.HIDDEN) {
                    this.g2.drawString(string, n8 - (this.g2.getFontMetrics().stringWidth(string) >> 1), n9);
                } else {
                    Icon icon = Icons.getEntityIcon((Object)unit, this.params.iconSizes);
                    Icons.getEntityIcon((Object)unit, this.params.iconSizes).paintIcon(this.params.chartCanvas, this.g2, n8 - (icon.getIconWidth() >> 1), n9 - icon.getIconHeight());
                    arrayList.add(new Pair<Rectangle, String>(new Rectangle(n8 - (icon.getIconWidth() >> 1), n9 - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight()), string));
                }
                if (this.params.showDuration != ReplayAnalyzer.ShowDuration.NONE && action instanceof GameEvents.BaseUseAbilityAction && (entityParams = ((GameEvents.BaseUseAbilityAction)action).getEntityParams()) != null) {
                    this.g2.setStroke(STROKE_DEFAULT);
                    this.g2.drawLine(n8, n9 + 1, n8 + entityParams.time * this.params.chartDX / (this.params.replay.gameLengthSec == 0 ? 1 : this.params.replay.gameLengthSec), n9 + 1);
                }
            }
            ++n5;
        }
        if (this.params.showDuration == ReplayAnalyzer.ShowDuration.BARS) {
            if (n3 > 2) {
                Arrays.fill(nArray7, 1);
            } else {
                Arrays.fill(nArray7, 0);
            }
            n5 = 0;
            while (n5 < n4) {
                ReplayConsts.Unit unit;
                action = actionArray[n5];
                n = this.params.playerChartIndices[action.player];
                if (n >= 0 && enumSet.contains((Object)action.type) && !(action.type != ReplayConsts.ActionType.TRAIN ? action.type == ReplayConsts.ActionType.OTHER && (!(action instanceof GameEvents.UseUnitAbilityAction) && !(action instanceof GameEvents.UseBuildingAbilityAction) || ((GameEvents.BaseUseAbilityAction)action).abilityGroup == null) : ((unit = ((GameEvents.TrainAction)action).unit) == ReplayConsts.Unit.SCV || unit == ReplayConsts.Unit.DRONE || unit == ReplayConsts.Unit.PROBE) && !this.params.showWorkers)) {
                    if (this.params.allPlayersOnOneChart) {
                        n = 0;
                    }
                    int n11 = this.params.frameToX(action.frame);
                    int n12 = this.params.chartY2s[n] - 7 - nArray7[n] * n2;
                    int n13 = n;
                    nArray7[n13] = nArray7[n13] + 1;
                    if (nArray7[n13] == n3) {
                        nArray7[n] = 0;
                    }
                    if (action instanceof GameEvents.BaseUseAbilityAction && (entityParams = ((GameEvents.BaseUseAbilityAction)action).getEntityParams()) != null) {
                        Color color = action.type == ReplayConsts.ActionType.RESEARCH || action.type == ReplayConsts.ActionType.UPGRADE ? this.params.replay.details.players[action.player].getBrighterColor() : (action.type == ReplayConsts.ActionType.OTHER ? this.params.replay.details.players[action.player].getDarkerColor() : this.params.playerColors[action.player]);
                        this.g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
                        this.g2.fillRect(n11, n12 + 1, entityParams.time * this.params.chartDX / this.params.replay.gameLengthSec + 1, this.params.chartY2s[n] - n12 - 1);
                    }
                }
                ++n5;
            }
        }
        if (arrayList != null) {
            this.params.toolTipProvider = new ChartParams.StaticToolTipProvider(arrayList);
        }
        if (!enumSet.isEmpty()) {
            n5 = 0;
            while (n5 < this.descriptionBuilders.length) {
                if (this.params.showBuilds) {
                    this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.builds", nArray[n5]));
                }
                if (this.params.showTrains) {
                    this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.trains", nArray2[n5]));
                    if (this.params.showWorkers) {
                        this.descriptionBuilders[n5].append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.workers", nArray3[n5])).append(')');
                    }
                }
                if (this.params.showResearches) {
                    this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.researches", nArray4[n5]));
                }
                if (this.params.showUpgrades) {
                    this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.upgrades", nArray5[n5]));
                }
                if (this.params.showAbilityGroups) {
                    this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.abilityGroups", nArray6[n5]));
                }
                ++n5;
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void paintBuildsTechStatChart() {
        var1_1 = this.params.markerFrame != null ? this.params.markerFrame : (this.params.markerX != null ? this.params.xToFrame(this.params.markerX) : this.params.replay.frames);
        var2_2 = this.params.actions;
        var3_3 = new ChartStat[this.params.chartPlayerIndices.length];
        var4_4 = 0;
        while (var4_4 < var3_3.length) {
            var3_3[var4_4] = new ChartStat();
            ++var4_4;
        }
        var6_6 = var2_2.length;
        var8_7 = 0;
        if (true) ** GOTO lbl59
        do {
            if (!((var7_10 = this.params.playerChartIndices[var4_5.player]) < 0 || this.params.showAfterCompleted && var4_5 instanceof GameEvents.BaseUseAbilityAction && (var9_11 = ((GameEvents.BaseUseAbilityAction)var4_5).getEntityParams()) != null && var4_5.frame + (var9_11.time << 6) > var1_1)) {
                var5_9 = var3_3[var7_10];
                var9_11 = null;
                switch (ChartPainter.$SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType()[var4_5.type.ordinal()]) {
                    case 3: {
                        if (!this.params.showUnitsStat || (var9_11 = var5_9.unitCountMap.get(var10_13 = ((GameEvents.TrainAction)var4_5).unit)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.unitCountMap.put((ReplayConsts.Unit)var10_13, (IntHolder)var9_11);
                        var5_9.unitList.add((ReplayConsts.Unit)var10_13);
                        break;
                    }
                    case 2: {
                        if (!this.params.showBuildingsStat || (var9_11 = var5_9.buildingCountMap.get(var10_13 = ((GameEvents.BuildAction)var4_5).building)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.buildingCountMap.put((ReplayConsts.Building)var10_13, (IntHolder)var9_11);
                        var5_9.buildingList.add((ReplayConsts.Building)var10_13);
                        break;
                    }
                    case 4: {
                        if (!this.params.showResearchesStat || (var9_11 = var5_9.researchCountMap.get(var10_13 = ((GameEvents.ResearchAction)var4_5).research)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.researchCountMap.put((ReplayConsts.Research)var10_13, (IntHolder)var9_11);
                        var5_9.researchList.add((ReplayConsts.Research)var10_13);
                        break;
                    }
                    case 5: {
                        if (!this.params.showUpgradesStat || (var9_11 = var5_9.upgradeCountMap.get(var10_13 = ((GameEvents.UpgradeAction)var4_5).upgrade)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.upgradeCountMap.put((ReplayConsts.Upgrade)var10_13, (IntHolder)var9_11);
                        var5_9.upgradeList.add((ReplayConsts.Upgrade)var10_13);
                        break;
                    }
                    default: {
                        if (!(var4_5 instanceof GameEvents.BaseUseAbilityAction) || !this.params.showAbilityGroupsStat || (var10_13 = ((GameEvents.BaseUseAbilityAction)var4_5).abilityGroup) == null || (var9_11 = var5_9.abilityGroupCountMap.get(var10_13)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.abilityGroupCountMap.put((ReplayConsts.AbilityGroup)var10_13, (IntHolder)var9_11);
                        var5_9.abilityGroupList.add((ReplayConsts.AbilityGroup)var10_13);
                    }
                }
                if (var9_11 != null) {
                    ++var9_11.value;
                }
            }
            ++var8_7;
lbl59:
            // 2 sources

            if (var8_7 >= var6_6) break;
            var4_5 = var2_2[var8_7];
        } while (var4_5.frame <= var1_1);
        var8_8 = new int[5][var3_3.length];
        var9_12 = 0;
        while (var9_12 < var3_3.length) {
            var5_9 = var3_3[var9_12];
            var8_8[0][var9_12] = ChartPainter.maxOfMap(var5_9.unitCountMap);
            var8_8[1][var9_12] = ChartPainter.maxOfMap(var5_9.buildingCountMap);
            var8_8[2][var9_12] = ChartPainter.maxOfMap(var5_9.researchCountMap);
            var8_8[3][var9_12] = ChartPainter.maxOfMap(var5_9.upgradeCountMap);
            var8_8[4][var9_12] = ChartPainter.maxOfMap(var5_9.abilityGroupCountMap);
            ++var9_12;
        }
        if (this.params.allPlayersOnOneChart) {
            var9_12 = 0;
            while (var9_12 < 5) {
                var8_8[var9_12][0] = GeneralUtils.maxValue(var8_8[var9_12]);
                var10_15 = 1;
                while (var10_15 < var8_8[var9_12].length) {
                    var8_8[var9_12][var10_15] = var8_8[var9_12][0];
                    ++var10_15;
                }
                ++var9_12;
            }
        }
        var9_12 = this.g2.getFontMetrics().getAscent();
        var10_16 = Math.max(0, this.params.chartHeight - Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, this.params.barSize).getIconHeight() - var9_12);
        var11_17 = new IntHolder[this.params.allPlayersOnOneChart != false ? 1 : var3_3.length];
        var12_18 = 0;
        while (var12_18 < var11_17.length) {
            var11_17[var12_18] = new IntHolder(26);
            ++var12_18;
        }
        var12_19 = new ArrayList<Pair<Rectangle, String>>(32);
        var13_20 = new boolean[this.params.allPlayersOnOneChart != false ? 1 : var3_3.length][5];
        var14_21 = 0;
        while (var14_21 < 5) {
            var15_22 = 0;
            while (var15_22 < var3_3.length) {
                var5_9 = var3_3[var15_22];
                var16_23 = this.params.chartY2s[var15_22];
                var17_24 = var11_17[this.params.allPlayersOnOneChart != false ? 0 : var15_22];
                var18_25 = var13_20[this.params.allPlayersOnOneChart != false ? 0 : var15_22];
                if (var14_21 > 0) {
                    v0 = var14_21;
                    var18_25[v0] = var18_25[v0] | var18_25[var14_21 - 1];
                }
                this.g2.setColor(var14_21 == 2 || var14_21 == 3 ? this.params.replay.details.players[this.params.chartPlayerIndices[var15_22]].getBrighterColor() : this.params.playerColors[this.params.chartPlayerIndices[var15_22]]);
                var19_26 = false;
                if (var14_21 == 0 && var5_9.unitList.size() > 0) {
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.unitList) {
                        this.drawStatBar(var12_19, Icons.getUnitIcon((ReplayConsts.Unit)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.unitCountMap.get((Object)var20_27).value, var8_8[0][var15_22], var16_23);
                    }
                }
                if (var14_21 == 1 && var5_9.buildingList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.buildingList) {
                        this.drawStatBar(var12_19, Icons.getBuildingIcon((ReplayConsts.Building)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.buildingCountMap.get((Object)var20_27).value, var8_8[1][var15_22], var16_23);
                    }
                }
                if (var14_21 == 2 && var5_9.researchList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.researchList) {
                        this.drawStatBar(var12_19, Icons.getResearchIcon((ReplayConsts.Research)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.researchCountMap.get((Object)var20_27).value, var8_8[2][var15_22], var16_23);
                    }
                }
                if (var14_21 == 3 && var5_9.upgradeList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.upgradeList) {
                        this.drawStatBar(var12_19, Icons.getUpgradeIcon((ReplayConsts.Upgrade)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.upgradeCountMap.get((Object)var20_27).value, var8_8[3][var15_22], var16_23);
                    }
                }
                if (var14_21 == 4 && var5_9.abilityGroupList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.abilityGroupList) {
                        this.drawStatBar(var12_19, Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.abilityGroupCountMap.get((Object)var20_27).value, var8_8[4][var15_22], var16_23);
                    }
                }
                v1 = var14_21;
                var18_25[v1] = var18_25[v1] | var19_26;
                ++var15_22;
            }
            ++var14_21;
        }
        this.params.toolTipProvider = new ChartParams.StaticToolTipProvider(var12_19);
    }

    private void drawStatBar(List<Pair<Rectangle, String>> list, Icon icon, Object object, IntHolder intHolder, int n, int n2, int n3, int n4) {
        int n5 = icon.getIconWidth();
        icon.paintIcon(this.params.chartCanvas, this.g2, intHolder.value, n4 - icon.getIconHeight() + 1);
        int n6 = n4 - icon.getIconHeight();
        int n7 = n * n2 / n3;
        int n8 = n7 < 1 ? 1 : n7;
        this.g2.fill3DRect(intHolder.value, n6 - n8, n5, n8, true);
        Color color = this.g2.getColor();
        this.g2.setColor(COLOR_PLAYER_DEFAULT);
        String string = Integer.toString(n2);
        this.g2.drawString(string, intHolder.value + (n5 - this.g2.getFontMetrics().stringWidth(string) >> 1), n6 - n8 - 1);
        this.g2.setColor(color);
        list.add(new Pair<Rectangle, String>(new Rectangle(intHolder.value, n6 - n8, n5, n4 - n6 + n8), object.toString()));
        intHolder.value += n5;
    }

    private static int maxOfMap(Map<?, IntHolder> map) {
        int n = 0;
        if (map != null) {
            for (IntHolder intHolder : map.values()) {
                if (n >= intHolder.value) continue;
                n = intHolder.value;
            }
        }
        return n;
    }

    private void paintUnitTiersChart() {
        Map<ReplayConsts.Unit, IntHolder> map;
        int n;
        int n2;
        ReplayConsts.UnitTier[] unitTierArray = ReplayConsts.UnitTier.values();
        int n3 = this.params.width / this.params.unitTiersGranularity + (this.params.width % this.params.unitTiersGranularity != 0 ? 1 : 0);
        int[][][] nArray = new int[this.params.chartPlayerIndices.length][n3][unitTierArray.length];
        int[][] nArray2 = new int[this.params.chartPlayerIndices.length][n3];
        Map[][] mapArray = new Map[this.params.chartPlayerIndices.length][n3];
        GameEvents.Action[] actionArray = this.params.actions;
        int n4 = actionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            EntityParams entityParams;
            ReplayConsts.UnitTier unitTier;
            GameEvents.Action action = actionArray[n5];
            int n6 = this.params.playerChartIndices[action.player];
            if (n6 >= 0 && action instanceof GameEvents.BaseUseAbilityAction && (unitTier = ((GameEvents.BaseUseAbilityAction)action).getUnitTier()) != null && (n2 = (this.params.frameToX(n = this.params.showAfterCompleted ? action.frame + ((entityParams = ((GameEvents.BaseUseAbilityAction)action).getEntityParams()) == null ? 0 : entityParams.time << 6) : action.frame) - 25) / this.params.unitTiersGranularity) < n3) {
                IntHolder intHolder;
                int[] nArray3 = nArray[n6][n2];
                int n7 = unitTier.ordinal();
                nArray3[n7] = nArray3[n7] + 1;
                int[] nArray4 = nArray2[n6];
                int n8 = n2;
                nArray4[n8] = nArray4[n8] + 1;
                ReplayConsts.Unit unit = action instanceof GameEvents.TrainAction ? ((GameEvents.TrainAction)action).unit : ((GameEvents.UseUnitAbilityAction)action).unitAbility.transformationTargetUnit;
                map = mapArray[n6][n2];
                if (map == null) {
                    TreeMap<ReplayConsts.Unit, IntHolder> treeMap = new TreeMap<ReplayConsts.Unit, IntHolder>(ReplayUtils.UNIT_TIER_REVERSE_COMPARATOR);
                    mapArray[n6][n2] = treeMap;
                    map = treeMap;
                }
                if ((intHolder = (IntHolder)map.get((Object)unit)) == null) {
                    map.put(unit, new IntHolder(1));
                } else {
                    ++intHolder.value;
                }
            }
            ++n5;
        }
        int[] nArray5 = new int[this.params.chartPlayerIndices.length];
        int n9 = 0;
        while (n9 < nArray2.length) {
            nArray5[n9] = GeneralUtils.maxValue(nArray2[n9]);
            ++n9;
        }
        ArrayList arrayList = new ArrayList(this.params.chartPlayerIndices.length * n3);
        n = this.g2.getFontMetrics().getAscent();
        n2 = Math.max(0, this.params.chartHeight - n);
        int n10 = 0;
        while (n10 < nArray.length) {
            int n11 = nArray5[n10];
            if (n11 != 0) {
                int[][] nArray6 = nArray[n10];
                int[] nArray7 = nArray2[n10];
                int n12 = this.params.chartY2s[n10] + 1;
                int n13 = nArray6.length - 1;
                while (n13 >= 0) {
                    int n14 = this.params.chartX1 + n13 * this.params.unitTiersGranularity + 1;
                    int n15 = this.params.stretchBars ? nArray2[n10][n13] : n11;
                    int[] nArray8 = nArray6[n13];
                    int n16 = 0;
                    int n17 = n12;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < nArray8.length) {
                        if (nArray8[n19] > 0) {
                            this.g2.setColor(unitTierArray[n19].color);
                            n18 = n12 - (n16 += nArray8[n19]) * n2 / n15;
                            this.g2.fillRect(n14, n18, this.params.unitTiersGranularity, n17 - n18);
                            n17 = n18;
                        }
                        ++n19;
                    }
                    this.g2.setColor(COLOR_PLAYER_DEFAULT);
                    String string = Integer.toString(nArray7[n13]);
                    int n20 = n14 + (this.params.unitTiersGranularity - this.g2.getFontMetrics().stringWidth(string) >> 1);
                    if (n20 + this.g2.getFontMetrics().stringWidth(string) > this.params.chartX2) {
                        n20 = this.params.chartX2 - this.g2.getFontMetrics().stringWidth(string);
                    }
                    this.g2.drawString(string, n20, n18 - 1);
                    map = mapArray[n10][n13];
                    if (map != null) {
                        arrayList.add(new Pair(new Rectangle(n14, n18, this.params.unitTiersGranularity, n12 - n18), new Pair(map, nArray8)));
                    }
                    --n13;
                }
            }
            ++n10;
        }
        this.params.toolTipProvider = new ChartParams.DeferredToolTipProvider<Pair<Map<ReplayConsts.Unit, IntHolder>, int[]>>(arrayList, new Producer<Pair<Map<ReplayConsts.Unit, IntHolder>, int[]>, String>(){

            @Override
            public String produce(Pair<Map<ReplayConsts.Unit, IntHolder>, int[]> pair) {
                Map map = (Map)pair.value1;
                int[] nArray = (int[])pair.value2;
                StringBuilder stringBuilder = new StringBuilder("<html><table border=1>");
                ReplayConsts.UnitTier unitTier = null;
                for (Map.Entry entry : map.entrySet()) {
                    if (unitTier != ((ReplayConsts.Unit)((Object)entry.getKey())).unitTier) {
                        unitTier = ((ReplayConsts.Unit)((Object)entry.getKey())).unitTier;
                        stringBuilder.append("<tr><td style='background:#").append(unitTier.htmlColor).append("'>&nbsp;&nbsp;&nbsp;<td><b>").append(unitTier.stringValue).append("</b>").append("<td>&sum;=").append(nArray[unitTier.ordinal()]).append("<td>");
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((ReplayConsts.Unit)((Object)entry.getKey())).stringValue);
                    if (((IntHolder)entry.getValue()).value <= 1) continue;
                    stringBuilder.append(" x").append(((IntHolder)entry.getValue()).value);
                }
                stringBuilder.append("</table></html>");
                return stringBuilder.toString();
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void paintMapViewChart() {
        block53: {
            this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.params.mapViewQuality.hintValue);
            var1_1 = this.params.replay.mapInfo;
            if (this.params.replay.mapInfo == null) {
                this.g2.setColor(Color.WHITE);
                this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewChartNotAvailable1"), 10, 20);
                this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewChartNotAvailable2"), 10, 20 + this.g2.getFontMetrics().getHeight());
                this.params.toolTipProvider = new ChartParams.StaticToolTipProvider(new ArrayList<Pair<Rectangle, String>>(0));
                return;
            }
            if (var1_1.mapObjectList == null) {
                MapParser.parseExtendedMapInfo(this.params.replay);
            }
            var2_2 = this.params.markerFrame != null ? this.params.markerFrame : (this.params.markerX != null ? this.params.xToFrame(this.params.markerX) : this.params.replay.frames);
            var3_3 = this.params.actions;
            var4_4 = new ArrayList<Pair<Object, Pair<Object, MapInfo.MapObject>>>(128);
            var5_5 = this.params.zoom << 1;
            var6_6 = var1_1.width * var5_5;
            var7_7 = var1_1.height * var5_5;
            this.g2.setColor(Color.LIGHT_GRAY);
            this.g2.drawLine(var6_6, 0, var6_6, var7_7);
            this.g2.drawLine(0, var7_7, var6_6, var7_7);
            if (var5_5 <= 2) {
                this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewZoomTip"), var6_6 + 5, 20);
            }
            if (this.params.mapBackground.requiresMapImage) {
                this.g2.drawImage(var1_1.previewIcon.getImage(), var1_1.boundaryLeft * var5_5, (var1_1.height - var1_1.boundaryTop) * var5_5, var1_1.previewIcon.getIconWidth() * var5_5, var1_1.previewIcon.getIconHeight() * var5_5, null);
            }
            var9_8 = var3_3.length;
            var10_9 = new GameEvents.Action[this.params.playerChartIndices.length];
            if (!this.params.mapBackground.involvesAreaAggregation) break block53;
            var11_10 = this.params.mapBackground == ReplayAnalyzer.MapBackground.HOT_AREAS || this.params.mapBackground == ReplayAnalyzer.MapBackground.MAP_IMAGE_AND_HOT_AREAS;
            var12_13 = this.params.areaGranularityCount;
            var13_16 /* !! */  = new int[var12_13][var12_13];
            var14_18 /* !! */  = 0;
            if (true) ** GOTO lbl54
            do {
                if (this.params.playerChartIndices[var8_21.player] >= 0) {
                    if (var11_10) {
                        if (var8_21 instanceof GameEvents.BaseUseAbilityAction) {
                            var15_22 /* !! */  = (GameEvents.BaseUseAbilityAction)var8_21;
                            if (!var15_22 /* !! */ .targetIsUnit && var15_22 /* !! */ .targetP1 != 256 && var15_22 /* !! */ .targetP2 != 256) {
                                v0 = var13_16 /* !! */ [var12_13 * (var1_1.height - (var15_22 /* !! */ .targetP2 >> 16)) / var1_1.height];
                                v1 = var12_13 * (var15_22 /* !! */ .targetP1 >> 16) / var1_1.width;
                                v0[v1] = v0[v1] + 1;
                            }
                        }
                    } else if (var8_21 instanceof GameEvents.MoveScreenAction) {
                        var15_22 /* !! */  = (GameEvents.MoveScreenAction)var10_9[var8_21.player];
                        if (var15_22 /* !! */  != null) {
                            v2 = var13_16 /* !! */ [var12_13 * (var1_1.height - (var15_22 /* !! */ .y >> 8)) / var1_1.height];
                            v3 = var12_13 * (var15_22 /* !! */ .x >> 8) / var1_1.width;
                            v2[v3] = v2[v3] + (var8_21.frame - var15_22 /* !! */ .frame);
                        }
                        var10_9[var8_21.player] = var8_21;
                    } else if (var8_21 instanceof GameEvents.LeaveGameAction) {
                        var10_9[var8_21.player] = null;
                    }
                }
                ++var14_18 /* !! */ ;
lbl54:
                // 2 sources

                if (var14_18 /* !! */  >= var9_8) break;
                var8_21 = var3_3[var14_18 /* !! */ ];
            } while (var8_21.frame <= var2_2);
            if (!var11_10) {
                var14_18 /* !! */  = 0;
                while (var14_18 /* !! */  < var10_9.length) {
                    var15_22 /* !! */  = (GameEvents.MoveScreenAction)var10_9[var14_18 /* !! */ ];
                    if (var10_9[var14_18 /* !! */ ] != null) {
                        v4 = var13_16 /* !! */ [var12_13 * (var1_1.height - (var15_22 /* !! */ .y >> 8)) / var1_1.height];
                        v5 = var12_13 * (var15_22 /* !! */ .x >> 8) / var1_1.width;
                        v4[v5] = v4[v5] + (var2_2 - var15_22 /* !! */ .frame);
                    }
                    ++var14_18 /* !! */ ;
                }
            }
            var14_18 /* !! */  = 0;
            var18_27 = var13_16 /* !! */ ;
            var17_31 = var13_16 /* !! */ .length;
            var16_37 = 0;
            while (var16_37 < var17_31) {
                var22_53 /* !! */  = var15_22 /* !! */  = (GameEvents.Action[])var18_27[var16_37];
                var21_51 = var15_22 /* !! */ .length;
                var20_47 = 0;
                while (var20_47 < var21_51) {
                    var19_43 = var22_53 /* !! */ [var20_47];
                    if (var19_43 > var14_18 /* !! */ ) {
                        var14_18 /* !! */  = (int)var19_43;
                    }
                    ++var20_47;
                }
                ++var16_37;
            }
            var15_23 = var13_16 /* !! */ .length - 1;
            while (var15_23 >= 0) {
                var16_38 = var13_16 /* !! */ [var15_23];
                var17_31 = var16_38.length - 1;
                while (var17_31 >= 0) {
                    var18_28 = var14_18 /* !! */  == 0 ? 255 : var16_38[var17_31] * 255 / var14_18 /* !! */ ;
                    this.g2.setColor(this.params.mapBackground.requiresMapImage != false ? new Color(var18_28, var18_28 / 2, var18_28 / 2, 128) : new Color(var18_28, var18_28 / 2, var18_28 / 2));
                    var19_43 = var17_31 * var6_6 / var12_13;
                    var20_47 = var15_23 * var7_7 / var12_13;
                    this.g2.fillRect((int)var19_43, var20_47, (var17_31 + 1) * var6_6 / var12_13 - var19_43, (var15_23 + 1) * var7_7 / var12_13 - var20_47);
                    --var17_31;
                }
                --var15_23;
            }
        }
        if (this.params.showMapObjects && var1_1.mapObjectList != null) {
            for (Pair<MapInfo.MapObject, Point> var11_11 : var1_1.mapObjectList) {
                this.g2.setColor(ChartPainter.MAP_OBJECT_COLOR_MAP.get(var11_11.value1));
                var13_16 /* !! */  = (int[][])new Rectangle(((MapInfo.MapObject)var11_11.value1).width * var5_5, ((MapInfo.MapObject)var11_11.value1).height * var5_5);
                var13_16 /* !! */ .x = this.params.scaleMapCoord(((Point)var11_11.value2).x) - (var13_16 /* !! */ .width >> 1);
                var13_16 /* !! */ .y = var7_7 - this.params.scaleMapCoord(((Point)var11_11.value2).y) - (var13_16 /* !! */ .height >> 1);
                this.g2.fillRect(var13_16 /* !! */ .x, var13_16 /* !! */ .y, var13_16 /* !! */ .width, var13_16 /* !! */ .height);
                if (((MapInfo.MapObject)var11_11.value1).toolTip == null) continue;
                var4_4.add(new Pair<int[][], Pair<Object, MapInfo.MapObject>>(var13_16 /* !! */ , new Pair<Object, MapInfo.MapObject>(null, (MapInfo.MapObject)var11_11.value1)));
            }
        }
        var11_12 = new ArrayList<Pair<GameEvents.BuildAction, Object>>(128);
        var13_17 = this.params.replay.details.players.length - 1;
        while (var13_17 >= 0) {
            block52: {
                if (this.params.playerChartIndices[var13_17] >= 0) {
                    var12_15 = this.params.replay.details.players[var13_17];
                    if (var12_15.startLocation != null) {
                        var14_19 = null;
                        var15_25 = var12_15.finalRace;
                        if (!var15_25.isConcrete) {
                            var16_39 = 0;
                            while (var16_39 < var9_8) {
                                var8_21 = var3_3[var16_39];
                                if (var8_21.player == var13_17 && var8_21 instanceof GameEvents.TrainAction) {
                                    var15_25 = ((GameEvents.TrainAction)var8_21).unit.raceOfUnit();
                                    break;
                                }
                                ++var16_39;
                            }
                        }
                        switch (ChartPainter.$SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race()[var15_25.ordinal()]) {
                            case 1: {
                                var14_19 = ReplayConsts.Building.NEXUS;
                                break;
                            }
                            case 2: {
                                var14_19 = ReplayConsts.Building.COMMAND_CENTER;
                                break;
                            }
                            case 3: {
                                var14_19 = ReplayConsts.Building.HATCHERY;
                                break;
                            }
                            default: {
                                break block52;
                            }
                        }
                        v6 = this.params.replay.gameEvents;
                        v6.getClass();
                        var16_40 = v6.new GameEvents.BuildAction(var14_19);
                        var16_40.player = (byte)var13_17;
                        var17_32 = new Rectangle(var16_40.building.width * var5_5, var16_40.building.height * var5_5);
                        var17_32.x = this.params.scaleMapCoord(var12_15.startLocation.x) - (var17_32.width >> 1);
                        var17_32.y = var7_7 - this.params.scaleMapCoord(var12_15.startLocation.y) - (var17_32.height >> 1);
                        var11_12.add(new Pair<GameEvents.BuildAction, Rectangle>(var16_40, var17_32));
                    }
                }
            }
            --var13_17;
        }
        var13_17 = (int)this.params.hideOverlappedBuildings;
        var14_20 = this.params.mapBackground == ReplayAnalyzer.MapBackground.HOT_POINTS || this.params.mapBackground == ReplayAnalyzer.MapBackground.MAP_IMAGE_AND_HOT_POINTS;
        var15_26 = var5_5 << 1;
        var16_41 = 0;
        if (true) ** GOTO lbl183
        do {
            if (this.params.playerChartIndices[var8_21.player] >= 0) {
                if (var8_21 instanceof GameEvents.MoveScreenAction) {
                    var10_9[var8_21.player] = var8_21;
                } else if (var8_21 instanceof GameEvents.BuildAction && (var17_33 = (GameEvents.BuildAction)var8_21).hasTargetPoint()) {
                    var18_27 = new Rectangle(var17_33.building.width * var5_5, var17_33.building.height * var5_5);
                    var18_27.x = this.params.scaleMapCoord(var17_33.targetP1) - (var18_27.width >> 1);
                    var18_27.y = var7_7 - this.params.scaleMapCoord(var17_33.targetP2) - (var18_27.height >> 1);
                    if (var13_17 != 0) {
                        var19_43 = var11_12.size() - 1;
                        while (var19_43 >= 0) {
                            if (var18_27.intersects((Rectangle)((Pair)var11_12.get((int)var19_43)).value2)) {
                                var11_12.remove((int)var19_43);
                            }
                            --var19_43;
                        }
                    }
                    var11_12.add(new Pair<GameEvents.BuildAction, Object>(var17_33, var18_27));
                }
                if (var14_20 && var8_21 instanceof GameEvents.BaseUseAbilityAction) {
                    var17_34 = (GameEvents.BaseUseAbilityAction)var8_21;
                    if (!var17_34.targetIsUnit && var17_34.targetP1 != 256 && var17_34.targetP2 != 256) {
                        var18_29 = this.params.scaleMapCoord(var17_34.targetP1) - (var15_26 >> 1);
                        var19_43 = var7_7 - this.params.scaleMapCoord(var17_34.targetP2) - (var15_26 >> 1);
                        this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[this.params.playerChartIndices[var17_34.player]]]);
                        this.g2.fillOval(var18_29, (int)var19_43, var15_26, var15_26);
                    }
                }
            }
            ++var16_41;
lbl183:
            // 2 sources

            if (var16_41 >= var9_8) break;
            var8_21 = var3_3[var16_41];
        } while (var8_21.frame <= var2_2);
        var16_42 = this.params.replay.converterGameSpeed;
        var18_27 = var11_12.iterator();
        while (var18_27.hasNext()) {
            var17_35 = (Pair)var18_27.next();
            var19_44 = (GameEvents.BuildAction)var17_35.value1;
            this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[this.params.playerChartIndices[var19_44.player]]]);
            var20_49 = (Rectangle)var17_35.value2;
            if (this.params.fillBuildingIcons) {
                this.g2.fillRect(var20_49.x, var20_49.y, var20_49.width, var20_49.height);
            } else {
                var21_52 = Icons.getBuildingIcon(var19_44.building, IconHandler.Size.BIG);
                if (var21_52 instanceof ImageIcon) {
                    var22_53 /* !! */  = ((ImageIcon)var21_52).getImage();
                    this.g2.drawImage((Image)var22_53 /* !! */ , var20_49.x, var20_49.y, var20_49.width, var20_49.height, null);
                    this.g2.drawRect(var20_49.x, var20_49.y, var20_49.width, var20_49.height);
                }
            }
            var4_4.add(new Pair<Rectangle, Pair<GameEvents.BuildAction, Object>>(var20_49, new Pair<GameEvents.BuildAction, Object>(var19_44, null)));
        }
        var17_36 = 25 * var5_5;
        var18_30 = 15 * var5_5;
        this.g2.setStroke(ChartPainter.STROKE_DOUBLE_WIDTH);
        var22_53 /* !! */  = var10_9;
        var21_51 = var10_9.length;
        var20_50 = 0;
        while (var20_50 < var21_51) {
            var19_45 = var22_53 /* !! */ [var20_50];
            if (var19_45 != null) {
                this.g2.setColor(this.params.playerColors[var19_45.player]);
                var23_54 = (GameEvents.MoveScreenAction)var19_45;
                this.g2.drawRect((var23_54.x * var5_5 >> 8) - (var17_36 >> 1), var7_7 - (var23_54.y * var5_5 >> 8) - (var18_30 >> 1), var17_36, var18_30);
            }
            ++var20_50;
        }
        this.g2.setStroke(ChartPainter.STROKE_DEFAULT);
        if (this.params.selectedAction instanceof GameEvents.BaseUseAbilityAction && (var19_46 = (GameEvents.BaseUseAbilityAction)this.params.selectedAction).hasTargetPoint()) {
            var20_50 = this.params.scaleMapCoord(var19_46.targetP1);
            var21_51 = var7_7 - this.params.scaleMapCoord(var19_46.targetP2);
            this.g2.setColor(Color.RED);
            this.g2.drawLine(var20_50, var21_51 - var5_5, var20_50, var21_51 + var5_5);
            this.g2.drawLine(var20_50 - var5_5, var21_51, var20_50 + var5_5, var21_51);
            this.g2.setColor(Color.WHITE);
            this.g2.drawRect(var20_50 - var5_5, var21_51 - var5_5, var5_5 * 2, var5_5 * 2);
        }
        this.params.toolTipProvider = new ChartParams.DeferredToolTipProvider<Pair<GameEvents.BuildAction, MapInfo.MapObject>>(var4_4, (Producer)new Producer<Pair<GameEvents.BuildAction, MapInfo.MapObject>, String>(){

            @Override
            public String produce(Pair<GameEvents.BuildAction, MapInfo.MapObject> pair) {
                if (pair.value1 != null) {
                    GameEvents.BuildAction buildAction = (GameEvents.BuildAction)pair.value1;
                    return String.valueOf(buildAction.building.stringValue) + " (" + ChartPainter.this.params.replay.details.players[buildAction.player].playerId.name + (buildAction.frame == 0 ? ")" : "); " + Language.getText("module.repAnalyzer.tab.charts.chartTooltip.frameTime", buildAction.frame, ReplayUtils.formatFramesShort(buildAction.frame, var16_42)));
                }
                if (pair.value2 != null) {
                    return ((MapInfo.MapObject)((Object)pair.value2)).toolTip;
                }
                return null;
            }
        }){

            @Override
            public String getToolTip(Point point) {
                String string = super.getToolTip(point);
                if (string != null) {
                    return string;
                }
                if (point.x < var6_6 && point.y < var7_7) {
                    return "x=" + ReplayUtils.formatCoordinate((int)((float)point.x * 65536.0f * (float)var1_1.width / (float)var6_6)) + ", y=" + ReplayUtils.formatCoordinate((int)((float)(var7_7 - point.y) * 65536.0f * (float)var1_1.height / (float)var7_7));
                }
                return null;
            }
        };
    }

    private void paintMainBuildingControl() {
        Object object;
        List[] listArray = new List[this.params.chartPlayerIndices.length];
        GameEvents.Action[] actionArray = this.params.actions;
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameEvents.Action action = actionArray[n2];
            int n3 = this.params.playerChartIndices[action.player];
            if (n3 >= 0 && action instanceof GameEvents.UseUnitAbilityAction) {
                GameEvents.UseUnitAbilityAction useUnitAbilityAction = (GameEvents.UseUnitAbilityAction)action;
                if (useUnitAbilityAction.unitAbility == ReplayConsts.UnitAbility.SPAWN_LARVA) {
                    if (listArray[n3] == null) {
                        listArray[n3] = new ArrayList();
                    }
                    object = null;
                    for (Pair pair : listArray[n3]) {
                        if ((Integer)pair.value1 != useUnitAbilityAction.targetP1) continue;
                        object = pair;
                        break;
                    }
                    if (object == null) {
                        object = new Pair(useUnitAbilityAction.targetP1, new ArrayList());
                        listArray[n3].add(object);
                    }
                    if (!((List)((Pair)object).value2).isEmpty() && (Integer)((List)((Pair)object).value2).get(((List)((Pair)object).value2).size() - 1) + 2560 > action.frame) {
                        ((List)((Pair)object).value2).remove(((List)((Pair)object).value2).size() - 1);
                    }
                    ((List)((Pair)object).value2).add(action.frame);
                }
            }
            ++n2;
        }
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        int n4 = 0;
        while (n4 < listArray.length) {
            object = listArray[n4];
            if (object != null && !object.isEmpty()) {
                int n5 = this.params.chartX1 + 3;
                int n6 = this.params.chartY1s[n4] + 1;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = this.getChartLastActionFrame(n4);
                int n12 = (this.params.chartHeight - object.size()) / object.size();
                int n13 = this.g2.getFontMetrics().getAscent();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    int n14 = n11 - (Integer)((List)pair.value2).get(0);
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[n4]]);
                    int n18 = ((List)pair.value2).size();
                    int n19 = 0;
                    while (n19 < n18) {
                        int n20 = (Integer)((List)pair.value2).get(n19);
                        int n21 = this.params.frameToX(n20);
                        int n22 = this.params.frameToX(n20 + 2560);
                        this.g2.fillRect(n21, n6, n22 - n21 + 1, n12);
                        n15 += Math.min(2560, n11 - n20);
                        if (n19 < n18 - 1) {
                            n16 += (Integer)((List)pair.value2).get(n19 + 1) - n20 - 2560;
                            ++n17;
                        }
                        ++n19;
                    }
                    this.g2.setColor(this.params.replay.details.players[this.params.chartPlayerIndices[n4]].getBrighterColor());
                    this.g2.drawString("Hatchery " + Integer.toHexString((Integer)pair.value1) + " (" + (n14 == 0 ? "N/A" : String.valueOf(n15 * 100 / n14) + "%") + ", " + (n17 == 0 ? "N/A" : String.valueOf(ReplayUtils.formatFramesDecimal(n16 / n17, this.params.replay.converterGameSpeed)) + " " + Language.getText("module.repAnalyzer.tab.charts.chartText.sec")) + ")", n5 + this.params.visibleRectangle.x, n6 + (n12 + n13 >> 1));
                    n7 += n14;
                    n8 += n15;
                    n9 += n16;
                    n10 += n17;
                    n6 += n12 + 1;
                }
                this.descriptionBuilders[n4].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.avgSpawningRatio", n7 == 0 ? "N/A" : String.valueOf(n8 * 100 / n7) + "%")).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.avgInjectionGap", n10 == 0 ? "N/A" : String.valueOf(ReplayUtils.formatFramesDecimal(n9 / n10, this.params.replay.converterGameSpeed)) + " " + Language.getText("module.repAnalyzer.tab.charts.chartText.sec")));
            }
            ++n4;
        }
        this.g2.setFont(font);
    }

    /*
     * Unable to fully structure code
     */
    private void paintProductionsChart() {
        var1_1 = this.params.markerFrame == null ? (this.params.markerX == null ? this.params.replay.frames : this.params.xToFrame(this.params.markerX)) : this.params.markerFrame;
        var2_2 = this.params.actions;
        var3_3 = this.params.groupSameProductions;
        var4_4 = EnumSet.of(ReplayConsts.AbilityGroup.ARCHON_WARP, new ReplayConsts.AbilityGroup[]{ReplayConsts.AbilityGroup.ARM_SILO_WITH_NUKE, ReplayConsts.AbilityGroup.MORPH_TO_BANELING, ReplayConsts.AbilityGroup.MORPH_TO_BROOD_LORD, ReplayConsts.AbilityGroup.MORPH_TO_OVERSEER, ReplayConsts.AbilityGroup.MUTATE_INTO_A_GATEWAY, ReplayConsts.AbilityGroup.MUTATE_INTO_GREATER_SPIRE, ReplayConsts.AbilityGroup.MUTATE_INTO_HIVE, ReplayConsts.AbilityGroup.MUTATE_INTO_LAIR, ReplayConsts.AbilityGroup.SPAWN_CREEP_TUMOR, ReplayConsts.AbilityGroup.TRAIN_AN_INTERCEPTOR, ReplayConsts.AbilityGroup.UPGRADE_TO_ORBITAL_COMMAND, ReplayConsts.AbilityGroup.UPGRADE_TO_PLANETARY_FORTRESS, ReplayConsts.AbilityGroup.UPGRADE_TO_WARP_GATE});
        var5_5 = this.params.iconSizesP;
        var6_6 = Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, var5_5).getIconWidth() - 2;
        var7_7 = new List[this.params.chartPlayerIndices.length];
        var8_8 = var7_7.length - 1;
        while (var8_8 >= 0) {
            var7_7[var8_8] = new ArrayList<E>(var3_3 != false ? 10 : 20);
            --var8_8;
        }
        var10_10 = var2_2.length;
        var12_11 = 0;
        if (true) ** GOTO lbl61
        do {
            if ((var11_14 = this.params.playerChartIndices[var8_9.player]) >= 0 && var8_9 instanceof GameEvents.BaseUseAbilityAction && (var9_13 = ((GameEvents.BaseUseAbilityAction)var8_9).getEntityParams()) != null && var9_13.time > 0 && var8_9.frame + (var9_13.time << 6) >= var1_1) {
                var13_15 = null;
                var14_16 = null;
                switch (ChartPainter.$SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType()[var8_9.type.ordinal()]) {
                    case 3: {
                        var15_18 = ((GameEvents.TrainAction)var8_9).unit;
                        var13_15 = var15_18;
                        var14_16 = var15_18.stringValue;
                        break;
                    }
                    case 2: {
                        var15_18 = ((GameEvents.BuildAction)var8_9).building;
                        var13_15 = var15_18;
                        var14_16 = var15_18.stringValue;
                        break;
                    }
                    case 4: {
                        var15_18 = ((GameEvents.ResearchAction)var8_9).research;
                        var13_15 = var15_18;
                        var14_16 = var15_18.stringValue;
                        break;
                    }
                    case 5: {
                        var15_18 = ((GameEvents.UpgradeAction)var8_9).upgrade;
                        var13_15 = var15_18;
                        var14_16 = var15_18.stringValue;
                        break;
                    }
                    default: {
                        var15_18 = ((GameEvents.BaseUseAbilityAction)var8_9).abilityGroup;
                        if (!var4_4.contains(var15_18)) break;
                        var13_15 = var15_18;
                        var14_16 = var15_18.stringValue;
                    }
                }
                if (var13_15 != null) {
                    var15_19 = var6_6 * (var1_1 - var8_9.frame) / (var9_13.time << 6);
                    var16_21 = var7_7[var11_14];
                    var17_22 = 1;
                    if (var3_3) {
                        for (ProductionStat var18_23 : var16_21) {
                            if (var18_23.entity != var13_15) continue;
                            var17_22 = 0;
                            ++var18_23.count;
                            var18_23.completionBarWidth = Math.max(var15_19, var18_23.completionBarWidth);
                            break;
                        }
                    }
                    if (var17_22 != 0) {
                        var16_21.add(new ProductionStat(var13_15, var14_16, var15_19));
                    }
                }
            }
            ++var12_11;
lbl61:
            // 2 sources

            if (var12_11 >= var10_10) break;
            var8_9 = var2_2[var12_11];
        } while (var8_9.frame <= var1_1);
        var12_12 = new ArrayList<Pair<Rectangle, String>>(128);
        var13_15 = this.g2.getFont();
        this.g2.setFont(new Font(var13_15.getName(), 1, var13_15.getSize()));
        var14_17 = Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, var5_5).getIconHeight() >> 2;
        var15_20 = 0;
        while (var15_20 < var7_7.length) {
            var16_21 = var7_7[var15_20];
            var17_22 = this.params.chartX1 + 1;
            var18_24 = this.params.chartY1s[var15_20] + 1;
            var19_26 = 0;
            while (var19_26 < var16_21.size()) {
                var20_27 = (ProductionStat)var16_21.get(var19_26);
                var21_28 = Icons.getEntityIcon(var20_27.entity, var5_5);
                var22_29 = var21_28.getIconWidth();
                var23_30 = var21_28.getIconHeight();
                if (var17_22 + var22_29 > this.params.chartX2 && var18_24 + (var23_30 + var14_17 + 1 << 1) < this.params.chartY2s[var15_20]) {
                    var17_22 = this.params.chartX1 + 1;
                    var18_24 += var23_30 + var14_17 + 1;
                }
                var21_28.paintIcon(this.params.chartCanvas, this.g2, var17_22, var18_24);
                var12_12.add(new Pair<Rectangle, String>(new Rectangle(var17_22, var18_24, var22_29, var23_30), var20_27.count == 1 ? var20_27.entityName : String.valueOf(var20_27.entityName) + " x" + var20_27.count));
                if (var3_3) {
                    this.g2.setColor(Color.WHITE);
                    var24_31 = Integer.toString(var20_27.count);
                    this.g2.drawString(var24_31, var17_22 + var22_29 - this.g2.getFontMetrics().stringWidth(var24_31), var18_24 + var23_30);
                }
                this.g2.setColor(ReplayConsts.PlayerColor.GREEN.color);
                this.g2.drawRect(var17_22 + 1, var18_24 + 1 + var23_30, var22_29 - 2, var14_17);
                this.g2.setColor(ReplayConsts.PlayerColor.DARK_GREEN.color);
                this.g2.fillRect(var17_22 + 2, var18_24 + 1 + var23_30 + 1, var6_6, var14_17 - 1);
                this.g2.setColor(ReplayConsts.PlayerColor.LIGHT_GREEN.color);
                this.g2.fillRect(var17_22 + 2, var18_24 + 1 + var23_30 + 1, var20_27.completionBarWidth, var14_17 - 1);
                var17_22 += var22_29;
                ++var19_26;
            }
            ++var15_20;
        }
        this.g2.setFont((Font)var13_15);
        this.params.toolTipProvider = new ChartParams.StaticToolTipProvider(var12_12);
    }

    /*
     * Unable to fully structure code
     */
    private void paintPlayerSelectionsChart() {
        var1_1 = new PlayerSelectionTracker[this.params.playerColors.length];
        var2_2 = 0;
        while (var2_2 < var1_1.length) {
            var1_1[var2_2] = this.params.playerChartIndices[var2_2] < 0 ? null : new PlayerSelectionTracker();
            ++var2_2;
        }
        var2_3 = this.params.actions;
        var3_4 = this.params.markerFrame != null ? this.params.markerFrame : (this.params.markerX != null ? this.params.xToFrame(this.params.markerX) : this.params.replay.frames);
        var5_5 = var2_3.length;
        var6_6 = 0;
        if (true) ** GOTO lbl20
        do {
            if (var1_1[var4_7.player] != null) {
                if (var4_7 instanceof GameEvents.SelectAction) {
                    var1_1[var4_7.player].processSelectAction((GameEvents.SelectAction)var4_7);
                } else if (var4_7 instanceof GameEvents.HotkeyAction) {
                    var1_1[var4_7.player].processHotkeyAction((GameEvents.HotkeyAction)var4_7);
                }
            }
            ++var6_6;
lbl20:
            // 2 sources

            if (var6_6 >= var5_5) break;
            var4_7 = var2_3[var6_6];
        } while (var4_7.frame <= var3_4);
        var7_8 = new List[this.params.chartPlayerIndices.length];
        var11_9 = this.params.playerIndices;
        var10_10 = this.params.playerIndices.length;
        var9_12 = 0;
        while (var9_12 < var10_10) {
            var8_14 = var11_9[var9_12];
            if (var1_1[var8_14] != null) {
                var6_6 = this.params.playerChartIndices[var8_14];
                if (var7_8[var6_6] == null) {
                    var7_8[var6_6] = var1_1[var8_14].currentSelection;
                } else {
                    var7_8[var6_6].addAll(var1_1[var8_14].currentSelection);
                }
            }
            ++var9_12;
        }
        var8_15 = this.params.replay.gameEvents.abilityCodes;
        var9_13 = new Point[this.params.chartPlayerIndices.length];
        var10_10 = 0;
        while (var10_10 < var7_8.length) {
            var9_13[var10_10] = new Point(this.params.chartX1 + 1, this.params.chartY1s[var10_10] + 1);
            ++var10_10;
        }
        var10_11 = new Icon(){
            private final int width;
            private final int height;
            {
                this.width = IconHandler.NULL.get((Object)ChartPainter.this.params.iconSizesPS).getIconWidth();
                this.height = IconHandler.NULL.get((Object)ChartPainter.this.params.iconSizesPS).getIconHeight();
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(Color.gray);
                graphics.fillRect(n + 1, n2 + 1, this.width - 1, this.height - 1);
            }
        };
        var11_9 = new ArrayList<E>(256);
        var12_16 = 0;
        while (var12_16 < var7_8.length) {
            for (Short var13_18 : var7_8[var12_16]) {
                var15_21 = var8_15.UNIT_TYPE_NAME.get(var13_18);
                var16_22 = AbilityCodes.UNIT_NAME_OBJECT_MAP.get(var15_21);
                var17_23 = var16_22 == null ? var10_11 : Icons.getEntityIcon(var16_22, this.params.iconSizesPS);
                var18_24 = var9_13[var12_16];
                if (var18_24.x + var17_23.getIconWidth() > this.params.chartX2 && var18_24.y + (var17_23.getIconHeight() << 1) < this.params.chartY2s[var12_16]) {
                    var18_24.x = this.params.chartX1 + 1;
                    var18_24.y += var17_23.getIconHeight();
                }
                var17_23.paintIcon(this.params.chartCanvas, this.g2, var18_24.x, var18_24.y);
                var11_9.add(new Pair<Rectangle, String>(new Rectangle(var18_24.x, var18_24.y, var17_23.getIconWidth(), var17_23.getIconHeight()), var15_21));
                var18_24.x += var17_23.getIconWidth();
            }
            ++var12_16;
        }
        this.params.toolTipProvider = new ChartParams.StaticToolTipProvider((List<Pair<Rectangle, String>>)var11_9);
        var12_17 = this.params.replay.gameEvents.abilityCodes.UNIT_TYPE_NAME;
        var13_19 = 0;
        while (var13_19 < this.descriptionBuilders.length) {
            this.descriptionBuilders[var13_19].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.selection", new Object[]{PlayerSelectionTracker.getSelectionString(var7_8[var13_19], var12_17)}));
            ++var13_19;
        }
    }

    private void paintResourcesSpentChart() {
        List[] listArray = new List[this.params.chartPlayerIndices.length];
        List[] listArray2 = new List[this.params.chartPlayerIndices.length];
        int n = 0;
        while (n < this.params.chartPlayerIndices.length) {
            listArray[n] = new ArrayList(256);
            listArray2[n] = new ArrayList(128);
            listArray[n].add(new Point(25, 0));
            listArray2[n].add(new Point(25, 0));
            ++n;
        }
        GameEvents.Action[] actionArray = this.params.actions;
        int n2 = this.params.actions.length;
        int n3 = 0;
        while (n3 < n2) {
            EntityParams entityParams;
            GameEvents.Action action = actionArray[n3];
            if (action instanceof GameEvents.BaseUseAbilityAction && (n = this.params.playerChartIndices[action.player]) >= 0 && (entityParams = ((GameEvents.BaseUseAbilityAction)action).getEntityParams()) != null) {
                Point point;
                List list;
                int n4 = this.params.frameToX(action.frame);
                if (entityParams.minerals != 0) {
                    list = listArray[n];
                    point = (Point)list.get(list.size() - 1);
                    if (point.x != n4) {
                        point = new Point(n4, point.y);
                        list.add(point);
                    }
                    point.y += entityParams.minerals;
                }
                if (entityParams.gas != 0) {
                    list = listArray2[n];
                    point = (Point)list.get(list.size() - 1);
                    if (point.x != n4) {
                        point = new Point(n4, point.y);
                        list.add(point);
                    }
                    point.y += entityParams.gas;
                }
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < this.params.chartPlayerIndices.length) {
            this.descriptionBuilders[n5].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.mineralsSpent", ((Point)listArray[n5].get((int)(listArray[n5].size() - 1))).y)).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.gasSpent", ((Point)listArray2[n5].get((int)(listArray2[n5].size() - 1))).y));
            ++n5;
        }
        this.paintStepCharts(listArray, listArray2);
    }

    private void paintProducedArmySupplyChart() {
        Object object;
        List[] listArray = new List[this.params.chartPlayerIndices.length];
        List[] listArray2 = new List[this.params.chartPlayerIndices.length];
        int n = 0;
        while (n < this.params.chartPlayerIndices.length) {
            listArray[n] = new ArrayList(256);
            listArray2[n] = new ArrayList(64);
            listArray[n].add(new Point(25, 0));
            listArray2[n].add(new Point(25, 0));
            ++n;
        }
        if (this.params.includeInitialUnits) {
            object = this.params.replay.details.players;
            int n2 = 0;
            while (n2 < ((Details.Player[])object).length) {
                n = this.params.playerChartIndices[n2];
                if (n >= 0) {
                    ((Point)listArray[n].get((int)0)).y += 6;
                    ((Point)listArray2[n].get((int)0)).y = ((Point)listArray2[n].get((int)0)).y + (object[n2].finalRace == ReplayConsts.Race.TERRAN ? 11 : 10);
                }
                ++n2;
            }
        }
        GameEvents.Action[] actionArray = this.params.actions;
        int n3 = this.params.actions.length;
        int n4 = 0;
        while (n4 < n3) {
            EntityParams entityParams;
            GameEvents.Action action = actionArray[n4];
            if (action instanceof GameEvents.BaseUseAbilityAction && (n = this.params.playerChartIndices[action.player]) >= 0 && (entityParams = ((GameEvents.BaseUseAbilityAction)action).getEntityParams()) != null) {
                int n5 = this.params.frameToX(this.params.showAfterCompleted ? action.frame + (entityParams.time << 6) : action.frame);
                if (entityParams.supply != 0) {
                    object = (entityParams.supply > 0 ? listArray : listArray2)[n];
                    int n6 = object.size() - 1;
                    while (n6 >= 0) {
                        Point point = (Point)object.get(n6);
                        if (point.x < n5) {
                            point = new Point(n5, point.y);
                            object.add(n6 + 1, point);
                        }
                        point.y = point.y + (entityParams.supply > 0 ? entityParams.supply : -entityParams.supply);
                        if (point.x <= n5) break;
                        --n6;
                    }
                }
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.params.chartPlayerIndices.length) {
            this.descriptionBuilders[n7].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.producedArmySize", ((Point)listArray[n7].get((int)(listArray[n7].size() - 1))).y)).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.producedSupply", ((Point)listArray2[n7].get((int)(listArray2[n7].size() - 1))).y));
            ++n7;
        }
        this.paintStepCharts(listArray, listArray2);
    }

    /*
     * WARNING - void declaration
     */
    private void paintStepCharts(List<Point>[] listArray, List<Point>[] listArray2) {
        int n;
        int n2;
        int[] nArray = new int[this.params.chartPlayerIndices.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 = listArray[n3].get((int)(listArray[n3].size() - 1)).y;
            int n4 = listArray2[n3].get((int)(listArray2[n3].size() - 1)).y;
            for (Point point : listArray[n3]) {
                if (point.y <= n2) continue;
                n2 = point.y;
            }
            for (Point n9 : listArray2[n3]) {
                if (n9.y <= n4) continue;
                n4 = n9.y;
            }
            nArray[n3] = Math.max(n2, n4);
            listArray[n3].add(new Point(this.params.chartX2, n2));
            listArray2[n3].add(new Point(this.params.chartX2, n4));
            ++n3;
        }
        if (this.params.allPlayersOnOneChart) {
            Arrays.fill(nArray, GeneralUtils.maxValue(nArray));
        }
        n3 = this.params.chartHeight < 20 ? 1 : this.params.chartHeight / 20;
        this.g2.setStroke(STROKE_DASHED);
        n2 = this.params.chartsCount - 1;
        while (n2 >= 0) {
            Float f = nArray[n2] > 9999 ? new Float(9.0f) : (nArray[n2] > 999 ? new Float(10.0f) : null);
            Object var7_14 = null;
            if (f != null) {
                Font font = this.g2.getFont();
                this.g2.setFont(font.deriveFont(9.0f));
            }
            int n4 = this.g2.getFontMetrics().getAscent();
            int n5 = n3 - 1;
            while (n5 >= 0) {
                int n6 = this.params.chartY1s[n2] + n5 * this.params.chartDY / n3;
                this.g2.setColor(COLOR_ASSIST_LINES);
                this.g2.drawLine(this.params.chartX1 + 1 + this.params.visibleRectangle.x, n6, this.params.chartX2, n6);
                this.g2.setColor(COLOR_AXIS_LABELS);
                n = (n3 - n5) * nArray[n2] / n3;
                this.g2.drawString(Integer.toString(n), this.params.visibleRectangle.x, n6 + (n4 >> 1) - 1);
                --n5;
            }
            if (f != null) {
                void var7_16;
                this.g2.setFont((Font)var7_16);
            }
            --n2;
        }
        this.g2.setStroke(STROKE_DOUBLE_WIDTH_ROUNDED);
        n2 = 0;
        while (n2 < listArray.length) {
            int n8 = this.params.chartY2s[n2];
            int n7 = nArray[n2] == 0 ? 1 : nArray[n2];
            int n9 = 0;
            while (n9 < 2) {
                List<Point> list = n9 == 0 ? listArray[n2] : listArray2[n2];
                this.g2.setColor(n9 == 0 ? this.params.playerColors[this.params.chartPlayerIndices[n2]] : this.params.replay.details.players[this.params.chartPlayerIndices[n2]].getBrighterColor());
                Point point = list.get(0);
                n = n8 - point.y * this.params.chartDY / n7;
                int n10 = list.size();
                int n11 = 1;
                while (n11 < n10) {
                    Point point2 = list.get(n11);
                    int n12 = n8 - point2.y * this.params.chartDY / n7;
                    this.g2.drawLine(point.x, n, point2.x, n);
                    this.g2.drawLine(point2.x, n, point2.x, n12);
                    point = point2;
                    n = n12;
                    ++n11;
                }
                ++n9;
            }
            ++n2;
        }
        this.g2.setStroke(STROKE_DEFAULT);
    }

    private void paintChartDescriptions() {
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        int n = this.g2.getFontMetrics().getAscent();
        int n2 = 0;
        while (n2 < this.descriptionBuilders.length) {
            int n3;
            Object object;
            Object object2;
            Details.Player player = this.params.replay.details.players[this.params.chartPlayerIndices[n2]];
            Color color = player.getBrighterColor();
            this.g2.setColor(color);
            String string = this.descriptionBuilders[n2].toString();
            int n4 = 28 + this.params.visibleRectangle.x;
            int n5 = this.params.chartY1s[n2] - 1 + (this.params.allPlayersOnOneChart ? n2 * n + n2 : 0);
            this.g2.drawString(string, n4, n5);
            ArrayList<Pair<Color, String>> arrayList = null;
            switch (this.params.chartType) {
                case UNIT_TIERS: {
                    object2 = ReplayConsts.UnitTier.values();
                    arrayList = new ArrayList(((ReplayConsts.UnitTier[])object2).length);
                    object = object2;
                    int n6 = ((Object)object).length;
                    n3 = 0;
                    while (n3 < n6) {
                        Object object3 = object[n3];
                        arrayList.add(new Pair<Color, String>(((ReplayConsts.UnitTier)((Object)object3)).color, ((ReplayConsts.UnitTier)((Object)object3)).textKey));
                        ++n3;
                    }
                    break;
                }
                case RESOURCES_SPENT: {
                    arrayList = new ArrayList<Pair<Color, String>>(2);
                    arrayList.add(new Pair<Color, String>(this.params.playerColors[this.params.chartPlayerIndices[n2]], "module.repAnalyzer.tab.charts.chartText.minerals"));
                    arrayList.add(new Pair<Color, String>(player.getBrighterColor(), "module.repAnalyzer.tab.charts.chartText.gas"));
                    break;
                }
                case PRODUCED_ARMY_SUPPLY: {
                    arrayList = new ArrayList(2);
                    arrayList.add(new Pair<Color, String>(this.params.playerColors[this.params.chartPlayerIndices[n2]], "module.repAnalyzer.tab.charts.chartText.army"));
                    arrayList.add(new Pair<Color, String>(player.getBrighterColor(), "module.repAnalyzer.tab.charts.chartText.supply"));
                }
            }
            if (arrayList != null) {
                object2 = this.g2.getFontMetrics();
                this.g2.drawString("(", n4 += ((FontMetrics)object2).stringWidth(string) + 10, n5);
                n4 += ((FontMetrics)object2).stringWidth("(");
                int n7 = 11;
                n3 = 0;
                while (n3 < arrayList.size()) {
                    Pair pair = (Pair)arrayList.get(n3);
                    this.g2.setColor((Color)pair.value1);
                    this.g2.fillRoundRect(n4, n5 - ((FontMetrics)object2).getAscent() + 3, 11, 11, 5, 5);
                    this.g2.setColor(color);
                    object = String.valueOf(Language.getText((String)pair.value2)) + (n3 == arrayList.size() - 1 ? ")" : ", ");
                    this.g2.drawString((String)object, n4 += 14, n5);
                    n4 += ((FontMetrics)object2).stringWidth((String)object);
                    ++n3;
                }
            }
            ++n2;
        }
        this.g2.setFont(font);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType() {
        if ($SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType != null) {
            return $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType;
        }
        int[] nArray = new int[ReplayConsts.ActionType.values().length];
        try {
            nArray[ReplayConsts.ActionType.BUILD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.INACTION.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.OTHER.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.RESEARCH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.SELECT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.TRAIN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.UPGRADE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$ActionType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race() {
        if ($SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race != null) {
            return $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race;
        }
        int[] nArray = new int[ReplayConsts.Race.values().length];
        try {
            nArray[ReplayConsts.Race.ANY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.PROTOSS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.RANDOM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.TERRAN.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.UNKNOWN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.ZERG.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$hu$belicza$andras$sc2gears$sc2replay$ReplayConsts$Race = nArray;
        return nArray;
    }

    private class ChartStat {
        public final Map<ReplayConsts.Unit, IntHolder> unitCountMap;
        public final Map<ReplayConsts.Building, IntHolder> buildingCountMap;
        public final Map<ReplayConsts.Research, IntHolder> researchCountMap;
        public final Map<ReplayConsts.Upgrade, IntHolder> upgradeCountMap;
        public final Map<ReplayConsts.AbilityGroup, IntHolder> abilityGroupCountMap;
        public final List<ReplayConsts.Unit> unitList;
        public final List<ReplayConsts.Building> buildingList;
        public final List<ReplayConsts.Research> researchList;
        public final List<ReplayConsts.Upgrade> upgradeList;
        public final List<ReplayConsts.AbilityGroup> abilityGroupList;

        private ChartStat() {
            this.unitCountMap = ChartPainter.this.params.showUnitsStat ? new EnumMap(ReplayConsts.Unit.class) : null;
            this.buildingCountMap = ChartPainter.this.params.showBuildingsStat ? new EnumMap(ReplayConsts.Building.class) : null;
            this.researchCountMap = ChartPainter.this.params.showResearchesStat ? new EnumMap(ReplayConsts.Research.class) : null;
            this.upgradeCountMap = ChartPainter.this.params.showUpgradesStat ? new EnumMap(ReplayConsts.Upgrade.class) : null;
            this.abilityGroupCountMap = ChartPainter.this.params.showAbilityGroupsStat ? new EnumMap(ReplayConsts.AbilityGroup.class) : null;
            this.unitList = new ArrayList<ReplayConsts.Unit>();
            this.buildingList = new ArrayList<ReplayConsts.Building>();
            this.researchList = new ArrayList<ReplayConsts.Research>();
            this.upgradeList = new ArrayList<ReplayConsts.Upgrade>();
            this.abilityGroupList = new ArrayList<ReplayConsts.AbilityGroup>();
        }
    }

    private static class ProductionStat {
        public final Object entity;
        public final String entityName;
        public int count = 1;
        public int completionBarWidth;

        public ProductionStat(Object object, String string, int n) {
            this.entity = object;
            this.entityName = string;
            this.completionBarWidth = n;
        }
    }
}

