/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.Pair;

public class GridParams {
    public PredefinedGrid predefinedGrid;
    public Pair<IntHolder, Holder<TimeUnit>> firstMarker;
    public Pair<IntHolder, Holder<TimeUnit>> repeatMarker;

    public GridParams() {
        try {
            this.predefinedGrid = PredefinedGrid.values()[Settings.getInt("module.repAnalyzer.charts.grid.predefined")];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.predefinedGrid = PredefinedGrid.values()[0];
        }
        this.firstMarker = GridParams.getTimeSetting("module.repAnalyzer.charts.grid.firstMarker");
        this.repeatMarker = GridParams.getTimeSetting("module.repAnalyzer.charts.grid.repeatMarker");
    }

    private static Pair<IntHolder, Holder<TimeUnit>> getTimeSetting(String string) {
        TimeUnit timeUnit;
        String string2 = Settings.getString(string);
        int n = string2.indexOf(44);
        int n2 = Integer.parseInt(string2.substring(0, n));
        try {
            timeUnit = TimeUnit.values()[Integer.parseInt(string2.substring(n + 1))];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            timeUnit = TimeUnit.SECONDS;
        }
        return new Pair<IntHolder, Holder<TimeUnit>>(new IntHolder(n2), new Holder<TimeUnit>(timeUnit));
    }

    public void storeSettings() {
        Settings.set("module.repAnalyzer.charts.grid.predefined", this.predefinedGrid.ordinal());
        GridParams.storeTime("module.repAnalyzer.charts.grid.firstMarker", this.firstMarker);
        GridParams.storeTime("module.repAnalyzer.charts.grid.repeatMarker", this.repeatMarker);
    }

    private static void storeTime(String string, Pair<IntHolder, Holder<TimeUnit>> pair) {
        Settings.set(string, String.valueOf(((IntHolder)pair.value1).value) + "," + ((TimeUnit)((Object)((Holder)pair.value2).value)).ordinal());
    }

    public static float getFrame(int n, TimeUnit timeUnit, ReplayConsts.GameSpeed gameSpeed) {
        switch (timeUnit) {
            case SECONDS: {
                return gameSpeed.convertToGameTime(n) << 6;
            }
            case FRAMES: {
                return n;
            }
            case ENERGY_REGENERATION: {
                return (float)n / 0.0087890625f;
            }
        }
        throw new RuntimeException("Unhandled time unit.");
    }

    public static enum PredefinedGrid {
        SPAWN_LARVA("gridSettings.autoConfigure.spawnLarva"),
        CALLDOWN_MULE("gridSettings.autoConfigure.calldownMule"),
        CHRONO_BOOST("gridSettings.autoConfigure.chronoBoost"),
        CUSTOM("gridSettings.autoConfigure.custom");

        public final String stringValue;

        private PredefinedGrid(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum TimeUnit {
        SECONDS("module.repAnalyzer.tab.charts.timeUnit.seconds"),
        FRAMES("module.repAnalyzer.tab.charts.timeUnit.frames"),
        ENERGY_REGENERATION("module.repAnalyzer.tab.charts.timeUnit.energyRegeneration");

        public final String stringValue;

        private TimeUnit(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

