/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class OverlayChartFrame
extends JInternalFrame {
    public final ReplayAnalyzer.ChartType chartType;
    private ChartParams chartParams;
    private int mainChartWidth;
    private int mainChartHeight;
    private boolean projectMainChartSize;
    public final JComponent chartCanvas;

    protected OverlayChartFrame(final ReplayAnalyzer.ChartType chartType, Container container, final JComponent jComponent) {
        super(chartType.stringValue, true, true, true);
        this.chartType = chartType;
        this.setDefaultCloseOperation(2);
        this.chartCanvas = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                if (OverlayChartFrame.this.chartParams != null) {
                    ((OverlayChartFrame)OverlayChartFrame.this).chartParams.g2 = (Graphics2D)graphics;
                    if (!OverlayChartFrame.this.projectMainChartSize) {
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.zoom = 1;
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.width = jComponent.getWidth();
                        OverlayChartFrame.this.mainChartWidth = ((OverlayChartFrame)OverlayChartFrame.this).chartParams.width;
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.height = jComponent.getHeight();
                        OverlayChartFrame.this.mainChartHeight = ((OverlayChartFrame)OverlayChartFrame.this).chartParams.height;
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.visibleRectangle = chartType == ReplayAnalyzer.ChartType.MAP_VIEW ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                    }
                    if (chartType != ReplayAnalyzer.ChartType.MAP_VIEW) {
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.g2.scale((double)this.getWidth() * (double)((OverlayChartFrame)OverlayChartFrame.this).chartParams.zoom / (double)OverlayChartFrame.this.mainChartWidth, (double)this.getHeight() / (double)OverlayChartFrame.this.mainChartHeight);
                        ((OverlayChartFrame)OverlayChartFrame.this).chartParams.g2.translate(-((OverlayChartFrame)OverlayChartFrame.this).chartParams.visibleRectangle.x, 0);
                    }
                    new ChartPainter(OverlayChartFrame.this.chartParams).paintChart();
                }
            }
        };
        this.getContentPane().add((Component)this.chartCanvas, "Center");
        int n = jComponent.getWidth() >> 1;
        int n2 = jComponent.getHeight() >> 1;
        int n3 = -(ReplayAnalyzer.ChartType.values().length << 3) + (chartType.ordinal() << 4);
        this.setBounds(n3 + (container.getWidth() - n >> 1), n3 + (container.getHeight() - n2 >> 1), n, n2);
        container.add((Component)this, JLayeredPane.PALETTE_LAYER);
        this.setVisible(true);
    }

    public void setChartParams(ChartParams chartParams) {
        this.chartParams = chartParams;
        if (this.chartType == ReplayAnalyzer.ChartType.MAP_VIEW || chartParams.chartType == ReplayAnalyzer.ChartType.MAP_VIEW) {
            this.projectMainChartSize = false;
            if (this.chartType == ReplayAnalyzer.ChartType.MAP_VIEW && chartParams.markerX != null) {
                chartParams.calcualteDerivedData();
                chartParams.markerFrame = chartParams.xToFrame(chartParams.markerX);
            }
        } else {
            this.projectMainChartSize = true;
            this.mainChartWidth = chartParams.width;
            this.mainChartHeight = chartParams.height;
        }
        chartParams.chartType = this.chartType;
    }

    public static boolean openOverlayChart(ReplayAnalyzer.ChartType chartType, final List<OverlayChartFrame> list, final Container container, JComponent jComponent) {
        OverlayChartFrame overlayChartFrame2;
        for (OverlayChartFrame overlayChartFrame2 : list) {
            if (overlayChartFrame2.chartType != chartType) continue;
            return false;
        }
        overlayChartFrame2 = new OverlayChartFrame(chartType, container, jComponent);
        overlayChartFrame2.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                container.setComponentZOrder((OverlayChartFrame)internalFrameEvent.getSource(), 0);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                list.remove(internalFrameEvent.getSource());
                container.requestFocusInWindow();
            }
        });
        list.add(overlayChartFrame2);
        return true;
    }

    public static boolean closeOverlayChart(ReplayAnalyzer.ChartType chartType, List<OverlayChartFrame> list) {
        for (OverlayChartFrame overlayChartFrame : list) {
            if (overlayChartFrame.chartType != chartType) continue;
            overlayChartFrame.dispose();
            return true;
        }
        return false;
    }

    public static void invertOverlayChart(ReplayAnalyzer.ChartType chartType, List<OverlayChartFrame> list, Container container, JComponent jComponent) {
        if (!OverlayChartFrame.openOverlayChart(chartType, list, container, jComponent)) {
            OverlayChartFrame.closeOverlayChart(chartType, list);
        }
    }
}

