/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2map.MapParser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.importing.ReplaySpecification;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.services.Downloader;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.components.PlayerPopupMenu;
import hu.belicza.andras.sc2gears.ui.components.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.dialogs.GridSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.OverlayChartsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.PlayerProfileDialog;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.Animator;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.GridParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.OverlayChartFrame;
import hu.belicza.andras.sc2gears.util.BoolHolder;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.GoogleTranslator;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.ProfileCache;
import hu.belicza.andras.sc2gears.util.Task;
import hu.belicza.andras.sc2gears.util.TextFilter;
import hu.belicza.andras.sc2gearspluginapi.api.listener.DownloaderCallback;
import hu.belicza.andras.sc2gearspluginapi.api.listener.ReplayOpCallback;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ReplayAnalyzer
extends ModuleFrame {
    private static final int MAX_MAP_PREVIEW_ZOOM = 6;
    private static final Dictionary<Integer, JComponent> LABEL_DICTIONARY = new Hashtable<Integer, JComponent>();
    private File replayFile;
    private final Replay replay;
    private final JLayeredPane layeredPane = this.getLayeredPane();
    private static final AtomicInteger counter;
    private static String PORTRAIT_TOOL_TIP_BEST_LEAGUES_TABLE_HEADER;
    private static String PORTRAIT_TOOL_TIP_ALL_LEAGUES_TABLE_HEADER;

    static {
        int n = 0;
        while (n <= 6) {
            LABEL_DICTIONARY.put(n, new JLabel(n == 0 ? "1/2x" : String.valueOf(n) + "x"));
            ++n;
        }
        counter = new AtomicInteger();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReplayAnalyzer(Object ... objectArray) {
        super(objectArray.length < 1 ? Language.getText("module.replayAnalyzer.opening") : null);
        ReplaySpecification replaySpecification = null;
        if (objectArray.length == 0) {
            JFileChooser jFileChooser = new JFileChooser(GeneralUtils.getDefaultReplayFolder());
            jFileChooser.setDialogTitle(Language.getText("module.repAnalyzer.openTitle"));
            jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
            jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) {
                this.dispose();
                this.replayFile = null;
                this.replay = null;
                return;
            }
            this.replayFile = jFileChooser.getSelectedFile();
        } else if (objectArray.length == 1) {
            this.replayFile = (File)objectArray[0];
        } else if (objectArray.length == 2) {
            replaySpecification = (ReplaySpecification)objectArray[1];
        }
        if (this.replayFile != null) {
            this.replay = ReplayFactory.parseReplay(this.replayFile.getAbsolutePath(), ReplayFactory.ALL_CONTENT);
            if (this.replay == null) {
                new NormalThread("Non-blocking executor thread"){

                    @Override
                    public void run() {
                        GuiUtils.showErrorDialog(Language.getText("module.repAnalyzer.openError"), new Frame[0]);
                    }
                }.start();
                this.dispose();
                return;
            }
            if (Settings.getBoolean("settings.misc.rearrangePlayersInRepAnalyzer")) {
                ReplayUtils.applyFavoredPlayerListSetting(this.replay.details);
            }
            MainFrame.INSTANCE.updateRecentReplays(this.replayFile);
            this.setTitle(GeneralUtils.getFileNameWithoutExt(this.replayFile));
            this.setFrameIcon(Icons.SC2);
        } else {
            this.replay = ReplayFactory.constructReplay(replaySpecification);
            this.setTitle(Language.getText("module.repAnalyzer.buildOrderAnalysisTitle", counter.incrementAndGet()));
            this.setFrameIcon(Icons.BLOCK);
        }
        this.buildGui();
    }

    private void buildGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.charts.title"), Icons.CHART, false, jTabbedPane, this.createChartsTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.gameInfo.title"), Icons.INFORMATION_BALLOON, false, jTabbedPane, this.createGameInfoTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.inGameChat.title"), Icons.BALLOONS, false, jTabbedPane, this.createInGameChatTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.mapPreview.title"), Icons.MAP, false, jTabbedPane, this.createMapPreviewTab(), null);
        this.getContentPane().add(jTabbedPane);
    }

    private JComponent createChartsTab() {
        Object object;
        JComponent jComponent;
        Object object2;
        Object object3;
        JComponent jComponent2;
        Object object4;
        JComponent jComponent3;
        JComponent jComponent4;
        JComponent jComponent5;
        JComponent jComponent6;
        Object object5;
        Serializable serializable;
        JComponent jComponent7;
        Object object6;
        Object object7;
        JComponent jComponent8;
        Object object8;
        Object object9;
        final Holder holder = new Holder();
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public void updateUI() {
                super.updateUI();
                if (holder.value != null) {
                    ((Runnable)holder.value).run();
                }
            }
        };
        final JList jList = new JList();
        final EnumMap<ReplayConsts.ActionType, JCheckBox> enumMap = new EnumMap<ReplayConsts.ActionType, JCheckBox>(ReplayConsts.ActionType.class);
        final JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.useListedActionsAsInput", "module.repAnalyzer.charts.actions.useListedAsInput");
        final ArrayList arrayList = new ArrayList();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    ((OverlayChartFrame)arrayList.get(n)).dispose();
                    --n;
                }
            }
        });
        final JScrollPane jScrollPane = new JScrollPane(21, 31);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        final Holder holder2 = new Holder();
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)holder2.value).repaint();
                for (OverlayChartFrame overlayChartFrame : arrayList) {
                    overlayChartFrame.chartCanvas.repaint();
                }
            }
        };
        final Holder holder3 = new Holder();
        final JCheckBox[] jCheckBoxArray = new JCheckBox[this.replay.details.players.length];
        final int[] nArray = this.replay.details.getTeamOrderPlayerIndices();
        final Holder<TextFilter> holder4 = new Holder<TextFilter>(new TextFilter("", ""));
        final JLabel jLabel = new JLabel();
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                EnumSet<ReplayConsts.ActionType> enumSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
                ReplayConsts.ActionType[] actionTypeArray = ReplayConsts.ActionType.values();
                int n = actionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = actionTypeArray[n2];
                    if (((JCheckBox)enumMap.get(object)).isSelected()) {
                        enumSet.add((ReplayConsts.ActionType)((Object)object));
                    }
                    ++n2;
                }
                object = (TextFilter)holder4.value;
                n2 = ((TextFilter)object).isFilterSpecified() ? 0 : 1;
                boolean[] blArray = new boolean[jCheckBoxArray.length];
                int n3 = 0;
                while (n3 < blArray.length) {
                    blArray[nArray[n3]] = jCheckBoxArray[n3].isSelected();
                    ++n3;
                }
                ArrayList<GameEvents.Action> arrayList = new ArrayList<GameEvents.Action>();
                GameEvents.Action[] actionArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                int n4 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions.length;
                int n5 = 0;
                while (n5 < n4) {
                    GameEvents.Action action = actionArray[n5];
                    if (blArray[action.player] && enumSet.contains((Object)action.type) && (n2 != 0 || ((TextFilter)object).isIncluded(action.toString().toLowerCase()))) {
                        arrayList.add(action);
                    }
                    ++n5;
                }
                holder3.value = arrayList.toArray(new GameEvents.Action[arrayList.size()]);
                jList.setListData((E[])holder3.value);
                jLabel.setText(Language.getText("module.repAnalyzer.tab.charts.actions.listedActionsCount", ((GameEvents.Action[])holder3.value).length));
                if (jCheckBox.isSelected()) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(new JPanel(new BorderLayout()));
        box2.add(new JLabel(Language.getText("charts.chartType")));
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])ChartType.values(), "module.repAnalyzer.charts.chartType");
        jComboBox.setToolTipText(Language.getText("charts.chartTypeToolTip"));
        jComboBox.setMaximumRowCount(jComboBox.getItemCount());
        jComboBox.addActionListener(actionListener);
        box2.add(jComboBox);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.groupByTeams", "module.repAnalyzer.charts.groupByTeams");
        jCheckBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.groupByTeamToolTip"));
        jCheckBox2.addActionListener(actionListener);
        box2.add(jCheckBox2);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.allPlayersOn1Chart", "module.repAnalyzer.charts.allPlayersOn1Chart");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox3.setEnabled(((ChartType)((Object)jComboBox.getSelectedItem())).supportsAllOnOneChart);
            }
        };
        actionListener3.actionPerformed(null);
        jComboBox.addActionListener(actionListener3);
        jCheckBox3.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.allPlayersOn1ChartToolTip"));
        jCheckBox3.addActionListener(actionListener);
        box2.add(jCheckBox3);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox4 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.usePlayersColors", "module.repAnalyzer.charts.usePlayersColors");
        jCheckBox4.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.usePlayersColorsToolTip"));
        jCheckBox4.addActionListener(actionListener);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.invalidate();
                jList.getParent().repaint();
                if (jCheckBox.isSelected()) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        jCheckBox4.addActionListener(actionListener4);
        box2.add(jCheckBox4);
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox4.setEnabled(!jCheckBox3.isSelected());
                jCheckBox4.updateUI();
            }
        };
        jCheckBox3.addActionListener(actionListener5);
        actionListener5.actionPerformed(null);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox5 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.displayInSeconds", "module.repAnalyzer.charts.displayInSeconds");
        jCheckBox5.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.displayInSecondsToolTip"));
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.displayInSeconds = jCheckBox5.isSelected();
            }
        };
        actionListener6.actionPerformed(null);
        jCheckBox5.addActionListener(actionListener6);
        jCheckBox5.addActionListener(actionListener2);
        jCheckBox5.addActionListener(actionListener);
        box2.add(jCheckBox5);
        box2.add(Box.createHorizontalStrut(9));
        final JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.zoom"));
        jLabel2.setOpaque(true);
        box2.add(jLabel2);
        final JComboBox jComboBox2 = GuiUtils.createComboBox(new Object[]{"x1", "x2", "x4", "x8", "x16", "x32"}, "module.repAnalyzer.charts.zoom");
        jComboBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.zoomToolTip"));
        box2.add(jComboBox2);
        box2.add(new JPanel(new BorderLayout()));
        box.add(box2);
        final Box box3 = Box.createHorizontalBox();
        box.add(box3);
        final Holder<ChartParams> holder5 = new Holder<ChartParams>();
        box.add(Box.createVerticalStrut(2));
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(3));
        JLabel jLabel3 = GeneralUtils.createLinkStyledLabel(Language.getText("module.repAnalyzer.tab.charts.overlayCharts"));
        jLabel3.setIcon(Icons.CHART_PLUS);
        jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new OverlayChartsDialog(arrayList, ReplayAnalyzer.this.layeredPane, actionListener, jScrollPane);
            }
        });
        box4.add(jLabel3);
        box4.add(Box.createHorizontalStrut(5));
        box4.add(new JPanel(new BorderLayout()));
        JLabel jLabel4 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.players"));
        box4.add(jLabel4);
        box4.add(Box.createHorizontalStrut(5));
        int n = nArray.length == 0 ? -1 : this.replay.details.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < this.replay.details.players.length) {
            object9 = this.replay.details.players[nArray[n2]];
            jCheckBoxArray[n2] = new JCheckBox(((Details.Player)object9).playerId.name, ((Details.Player)object9).lastActionFrame > 0);
            object8 = jCheckBoxArray[n2];
            ((AbstractButton)object8).addActionListener(actionListener2);
            ((AbstractButton)object8).addActionListener(actionListener);
            int n3 = this.replay.details.players[nArray[n2]].team;
            if (n3 != n) {
                box4.add(Box.createHorizontalStrut(7));
                jComponent8 = new JLabel("VS.");
                GuiUtils.changeFontToBold(jComponent8);
                box4.add(jComponent8);
                box4.add(Box.createHorizontalStrut(12));
                n = n3;
            }
            jComponent8 = Box.createHorizontalBox();
            try {
                object7 = ShowProfileInfo.values()[Settings.getInt("settings.misc.showProfileInfo")];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object7 = ShowProfileInfo.values()[Settings.getDefaultInt("settings.misc.showProfileInfo")];
            }
            object6 = object7;
            try {
                Settings.getInt("settings.misc.showProfileInfo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            jComponent7 = object6 == ShowProfileInfo.PORTRAIT_AND_LEAGUES ? Box.createHorizontalBox() : (object6 == ShowProfileInfo.LEAGUES_ONLY ? Box.createVerticalBox() : jComponent8);
            jComponent7.setBorder(BorderFactory.createLoweredBevelBorder());
            serializable = new ArrayList<Object>(5);
            object5 = new MouseAdapter((Details.Player)object9, (List)((Object)serializable), (JCheckBox)object8, jCheckBoxArray){
                private final /* synthetic */ Details.Player val$player;
                private final /* synthetic */ List val$componentToOpenProfileDialogList;
                private final /* synthetic */ JCheckBox val$playerCheckBox;
                private final /* synthetic */ JCheckBox[] val$playerCheckBoxes;
                {
                    this.val$player = player;
                    this.val$componentToOpenProfileDialogList = list;
                    this.val$playerCheckBox = jCheckBox;
                    this.val$playerCheckBoxes = jCheckBoxArray;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3) {
                        JPopupMenu jPopupMenu;
                        if (ReplayAnalyzer.this.replayFile != null) {
                            jPopupMenu = new PlayerPopupMenu(this.val$player.playerId, this.val$player.type);
                            jPopupMenu.addSeparator();
                        } else {
                            jPopupMenu = new JPopupMenu();
                        }
                        JMenuItem jMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.showOnlyThisPlayer"), Icons.USER_ARROW);
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                JCheckBox[] jCheckBoxArray = val$playerCheckBoxes;
                                int n = val$playerCheckBoxes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    JCheckBox jCheckBox = jCheckBoxArray[n2];
                                    if (val$playerCheckBox != jCheckBox && jCheckBox.isSelected() || val$playerCheckBox == jCheckBox && !jCheckBox.isSelected()) {
                                        jCheckBox.doClick(0);
                                    }
                                    ++n2;
                                }
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                        JMenuItem jMenuItem2 = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.showAllPlayers"), Icons.USERS);
                        jMenuItem2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                JCheckBox[] jCheckBoxArray = val$playerCheckBoxes;
                                int n = val$playerCheckBoxes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    JCheckBox jCheckBox = jCheckBoxArray[n2];
                                    if (!jCheckBox.isSelected()) {
                                        jCheckBox.doClick(0);
                                    }
                                    ++n2;
                                }
                            }
                        });
                        jPopupMenu.add(jMenuItem2);
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getButton() == 1) {
                        boolean bl;
                        boolean bl2 = bl = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.gateway == ReplayConsts.Gateway.UNKNOWN || ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.gateway == ReplayConsts.Gateway.PUBLIC_TEST || this.val$player.type != ReplayConsts.PlayerType.HUMAN || this.val$player.playerId.battleNetId == 0;
                        if (bl || !this.val$componentToOpenProfileDialogList.contains(mouseEvent.getSource())) {
                            this.val$playerCheckBox.doClick(100);
                        } else {
                            new PlayerProfileDialog(this.val$player.playerId, this.val$player.type);
                        }
                    }
                }
            };
            if (((Details.Player)object9).handicap < 100) {
                jComponent6 = new JLabel(Icons.HANDICAP);
                jComponent6.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.players.handicapToolTip", ((Details.Player)object9).handicap));
                jComponent6.addMouseListener((MouseListener)object5);
                jComponent8.add(jComponent6);
            }
            if (((Details.Player)object9).isWinner != null && ((Details.Player)object9).isWinner.booleanValue() && Settings.getBoolean("settings.misc.showWinners")) {
                jComponent6 = new JLabel(Icons.TROPHY);
                jComponent6.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.players.winnerToolTip"));
                jComponent6.addMouseListener((MouseListener)object5);
                jComponent8.add(jComponent6);
            }
            jComponent6 = new JLabel(GuiUtils.getColorIcon(((Details.Player)object9).getColor()));
            jComponent6.setToolTipText(((Details.Player)object9).playerColor.stringValue);
            jComponent6.addMouseListener((MouseListener)object5);
            jComponent8.add(jComponent6);
            jComponent8.add((Component)object8);
            ((AbstractButton)object8).addActionListener(new ActionListener((Box)jComponent7, (JCheckBox)object8){
                private final /* synthetic */ Box val$playerWrapperBox;
                private final /* synthetic */ JCheckBox val$playerCheckBox;
                {
                    this.val$playerWrapperBox = box;
                    this.val$playerCheckBox = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$playerWrapperBox.setBorder(this.val$playerCheckBox.isSelected() ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
                }
            });
            jComponent5 = GuiUtils.createRaceIconLabel(((Details.Player)object9).race == null ? ((Details.Player)object9).finalRace : ((Details.Player)object9).race);
            jComponent5.addMouseListener((MouseListener)object5);
            jComponent8.add(jComponent5);
            ((Component)object8).addMouseListener((MouseListener)object5);
            if (object6 != ShowProfileInfo.NONE) {
                if (object6 == ShowProfileInfo.PORTRAIT_AND_LEAGUES) {
                    jComponent4 = new JLabel(((Details.Player)object9).type == ReplayConsts.PlayerType.COMPUTER ? Icons.PORTRAIT_COMPUTER_ICON : Icons.PORTRAIT_LOADING_ICON);
                    jComponent7.add(jComponent4);
                    serializable.add(jComponent4);
                    jComponent4.addMouseListener((MouseListener)object5);
                    jComponent3 = Box.createVerticalBox();
                    jComponent7.add(jComponent3);
                    object4 = ProfileCache.queryCustomPortrait(((Details.Player)object9).playerId, false, new ProfileCache.CustomPortraitListener((JLabel)jComponent4){
                        private final /* synthetic */ JLabel val$portraitLabel;
                        {
                            this.val$portraitLabel = jLabel;
                        }

                        @Override
                        public void customPortraitReady(ImageIcon imageIcon) {
                            this.val$portraitLabel.setIcon(imageIcon == null ? Icons.PORTRAIT_NA_ICON : imageIcon);
                        }
                    });
                } else {
                    jComponent4 = null;
                    jComponent3 = jComponent7;
                    object4 = null;
                }
                jComponent3.add(jComponent8);
                jComponent2 = Box.createHorizontalBox();
                jComponent3.add(jComponent2);
                if (((Details.Player)object9).type == ReplayConsts.PlayerType.COMPUTER) {
                    object3 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.players.difficulty", ((Details.Player)object9).difficulty.stringValue));
                    ((Component)object3).addMouseListener((MouseListener)object5);
                    jComponent2.add((Component)object3);
                } else {
                    object3 = new JLabel[4];
                    int n4 = 0;
                    while (n4 < 4) {
                        object3[n4] = new JLabel(Icons.LEAGUE_LOADING_ICON);
                        jComponent2.add(object3[n4]);
                        serializable.add(object3[n4]);
                        ((Component)object3[n4]).addMouseListener((MouseListener)object5);
                        ++n4;
                    }
                    ProfileCache.queryProfile(((Details.Player)object9).playerId, new ProfileCache.ProfileListener((ShowProfileInfo)((Object)object6), (Boolean)object4, (JLabel)jComponent4, (JLabel[])object3){
                        private final /* synthetic */ ShowProfileInfo val$showProfileInfo;
                        private final /* synthetic */ Boolean val$customPortraitReady;
                        private final /* synthetic */ JLabel val$portraitLabel;
                        private final /* synthetic */ JLabel[] val$leagueLabels;
                        {
                            this.val$showProfileInfo = showProfileInfo;
                            this.val$customPortraitReady = bl;
                            this.val$portraitLabel = jLabel;
                            this.val$leagueLabels = jLabelArray;
                        }

                        @Override
                        public void profileReady(ProfileCache.Profile profile, boolean bl) {
                            int n = Settings.getInt("settings.misc.maxRowsInProfileToolTip");
                            String string = profile == null || n == 0 ? null : ReplayAnalyzer.buildProfileToolTip(profile, n);
                            if (this.val$showProfileInfo == ShowProfileInfo.PORTRAIT_AND_LEAGUES) {
                                if (this.val$customPortraitReady == null) {
                                    this.val$portraitLabel.setIcon(profile == null ? Icons.PORTRAIT_NA_ICON : Icons.getPortraitIcon(profile.portraitGroup, profile.portraitRow, profile.portraitColumn));
                                }
                                if (string != null) {
                                    this.val$portraitLabel.setToolTipText(string);
                                }
                            }
                            int n2 = 0;
                            while (n2 < 4) {
                                if (profile == null) {
                                    this.val$leagueLabels[n2].setIcon(Icons.LEAGUE_NA_ICON);
                                } else {
                                    if (profile.bestRanks[n2] != null) {
                                        this.val$leagueLabels[n2].setIcon(profile.bestRanks[n2].league.getIconForRank(profile.bestRanks[n2].divisionRank));
                                    } else {
                                        this.val$leagueLabels[n2].setIcon(Icons.League.UNRANKED.getIconForRank(0));
                                    }
                                    if (string != null) {
                                        this.val$leagueLabels[n2].setToolTipText(string);
                                    }
                                }
                                ++n2;
                            }
                        }
                    }, Settings.getBoolean("settings.misc.autoRetrieveExtProfileInfo"));
                }
            }
            jComponent7.addMouseListener((MouseListener)object5);
            box4.add(jComponent7);
            if (n2 < this.replay.details.players.length - 1) {
                box4.add(Box.createHorizontalStrut(5));
            }
            ++n2;
        }
        box4.add(new JPanel(new BorderLayout()));
        box4.add(Box.createHorizontalStrut(5));
        box4.add(GeneralUtils.createLinkStyledLabel(""));
        final GridParams gridParams = new GridParams();
        object9 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.grid", "module.repAnalyzer.charts.grid");
        ((JComponent)object9).setOpaque(true);
        ((JComponent)object9).setToolTipText(Language.getText("module.repAnalyzer.tab.charts.gridToolTip"));
        object8 = new ActionListener((JCheckBox)object9){
            private final /* synthetic */ JCheckBox val$gridCheckBox;
            {
                this.val$gridCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$gridCheckBox.setBackground(this.val$gridCheckBox.isSelected() ? Color.GREEN : null);
            }
        };
        object8.actionPerformed(null);
        ((AbstractButton)object9).addActionListener((ActionListener)object8);
        ((AbstractButton)object9).addActionListener(actionListener);
        box4.add((Component)object9);
        box4.add(Box.createHorizontalStrut(5));
        JLabel jLabel5 = GuiUtils.createIconLabelButton(Icons.GRID, "module.repAnalyzer.tab.charts.gridSettingsToolTip");
        jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new GridSettingsDialog(gridParams, (ChartParams)holder5.value, actionListener);
            }
        });
        box4.add(jLabel5);
        box4.add(Box.createHorizontalStrut(3));
        jComponent8 = new JScrollPane(box4);
        ((JScrollPane)jComponent8).setVerticalScrollBarPolicy(21);
        ((JScrollPane)jComponent8).getHorizontalScrollBar().setPreferredSize(new Dimension(0, 12));
        ((JScrollPane)jComponent8).getHorizontalScrollBar().setUnitIncrement(10);
        object7 = new ComponentAdapter((JScrollPane)jComponent8, box4, jPanel){
            private final /* synthetic */ JScrollPane val$playersBoxScrollPane;
            private final /* synthetic */ Box val$playersBox;
            private final /* synthetic */ JPanel val$chartsPanel;
            {
                this.val$playersBoxScrollPane = jScrollPane;
                this.val$playersBox = box;
                this.val$chartsPanel = jPanel;
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.val$playersBoxScrollPane.setHorizontalScrollBarPolicy(this.val$playersBox.getWidth() < this.val$playersBoxScrollPane.getWidth() ? 31 : 32);
                if (componentEvent != null) {
                    this.val$chartsPanel.revalidate();
                }
            }
        };
        jComponent8.addComponentListener((ComponentListener)object7);
        box.add(jComponent8);
        jPanel.add((Component)box, "North");
        object6 = new JSplitPane(0, true);
        ((JSplitPane)object6).setDividerSize(6);
        jComponent7 = GuiUtils.createComboBox(new Integer[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100, 200}, "module.repAnalyzer.charts.apm.granularity");
        ((JComboBox)jComponent7).setMaximumRowCount(((JComboBox)jComponent7).getItemCount());
        ((JComboBox)jComponent7).addActionListener(actionListener);
        serializable = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.repAnalyzer.charts.apm.graphApproximation");
        ((JComboBox)serializable).addActionListener(actionListener);
        object5 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.apm.showMicroMacroApm", "module.repAnalyzer.charts.apm.showMicroMacroApm");
        ((AbstractButton)object5).addActionListener(actionListener);
        jComponent6 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.hotkeys.showSelectHotkeys", "module.repAnalyzer.charts.hotkeys.showSelectHotkeys");
        ((AbstractButton)jComponent6).addActionListener(actionListener);
        jComponent5 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showBuilds", "module.repAnalyzer.charts.buildsTech.showBuilds");
        ((AbstractButton)jComponent5).addActionListener(actionListener);
        jComponent3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showTrains", "module.repAnalyzer.charts.buildsTech.showTrains");
        ((AbstractButton)jComponent3).addActionListener(actionListener);
        jComponent4 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showWorkers", "module.repAnalyzer.charts.buildsTech.showWorkers");
        object4 = new ActionListener((JCheckBox)jComponent4, (JCheckBox)jComponent3){
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            {
                this.val$showWorkersCheckBox = jCheckBox;
                this.val$showTrainsCheckBox = jCheckBox2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$showWorkersCheckBox.setEnabled(this.val$showTrainsCheckBox.isSelected());
                this.val$showWorkersCheckBox.updateUI();
            }
        };
        object4.actionPerformed(null);
        ((AbstractButton)jComponent3).addActionListener((ActionListener)object4);
        ((AbstractButton)jComponent4).addActionListener(actionListener);
        jComponent2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showResearches", "module.repAnalyzer.charts.buildsTech.showResearches");
        ((AbstractButton)jComponent2).addActionListener(actionListener);
        object3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        ((AbstractButton)object3).addActionListener(actionListener);
        JCheckBox jCheckBox6 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showAbilityGroups", "module.repAnalyzer.charts.buildsTech.showAbilityGroups");
        jCheckBox6.addActionListener(actionListener);
        JComboBox jComboBox3 = GuiUtils.createComboBox((Object[])ShowDuration.values(), "module.repAnalyzer.charts.buildsTech.showDuration");
        jComboBox3.addActionListener(actionListener);
        JComboBox jComboBox4 = GuiUtils.createComboBox((Object[])IconHandler.Size.values(), "module.repAnalyzer.charts.buildsTech.iconSizes");
        jComboBox4.addActionListener(actionListener);
        JCheckBox jCheckBox7 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUnits", "module.repAnalyzer.charts.buildsTechStat.showUnits");
        jCheckBox7.addActionListener(actionListener);
        JCheckBox jCheckBox8 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showBuildings", "module.repAnalyzer.charts.buildsTechStat.showBuildings");
        jCheckBox8.addActionListener(actionListener);
        JCheckBox jCheckBox9 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showResearches", "module.repAnalyzer.charts.buildsTechStat.showResearches");
        jCheckBox9.addActionListener(actionListener);
        JCheckBox jCheckBox10 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        jCheckBox10.addActionListener(actionListener);
        JCheckBox jCheckBox11 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showAbilityGroups", "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups");
        jCheckBox11.addActionListener(actionListener);
        JComboBox jComboBox5 = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.buildsTechStat.barSize");
        jComboBox5.addActionListener(actionListener);
        JCheckBox jCheckBox12 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.showAfterCompleted", "module.repAnalyzer.charts.showAfterCompleted");
        jCheckBox12.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.showAfterCompletedToolTip"));
        jCheckBox12.addActionListener(actionListener);
        JComboBox jComboBox6 = GuiUtils.createComboBox(new Integer[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100, 200, 300, 500, 1000, 9999}, "module.repAnalyzer.charts.unitTiersGranularity");
        jComboBox6.setMaximumRowCount(jComboBox6.getItemCount());
        jComboBox6.addActionListener(actionListener);
        JCheckBox jCheckBox13 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.unitTiers.stretchBars", "module.repAnalyzer.charts.stretchBars");
        jCheckBox13.addActionListener(actionListener);
        JComboBox jComboBox7 = GuiUtils.createComboBox((Object[])MapViewQuality.values(), "module.repAnalyzer.charts.mapView.quality");
        jComboBox7.addActionListener(actionListener);
        final JComboBox jComboBox8 = GuiUtils.createComboBox(new Object[]{"2x2", "3x3", "4x4", "6x6", "8x8", "12x12", "16x16", "32x32", "64x64", "128x128", "256x256"}, "module.repAnalyzer.charts.mapView.areaGranularity");
        final JComboBox jComboBox9 = GuiUtils.createComboBox((Object[])MapBackground.values(), "module.repAnalyzer.charts.mapView.background");
        jComboBox9.setMaximumRowCount(jComboBox9.getItemCount());
        jComboBox9.addActionListener(actionListener);
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox8.setEnabled(((MapBackground)((Object)jComboBox9.getSelectedItem())).involvesAreaAggregation);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jComboBox8.updateUI();
                    }
                });
            }
        };
        actionListener7.actionPerformed(null);
        jComboBox9.addActionListener(actionListener7);
        jComboBox8.setMaximumRowCount(jComboBox8.getModel().getSize());
        jComboBox8.addActionListener(actionListener);
        JCheckBox jCheckBox14 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.hideOverlappedBuildings", "module.repAnalyzer.charts.mapView.hideOverlappedBuildings");
        jCheckBox14.addActionListener(actionListener);
        JCheckBox jCheckBox15 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.fillBuildingIcons", "module.repAnalyzer.charts.mapView.fillBuildingIcons");
        jCheckBox15.addActionListener(actionListener);
        JCheckBox jCheckBox16 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.showMapObjects", "module.repAnalyzer.charts.mapView.showMapObjects");
        jCheckBox16.addActionListener(actionListener);
        JCheckBox jCheckBox17 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.productions.groupSameProductions", "module.repAnalyzer.charts.productions.groupSameProductions");
        jCheckBox17.addActionListener(actionListener);
        JComboBox jComboBox10 = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.productions.iconSizes");
        jComboBox10.addActionListener(actionListener);
        JComboBox jComboBox11 = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.playerSelections.iconSizes");
        jComboBox11.addActionListener(actionListener);
        JCheckBox jCheckBox18 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.producedArmySupply.includeInitialUnits", "module.repAnalyzer.charts.producedArmySupply.includeInitialUnits");
        jCheckBox18.addActionListener(actionListener);
        holder.value = new Runnable((JComboBox)jComponent7, (JComboBox)serializable, (JCheckBox)object5, (JCheckBox)jComponent6, (JCheckBox)jComponent5, (JCheckBox)jComponent3, (JCheckBox)jComponent4, (JCheckBox)jComponent2, (JCheckBox)object3, jCheckBox6, jComboBox3, jComboBox4, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jComboBox5, jCheckBox12, jComboBox7, jComboBox8, jComboBox9, jCheckBox14, jCheckBox15, jCheckBox16, jCheckBox17, jComboBox10, jComboBox11, jCheckBox18){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showMicroMacroApmCheckBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsCheckBox;
            private final /* synthetic */ JComboBox val$showDurationComboBox;
            private final /* synthetic */ JComboBox val$iconSizesComboBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JCheckBox val$showAfterCompletedCheckBox;
            private final /* synthetic */ JComboBox val$mapViewQualityComboBox;
            private final /* synthetic */ JComboBox val$areaGranularityCountComboBox;
            private final /* synthetic */ JComboBox val$mapBackgroundComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showMapObjectsCheckBox;
            private final /* synthetic */ JCheckBox val$groupSameProductionsCheckBox;
            private final /* synthetic */ JComboBox val$iconSizesPComboBox;
            private final /* synthetic */ JComboBox val$iconSizesPSComboBox;
            private final /* synthetic */ JCheckBox val$includeInitialUnitsCheckBox;
            {
                this.val$apmGranularityComboBox = jComboBox;
                this.val$apmApproximationComboBox = jComboBox2;
                this.val$showMicroMacroApmCheckBox = jCheckBox;
                this.val$showSelectHotkeysCheckBox = jCheckBox2;
                this.val$showBuildsCheckBox = jCheckBox3;
                this.val$showTrainsCheckBox = jCheckBox4;
                this.val$showWorkersCheckBox = jCheckBox5;
                this.val$showResearchesCheckBox = jCheckBox6;
                this.val$showUpgradesCheckBox = jCheckBox7;
                this.val$showAbilityGroupsCheckBox = jCheckBox8;
                this.val$showDurationComboBox = jComboBox3;
                this.val$iconSizesComboBox = jComboBox4;
                this.val$showUnitsStatCheckBox = jCheckBox9;
                this.val$showBuildingsStatCheckBox = jCheckBox10;
                this.val$showResearchesStatCheckBox = jCheckBox11;
                this.val$showUpgradesStatCheckBox = jCheckBox12;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox13;
                this.val$barSizeComboBox = jComboBox5;
                this.val$showAfterCompletedCheckBox = jCheckBox14;
                this.val$mapViewQualityComboBox = jComboBox6;
                this.val$areaGranularityCountComboBox = jComboBox7;
                this.val$mapBackgroundComboBox = jComboBox8;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox15;
                this.val$fillBuildingIconsCheckBox = jCheckBox16;
                this.val$showMapObjectsCheckBox = jCheckBox17;
                this.val$groupSameProductionsCheckBox = jCheckBox18;
                this.val$iconSizesPComboBox = jComboBox9;
                this.val$iconSizesPSComboBox = jComboBox10;
                this.val$includeInitialUnitsCheckBox = jCheckBox19;
            }

            @Override
            public void run() {
                JComponent[] jComponentArray;
                JComponent[] jComponentArray2 = jComponentArray = new JComponent[]{this.val$apmGranularityComboBox, this.val$apmApproximationComboBox, this.val$showMicroMacroApmCheckBox, this.val$showSelectHotkeysCheckBox, this.val$showBuildsCheckBox, this.val$showTrainsCheckBox, this.val$showWorkersCheckBox, this.val$showResearchesCheckBox, this.val$showUpgradesCheckBox, this.val$showAbilityGroupsCheckBox, this.val$showDurationComboBox, this.val$iconSizesComboBox, this.val$showUnitsStatCheckBox, this.val$showBuildingsStatCheckBox, this.val$showResearchesStatCheckBox, this.val$showUpgradesStatCheckBox, this.val$showAbilityGroupsStatCheckBox, this.val$barSizeComboBox, this.val$showAfterCompletedCheckBox, this.val$mapViewQualityComboBox, this.val$areaGranularityCountComboBox, this.val$mapBackgroundComboBox, this.val$hideOverlappedBuildingsCheckBox, this.val$fillBuildingIconsCheckBox, this.val$showMapObjectsCheckBox, this.val$groupSameProductionsCheckBox, this.val$iconSizesPComboBox, this.val$iconSizesPSComboBox, this.val$includeInitialUnitsCheckBox};
                int n = jComponentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JComponent jComponent = jComponentArray2[n2];
                    jComponent.updateUI();
                    ++n2;
                }
            }
        };
        ActionListener actionListener8 = new ActionListener((JComboBox)jComponent7, (JComboBox)serializable, (JCheckBox)object5, (JCheckBox)jComponent6, (JCheckBox)jComponent5, (JCheckBox)jComponent3, (JCheckBox)jComponent4, (JCheckBox)jComponent2, (JCheckBox)object3, jCheckBox6, jComboBox4, jComboBox3, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jComboBox5, jCheckBox12, jComboBox6, jCheckBox13, jComboBox7, jComboBox9, jComboBox8, jCheckBox14, jCheckBox15, jCheckBox16, jCheckBox17, jComboBox10, jComboBox11, jCheckBox18, jPanel){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showMicroMacroApmCheckBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsCheckBox;
            private final /* synthetic */ JComboBox val$iconSizesComboBox;
            private final /* synthetic */ JComboBox val$showDurationComboBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JCheckBox val$showAfterCompletedCheckBox;
            private final /* synthetic */ JComboBox val$unitTiersGranularityComboBox;
            private final /* synthetic */ JCheckBox val$stretchBarsCheckBox;
            private final /* synthetic */ JComboBox val$mapViewQualityComboBox;
            private final /* synthetic */ JComboBox val$mapBackgroundComboBox;
            private final /* synthetic */ JComboBox val$areaGranularityCountComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showMapObjectsCheckBox;
            private final /* synthetic */ JCheckBox val$groupSameProductionsCheckBox;
            private final /* synthetic */ JComboBox val$iconSizesPComboBox;
            private final /* synthetic */ JComboBox val$iconSizesPSComboBox;
            private final /* synthetic */ JCheckBox val$includeInitialUnitsCheckBox;
            private final /* synthetic */ JPanel val$chartsPanel;
            {
                this.val$apmGranularityComboBox = jComboBox2;
                this.val$apmApproximationComboBox = jComboBox3;
                this.val$showMicroMacroApmCheckBox = jCheckBox;
                this.val$showSelectHotkeysCheckBox = jCheckBox2;
                this.val$showBuildsCheckBox = jCheckBox3;
                this.val$showTrainsCheckBox = jCheckBox4;
                this.val$showWorkersCheckBox = jCheckBox5;
                this.val$showResearchesCheckBox = jCheckBox6;
                this.val$showUpgradesCheckBox = jCheckBox7;
                this.val$showAbilityGroupsCheckBox = jCheckBox8;
                this.val$iconSizesComboBox = jComboBox4;
                this.val$showDurationComboBox = jComboBox5;
                this.val$showUnitsStatCheckBox = jCheckBox9;
                this.val$showBuildingsStatCheckBox = jCheckBox10;
                this.val$showResearchesStatCheckBox = jCheckBox11;
                this.val$showUpgradesStatCheckBox = jCheckBox12;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox13;
                this.val$barSizeComboBox = jComboBox6;
                this.val$showAfterCompletedCheckBox = jCheckBox14;
                this.val$unitTiersGranularityComboBox = jComboBox7;
                this.val$stretchBarsCheckBox = jCheckBox15;
                this.val$mapViewQualityComboBox = jComboBox8;
                this.val$mapBackgroundComboBox = jComboBox9;
                this.val$areaGranularityCountComboBox = jComboBox10;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox16;
                this.val$fillBuildingIconsCheckBox = jCheckBox17;
                this.val$showMapObjectsCheckBox = jCheckBox18;
                this.val$groupSameProductionsCheckBox = jCheckBox19;
                this.val$iconSizesPComboBox = jComboBox11;
                this.val$iconSizesPSComboBox = jComboBox12;
                this.val$includeInitialUnitsCheckBox = jCheckBox20;
                this.val$chartsPanel = jPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                box3.removeAll();
                switch ((ChartType)((Object)jComboBox.getSelectedItem())) {
                    case APM: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("charts.granularity")));
                        box3.add(this.val$apmGranularityComboBox);
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.pixels")));
                        box3.add(Box.createHorizontalStrut(6));
                        box3.add(new JLabel(Language.getText("charts.graphApproximation")));
                        box3.add(this.val$apmApproximationComboBox);
                        box3.add(Box.createHorizontalStrut(5));
                        box3.add(this.val$showMicroMacroApmCheckBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case HOTKEYS: {
                        box3.add(this.val$showSelectHotkeysCheckBox);
                        break;
                    }
                    case BUILDS_TECH: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(this.val$showBuildsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showTrainsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showWorkersCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAbilityGroupsCheckBox);
                        box3.add(Box.createHorizontalStrut(7));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTech.iconSizes")));
                        box3.add(this.val$iconSizesComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTech.showDuration")));
                        box3.add(this.val$showDurationComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(this.val$showUnitsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showBuildingsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAbilityGroupsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(7));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTechStat.barSize")));
                        box3.add(this.val$barSizeComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAfterCompletedCheckBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case UNIT_TIERS: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("charts.granularity")));
                        box3.add(this.val$unitTiersGranularityComboBox);
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.pixels")));
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$stretchBarsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAfterCompletedCheckBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case MAP_VIEW: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.quality")));
                        box3.add(this.val$mapViewQualityComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.background")));
                        box3.add(this.val$mapBackgroundComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.areaGranularity")));
                        box3.add(this.val$areaGranularityCountComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$hideOverlappedBuildingsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$fillBuildingIconsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showMapObjectsCheckBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case MAIN_BUILDING_CONTROL: {
                        break;
                    }
                    case PRODUCTIONS: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(this.val$groupSameProductionsCheckBox);
                        box3.add(Box.createHorizontalStrut(10));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.productions.iconSizes")));
                        box3.add(this.val$iconSizesPComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case PLAYER_SELECTIONS: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.playerSelections.iconSizes")));
                        box3.add(this.val$iconSizesPSComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case PRODUCED_ARMY_SUPPLY: {
                        box3.add(this.val$includeInitialUnitsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAfterCompletedCheckBox);
                    }
                }
                this.val$chartsPanel.validate();
                this.val$chartsPanel.repaint();
            }
        };
        jComboBox.addActionListener(actionListener8);
        actionListener8.actionPerformed(null);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        final Holder<Integer> holder6 = new Holder<Integer>();
        final Holder<Integer> holder7 = new Holder<Integer>();
        final Holder holder8 = new Holder();
        holder2.value = new JComponent((JCheckBox)object9, gridParams, jCheckBoxArray, nArray, arrayList, jCheckBox3, (JComboBox)jComponent7, (JComboBox)serializable, (JCheckBox)object5, (JCheckBox)jComponent6, (JCheckBox)jComponent5, (JCheckBox)jComponent3, (JCheckBox)jComponent4, (JCheckBox)jComponent2, (JCheckBox)object3, jCheckBox6, jComboBox3, jComboBox4, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jComboBox5, jCheckBox12, jComboBox6, jCheckBox13, jComboBox7, jComboBox9, jComboBox8, jCheckBox14, jCheckBox15, jCheckBox16, jCheckBox17, jComboBox10, jComboBox11, jCheckBox18, jScrollPane){
            private final /* synthetic */ JCheckBox val$gridCheckBox;
            private final /* synthetic */ GridParams val$gridParams;
            private final /* synthetic */ JCheckBox[] val$playerCheckBoxes;
            private final /* synthetic */ int[] val$playerCheckBoxToPlayerIndices;
            private final /* synthetic */ List val$overlayChartFrameList;
            private final /* synthetic */ JCheckBox val$allPlayersOnOneChartCheckBox;
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showMicroMacroApmCheckBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsCheckBox;
            private final /* synthetic */ JComboBox val$showDurationComboBox;
            private final /* synthetic */ JComboBox val$iconSizesComboBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JCheckBox val$showAfterCompletedCheckBox;
            private final /* synthetic */ JComboBox val$unitTiersGranularityComboBox;
            private final /* synthetic */ JCheckBox val$stretchBarsCheckBox;
            private final /* synthetic */ JComboBox val$mapViewQualityComboBox;
            private final /* synthetic */ JComboBox val$mapBackgroundComboBox;
            private final /* synthetic */ JComboBox val$areaGranularityCountComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showMapObjectsCheckBox;
            private final /* synthetic */ JCheckBox val$groupSameProductionsCheckBox;
            private final /* synthetic */ JComboBox val$iconSizesPComboBox;
            private final /* synthetic */ JComboBox val$iconSizesPSComboBox;
            private final /* synthetic */ JCheckBox val$includeInitialUnitsCheckBox;
            private final /* synthetic */ JScrollPane val$chartCanvasScrollPane;
            {
                this.val$gridCheckBox = jCheckBox52;
                this.val$gridParams = gridParams;
                this.val$playerCheckBoxes = jCheckBoxArray;
                this.val$playerCheckBoxToPlayerIndices = nArray;
                this.val$overlayChartFrameList = list;
                this.val$allPlayersOnOneChartCheckBox = jCheckBox6;
                this.val$apmGranularityComboBox = jComboBox3;
                this.val$apmApproximationComboBox = jComboBox4;
                this.val$showMicroMacroApmCheckBox = jCheckBox7;
                this.val$showSelectHotkeysCheckBox = jCheckBox8;
                this.val$showBuildsCheckBox = jCheckBox9;
                this.val$showTrainsCheckBox = jCheckBox10;
                this.val$showWorkersCheckBox = jCheckBox11;
                this.val$showResearchesCheckBox = jCheckBox12;
                this.val$showUpgradesCheckBox = jCheckBox13;
                this.val$showAbilityGroupsCheckBox = jCheckBox14;
                this.val$showDurationComboBox = jComboBox5;
                this.val$iconSizesComboBox = jComboBox6;
                this.val$showUnitsStatCheckBox = jCheckBox15;
                this.val$showBuildingsStatCheckBox = jCheckBox16;
                this.val$showResearchesStatCheckBox = jCheckBox17;
                this.val$showUpgradesStatCheckBox = jCheckBox18;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox19;
                this.val$barSizeComboBox = jComboBox7;
                this.val$showAfterCompletedCheckBox = jCheckBox20;
                this.val$unitTiersGranularityComboBox = jComboBox8;
                this.val$stretchBarsCheckBox = jCheckBox21;
                this.val$mapViewQualityComboBox = jComboBox9;
                this.val$mapBackgroundComboBox = jComboBox10;
                this.val$areaGranularityCountComboBox = jComboBox11;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox22;
                this.val$fillBuildingIconsCheckBox = jCheckBox23;
                this.val$showMapObjectsCheckBox = jCheckBox24;
                this.val$groupSameProductionsCheckBox = jCheckBox25;
                this.val$iconSizesPComboBox = jComboBox12;
                this.val$iconSizesPSComboBox = jComboBox13;
                this.val$includeInitialUnitsCheckBox = jCheckBox26;
                this.val$chartCanvasScrollPane = jScrollPane;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                holder5.value = new ChartParams();
                ChartParams chartParams = holder5.value;
                chartParams.chartCanvas = (JComponent)holder2.value;
                chartParams.markerFrame = (Integer)holder6.value;
                chartParams.markerX = (Integer)holder7.value;
                chartParams.selectedAction = (GameEvents.Action)holder8.value;
                chartParams.visibleRectangle = this.getVisibleRect();
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.replay = ReplayAnalyzer.this.replay;
                chartParams.actions = jCheckBox.isSelected() ? (GameEvents.Action[])holder3.value : ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                chartParams.chartType = (ChartType)((Object)jComboBox.getSelectedItem());
                chartParams.groupByTeam = jCheckBox2.isSelected();
                chartParams.usePlayersInGameColors = jCheckBox4.isSelected();
                chartParams.displayInSeconds = jCheckBox5.isSelected();
                chartParams.zoom = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                if (this.val$gridCheckBox.isSelected()) {
                    chartParams.gridParams = this.val$gridParams;
                }
                chartParams.setVisiblePlayers(this.val$playerCheckBoxes, this.val$playerCheckBoxToPlayerIndices);
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                int n = -1;
                while (n < this.val$overlayChartFrameList.size()) {
                    if (n >= 0) {
                        chartParams = (ChartParams)((ChartParams)holder5.value).clone();
                        ((OverlayChartFrame)this.val$overlayChartFrameList.get(n)).setChartParams(chartParams);
                    }
                    chartParams.allPlayersOnOneChart = chartParams.chartType.supportsAllOnOneChart && this.val$allPlayersOnOneChartCheckBox.isSelected();
                    switch (chartParams.chartType) {
                        case APM: {
                            chartParams.apmGranularity = (Integer)this.val$apmGranularityComboBox.getSelectedItem();
                            chartParams.apmApproximation = (ChartUtils.GraphApproximation)((Object)this.val$apmApproximationComboBox.getSelectedItem());
                            chartParams.showMicroMacroApm = this.val$showMicroMacroApmCheckBox.isSelected();
                            break;
                        }
                        case HOTKEYS: {
                            chartParams.showSelectHotkeys = this.val$showSelectHotkeysCheckBox.isSelected();
                            break;
                        }
                        case BUILDS_TECH: {
                            chartParams.showBuilds = this.val$showBuildsCheckBox.isSelected();
                            chartParams.showTrains = this.val$showTrainsCheckBox.isSelected();
                            chartParams.showWorkers = this.val$showWorkersCheckBox.isSelected();
                            chartParams.showResearches = this.val$showResearchesCheckBox.isSelected();
                            chartParams.showUpgrades = this.val$showUpgradesCheckBox.isSelected();
                            chartParams.showAbilityGroups = this.val$showAbilityGroupsCheckBox.isSelected();
                            chartParams.showDuration = (ShowDuration)((Object)this.val$showDurationComboBox.getSelectedItem());
                            chartParams.iconSizes = (IconHandler.Size)((Object)this.val$iconSizesComboBox.getSelectedItem());
                            break;
                        }
                        case BUILDS_TECH_STAT: {
                            chartParams.showUnitsStat = this.val$showUnitsStatCheckBox.isSelected();
                            chartParams.showBuildingsStat = this.val$showBuildingsStatCheckBox.isSelected();
                            chartParams.showResearchesStat = this.val$showResearchesStatCheckBox.isSelected();
                            chartParams.showUpgradesStat = this.val$showUpgradesStatCheckBox.isSelected();
                            chartParams.showAbilityGroupsStat = this.val$showAbilityGroupsStatCheckBox.isSelected();
                            chartParams.barSize = (IconHandler.Size)((Object)this.val$barSizeComboBox.getSelectedItem());
                            chartParams.showAfterCompleted = this.val$showAfterCompletedCheckBox.isSelected();
                            break;
                        }
                        case UNIT_TIERS: {
                            chartParams.unitTiersGranularity = (Integer)this.val$unitTiersGranularityComboBox.getSelectedItem();
                            chartParams.stretchBars = this.val$stretchBarsCheckBox.isSelected();
                            chartParams.showAfterCompleted = this.val$showAfterCompletedCheckBox.isSelected();
                            break;
                        }
                        case MAP_VIEW: {
                            chartParams.mapViewQuality = (MapViewQuality)((Object)this.val$mapViewQualityComboBox.getSelectedItem());
                            chartParams.mapBackground = (MapBackground)((Object)this.val$mapBackgroundComboBox.getSelectedItem());
                            String string = (String)this.val$areaGranularityCountComboBox.getSelectedItem();
                            chartParams.areaGranularityCount = Integer.parseInt(string.substring(0, string.indexOf(120)));
                            chartParams.hideOverlappedBuildings = this.val$hideOverlappedBuildingsCheckBox.isSelected();
                            chartParams.fillBuildingIcons = this.val$fillBuildingIconsCheckBox.isSelected();
                            chartParams.showMapObjects = this.val$showMapObjectsCheckBox.isSelected();
                            break;
                        }
                        case MAIN_BUILDING_CONTROL: {
                            break;
                        }
                        case PRODUCTIONS: {
                            chartParams.groupSameProductions = this.val$groupSameProductionsCheckBox.isSelected();
                            chartParams.iconSizesP = (IconHandler.Size)((Object)this.val$iconSizesPComboBox.getSelectedItem());
                            break;
                        }
                        case PLAYER_SELECTIONS: {
                            chartParams.iconSizesPS = (IconHandler.Size)((Object)this.val$iconSizesPSComboBox.getSelectedItem());
                            break;
                        }
                        case PRODUCED_ARMY_SUPPLY: {
                            chartParams.includeInitialUnits = this.val$includeInitialUnitsCheckBox.isSelected();
                            chartParams.showAfterCompleted = this.val$showAfterCompletedCheckBox.isSelected();
                        }
                    }
                    if (n < 0) {
                        new ChartPainter(chartParams).paintChart();
                    }
                    ++n;
                }
            }

            @Override
            public Dimension getPreferredSize() {
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW && ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo != null) {
                    int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                    return new Dimension(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.width * n << 1, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * n << 1);
                }
                Dimension dimension = this.val$chartCanvasScrollPane.getViewport().getExtentSize();
                dimension.width *= Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                return dimension;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                ChartParams chartParams = (ChartParams)holder5.value;
                if (chartParams == null) {
                    return null;
                }
                if (chartParams.toolTipProvider == null) {
                    int n = chartParams.xToFrame(mouseEvent.getX());
                    return n < 0 ? null : Language.getText("module.repAnalyzer.tab.charts.chartTooltip.frameTime", n, ReplayUtils.formatFrames(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed));
                }
                return chartParams.toolTipProvider.getToolTip(mouseEvent.getPoint());
            }
        };
        final JComponent jComponent9 = holder2.value;
        jComponent9.setToolTipText("");
        jComponent9.setFocusable(true);
        GuiUtils.makeComponentDragScrollable(jComponent9);
        final BoolHolder boolHolder = new BoolHolder();
        final Task<Integer> task = new Task<Integer>(){

            @Override
            public void execute(Integer n) {
                if (holder5.value != null && ((GameEvents.Action[])holder3.value).length > 0) {
                    GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                    action.frame = n;
                    int n2 = Arrays.binarySearch((GameEvents.Action[])holder3.value, action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                    int n3 = n2 >= 0 ? n2 : (-n2 <= ((GameEvents.Action[])holder3.value).length ? -n2 - 1 : -n2 - 2);
                    boolHolder.value = true;
                    jList.setSelectedIndex(n3);
                    jList.ensureIndexIsVisible(n3);
                    boolHolder.value = false;
                }
            }
        };
        final Animator animator = new Animator(this.replay, actionListener, this.layeredPane, holder5, holder7, holder6, task);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                animator.requestToCancel();
            }
        });
        jComponent9.addMouseListener(new MouseAdapter((JSplitPane)object6, box, jPanel2){
            private boolean enlarged = false;
            private double storedDividerLocation;
            private final /* synthetic */ JSplitPane val$chartSplitPane;
            private final /* synthetic */ Box val$topBox;
            private final /* synthetic */ JPanel val$bottomPanel;
            {
                this.val$chartSplitPane = jSplitPane;
                this.val$topBox = box;
                this.val$bottomPanel = jPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JPopupMenu jPopupMenu;
                    if (ReplayAnalyzer.this.replayFile != null) {
                        jPopupMenu = new ReplayOperationsPopupMenu(new File[]{ReplayAnalyzer.this.replayFile}, new ReplayOpCallback(){

                            @Override
                            public void replayRenamed(File file, File file2, int n) {
                                ReplayAnalyzer.this.replayFile = file2;
                            }

                            @Override
                            public void replayMoved(File file, File file2, int n) {
                                ReplayAnalyzer.this.replayFile = new File(file2, file.getName());
                            }

                            @Override
                            public void replayDeleted(File file, int n) {
                            }

                            @Override
                            public void moveRenameDeleteEnded() {
                                ReplayAnalyzer.this.setTitle(GeneralUtils.getFileNameWithoutExt(ReplayAnalyzer.this.replayFile));
                                MainFrame.INSTANCE.refreshRepAnalNavigationNode();
                            }
                        });
                        jPopupMenu.addSeparator();
                    } else {
                        jPopupMenu = new JPopupMenu();
                    }
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Language.getText("module.repAnalyzer.tab.charts.chartMenu.enlargeChart"), this.enlarged ? Icons.APPLICATION_RESIZE_ACTUAL : Icons.APPLICATION_RESIZE_FULL, this.enlarged);
                    jCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.handleChartEnlarge();
                        }
                    });
                    jPopupMenu.add(jCheckBoxMenuItem);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getButton() == 1) {
                    if (jComboBox.getSelectedItem() != ChartType.MAP_VIEW && holder5.value != null) {
                        holder7.value = Math.max(25, mouseEvent.getX());
                        holder6.value = null;
                        task.execute(((ChartParams)holder5.value).xToFrame((Integer)holder7.value));
                        actionListener.actionPerformed(null);
                        animator.setCurrentFrame(((ChartParams)holder5.value).xToFrame((Integer)holder7.value));
                    }
                } else if (mouseEvent.getButton() == 2) {
                    this.handleChartEnlarge();
                }
            }

            private void handleChartEnlarge() {
                boolean bl = this.enlarged = !this.enlarged;
                if (this.enlarged) {
                    this.storedDividerLocation = this.val$chartSplitPane.getHeight() == 0 ? 1.0 : (double)this.val$chartSplitPane.getDividerLocation() / (double)this.val$chartSplitPane.getHeight();
                }
                this.val$topBox.setVisible(!this.enlarged);
                this.val$topBox.getParent().validate();
                this.val$bottomPanel.setVisible(!this.enlarged);
                if (!this.enlarged) {
                    this.val$chartSplitPane.setDividerLocation((int)((double)this.val$chartSplitPane.getHeight() * this.storedDividerLocation));
                }
            }
        });
        jScrollPane.setViewportView(jComponent9);
        ((JSplitPane)object6).setTopComponent(jScrollPane);
        final ActionListener actionListener9 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                float f = (float)jScrollPane.getHorizontalScrollBar().getValue() / (float)jScrollPane.getHorizontalScrollBar().getMaximum();
                float f2 = (float)jScrollPane.getVerticalScrollBar().getValue() / (float)jScrollPane.getVerticalScrollBar().getMaximum();
                int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                jLabel2.setBackground(n == 1 ? null : Color.GREEN);
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW) {
                    jScrollPane.setHorizontalScrollBarPolicy(32);
                    jScrollPane.setVerticalScrollBarPolicy(22);
                } else {
                    jScrollPane.setHorizontalScrollBarPolicy(n > 1 ? 32 : 31);
                    jScrollPane.setVerticalScrollBarPolicy(21);
                }
                jComponent9.invalidate();
                jScrollPane.validate();
                jScrollPane.getHorizontalScrollBar().setValue((int)((float)jScrollPane.getHorizontalScrollBar().getMaximum() * f));
                jScrollPane.getVerticalScrollBar().setValue((int)((float)jScrollPane.getVerticalScrollBar().getMaximum() * f2));
            }
        };
        actionListener9.actionPerformed(null);
        jComboBox2.addActionListener(actionListener9);
        jComboBox.addActionListener(new ActionListener(){
            private boolean lastWasMapView;
            {
                this.lastWasMapView = jComboBox2.getSelectedItem() == ChartType.MAP_VIEW;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = jComboBox.getSelectedItem() == ChartType.MAP_VIEW;
                if (bl ^ this.lastWasMapView) {
                    actionListener9.actionPerformed(null);
                }
                this.lastWasMapView = bl;
            }
        });
        jComponent9.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    int n = jComboBox2.getSelectedIndex() - mouseWheelEvent.getWheelRotation();
                    if (n < 0) {
                        n = 0;
                    }
                    if (n >= jComboBox2.getItemCount()) {
                        n = jComboBox2.getItemCount() - 1;
                    }
                    jComboBox2.setSelectedIndex(n);
                }
            }
        });
        Box box5 = Box.createHorizontalBox();
        box5.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.displayActionTypes")));
        box5.add(Box.createHorizontalStrut(5));
        Object object10 = ReplayConsts.ActionType.values();
        int n5 = ((ReplayConsts.ActionType[])object10).length;
        int n6 = 0;
        while (n6 < n5) {
            object2 = object10[n6];
            jComponent = GuiUtils.createCheckBox(((ReplayConsts.ActionType)((Object)object2)).textKey, "module.repAnalyzer.charts.actions.actionType." + ((Enum)object2).ordinal());
            ((AbstractButton)jComponent).addActionListener(actionListener2);
            enumMap.put((ReplayConsts.ActionType)((Object)object2), (JCheckBox)jComponent);
            box5.add(jComponent);
            box5.add(Box.createHorizontalStrut(5));
            ++n6;
        }
        box5.add(new JPanel(new BorderLayout()));
        box5.add(animator.getControlUIComponent());
        jPanel2.add((Component)box5, "North");
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && jList.getSelectedIndex() >= 0 && !boolHolder.value) {
                    holder7.value = null;
                    holder8.value = ((GameEvents.Action[])holder3.value)[jList.getSelectedIndex()];
                    holder6.value = ((GameEvents.Action)holder8.value).frame;
                    int n = (Integer)holder6.value;
                    animator.setCurrentFrame((Integer)holder6.value);
                    if (holder5.value != null) {
                        Rectangle rectangle = ((ChartParams)holder5.value).visibleRectangle;
                        if (((ChartParams)holder5.value).chartType == ChartType.MAP_VIEW) {
                            int n2;
                            int n3;
                            GameEvents.BaseUseAbilityAction baseUseAbilityAction;
                            GameEvents.Action action = (GameEvents.Action)jList.getSelectedValue();
                            if (action instanceof GameEvents.BaseUseAbilityAction && (baseUseAbilityAction = (GameEvents.BaseUseAbilityAction)action).hasTargetPoint() && !rectangle.contains(n3 = ((ChartParams)holder5.value).scaleMapCoord(baseUseAbilityAction.targetP1), n2 = (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * ((ChartParams)holder5.value).zoom << 1) - ((ChartParams)holder5.value).scaleMapCoord(baseUseAbilityAction.targetP2))) {
                                int n4 = Math.min(Math.min(10 * ((ChartParams)holder5.value).zoom, rectangle.width), rectangle.height);
                                jComponent9.scrollRectToVisible(new Rectangle(n3 - n4, n2 - n4, n4 << 1, n4 << 1));
                                jScrollPane.repaint();
                            }
                        } else if (n < rectangle.x || n >= rectangle.x + rectangle.width) {
                            jComponent9.scrollRectToVisible(new Rectangle(((ChartParams)holder5.value).frameToX(n) - (rectangle.width >> 2), 0, rectangle.width >> 1, 1));
                        }
                    }
                    actionListener.actionPerformed(null);
                }
            }
        });
        jList.setFont(new Font("Monospaced", 0, 12));
        object2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.invertColors", "module.repAnalyzer.charts.actions.invertColors");
        final JComboBox jComboBox12 = GuiUtils.createComboBox((Object[])IconHandler.Size.values(), "module.repAnalyzer.charts.actions.iconSize");
        jList.setCellRenderer(new ListCellRenderer((JCheckBox)object2, jCheckBox4){
            private final JLabel label = new JLabel();
            private final /* synthetic */ JCheckBox val$invertListColorsCheckBox;
            private final /* synthetic */ JCheckBox val$usePlayersColorsCheckBox;
            {
                this.val$invertListColorsCheckBox = jCheckBox;
                this.val$usePlayersColorsCheckBox = jCheckBox2;
                this.label.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                GameEvents.Action action = (GameEvents.Action)object;
                IconHandler.Size size = (IconHandler.Size)((Object)jComboBox12.getSelectedItem());
                if (size == IconHandler.Size.HIDDEN) {
                    this.label.setIcon(null);
                } else if (action instanceof GameEvents.UseUnitAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseUnitAbilityAction)action).unitAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.TrainAction) {
                    this.label.setIcon(Icons.getUnitIcon(((GameEvents.TrainAction)action).unit, size));
                } else if (action instanceof GameEvents.UseBuildingAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseBuildingAbilityAction)action).buildingAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.BuildAction) {
                    this.label.setIcon(Icons.getBuildingIcon(((GameEvents.BuildAction)action).building, size));
                } else if (action instanceof GameEvents.UpgradeAction) {
                    this.label.setIcon(Icons.getUpgradeIcon(((GameEvents.UpgradeAction)action).upgrade, size));
                } else if (action instanceof GameEvents.ResearchAction) {
                    this.label.setIcon(Icons.getResearchIcon(((GameEvents.ResearchAction)action).research, size));
                } else if (action instanceof GameEvents.BaseUseAbilityAction && ((GameEvents.BaseUseAbilityAction)action).abilityGroup != null) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.BaseUseAbilityAction)action).abilityGroup, size));
                } else {
                    this.label.setIcon(IconHandler.NULL.get((Object)size));
                }
                this.label.setText(action.toString());
                if (bl ^ this.val$invertListColorsCheckBox.isSelected()) {
                    this.label.setBackground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getSelectionBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? Color.WHITE : jList.getSelectionForeground());
                } else {
                    this.label.setBackground(jList.getBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getForeground());
                }
                this.label.setEnabled(jList.isEnabled());
                this.label.setFont(jList.getFont());
                return this.label;
            }
        });
        jPanel2.add((Component)new JScrollPane(jList), "Center");
        Box box6 = Box.createVerticalBox();
        object10 = new JPanel(new GridLayout(4, 2, 0, 0));
        ((Container)object10).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrame")));
        jComponent = new JTextField(1);
        jComponent.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrameToolTip"));
        ((JTextField)jComponent).addActionListener(new ActionListener((JTextField)jComponent, jList, actionListener){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            private final /* synthetic */ JList val$actionsList;
            private final /* synthetic */ ActionListener val$chartCanvasRepainterListener;
            {
                this.val$jumpToFrameTextField = jTextField;
                this.val$actionsList = jList;
                this.val$chartCanvasRepainterListener = actionListener;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((GameEvents.Action[])holder3.value).length > 0) {
                    try {
                        int n = Integer.parseInt(this.val$jumpToFrameTextField.getText());
                        GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        action.frame = n;
                        int n2 = Arrays.binarySearch((GameEvents.Action[])holder3.value, action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int n3 = n2 >= 0 ? n2 : (-n2 <= ((GameEvents.Action[])holder3.value).length ? -n2 - 1 : -n2 - 2);
                        this.val$actionsList.setSelectedIndex(n3);
                        this.val$actionsList.ensureIndexIsVisible(n3);
                        this.val$chartCanvasRepainterListener.actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        ((Container)object10).add(jComponent);
        ((Container)object10).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchText")));
        final JComboBox jComboBox13 = GuiUtils.createPredefinedListComboBox(Settings.PredefinedList.REP_ANAL_SEARCH);
        jComboBox13.setPreferredSize(new Dimension(1, 1));
        jComboBox13.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchTextToolTip"));
        jComboBox13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = string = jComboBox13.getSelectedItem() == null ? "" : jComboBox13.getSelectedItem().toString().trim().toLowerCase();
                if (((GameEvents.Action[])holder3.value).length > 0 && string.length() > 0) {
                    int n;
                    GameEvents.Action[] actionArray = (GameEvents.Action[])holder3.value;
                    int n2 = n = jList.getSelectedIndex() < 0 ? actionArray.length - 1 : jList.getSelectedIndex();
                    do {
                        if (++n2 == actionArray.length) {
                            n2 = 0;
                        }
                        if (!actionArray[n2].toString().toLowerCase().contains(string)) continue;
                        jList.setSelectedIndex(n2);
                        jList.ensureIndexIsVisible(n2);
                        actionListener.actionPerformed(null);
                        break;
                    } while (n2 != n);
                }
            }
        });
        ((Container)object10).add(jComboBox13);
        final JLabel jLabel6 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActions"));
        jLabel6.setOpaque(true);
        ((Container)object10).add(jLabel6);
        final JComboBox jComboBox14 = GuiUtils.createPredefinedListComboBox(Settings.PredefinedList.REP_ANAL_FILTER);
        final JComboBox jComboBox15 = GuiUtils.createPredefinedListComboBox(Settings.PredefinedList.REP_ANAL_FILTER_OUT);
        jComboBox14.setPreferredSize(new Dimension(1, 1));
        jComboBox14.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActionsToolTip"));
        final ActionListener actionListener10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                holder4.value = new TextFilter((String)jComboBox14.getSelectedItem(), (String)jComboBox15.getSelectedItem());
                jLabel6.setBackground(((TextFilter)holder4.value).isIncludeFilterActive() ? Color.GREEN : null);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jComboBox14.addActionListener(actionListener10);
        ((Container)object10).add(jComboBox14);
        final JLabel jLabel7 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActions"));
        jLabel7.setOpaque(true);
        ((Container)object10).add(jLabel7);
        jComboBox15.setPreferredSize(new Dimension(1, 1));
        jComboBox15.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActionsToolTip"));
        final ActionListener actionListener11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                holder4.value = new TextFilter((String)jComboBox14.getSelectedItem(), (String)jComboBox15.getSelectedItem());
                jLabel7.setBackground(((TextFilter)holder4.value).isExcludeFilterActive() ? Color.GREEN : null);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jComboBox15.addActionListener(actionListener11);
        ((Container)object10).add(jComboBox15);
        box6.add((Component)object10);
        object10 = new JPanel(new GridLayout(1, 2, 0, 0));
        ((Container)object10).add(new JLabel());
        JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.charts.actionOps.clearFiltersButton", new Object[0]);
        jButton.putClientProperty("JComponent.sizeVariant", "small");
        jButton.updateUI();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox14.setSelectedItem("");
                jComboBox15.setSelectedItem("");
                actionListener10.actionPerformed(null);
                actionListener11.actionPerformed(null);
                actionListener2.actionPerformed(null);
            }
        });
        ((Container)object10).add(jButton);
        box6.add((Component)object10);
        box6.add(new JPanel(new BorderLayout()));
        box6.setMinimumSize(new Dimension(10, 10));
        jPanel2.add((Component)box6, "East");
        Box box7 = Box.createHorizontalBox();
        box7.add(jLabel);
        box7.add(Box.createHorizontalStrut(12));
        ((AbstractButton)object2).addActionListener(actionListener4);
        box7.add((Component)object2);
        box7.add(Box.createHorizontalStrut(12));
        box7.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actions.iconSizes")));
        jComboBox12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.updateUI();
            }
        });
        box7.add(jComboBox12);
        box7.add(Box.createHorizontalStrut(12));
        jCheckBox.setOpaque(true);
        ActionListener actionListener12 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox.setBackground(jCheckBox.isSelected() ? Color.GREEN : null);
            }
        };
        actionListener12.actionPerformed(null);
        jCheckBox.addActionListener(actionListener12);
        jCheckBox.addActionListener(actionListener);
        box7.add(jCheckBox);
        box7.add(new JPanel(new BorderLayout()));
        box7.add(Box.createHorizontalStrut(5));
        JLabel jLabel8 = MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.ANALYZER);
        jLabel8.setHorizontalAlignment(4);
        box7.add(jLabel8);
        JLabel jLabel9 = MiscSettingsDialog.createLinkLabelToPredefinedListsSettings(Settings.PredefinedList.REP_ANAL_SEARCH);
        jLabel9.setHorizontalAlignment(4);
        box7.add(Box.createHorizontalStrut(5));
        box7.add(jLabel9);
        jPanel2.add((Component)box7, "South");
        ((JSplitPane)object6).setBottomComponent(jPanel2);
        jPanel.add((Component)object6);
        double d = (double)Settings.getInt("settings.misc.chartsActionListPartitioning") / 100.0;
        ((JSplitPane)object6).setResizeWeight(d);
        SwingUtilities.invokeLater(new Runnable((JSplitPane)object6, d){
            private final /* synthetic */ JSplitPane val$chartSplitPane;
            private final /* synthetic */ double val$resizeWeight;
            {
                this.val$chartSplitPane = jSplitPane;
                this.val$resizeWeight = d;
            }

            @Override
            public void run() {
                this.val$chartSplitPane.setDividerLocation(this.val$resizeWeight);
            }
        });
        actionListener2.actionPerformed(null);
        InputMap inputMap = this.layeredPane.getInputMap(1);
        ActionMap actionMap = this.layeredPane.getActionMap();
        ChartType[] chartTypeArray = ChartType.values();
        int n7 = chartTypeArray.length;
        int n8 = 0;
        while (n8 < n7) {
            final ChartType chartType = chartTypeArray[n8];
            if (chartType.keyStroke != null) {
                object = new Object();
                inputMap.put(chartType.keyStroke, object);
                actionMap.put(object, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jComboBox.setSelectedItem((Object)chartType);
                    }
                });
                object = new Object();
                inputMap.put(KeyStroke.getKeyStroke(chartType.keyStroke.getKeyCode(), chartType.keyStroke.getModifiers() | 1), object);
                actionMap.put(object, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OverlayChartFrame.invertOverlayChart(chartType, arrayList, ReplayAnalyzer.this.layeredPane, jScrollPane);
                    }
                });
            }
            ++n8;
        }
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(73, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() < jComboBox2.getItemCount() - 1) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() + 1);
                }
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(85, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() > 0) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() - 1);
                }
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(71, 2), object);
        actionMap.put(object, new AbstractAction((JCheckBox)object9){
            private final /* synthetic */ JCheckBox val$gridCheckBox;
            {
                this.val$gridCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$gridCheckBox.doClick(0);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(71, 3), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GridSettingsDialog(gridParams, (ChartParams)holder5.value, actionListener);
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(74, 2), object);
        actionMap.put(object, new AbstractAction((JTextField)jComponent){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            {
                this.val$jumpToFrameTextField = jTextField;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$jumpToFrameTextField.requestFocusInWindow();
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(83, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox13.requestFocusInWindow();
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(70, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox14.requestFocusInWindow();
            }
        });
        object = new Object();
        inputMap.put(KeyStroke.getKeyStroke(84, 2), object);
        actionMap.put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox15.requestFocusInWindow();
            }
        });
        return jPanel;
    }

    private static String buildProfileToolTip(ProfileCache.Profile profile, int n) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        stringBuilder.append("&nbsp;&nbsp;<b><img src=\"").append(Icons.RESOURCE_ACHIEVEMENT).append("\" border=0>");
        stringBuilder.append(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.achievementPoints", profile.achievementPoints));
        stringBuilder.append(",&nbsp;&nbsp;");
        stringBuilder.append(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.leagueWins", profile.leagueWins));
        stringBuilder.append(",&nbsp;&nbsp;");
        stringBuilder.append(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.favoriteRace", profile.favoriteRace.stringValue));
        stringBuilder.append("</b><br><br>&nbsp;&nbsp;");
        stringBuilder.append(Language.getText("playerProfile.bestLeagues"));
        stringBuilder.append("<table border=1 width='100%'>");
        if (PORTRAIT_TOOL_TIP_BEST_LEAGUES_TABLE_HEADER == null) {
            PORTRAIT_TOOL_TIP_BEST_LEAGUES_TABLE_HEADER = "<tr><th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.format") + "<th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.league") + "<th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.rank");
        }
        stringBuilder.append(PORTRAIT_TOOL_TIP_BEST_LEAGUES_TABLE_HEADER);
        int n2 = 0;
        while (n2 < profile.bestRanks.length) {
            ProfileCache.Profile.TeamRank teamRank = profile.bestRanks[n2];
            if (teamRank != null) {
                --n;
                stringBuilder.append("<tr align=left>").append("<td>").append(n2 + 1).append('v').append(n2 + 1).append("<td><img src=\"").append(teamRank.league.getIconResourceForRank(teamRank.divisionRank)).append("\" width=16 height=16 border=0>").append(teamRank.league.stringValue).append("<td align=right style='background:#60e060;color:blue;font-weight:bold'>").append(teamRank.divisionRank);
            }
            ++n2;
        }
        stringBuilder.append("</table>&nbsp;&nbsp;");
        stringBuilder.append(Language.getText("playerProfile.allLeagues"));
        n2 = 0;
        stringBuilder.append("<table border=1 width='100%'>");
        if (PORTRAIT_TOOL_TIP_ALL_LEAGUES_TABLE_HEADER == null) {
            PORTRAIT_TOOL_TIP_ALL_LEAGUES_TABLE_HEADER = "<tr><th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.format") + "<th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.league") + "<th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.rank") + "<th>" + Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.teamMembers");
        }
        stringBuilder.append(PORTRAIT_TOOL_TIP_ALL_LEAGUES_TABLE_HEADER);
        int n3 = 0;
        while (n3 < profile.allRankss.length) {
            ProfileCache.Profile.TeamRank[] teamRankArray = profile.allRankss[n3];
            if (teamRankArray != null) {
                ProfileCache.Profile.TeamRank[] teamRankArray2 = teamRankArray;
                int n4 = teamRankArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ProfileCache.Profile.TeamRank teamRank = teamRankArray2[n5];
                    if (--n < 0) {
                        ++n2;
                    } else {
                        stringBuilder.append("<tr align=left>").append("<td>").append(n3 + 1).append('v').append(n3 + 1).append("<td><img src=\"").append(teamRank.league.getIconResourceForRank(teamRank.divisionRank)).append("\" width=16 height=16 border=0>").append(teamRank.league.stringValue).append("<td align=right style='background:#60e060;color:blue;font-weight:bold'>").append(teamRank.divisionRank).append("<td>");
                        int n6 = 0;
                        while (n6 < teamRank.teamMembers.length) {
                            if (n6 > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(teamRank.teamMembers[n6]);
                            ++n6;
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        stringBuilder.append("</table>");
        if (n2 > 0) {
            stringBuilder.append("<p style='font-weight:bold;font-style:italic'><br>").append(Language.getText("module.repAnalyzer.tab.charts.players.portraitToolTip.thereAreMoreRows", n2)).append("</p>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private JComponent createGameInfoTab() {
        Object[] objectArray;
        String[] stringArray;
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.setEditable(false);
        jTextArea.setTabSize(4);
        ArrayList<String> arrayList = new ArrayList<String>(16);
        if (this.replayFile != null) {
            arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.fileName", this.replayFile.getAbsolutePath()));
        }
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.version", this.replay.version));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.date", Language.formatDateTime(new Date(this.replay.details.saveTime))));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.recorderTimeZone", String.format(Locale.US, "%+.2f", Float.valueOf(this.replay.details.saveTimeZone))));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(this.replay.gameLength * 500, this.replay.converterGameSpeed)));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{this.replay.initData.gameSpeed}));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{this.replay.initData.gameType}));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{this.replay.initData.format}));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{this.replay.initData.gateway}));
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.replay.initData.getArrangedClientNames(this.replay.details.players);
        int n = ((String[])object).length;
        int n2 = 0;
        while (n2 < n) {
            String string = object[n2];
            if (string.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            ++n2;
        }
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.clients", stringBuilder));
        arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.details.mapName == this.replay.details.originalMapName ? this.replay.details.mapName : String.valueOf(this.replay.details.mapName) + " (" + this.replay.details.originalMapName + ")"));
        if (this.replay.initData.mapFileName != null) {
            arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.mapFile", this.replay.initData.mapFileName));
        }
        if (this.replay.mapInfo != null) {
            arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.mapSize", this.replay.mapInfo.getSizeString()));
            arrayList.add(Language.getText("module.repAnalyzer.tab.gameInfo.mapPlayableSize", this.replay.mapInfo.getPlayableSizeString()));
        }
        int n3 = 0;
        for (String string : arrayList) {
            n2 = string.indexOf(58);
            if (n2 <= n3) continue;
            n3 = n2;
        }
        for (String string : arrayList) {
            n2 = string.indexOf(58);
            GuiUtils.appendNewLine(jTextArea, String.format("%-" + n3 + "s%s", string.substring(0, n2), string.substring(n2)));
        }
        jTextArea.append("\n");
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.players"));
        n = -1;
        object = new ArrayList(2);
        ArrayList<String[]> arrayList2 = null;
        int[] nArray = this.replay.details.getTeamOrderPlayerIndices();
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n5];
            stringArray = this.replay.details.players[n6];
            if (stringArray.team != n) {
                arrayList2 = new ArrayList<String[]>(4);
                object.add(arrayList2);
                arrayList2.add(new String[]{Language.getText("module.repAnalyzer.tab.gameInfo.team", stringArray.team == Integer.MAX_VALUE ? Language.getText("general.unknown") : Integer.valueOf(stringArray.team))});
                n = stringArray.team;
            }
            objectArray = new String[stringArray.handicap < 100 ? 6 : 5];
            arrayList2.add((String[])objectArray);
            objectArray[0] = stringArray.playerId.name;
            objectArray[1] = stringArray.raceString();
            int n7 = ReplayUtils.calculatePlayerApm(this.replay, (Details.Player)stringArray);
            objectArray[2] = Language.getText("module.repAnalyzer.tab.charts.chartText.apm", n7);
            objectArray[3] = stringArray.type.stringValue;
            objectArray[3] = stringArray.type == ReplayConsts.PlayerType.COMPUTER ? String.valueOf(objectArray[3]) + " (" + stringArray.difficulty.stringValue + ")" : String.valueOf(objectArray[3]) + " (" + stringArray.playerId.getFullName() + ")";
            objectArray[4] = stringArray.getColorName();
            if (stringArray.handicap < 100) {
                objectArray[5] = Language.getText("module.repAnalyzer.tab.gameInfo.handicap", stringArray.handicap);
            }
            ++n5;
        }
        int[] nArray2 = new int[5];
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            List list = (List)object2.next();
            int n8 = 1;
            while (n8 < list.size()) {
                stringArray = (String[])list.get(n8);
                int n9 = nArray2.length - 1;
                while (n9 >= 0) {
                    if (stringArray[n9].length() > nArray2[n9]) {
                        nArray2[n9] = stringArray[n9].length();
                    }
                    --n9;
                }
                ++n8;
            }
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            List list = (List)object2.next();
            jTextArea.append("\n\t");
            GuiUtils.appendNewLine(jTextArea, ((String[])list.get(0))[0]);
            int n10 = 1;
            while (n10 < list.size()) {
                jTextArea.append("\t\t");
                stringArray = (String[])list.get(n10);
                int n11 = 0;
                while (n11 < stringArray.length) {
                    if (n11 == stringArray.length - 1) {
                        GuiUtils.appendNewLine(jTextArea, stringArray[n11]);
                    } else {
                        jTextArea.append(String.format("%-" + nArray2[n11] + "s, ", stringArray[n11]));
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        if (Settings.getBoolean("settings.misc.showWinners")) {
            jTextArea.append("\n");
            StringBuilder stringBuilder2 = new StringBuilder();
            objectArray = this.replay.details.players;
            int n12 = this.replay.details.players.length;
            int n13 = 0;
            while (n13 < n12) {
                object2 = objectArray[n13];
                if (((Details.Player)object2).isWinner != null && ((Details.Player)object2).isWinner.booleanValue()) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(((Details.Player)object2).playerId.name);
                }
                ++n13;
            }
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.winners", stringBuilder2.toString()));
        }
        jTextArea.setCaretPosition(0);
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }

    private JComponent createInGameChatTab() {
        Object object;
        Object object2;
        StyleContext styleContext = new StyleContext();
        Style style = styleContext.addStyle("default", StyleContext.getDefaultStyleContext().getStyle("default"));
        int n = 0;
        Object object3 = this.replay.details.players;
        int n2 = this.replay.details.players.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object3[n3];
            object = styleContext.addStyle("p" + n, style);
            StyleConstants.setForeground((MutableAttributeSet)object, ((Details.Player)object2).getDarkerColor());
            ++n;
            ++n3;
        }
        object2 = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        object3 = new JTextPane(){

            @Override
            public void paint(Graphics graphics) {
                Container container = this;
                while (!(container instanceof JViewport)) {
                    container = container.getParent();
                }
                Rectangle rectangle = ((JViewport)container).getViewRect();
                graphics.setColor(new Color(240, 240, 240));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                super.paint(graphics);
            }
        };
        ((JComponent)object3).setOpaque(false);
        ((JComponent)object3).setBackground(new Color(0, 0, 0, 0));
        object = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.hideMessageTarget", "module.repAnalyzer.inGameChat.hideMessageTargets");
        JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.showBlinks", "module.repAnalyzer.inGameChat.showBlinks");
        JCheckBox jCheckBox2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.formatIntoParagraphs", "module.repAnalyzer.inGameChat.formatIntoParagraphs");
        final Holder holder = new Holder();
        final ActionListener actionListener = new ActionListener((JCheckBox)object, jCheckBox, jCheckBox2, (JTextPane)object3, holder, styleContext){
            private final /* synthetic */ JCheckBox val$hideMessageTargetsCheckBox;
            private final /* synthetic */ JCheckBox val$showBlinksCheckBox;
            private final /* synthetic */ JCheckBox val$formatIntoParagraphsCheckBox;
            private final /* synthetic */ JTextPane val$chatTextPane;
            private final /* synthetic */ Holder val$translatedMessagesHolder;
            private final /* synthetic */ StyleContext val$STYLE_CONTEX;
            {
                this.val$hideMessageTargetsCheckBox = jCheckBox;
                this.val$showBlinksCheckBox = jCheckBox2;
                this.val$formatIntoParagraphsCheckBox = jCheckBox3;
                this.val$chatTextPane = jTextPane;
                this.val$translatedMessagesHolder = holder;
                this.val$STYLE_CONTEX = styleContext;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = this.val$hideMessageTargetsCheckBox.isSelected();
                boolean bl2 = this.val$showBlinksCheckBox.isSelected();
                boolean bl3 = this.val$formatIntoParagraphsCheckBox.isSelected();
                String string = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAll");
                String string2 = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAllies");
                this.val$chatTextPane.setText("");
                int n = 0;
                Document document = this.val$chatTextPane.getDocument();
                String[] stringArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.getArrangedClientNames(((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players);
                int n2 = 0;
                MessageEvents.Message[] messageArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages;
                int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages.length;
                int n4 = 0;
                while (n4 < n3) {
                    MessageEvents.Message message;
                    MessageEvents.Message message2 = messageArray[n4];
                    int n5 = n;
                    String string3 = null;
                    String string4 = stringArray[message2.client];
                    n += message2.time;
                    if (message2 instanceof MessageEvents.Text) {
                        String string5;
                        message = (MessageEvents.Text)message2;
                        String string6 = string5 = this.val$translatedMessagesHolder.value == null ? message.text : ((String[])this.val$translatedMessagesHolder.value)[n2++];
                        string3 = bl ? Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageNoTarget", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, string5) : Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageFull", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, message.opCode == 0 ? string : string2, string5);
                    } else if (message2 instanceof MessageEvents.Blink && bl2) {
                        message = (MessageEvents.Blink)message2;
                        string3 = Language.getText("module.repAnalyzer.tab.inGameChat.blinkMessage", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).x), ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).y));
                    }
                    if (string3 != null) {
                        try {
                            document.insertString(document.getLength(), bl3 && n - n5 > 6000 && n5 > 0 ? "\n" + string3 + "\n" : String.valueOf(string3) + "\n", this.val$STYLE_CONTEX.getStyle("p" + message2.client));
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    ++n4;
                }
                this.val$chatTextPane.setCaretPosition(0);
            }
        };
        ((AbstractButton)object).addActionListener(actionListener);
        jCheckBox.addActionListener(actionListener);
        jCheckBox2.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        box2.add((Component)object);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(jCheckBox);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(jCheckBox2);
        box.add(box2);
        Box box3 = Box.createHorizontalBox();
        final JButton jButton = new JButton(Icons.ARROW_CURVE_180);
        GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.inGameChat.restoreOriginalButton", new Object[0]);
        jButton.setEnabled(false);
        jButton.updateUI();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                holder.value = null;
                jButton.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jButton.updateUI();
                    }
                });
                actionListener.actionPerformed(null);
            }
        });
        box3.add(jButton);
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(GoogleTranslator.Language.values(), EnumSet.of(GoogleTranslator.Language.AUTO_DETECT, GoogleTranslator.Language.UNKNOWN)), "module.repAnalyzer.inGameChat.targetLanguage");
        final JComboBox jComboBox2 = GuiUtils.createComboBox((Object[])GoogleTranslator.Language.values(), "module.repAnalyzer.inGameChat.sourceLanguage");
        final JButton jButton2 = new JButton(Icons.LOCALE);
        GuiUtils.updateButtonText(jButton2, "module.repAnalyzer.tab.inGameChat.translateButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                jButton2.updateUI();
                new NormalThread("Translator"){

                    @Override
                    public void run() {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        MessageEvents.Message[] messageArray = ((ReplayAnalyzer)(this).ReplayAnalyzer.this).replay.messageEvents.messages;
                        int n = ((ReplayAnalyzer)(this).ReplayAnalyzer.this).replay.messageEvents.messages.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MessageEvents.Message message = messageArray[n2];
                            if (message instanceof MessageEvents.Text) {
                                arrayList.add(((MessageEvents.Text)message).text);
                            }
                            ++n2;
                        }
                        holder.value = GoogleTranslator.translateTexts(arrayList.toArray(new String[arrayList.size()]), (GoogleTranslator.Language)((Object)jComboBox2.getSelectedItem()), (GoogleTranslator.Language)((Object)jComboBox.getSelectedItem()));
                        jButton.setEnabled(holder.value != null);
                        jButton2.setEnabled(true);
                        actionListener.actionPerformed(null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jButton.updateUI();
                                jButton2.updateUI();
                            }
                        });
                    }
                }.start();
            }
        });
        box3.add(jButton2);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.inGameChat.targetLanguage")));
        jComboBox.setMaximumRowCount(12);
        box3.add(jComboBox);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.inGameChat.sourceLanguage")));
        jComboBox2.setMaximumRowCount(12);
        box3.add(jComboBox2);
        box.add(box3);
        ((Container)object2).add((Component)GuiUtils.wrapInPanel(box), "North");
        ((JTextComponent)object3).setEditable(false);
        ((Container)object2).add((Component)new JScrollPane((Component)object3), "Center");
        return object2;
    }

    private JComponent createMapPreviewTab() {
        Object object;
        Object object2;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        Box box = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.mapInfo == null ? this.replay.details.mapName : String.valueOf(this.replay.details.mapName) + " " + this.replay.mapInfo.getPlayableSizeString() + " (" + this.replay.mapInfo.getSizeString() + ")"), 0);
        GuiUtils.changeFontToBold(jLabel2);
        box.add(GuiUtils.wrapInPanel(jLabel2));
        if (this.replay.mapInfo == null && (serializable = MapParser.getMapFile(this.replay)) != null && !((File)serializable).exists() && ((String)(object2 = ((File)serializable).getName())).length() == 69) {
            object = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            JLabel jLabel3 = new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.mapFileNotExists"), 0);
            box2.add(jLabel3);
            box2.add(Box.createHorizontalStrut(5));
            Box box3 = Box.createHorizontalBox();
            JComboBox jComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(ReplayConsts.Gateway.values(), EnumSet.of(ReplayConsts.Gateway.UNKNOWN)), "module.repAnalyzer.mapPreview.downloadFromGateway");
            JButton jButton = new JButton(Icons.DRIVE_DOWNLOAD);
            GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.downloadMapButton", new Object[0]);
            jButton.addActionListener(new ActionListener((Box)object, box3, jButton, jLabel3, jComboBox, (String)object2, (File)serializable, jPanel, box2){
                private final /* synthetic */ Box val$downloadBox;
                private final /* synthetic */ Box val$downloadSourceBox;
                private final /* synthetic */ JButton val$downloadButton;
                private final /* synthetic */ JLabel val$downloadInfoLabel;
                private final /* synthetic */ JComboBox val$downloadFromGatewayComboBox;
                private final /* synthetic */ String val$mapFileName;
                private final /* synthetic */ File val$mapFile;
                private final /* synthetic */ JPanel val$mapPreviewPanel;
                private final /* synthetic */ Box val$controlBox;
                {
                    this.val$downloadBox = box;
                    this.val$downloadSourceBox = box2;
                    this.val$downloadButton = jButton;
                    this.val$downloadInfoLabel = jLabel;
                    this.val$downloadFromGatewayComboBox = jComboBox;
                    this.val$mapFileName = string;
                    this.val$mapFile = file;
                    this.val$mapPreviewPanel = jPanel;
                    this.val$controlBox = box3;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$downloadBox.remove(this.val$downloadSourceBox);
                    this.val$downloadButton.setEnabled(false);
                    this.val$downloadInfoLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.downloadingMap"));
                    String string = String.valueOf(((ReplayConsts.Gateway)((Object)this.val$downloadFromGatewayComboBox.getSelectedItem())).depotServerUrl) + this.val$mapFileName;
                    Downloader[] downloaderArray = new Downloader[1];
                    Downloader downloader = downloaderArray[0] = new Downloader(string, this.val$mapFile, true, new DownloaderCallback(downloaderArray){
                        private final InternalFrameListener downloadStopperListener;
                        {
                            this.downloadStopperListener = new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                    downloaderArray[0].requestToCancel();
                                }
                            };
                            ReplayAnalyzer.this.addInternalFrameListener(this.downloadStopperListener);
                        }

                        @Override
                        public void downloadFinished(boolean bl) {
                            ReplayAnalyzer.this.removeInternalFrameListener(this.downloadStopperListener);
                            if (!ReplayAnalyzer.this.isClosed()) {
                                val$downloadInfoLabel.setText(Language.getText(bl ? "module.repAnalyzer.tab.mapPreview.mapDownloaded" : "module.repAnalyzer.tab.mapPreview.mapDownloadFailed"));
                                val$controlBox.remove(val$downloadButton);
                                JButton jButton = new JButton(Icons.ARROW_CIRCLE_DOUBLE);
                                GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.reopenReplayButton", new Object[0]);
                                jButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        try {
                                            ReplayAnalyzer.this.setClosed(true);
                                        }
                                        catch (PropertyVetoException propertyVetoException) {
                                            // empty catch block
                                        }
                                        MainFrame.INSTANCE.openReplayFile(ReplayAnalyzer.this.replayFile);
                                    }
                                });
                                val$controlBox.add(jButton);
                                val$mapPreviewPanel.validate();
                            }
                        }
                    });
                    this.val$downloadBox.add(downloader.getProgressBar());
                    this.val$mapPreviewPanel.validate();
                    downloader.start();
                }
            });
            box2.add(jButton);
            ((Container)object).add(box2);
            box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.downloadFromGateway")));
            box3.add(jComboBox);
            ((Container)object).add(box3);
            box.add((Component)object);
        }
        serializable = Box.createHorizontalBox();
        ((Container)serializable).add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.zoom")));
        object2 = new JSlider(0, 6, Settings.getInt("module.repAnalyzer.mapPreview.zoom"));
        ((JSlider)object2).setPaintLabels(true);
        ((JSlider)object2).setPaintTicks(true);
        ((JSlider)object2).setSnapToTicks(true);
        ((JSlider)object2).setMajorTickSpacing(1);
        ((JSlider)object2).setLabelTable(LABEL_DICTIONARY);
        object = new ChangeListener((JSlider)object2, jLabel){
            private final /* synthetic */ JSlider val$zoomSlider;
            private final /* synthetic */ JLabel val$mapPreviewLabel;
            {
                this.val$zoomSlider = jSlider;
                this.val$mapPreviewLabel = jLabel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (this.val$zoomSlider.getValueIsAdjusting()) {
                    return;
                }
                int n = this.val$zoomSlider.getValue();
                if (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo == null) {
                    this.val$mapPreviewLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.previewNotAvailable"));
                } else {
                    int n2 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconWidth();
                    int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconHeight();
                    this.val$mapPreviewLabel.setIcon(new ImageIcon(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getImage().getScaledInstance(n == 0 ? n2 / 2 : n2 * n, n == 0 ? n3 / 2 : n3 * n, 4)));
                }
                if (changeEvent != null) {
                    Settings.set("module.repAnalyzer.mapPreview.zoom", n);
                }
            }
        };
        object.stateChanged(null);
        ((JSlider)object2).addChangeListener((ChangeListener)object);
        ((Container)serializable).add((Component)object2);
        box.add((Component)serializable);
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        jLabel.setHorizontalAlignment(0);
        GuiUtils.makeComponentDragScrollable(jLabel);
        jPanel.add((Component)new JScrollPane(jLabel), "Center");
        return jPanel;
    }

    public static enum ChartType {
        APM("module.repAnalyzer.tab.charts.chartType.apm", true),
        HOTKEYS("module.repAnalyzer.tab.charts.chartType.hotkeys", true),
        BUILDS_TECH("module.repAnalyzer.tab.charts.chartType.buildsTech", true),
        BUILDS_TECH_STAT("module.repAnalyzer.tab.charts.chartType.buildsTechStat", true),
        UNIT_TIERS("module.repAnalyzer.tab.charts.chartType.unitTiers", false),
        MAP_VIEW("module.repAnalyzer.tab.charts.chartType.mapView", true),
        MAIN_BUILDING_CONTROL("module.repAnalyzer.tab.charts.chartType.mainBuildingControl", false),
        PRODUCTIONS("module.repAnalyzer.tab.charts.chartType.productions", false),
        PLAYER_SELECTIONS("module.repAnalyzer.tab.charts.chartType.playerSelections", false),
        RESOURCES_SPENT("module.repAnalyzer.tab.charts.chartType.resourcesSpent", true),
        PRODUCED_ARMY_SUPPLY("module.repAnalyzer.tab.charts.chartType.producedArmySupply", true);

        public final String stringValue;
        public final KeyStroke keyStroke;
        public final boolean supportsAllOnOneChart;

        private ChartType(String string2, boolean bl) {
            this.stringValue = Language.getText(string2);
            int n2 = this.ordinal() + 1;
            this.keyStroke = n2 > 10 ? null : KeyStroke.getKeyStroke(48 + (n2 == 10 ? 0 : n2), 2);
            this.supportsAllOnOneChart = bl;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MapBackground {
        MAP_IMAGE("module.repAnalyzer.tab.charts.mapView.background.mapImage", true, false),
        HOT_POINTS("module.repAnalyzer.tab.charts.mapView.background.hotPoints", false, false),
        MAP_IMAGE_AND_HOT_POINTS("module.repAnalyzer.tab.charts.mapView.background.mapImageAndHotPoints", true, false),
        HOT_AREAS("module.repAnalyzer.tab.charts.mapView.background.hotAreas", false, true),
        MAP_IMAGE_AND_HOT_AREAS("module.repAnalyzer.tab.charts.mapView.background.mapImageAndHotAreas", true, true),
        CAMERA_AREAS("module.repAnalyzer.tab.charts.mapView.background.cameraAreas", false, true),
        MAP_IMAGE_AND_CAMERA_AREAS("module.repAnalyzer.tab.charts.mapView.background.mapImageAndCameraAreas", true, true),
        BLANK("module.repAnalyzer.tab.charts.mapView.background.blank", false, false);

        public final String stringValue;
        public final boolean requiresMapImage;
        public final boolean involvesAreaAggregation;

        private MapBackground(String string2, boolean bl, boolean bl2) {
            this.stringValue = Language.getText(string2);
            this.requiresMapImage = bl;
            this.involvesAreaAggregation = bl2;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MapViewQuality {
        LOW("module.repAnalyzer.tab.charts.mapView.quality.low", RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR),
        MEDIUM("module.repAnalyzer.tab.charts.mapView.quality.medium", RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        HIGH("module.repAnalyzer.tab.charts.mapView.quality.high", RenderingHints.VALUE_INTERPOLATION_BICUBIC);

        public final String stringValue;
        public final Object hintValue;

        private MapViewQuality(String string2, Object object) {
            this.stringValue = Language.getText(string2);
            this.hintValue = object;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ShowDuration {
        NONE("module.repAnalyzer.tab.charts.buildsTech.showDuration.none"),
        LINES("module.repAnalyzer.tab.charts.buildsTech.showDuration.lines"),
        BARS("module.repAnalyzer.tab.charts.buildsTech.showDuration.bars");

        public final String stringValue;

        private ShowDuration(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ShowProfileInfo {
        PORTRAIT_AND_LEAGUES("module.repAnalyzer.tab.charts.showProfileInfo.portraitAndLeagues"),
        LEAGUES_ONLY("module.repAnalyzer.tab.charts.showProfileInfo.leaguesOnly"),
        NONE("module.repAnalyzer.tab.charts.showProfileInfo.none");

        public final String stringValue;

        private ShowProfileInfo(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

