/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.components.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.components.TableBox;
import hu.belicza.andras.sc2gears.ui.dialogs.FindDuplicatesDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchFieldGroup;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildOrderSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ChatMessageSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.DateSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FileNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FormatSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameLengthSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameTypeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GatewaySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.MapNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.PlayerSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.RaceMatchupSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ResearchSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UpgradeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.VersionSearchField;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.ReplayCache;
import hu.belicza.andras.sc2gearspluginapi.api.listener.ReplayOpCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReplaySearch
extends ModuleFrame {
    private static final String[] RESULT_HEADER_KEYS = new String[]{"module.repSearch.tab.results.header.version", "module.repSearch.tab.results.header.type", "module.repSearch.tab.results.header.gateway", "module.repSearch.tab.results.header.fileDate", "module.repSearch.tab.results.header.map", "module.repSearch.tab.results.header.raceMatchup", "module.repSearch.tab.results.header.apms", "module.repSearch.tab.results.header.length", "module.repSearch.tab.results.header.players", "module.repSearch.tab.results.header.file", "module.repSearch.tab.results.header.comment"};
    public static final int COLUMN_FILE_NAME;
    private static final int COLUMN_COMMENT;
    private static final int COLUMN_SAVE_TIME;
    private static final String[] RESULT_HEADER_NAMES;
    private static final AtomicInteger counter;
    private volatile boolean temporarilyDisableFilters;
    private final JList sourceList = new JList(new DefaultListModel());
    private final JCheckBox autoSortSourcesCheckBox = GuiUtils.createCheckBox("module.repSearch.tab.source.autoSort", "module.repSearch.source.autoSort");
    private final JButton performSearchButton = new JButton(Icons.BINOCULAR_ARROW);
    private SearchFieldGroup[] searchFieldGroups;
    private File initialReplayList;

    static {
        RESULT_HEADER_NAMES = new String[RESULT_HEADER_KEYS.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < RESULT_HEADER_KEYS.length) {
            ReplaySearch.RESULT_HEADER_NAMES[n4] = Language.getText(RESULT_HEADER_KEYS[n4]);
            if ("module.repSearch.tab.results.header.file".equals(RESULT_HEADER_KEYS[n4])) {
                n = n4;
            } else if ("module.repSearch.tab.results.header.comment".equals(RESULT_HEADER_KEYS[n4])) {
                n2 = n4;
            } else if ("module.repSearch.tab.results.header.fileDate".equals(RESULT_HEADER_KEYS[n4])) {
                n3 = n4;
            }
            ++n4;
        }
        COLUMN_FILE_NAME = n;
        COLUMN_COMMENT = n2;
        COLUMN_SAVE_TIME = n3;
        counter = new AtomicInteger();
    }

    public ReplaySearch(Object ... objectArray) {
        super(Language.getText("module.repSearch.title", counter.incrementAndGet()));
        Object object;
        Object object2;
        Serializable serializable;
        boolean bl;
        this.setFrameIcon(Icons.BINOCULAR);
        Boolean bl2 = objectArray.length > 3 ? (Boolean)objectArray[3] : null;
        boolean bl3 = bl2 != null && bl2 == false;
        this.buildGUI(bl3);
        boolean bl4 = objectArray.length > 0 && objectArray[0] != null;
        boolean bl5 = objectArray.length > 1 && objectArray[1] != null;
        boolean bl6 = objectArray.length > 2 && objectArray[2] != null;
        boolean bl7 = bl = objectArray.length > 4 && objectArray[4] != null;
        if (bl4) {
            this.loadReplaySourceFile((File)objectArray[0]);
        }
        if (bl5) {
            serializable = (File)objectArray[1];
            if (bl || bl3) {
                object2 = ReplaySearch.loadReplayListFile((File)serializable);
                DefaultListModel defaultListModel = (DefaultListModel)this.sourceList.getModel();
                object = object2.iterator();
                while (object.hasNext()) {
                    Object[] objectArray2 = (Object[])object.next();
                    defaultListModel.addElement(new File((String)objectArray2[COLUMN_FILE_NAME]));
                }
            } else {
                this.initialReplayList = serializable;
            }
        }
        if (bl6) {
            serializable = (DefaultListModel)this.sourceList.getModel();
            object = (File[])objectArray[2];
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object[n2];
                ((DefaultListModel)serializable).addElement(object2);
                ++n2;
            }
        }
        if (bl) {
            this.loadSearchFiltersFile((File)objectArray[4]);
        }
        if ((bl2 == null || bl2.booleanValue()) && (bl4 || bl5 || bl6 || bl)) {
            if (!bl) {
                this.temporarilyDisableFilters = true;
            }
            this.performSearchButton.doClick();
        }
    }

    private void buildGUI(boolean bl) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.sourceList.setCellRenderer(new ListCellRenderer(){
            private final JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                File file = (File)object;
                this.label.setText(file.getAbsolutePath());
                this.label.setIcon(file.isDirectory() ? Icons.FOLDER : (GuiUtils.SC2_REPLAY_FILTER.accept(file) ? Icons.SC2 : Icons.DOCUMENT));
                if (bl) {
                    this.label.setBackground(jList.getSelectionBackground());
                    this.label.setForeground(jList.getSelectionForeground());
                } else {
                    this.label.setBackground(jList.getBackground());
                    this.label.setForeground(jList.getForeground());
                }
                this.label.setFont(jList.getFont());
                this.label.setOpaque(true);
                return this.label;
            }
        });
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.source.title"), Icons.FOLDERS_STACK, false, jTabbedPane, this.createSourceTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.filters.title"), Icons.EDIT_COLUMN, false, jTabbedPane, this.createFiltersTab(jTabbedPane), null);
        if (bl) {
            jTabbedPane.setSelectedIndex(1);
        }
        this.getContentPane().add(jTabbedPane);
    }

    private JComponent createSourceTab() {
        final JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
        JButton jButton = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.source.loadReplaySourceButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Replay sources");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectLoadReplaySource"));
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    ReplaySearch.this.loadReplaySourceFile(jFileChooser.getSelectedFile());
                }
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(Icons.DISK);
        GuiUtils.updateButtonText(jButton2, "module.repSearch.tab.source.saveReplaySourceButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Replay sources");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectSaveReplaySource"));
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (!GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        file = new File(String.valueOf(file.getAbsolutePath()) + ".sc2repsrc");
                    }
                    ReplaySearch.this.saveReplaySourceFile(file);
                }
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(Icons.FOLDERS);
        GuiUtils.updateButtonText(jButton3, "module.repSearch.tab.source.addFoldersButton", new Object[0]);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(GeneralUtils.getDefaultReplayFolder());
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectFoldersToAdd"));
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(true);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        defaultListModel.addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton(Icons.SC2);
        GuiUtils.updateButtonText(jButton4, "module.repSearch.tab.source.addFilesButton", new Object[0]);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(GeneralUtils.getDefaultReplayFolder());
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectReplaysToAdd"));
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
                jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ((DefaultListModel)ReplaySearch.this.sourceList.getModel()).addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        jPanel2.add(jButton4);
        box.add(jPanel2);
        JButton jButton5 = new JButton(Icons.BINOCULAR_ARROW);
        GuiUtils.updateButtonText(jButton5, "module.repSearch.tab.source.listAllReplays", new Object[0]);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaySearch.this.temporarilyDisableFilters = true;
                ReplaySearch.this.performSearchButton.doClick();
            }
        });
        box.add(GuiUtils.wrapInPanel(jButton5));
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        jPanel.add((Component)new JScrollPane(this.sourceList), "Center");
        this.sourceList.setOpaque(false);
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1));
        final JButton jButton6 = new JButton(Icons.SORT_ALPHABET);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton6.setEnabled(!ReplaySearch.this.autoSortSourcesCheckBox.isSelected());
                if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                    ReplaySearch.this.sortSources();
                }
                jPanel.updateUI();
            }
        };
        actionListener.actionPerformed(null);
        this.autoSortSourcesCheckBox.addActionListener(actionListener);
        jPanel3.add(this.autoSortSourcesCheckBox);
        GuiUtils.updateButtonText(jButton6, "module.repSearch.tab.source.sortButton", new Object[0]);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaySearch.this.sortSources();
            }
        });
        jPanel3.add(jButton6);
        JButton jButton7 = new JButton(Icons.TABLE_DELETE_ROW);
        GuiUtils.updateButtonText(jButton7, "module.repSearch.tab.source.removeSelectedButton", new Object[0]);
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int[] nArray = ReplaySearch.this.sourceList.getSelectedIndices();
                int n = nArray.length - 1;
                while (n >= 0) {
                    defaultListModel.remove(nArray[n]);
                    --n;
                }
            }
        });
        jPanel3.add(jButton7);
        JButton jButton8 = new JButton(Icons.BROOM);
        GuiUtils.updateButtonText(jButton8, "module.repSearch.tab.source.purgeButton", new Object[0]);
        jButton8.setToolTipText(Language.getText("module.repSearch.tab.source.purgeButtonToopTip"));
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int n = defaultListModel.getSize() - 1;
                while (n >= 0) {
                    File file = (File)defaultListModel.get(n);
                    if (file.exists()) {
                        int n2 = defaultListModel.getSize() - 1;
                        while (n2 >= 0) {
                            if (n2 != n && GeneralUtils.isDescendant((File)defaultListModel.get(n2), file)) {
                                defaultListModel.remove(n);
                                break;
                            }
                            --n2;
                        }
                    } else {
                        defaultListModel.remove(n);
                    }
                    --n;
                }
            }
        });
        jPanel3.add(jButton8);
        jPanel.add((Component)GuiUtils.wrapInPanel(jPanel3), "East");
        new DropTarget(this.sourceList, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor dataFlavor = dataFlavorArray[n2];
                    if (dataFlavor.isFlavorJavaFileListType()) {
                        dropTargetDropEvent.acceptDrop(3);
                        try {
                            List list = (List)transferable.getTransferData(dataFlavor);
                            DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                            for (File file : list) {
                                defaultListModel.addElement(file);
                            }
                            if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                                ReplaySearch.this.sortSources();
                            }
                            dropTargetDropEvent.dropComplete(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            dropTargetDropEvent.rejectDrop();
                        }
                        break;
                    }
                    ++n2;
                }
            }
        });
        return jPanel;
    }

    private void loadReplaySourceFile(File file) {
        block13: {
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    DefaultListModel defaultListModel = (DefaultListModel)this.sourceList.getModel();
                    defaultListModel.removeAllElements();
                    while (bufferedReader.ready()) {
                        defaultListModel.addElement(new File(bufferedReader.readLine()));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToLoadRepSource"), new Frame[0]);
                    if (bufferedReader == null) break block13;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveReplaySourceFile(File file) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(file, "UTF-8");
                ListModel listModel = this.sourceList.getModel();
                int n = listModel.getSize();
                int n2 = 0;
                while (n2 < n) {
                    printWriter.println(listModel.getElementAt(n2));
                    ++n2;
                }
                printWriter.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.source.repSourceSaved"), new Frame[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToSaveRepSource"), new Frame[0]);
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static List<Object[]> loadReplayListFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            bufferedReader.readLine();
            String[] stringArray = bufferedReader.readLine().split(";");
            int[] nArray = new int[RESULT_HEADER_KEYS.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = -1;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (RESULT_HEADER_KEYS[n].equals(stringArray[n3])) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                nArray[n] = n2;
                ++n;
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while ((string = bufferedReader.readLine()) != null) {
                Object[] objectArray = new Object[RESULT_HEADER_KEYS.length];
                String[] stringArray2 = GeneralUtils.splitBySemicolon(string);
                int n4 = RESULT_HEADER_KEYS.length - 1;
                while (n4 >= 0) {
                    objectArray[n4] = nArray[n4] < 0 ? "" : stringArray2[nArray[n4]];
                    --n4;
                }
                arrayList.add(objectArray);
            }
            ArrayList<Object[]> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToLoadRepList"), new Frame[0]);
            return null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void saveReplayListFile(File file, List<Object[]> list) {
        PrintWriter printWriter = null;
        try {
            try {
                Object[] objectArray;
                printWriter = new PrintWriter(file, "UTF-8");
                String[] stringArray = RESULT_HEADER_NAMES;
                int n = RESULT_HEADER_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    objectArray = stringArray[n2];
                    printWriter.print(objectArray.replace(';', '_'));
                    printWriter.print(';');
                    ++n2;
                }
                printWriter.println();
                stringArray = RESULT_HEADER_KEYS;
                n = RESULT_HEADER_KEYS.length;
                n2 = 0;
                while (n2 < n) {
                    objectArray = stringArray[n2];
                    printWriter.print((String)objectArray);
                    printWriter.print(';');
                    ++n2;
                }
                printWriter.println();
                Iterator<Object[]> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray2 = objectArray = iterator.next();
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray2[n4];
                        printWriter.print(((String)object).replace(';', '_'));
                        printWriter.print(';');
                        ++n4;
                    }
                    printWriter.println();
                }
                printWriter.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.results.repListSaved"), new Frame[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToSaveRepList"), new Frame[0]);
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void sortSources() {
        ListModel listModel = this.sourceList.getModel();
        File[] fileArray = new File[listModel.getSize()];
        int n = fileArray.length - 1;
        while (n >= 0) {
            fileArray[n] = (File)listModel.getElementAt(n);
            --n;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.isDirectory() && !file2.isDirectory()) {
                    return -1;
                }
                if (!file.isDirectory() && file2.isDirectory()) {
                    return 1;
                }
                return file.compareTo(file2);
            }
        });
        DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            defaultListModel.addElement(file);
            ++n3;
        }
        this.sourceList.setModel(defaultListModel);
    }

    private JComponent createFiltersTab(final JTabbedPane jTabbedPane) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout()){

            @Override
            public void setUI(PanelUI panelUI) {
                super.setUI(panelUI);
                if (ReplaySearch.this.searchFieldGroups != null) {
                    ReplaySearch.this.packSearchFields();
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        this.searchFieldGroups = new SearchFieldGroup[]{new SearchFieldGroup(jScrollPane, PlayerSearchField.class), new SearchFieldGroup(jScrollPane, MapNameSearchField.class), new SearchFieldGroup(jScrollPane, RaceMatchupSearchField.class), new SearchFieldGroup(jScrollPane, FileNameSearchField.class), new SearchFieldGroup(jScrollPane, ChatMessageSearchField.class), new SearchFieldGroup(jScrollPane, FormatSearchField.class), new SearchFieldGroup(jScrollPane, GameTypeSearchField.class), new SearchFieldGroup(jScrollPane, GatewaySearchField.class), new SearchFieldGroup(jScrollPane, DateSearchField.class), new SearchFieldGroup(jScrollPane, GameLengthSearchField.class), new SearchFieldGroup(jScrollPane, VersionSearchField.class), new SearchFieldGroup(jScrollPane, BuildOrderSearchField.class), new SearchFieldGroup(jScrollPane, BuildingSearchField.class), new SearchFieldGroup(jScrollPane, UnitSearchField.class), new SearchFieldGroup(jScrollPane, ResearchSearchField.class), new SearchFieldGroup(jScrollPane, UpgradeSearchField.class), new SearchFieldGroup(jScrollPane, UnitAbilitySearchField.class), new SearchFieldGroup(jScrollPane, BuildingAbilitySearchField.class)};
        Box box = Box.createHorizontalBox();
        GuiUtils.updateButtonText(this.performSearchButton, "module.repSearch.tab.filters.performSearchButton", new Object[0]);
        this.performSearchButton.addActionListener(new ActionListener(){
            private int resultsTabCounter = 1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray;
                if (ReplaySearch.this.temporarilyDisableFilters) {
                    ReplaySearch.this.temporarilyDisableFilters = false;
                    objectArray = ReplaySearch.this.createResultsTab(new SearchFieldGroup[0]);
                } else {
                    boolean bl = true;
                    SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                    int n = searchFieldGroupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                        bl &= searchFieldGroup.validateAll();
                        ++n2;
                    }
                    if (!bl) {
                        GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.filters.invalidFieldsError"), new Frame[0]);
                        return;
                    }
                    objectArray = ReplaySearch.this.createResultsTab(ReplaySearch.this.searchFieldGroups);
                }
                GuiUtils.addNewTab(Language.getText("module.repSearch.tab.results.title", this.resultsTabCounter++), Icons.TABLE, true, jTabbedPane, (JComponent)objectArray[0], (Runnable)objectArray[1]);
                jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            }
        });
        box.add(this.performSearchButton);
        JButton jButton = new JButton(Icons.CROSS_WHITE);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.filters.resetFieldsButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n = searchFieldGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                    searchFieldGroup.resetAll();
                    ++n2;
                }
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalStrut(20));
        JButton jButton2 = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(jButton2, "module.repSearch.tab.filters.loadFiltersButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Search filters");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.filters.selectLoadFiltersFile"));
                jFileChooser.setFileFilter(GuiUtils.SEARCH_FILTER_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    ReplaySearch.this.loadSearchFiltersFile(jFileChooser.getSelectedFile());
                }
            }
        });
        box.add(jButton2);
        JButton jButton3 = new JButton(Icons.DISK);
        GuiUtils.updateButtonText(jButton3, "module.repSearch.tab.filters.saveFiltersButton", new Object[0]);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Search filters");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.filters.selectSaveFiltersFile"));
                jFileChooser.setFileFilter(GuiUtils.SEARCH_FILTER_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (!GuiUtils.SEARCH_FILTER_FILE_FILTER.accept(file)) {
                        file = new File(String.valueOf(file.getAbsolutePath()) + ".filters");
                    }
                    ReplaySearch.this.saveSearchFiltersFile(file);
                }
            }
        });
        box.add(jButton3);
        box.add(Box.createHorizontalStrut(20));
        box.add(MiscSettingsDialog.createLinkLabelToPredefinedListsSettings(Settings.PredefinedList.REP_SEARCH_PLAYER_NAME));
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        Box box2 = Box.createVerticalBox();
        SearchFieldGroup[] searchFieldGroupArray = this.searchFieldGroups;
        int n = this.searchFieldGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
            box2.add(searchFieldGroup.uiComponent);
            ++n2;
        }
        this.packSearchFields();
        jPanel2.add((Component)box2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void packSearchFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchFieldGroup searchFieldGroup;
                int n = 0;
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n2 = searchFieldGroupArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    searchFieldGroup = searchFieldGroupArray[n3];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(null);
                        n = Math.max(n, searchField.displayLabel.getPreferredSize().width);
                    }
                    ++n3;
                }
                searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                n2 = searchFieldGroupArray.length;
                n3 = 0;
                while (n3 < n2) {
                    searchFieldGroup = searchFieldGroupArray[n3];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(new Dimension(n, searchField.displayLabel.getPreferredSize().height));
                        searchField.displayLabel.invalidate();
                    }
                    searchFieldGroup.parentToNotify.validate();
                    ++n3;
                }
            }
        });
    }

    private void loadSearchFiltersFile(File file) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("filterGroup");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                ((Element)nodeList.item(n2)).setIdAttribute("id", true);
                ++n2;
            }
            SearchFieldGroup[] searchFieldGroupArray = this.searchFieldGroups;
            int n3 = this.searchFieldGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n4];
                int n5 = 0;
                while (n5 < searchFieldGroup.searchFieldList.size()) {
                    searchFieldGroup.loadValues(document);
                    ++n5;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.filters.failedToLoadFilters"), new Frame[0]);
        }
    }

    private void saveSearchFiltersFile(File file) {
        try {
            Object object;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("filters");
            element.setAttribute("version", "1.0");
            SearchFieldGroup[] searchFieldGroupArray = this.searchFieldGroups;
            int n = this.searchFieldGroups.length;
            int n2 = 0;
            while (n2 < n) {
                object = searchFieldGroupArray[n2];
                ((SearchFieldGroup)object).saveValues(document, element);
                ++n2;
            }
            document.appendChild(element);
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(file));
            GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.filters.filtersSaved"), new Frame[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.filters.failedToSaveFilters"), new Frame[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] createResultsTab(SearchFieldGroup[] searchFieldGroupArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        void var4_5;
        ListModel listModel = this.sourceList.getModel();
        File[] fileArray = new File[listModel.getSize()];
        int bl = fileArray.length - 1;
        while (var4_5 >= 0) {
            fileArray[var4_5] = (File)listModel.getElementAt((int)var4_5);
            --var4_5;
        }
        boolean bl2 = Settings.getBoolean("settings.misc.useRealTimeMeasurement");
        EnumSet<ReplayFactory.ReplayContent> enumSet = EnumSet.copyOf(ReplayFactory.GENERAL_INFO_CONTENT);
        ArrayList<ReplayFilter[]> arrayList = new ArrayList<ReplayFilter[]>();
        Object object6 = searchFieldGroupArray;
        int n = searchFieldGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            object5 = object6[n2];
            object4 = ((SearchFieldGroup)object5).getReplayFilters();
            if (object4 != null) {
                arrayList.add((ReplayFilter[])object4);
                object3 = object4[0].getRequiredReplayContentSet();
                if (object3 != null) {
                    enumSet.addAll((Collection<ReplayFactory.ReplayContent>)object3);
                }
                if (object4[0] instanceof GameLengthSearchField.GameLengthReplayFilter) {
                    object2 = object4;
                    int n3 = ((ReplayFilter[])object4).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        object = object2[n4];
                        ((GameLengthSearchField.GameLengthReplayFilter)object).setUseRealTime(bl2);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        object5 = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        final JTable jTable = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.getColumnModel().getColumn(n2).getModelIndex() == COLUMN_COMMENT;
            }
        };
        object6 = Box.createHorizontalBox();
        object4 = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText((AbstractButton)object4, "module.repSearch.tab.results.abortButton", new Object[0]);
        ((Container)object6).add((Component)object4);
        object3 = new JButton(Icons.DISK);
        GuiUtils.updateButtonText((AbstractButton)object3, "module.repSearch.tab.results.saveButton", new Object[0]);
        ((AbstractButton)object3).setEnabled(false);
        ((Container)object6).add((Component)object3);
        object = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText((AbstractButton)object, "module.repSearch.tab.results.loadButton", new Object[0]);
        ((AbstractButton)object).setEnabled(false);
        ((Container)object6).add((Component)object);
        JButton jButton = new JButton(Icons.TABLE_EXPORT);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.results.setAsSourceButton", new Object[0]);
        jButton.setToolTipText(Language.getText("module.repSearch.tab.results.setAsSourceToolTip"));
        jButton.setEnabled(false);
        ((Container)object6).add(jButton);
        JButton jButton2 = new JButton(Icons.CHART_UP_COLOR);
        GuiUtils.updateButtonText(jButton2, "module.repSearch.tab.results.multiRepAnalysisButton", new Object[0]);
        jButton2.setToolTipText(Language.getText("module.repSearch.tab.results.multiRepAnalysisToolTip"));
        jButton2.setEnabled(false);
        ((Container)object6).add(jButton2);
        object2 = GuiUtils.createCheckBox("module.repSearch.tab.results.stretchToWindow", "module.repSearch.results.stretchToWindow");
        ActionListener actionListener = new ActionListener((JCheckBox)object2){
            private final /* synthetic */ JCheckBox val$stretchToWindowCheckBox;
            {
                this.val$stretchToWindowCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setAutoResizeMode(this.val$stretchToWindowCheckBox.isSelected() ? 4 : 0);
            }
        };
        actionListener.actionPerformed(null);
        ((AbstractButton)object2).addActionListener(actionListener);
        ((Container)object6).add((Component)object2);
        box.add((Component)object6);
        JProgressBar jProgressBar = new JProgressBar();
        box.add(jProgressBar);
        ((Container)object5).add((Component)box, "North");
        ((DefaultTableModel)jTable.getModel()).setColumnIdentifiers(RESULT_HEADER_NAMES);
        jTable.setAutoCreateRowSorter(true);
        jTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(COLUMN_SAVE_TIME, SortOrder.DESCENDING)));
        TableBox tableBox = new TableBox(jTable, this.getLayeredPane());
        NormalThread normalThread = new NormalThread("Replay search", enumSet, (JButton)object4, jTable, (JButton)object3, (JButton)object, jButton, jButton2, jProgressBar, (JPanel)object5, tableBox, fileArray, (Box)object6, arrayList, bl2){
            private final boolean cacheEnabled;
            private final boolean cachedReplaysAreGood;
            private final int timeExclusionForApm;
            private final Set<ReplayFactory.ReplayContent> contentSetForSearchAndCache;
            private volatile boolean aborted;
            private final List<Object[]> resultList;
            private int replaysCount;
            private int searchedCount;
            private int skippedCount;
            private final /* synthetic */ JButton val$abortButton;
            private final /* synthetic */ JTable val$resultsTable;
            private final /* synthetic */ JButton val$saveReplayListButton;
            private final /* synthetic */ JButton val$loadReplayListButton;
            private final /* synthetic */ JButton val$setAsSourceButton;
            private final /* synthetic */ JButton val$multiRepAnalysisButton;
            private final /* synthetic */ JProgressBar val$progressBar;
            private final /* synthetic */ JPanel val$resultsPanel;
            private final /* synthetic */ TableBox val$tableBox;
            private final /* synthetic */ File[] val$sources;
            private final /* synthetic */ Box val$buttonsBox;
            private final /* synthetic */ List val$replayFiltersList;
            private final /* synthetic */ boolean val$useRealTime;
            {
                this.val$abortButton = jButton;
                this.val$resultsTable = jTable;
                this.val$saveReplayListButton = jButton2;
                this.val$loadReplayListButton = jButton3;
                this.val$setAsSourceButton = jButton4;
                this.val$multiRepAnalysisButton = jButton5;
                this.val$progressBar = jProgressBar;
                this.val$resultsPanel = jPanel;
                this.val$tableBox = tableBox;
                this.val$sources = fileArray;
                this.val$buttonsBox = box;
                this.val$replayFiltersList = list;
                this.val$useRealTime = bl;
                super(string);
                this.cacheEnabled = Settings.getBoolean("settings.misc.cachePreprocessedReplays");
                this.cachedReplaysAreGood = !set.contains((Object)ReplayFactory.ReplayContent.GAME_EVENTS) && !set.contains((Object)ReplayFactory.ReplayContent.MESSAGE_EVENTS);
                this.timeExclusionForApm = Settings.getInt("settings.misc.initialTimeToExcludeFromApm") << 6;
                this.contentSetForSearchAndCache = EnumSet.copyOf(ReplayFactory.GENERAL_DATA_CONTENT);
                this.contentSetForSearchAndCache.addAll(set);
                this.resultList = new ArrayList<Object[]>();
            }

            @Override
            public void run() {
                Object object;
                InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        val$abortButton.doClick();
                    }
                };
                ReplaySearch.this.addInternalFrameListener(internalFrameAdapter);
                this.val$abortButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        val$buttonsBox.remove(val$abortButton);
                        val$resultsPanel.validate();
                        aborted = true;
                    }
                });
                this.val$resultsTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getColumn() >= 0 && val$resultsTable.getColumnModel().getColumn(tableModelEvent.getColumn()).getModelIndex() == COLUMN_COMMENT) {
                            RowSorter<? extends TableModel> rowSorter = val$resultsTable.getRowSorter();
                            int n = rowSorter.convertRowIndexToModel(val$resultsTable.getEditingRow());
                            ((Object[])(this).resultList.get((int)n))[COLUMN_COMMENT] = val$resultsTable.getValueAt(val$resultsTable.getEditingRow(), tableModelEvent.getColumn());
                        }
                    }
                });
                this.val$saveReplayListButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser("User Content/Replay lists");
                        jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.results.selectSaveReplayList"));
                        jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                        jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                        if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                            File file = jFileChooser.getSelectedFile();
                            if (!GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                                file = new File(String.valueOf(file.getAbsolutePath()) + ".csv");
                            }
                            ReplaySearch.saveReplayListFile(file, resultList);
                        }
                    }
                });
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object;
                        File file = null;
                        if (actionEvent == null) {
                            file = ReplaySearch.this.initialReplayList;
                            ReplaySearch.this.initialReplayList = null;
                        } else {
                            object = new JFileChooser("User Content/Replay lists");
                            ((JFileChooser)object).setDialogTitle(Language.getText("module.repSearch.tab.results.selectLoadReplayList"));
                            ((JFileChooser)object).setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                            ((JFileChooser)object).setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                            if (((JFileChooser)object).showOpenDialog(MainFrame.INSTANCE) == 0) {
                                file = ((JFileChooser)object).getSelectedFile();
                            }
                        }
                        if (file != null) {
                            val$buttonsBox.remove(val$abortButton);
                            val$resultsPanel.validate();
                            val$progressBar.setString(Language.getText("module.repSearch.tab.results.loadingReplayList", file.getName()));
                            object = ReplaySearch.loadReplayListFile(file);
                            if (object != null) {
                                val$tableBox.clearFilters();
                                resultList.clear();
                                resultList.addAll(object);
                                this.refreshTableFromResultList();
                            }
                            val$progressBar.setMaximum(resultList.size());
                            val$progressBar.setValue(resultList.size());
                            val$progressBar.setString(Language.getText("module.repSearch.tab.results.loadResult", resultList.size()));
                            val$saveReplayListButton.setEnabled(true);
                            val$loadReplayListButton.setEnabled(true);
                            val$setAsSourceButton.setEnabled(true);
                            val$multiRepAnalysisButton.setEnabled(true);
                        }
                    }
                };
                this.val$loadReplayListButton.addActionListener(actionListener);
                this.val$setAsSourceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                        defaultListModel.removeAllElements();
                        for (Object[] objectArray : resultList) {
                            defaultListModel.addElement(new File((String)objectArray[COLUMN_FILE_NAME]));
                        }
                    }
                });
                this.val$multiRepAnalysisButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File[] fileArray = new File[resultList.size()];
                        int n = 0;
                        for (Object[] objectArray : resultList) {
                            fileArray[n++] = new File((String)objectArray[COLUMN_FILE_NAME]);
                        }
                        MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(fileArray);
                    }
                });
                this.val$progressBar.setStringPainted(true);
                if (ReplaySearch.this.initialReplayList != null) {
                    actionListener.actionPerformed(null);
                    this.val$resultsPanel.add((Component)this.val$tableBox, "Center");
                    this.val$resultsPanel.validate();
                } else {
                    this.val$progressBar.setString(Language.getText("module.repSearch.tab.results.countingReplays"));
                    File[] fileArray = this.val$sources;
                    int n = this.val$sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = fileArray[n2];
                        if (this.aborted) break;
                        this.replaysCount += this.countReplays((File)object);
                        ++n2;
                    }
                    if (this.aborted) {
                        this.val$progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + this.val$progressBar.getString() + "]");
                        this.val$loadReplayListButton.setEnabled(true);
                    } else {
                        this.val$progressBar.setMaximum(this.replaysCount);
                        this.updateProgressBar();
                        fileArray = this.val$sources;
                        n = this.val$sources.length;
                        n2 = 0;
                        while (n2 < n) {
                            object = fileArray[n2];
                            if (this.aborted) break;
                            this.searchReplays((File)object);
                            ++n2;
                        }
                        if (this.aborted) {
                            this.val$progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + this.val$progressBar.getString() + "]");
                        } else {
                            this.val$buttonsBox.remove(this.val$abortButton);
                        }
                        this.val$resultsPanel.add((Component)this.val$tableBox, "Center");
                        this.val$resultsPanel.validate();
                        this.val$saveReplayListButton.setEnabled(true);
                        this.val$loadReplayListButton.setEnabled(true);
                        this.val$setAsSourceButton.setEnabled(true);
                        this.val$multiRepAnalysisButton.setEnabled(true);
                        this.refreshTableFromResultList();
                    }
                }
                this.val$resultsTable.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 3) {
                            int[] nArray;
                            if (val$resultsTable.getSelectedRow() < 0) {
                                int n = val$resultsTable.rowAtPoint(mouseEvent.getPoint());
                                val$resultsTable.getSelectionModel().setSelectionInterval(n, n);
                            }
                            if ((nArray = val$resultsTable.getSelectedRows()).length > 0) {
                                final File[] fileArray = this.getFilesForRows(nArray);
                                ReplayOperationsPopupMenu replayOperationsPopupMenu = new ReplayOperationsPopupMenu(fileArray, new ReplayOpCallback(){
                                    final List<Object[]> removedList = new ArrayList<Object[]>();

                                    @Override
                                    public void replayRenamed(File file, File file2, int n) {
                                        ((Object[])((this).this).resultList.get((int)nArray[n]))[ReplaySearch.COLUMN_FILE_NAME] = file2.getAbsolutePath();
                                    }

                                    @Override
                                    public void replayMoved(File file, File file2, int n) {
                                        ((Object[])((this).this).resultList.get((int)nArray[n]))[ReplaySearch.COLUMN_FILE_NAME] = new File(file2, file.getName()).getAbsolutePath();
                                    }

                                    @Override
                                    public void replayDeleted(File file, int n) {
                                        this.removedList.add((Object[])resultList.get(nArray[n]));
                                    }

                                    @Override
                                    public void moveRenameDeleteEnded() {
                                        if (!this.removedList.isEmpty()) {
                                            resultList.removeAll(this.removedList);
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                replayOperationsPopupMenu.addSeparator();
                                JMenuItem jMenuItem = new JMenuItem(Icons.TABLE_DELETE_ROW);
                                jMenuItem.setText(Language.getText("module.repSearch.tab.results.removeSelectedMenuItem"));
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        Arrays.sort(nArray);
                                        int n = nArray.length - 1;
                                        while (n >= 0) {
                                            resultList.remove(nArray[n]);
                                            --n;
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                replayOperationsPopupMenu.add(jMenuItem);
                                JMenuItem jMenuItem2 = new JMenuItem(Icons.TABLE_EXPORT);
                                jMenuItem2.setText(Language.getText("module.repSearch.tab.results.setSelectedAsSourceMenuItem"));
                                jMenuItem2.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                                        defaultListModel.removeAllElements();
                                        File[] fileArray2 = fileArray;
                                        int n = fileArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            File file = fileArray2[n2];
                                            defaultListModel.addElement(file);
                                            ++n2;
                                        }
                                    }
                                });
                                replayOperationsPopupMenu.add(jMenuItem2);
                                JMenuItem jMenuItem3 = new JMenuItem(Icons.DOCUMENTS_STACK);
                                jMenuItem3.setText(Language.getText("module.repSearch.tab.results.findDuplicatesMenuItem"));
                                jMenuItem3.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        new FindDuplicatesDialog(resultList, val$resultsTable);
                                    }
                                });
                                replayOperationsPopupMenu.add(jMenuItem3);
                                replayOperationsPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                        if (mouseEvent.getButton() == 1 && val$resultsTable.getSelectedRow() >= 0 && mouseEvent.getClickCount() == 2) {
                            MainFrame.INSTANCE.openReplayFile(new File((String)((Object[])resultList.get(val$resultsTable.getRowSorter().convertRowIndexToModel(val$resultsTable.rowAtPoint(mouseEvent.getPoint()))))[COLUMN_FILE_NAME]));
                        }
                    }
                });
                object = new Object();
                this.val$resultsTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), object);
                this.val$resultsTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 64), object);
                this.val$resultsTable.getActionMap().put(object, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = val$resultsTable.getSelectedRows();
                        if (nArray.length == 0) {
                            return;
                        }
                        File[] fileArray = this.getFilesForRows(nArray);
                        if (nArray.length == 1) {
                            MainFrame.INSTANCE.openReplayFile(fileArray[0]);
                        } else {
                            MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(fileArray);
                        }
                    }
                });
                object = new Object();
                this.val$resultsTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), object);
                this.val$resultsTable.getActionMap().put(object, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        final int[] nArray = val$resultsTable.getSelectedRows();
                        if (nArray.length > 0) {
                            File[] fileArray = this.getFilesForRows(nArray);
                            ReplayOperationsPopupMenu replayOperationsPopupMenu = new ReplayOperationsPopupMenu(fileArray, new ReplayOpCallback(){
                                final List<Object[]> removedList = new ArrayList<Object[]>();

                                @Override
                                public void replayRenamed(File file, File file2, int n) {
                                }

                                @Override
                                public void replayMoved(File file, File file2, int n) {
                                }

                                @Override
                                public void replayDeleted(File file, int n) {
                                    this.removedList.add((Object[])resultList.get(nArray[n]));
                                }

                                @Override
                                public void moveRenameDeleteEnded() {
                                    if (!this.removedList.isEmpty()) {
                                        resultList.removeAll(this.removedList);
                                    }
                                    this.refreshTableFromResultList();
                                }
                            });
                            replayOperationsPopupMenu.deleteReplaysMenuItem.doClick();
                        }
                    }
                });
                ReplaySearch.this.removeInternalFrameListener(internalFrameAdapter);
            }

            private File[] getFilesForRows(int[] nArray) {
                File[] fileArray = new File[nArray.length];
                RowSorter<? extends TableModel> rowSorter = this.val$resultsTable.getRowSorter();
                int n = nArray.length - 1;
                while (n >= 0) {
                    nArray[n] = rowSorter.convertRowIndexToModel(nArray[n]);
                    fileArray[n] = new File((String)this.resultList.get(nArray[n])[COLUMN_FILE_NAME]);
                    --n;
                }
                return fileArray;
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] fileArray = file.listFiles();
                int n = 0;
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        if (this.aborted) {
                            return 0;
                        }
                        n += this.countReplays(file2);
                        ++n3;
                    }
                }
                return n;
            }

            private void searchReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.searchedCount;
                        Replay replay = ReplayCache.getReplay(file, null, this.timeExclusionForApm, this.cacheEnabled && this.cachedReplaysAreGood, this.cacheEnabled, this.cachedReplaysAreGood ? null : this.contentSetForSearchAndCache);
                        if (replay != null) {
                            int n;
                            boolean bl = true;
                            for (Object object : this.val$replayFiltersList) {
                                n = 0;
                                ReplayFilter[] replayFilterArray = object;
                                int n2 = ((ReplayFilter[])object).length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    ReplayFilter replayFilter = replayFilterArray[n3];
                                    if (replayFilter.accept(file, replay)) {
                                        n = 1;
                                        break;
                                    }
                                    ++n3;
                                }
                                if (n != 0) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                Object object;
                                ReplayUtils.applyFavoredPlayerListSetting(replay.details);
                                object = new StringBuilder();
                                int[] nArray = replay.details.getTeamOrderPlayerIndices();
                                int n4 = nArray.length;
                                n = 0;
                                while (n < n4) {
                                    int n5 = nArray[n];
                                    Details.Player player = replay.details.players[n5];
                                    if (((StringBuilder)object).length() > 0) {
                                        ((StringBuilder)object).append(", ");
                                    }
                                    ((StringBuilder)object).append(ReplayUtils.calculatePlayerApm(replay, player));
                                    ++n;
                                }
                                this.resultList.add(new Object[]{replay.version, replay.initData.gameType.stringValue, replay.initData.gateway == null ? "" : replay.initData.gateway.stringValue, Language.formatDateTime(new Date(replay.details.saveTime)), replay.details.mapName, replay.details.getRaceMatchup(), ((StringBuilder)object).toString(), ReplayUtils.formatMs(replay.gameLength * 500, this.val$useRealTime ? replay.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL), replay.details.getPlayerNamesGrouped(), file.getAbsolutePath(), ""});
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n6 = 0;
                        while (n6 < n) {
                            File file2 = fileArray2[n6];
                            if (this.aborted) {
                                return;
                            }
                            this.searchReplays(file2);
                            ++n6;
                        }
                    }
                }
            }

            private void updateProgressBar() {
                this.val$progressBar.setValue(this.searchedCount);
                this.val$progressBar.setString(Language.getText("module.repSearch.tab.results.searchStatus", this.resultList.size(), this.searchedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.searchedCount / this.replaysCount));
            }

            private void refreshTableFromResultList() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<RowSorter.SortKey> list = val$resultsTable.getRowSorter().getSortKeys();
                        DefaultTableModel defaultTableModel = (DefaultTableModel)val$resultsTable.getModel();
                        defaultTableModel.setDataVector((Object[][])resultList.toArray((T[])new Object[resultList.size()][]), RESULT_HEADER_NAMES);
                        val$resultsTable.getRowSorter().setSortKeys(list);
                        GuiUtils.packTable(val$resultsTable);
                    }
                });
            }
        };
        normalThread.start();
        return new Object[]{object5, new Runnable((JButton)object4){
            private final /* synthetic */ JButton val$abortButton;
            {
                this.val$abortButton = jButton;
            }

            @Override
            public void run() {
                this.val$abortButton.doClick();
            }
        }};
    }
}

