/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class SearchField
implements ActionListener {
    protected static final Color ERROR_COLOR = new Color(255, 150, 150);
    protected final Id id;
    public final Box uiComponent = Box.createHorizontalBox();
    protected final JCheckBox invertCheckBox = new JCheckBox(Language.getText("module.repSearch.tab.filters.invert"));
    public final JLabel displayLabel;

    public SearchField(Id id) {
        this.id = id;
        this.displayLabel = new JLabel(id.displayText);
        this.invertCheckBox.setToolTipText(Language.getText("module.repSearch.tab.filters.invertToolTip"));
        this.invertCheckBox.setHorizontalTextPosition(2);
        this.invertCheckBox.addActionListener(this);
        this.invertCheckBox.setOpaque(true);
        this.uiComponent.add(this.invertCheckBox);
        this.uiComponent.add(Box.createHorizontalStrut(5));
        this.uiComponent.add(this.displayLabel);
    }

    public abstract boolean validate();

    public abstract ReplayFilter getFilter();

    public void reset() {
        this.invertCheckBox.setBackground(null);
        this.invertCheckBox.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.invertCheckBox.setBackground(this.invertCheckBox.isSelected() ? Color.GREEN : null);
    }

    public static void restoreDefaultBackground(JTextField jTextField) {
        jTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    public void saveValue(Document document, Element element) {
        SearchField.appendDataElement(document, element, "not", this.invertCheckBox.isSelected());
    }

    protected static void appendDataElement(Document document, Element element, String string, Object object) {
        Element element2 = document.createElement(string);
        element2.setTextContent(object.toString());
        element.appendChild(element2);
    }

    public void loadValue(Element element) {
        this.invertCheckBox.setSelected(Boolean.parseBoolean(SearchField.getDataElementValue(element, "not")));
        this.actionPerformed(null);
    }

    protected static String getDataElementValue(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return nodeList.getLength() == 0 ? null : nodeList.item(0).getTextContent();
    }

    protected static enum Id {
        PLAYER("module.repSearch.tab.filters.name.playerName"),
        MAP("module.repSearch.tab.filters.name.mapName"),
        RACE_MATCHUP("module.repSearch.tab.filters.name.raceMatchup"),
        FILE("module.repSearch.tab.filters.name.fileName"),
        CHAT_MESSAGE("module.repSearch.tab.filters.name.chatMessage"),
        FORMAT("module.repSearch.tab.filters.name.format"),
        GAME_TYPE("module.repSearch.tab.filters.name.gameType"),
        GATEWAY("module.repSearch.tab.filters.name.gateway"),
        DATE("module.repSearch.tab.filters.name.date"),
        GAME_LENGTH("module.repSearch.tab.filters.name.gameLength"),
        VERSION("module.repSearch.tab.filters.name.version"),
        BUILD_ORDER("module.repSearch.tab.filters.name.buildOrder"),
        BUILDING("module.repSearch.tab.filters.name.building"),
        UNIT("module.repSearch.tab.filters.name.unit"),
        RESEARCH("module.repSearch.tab.filters.name.research"),
        UPGRADE("module.repSearch.tab.filters.name.upgrade"),
        UNIT_ABILITY("module.repSearch.tab.filters.name.unitAbility"),
        BUILDING_ABILITY("module.repSearch.tab.filters.name.buildingAbility");

        public final String displayText;

        private Id(String string2) {
            this.displayText = Language.getText(string2);
        }
    }
}

