/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SearchFieldGroup {
    public static final String FILTER_GROUP_TAG_NAME = "filterGroup";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public final Container parentToNotify;
    private final Class<? extends SearchField> searchFieldType;
    public final Box uiComponent = Box.createHorizontalBox();
    public final Box searchFieldsBox = Box.createVerticalBox();
    public final List<SearchField> searchFieldList = new ArrayList<SearchField>();

    public SearchFieldGroup(Container container, Class<? extends SearchField> clazz) {
        this.parentToNotify = container;
        this.searchFieldType = clazz;
        this.uiComponent.setBorder(BorderFactory.createRaisedBevelBorder());
        this.uiComponent.add(this.searchFieldsBox);
        JLabel jLabel = GuiUtils.createIconLabelButton(Icons.PLUS, "module.repSearch.tab.filters.addNewFieldToolTip");
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchFieldGroup.this.addNewSearchField();
            }
        });
        this.uiComponent.add(jLabel);
        this.addNewSearchField();
    }

    private void addNewSearchField() {
        try {
            final Box box = Box.createHorizontalBox();
            final SearchField searchField = this.searchFieldType.newInstance();
            if (!this.searchFieldList.isEmpty()) {
                searchField.displayLabel.setPreferredSize(new Dimension(this.searchFieldList.get((int)0).displayLabel.getPreferredSize().width, searchField.displayLabel.getPreferredSize().height));
            }
            this.searchFieldList.add(searchField);
            box.add(searchField.uiComponent);
            box.add(Box.createHorizontalStrut(6));
            JLabel jLabel = GuiUtils.createIconLabelButton(Icons.MINUS, "module.repSearch.tab.filters.removeFieldToolTip");
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SearchFieldGroup.this.searchFieldsBox.getComponentCount() > 1) {
                        SearchFieldGroup.this.searchFieldList.remove(searchField);
                        SearchFieldGroup.this.searchFieldsBox.remove(box);
                        SearchFieldGroup.this.updateRemoveLabels();
                        SearchFieldGroup.this.parentToNotify.validate();
                    }
                }
            });
            box.add(jLabel);
            this.searchFieldsBox.add(box);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateRemoveLabels();
        this.parentToNotify.validate();
    }

    private void updateRemoveLabels() {
        boolean bl = this.searchFieldsBox.getComponentCount() != 1;
        int n = this.searchFieldsBox.getComponentCount() - 1;
        while (n >= 0) {
            Box box = (Box)this.searchFieldsBox.getComponent(n);
            box.getComponent(box.getComponentCount() - 1).setEnabled(bl);
            --n;
        }
    }

    public boolean validateAll() {
        boolean bl = true;
        for (SearchField searchField : this.searchFieldList) {
            bl &= searchField.validate();
        }
        return bl;
    }

    public void resetAll() {
        for (SearchField searchField : this.searchFieldList) {
            searchField.reset();
        }
    }

    public ReplayFilter[] getReplayFilters() {
        ArrayList<ReplayFilter> arrayList = new ArrayList<ReplayFilter>(this.searchFieldList.size());
        for (SearchField searchField : this.searchFieldList) {
            ReplayFilter replayFilter = searchField.getFilter();
            if (replayFilter == null) continue;
            arrayList.add(replayFilter);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new ReplayFilter[arrayList.size()]);
    }

    public void saveValues(Document document, Element element) {
        Element element2 = document.createElement(FILTER_GROUP_TAG_NAME);
        element2.setAttribute(ID_ATTRIBUTE_NAME, this.searchFieldList.get((int)0).id.name());
        for (SearchField searchField : this.searchFieldList) {
            Element element3 = document.createElement("filter");
            searchField.saveValue(document, element3);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    public void loadValues(Document document) {
        NodeList nodeList;
        int n;
        Element element = document.getElementById(this.searchFieldList.get((int)0).id.name());
        boolean bl = true;
        if (element != null && (n = (nodeList = element.getElementsByTagName("filter")).getLength()) > 0) {
            this.ensureExactSearchFieldsCount(n);
            int n2 = 0;
            while (n2 < n) {
                SearchField searchField = this.searchFieldList.get(n2);
                searchField.reset();
                searchField.loadValue((Element)nodeList.item(n2));
                ++n2;
            }
            bl = false;
        }
        if (bl) {
            this.ensureExactSearchFieldsCount(1);
            this.searchFieldList.get(0).reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void ensureExactSearchFieldsCount(int var1_1) {
        block3: {
            var2_2 = var1_1 - this.searchFieldList.size();
            if (var2_2 == 0) {
                return;
            }
            if (var2_2 <= 0) ** GOTO lbl12
            while (var2_2-- > 0) {
                this.addNewSearchField();
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.searchFieldList.remove(this.searchFieldList.size() - 1);
                this.searchFieldsBox.remove(this.searchFieldsBox.getComponentCount() - 1);
lbl12:
                // 2 sources

                ** while (var2_2++ < 0)
            }
        }
        this.updateRemoveLabels();
        this.parentToNotify.validate();
    }
}

