/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.components.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ComboBoxSearchField
extends SearchField {
    protected final JComboBox comboBox;
    protected JSpinner minOccurrenceSpinner;

    public ComboBoxSearchField(SearchField.Id id, Vector<Object> vector) {
        this(id, vector, true);
    }

    public ComboBoxSearchField(SearchField.Id id, Vector<Object> vector, boolean bl) {
        super(id);
        this.comboBox = new JComboBox<Object>(vector);
        this.comboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                return ComboBoxSearchField.this.getIcon(object);
            }
        });
        this.comboBox.setPreferredSize(new Dimension(100, this.comboBox.getMinimumSize().height));
        this.uiComponent.add(this.comboBox);
        if (bl) {
            this.minOccurrenceSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
            this.uiComponent.add(new JLabel(Language.getText("module.repSearch.tab.filters.name.minOccurrenceText")));
            this.minOccurrenceSpinner.setEditor(new JSpinner.NumberEditor(this.minOccurrenceSpinner));
            this.minOccurrenceSpinner.setMaximumSize(new Dimension(50, this.minOccurrenceSpinner.getPreferredSize().height));
            this.uiComponent.add(this.minOccurrenceSpinner);
        }
    }

    protected Icon getIcon(Object object) {
        return null;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.comboBox.setSelectedIndex(0);
        if (this.minOccurrenceSpinner != null) {
            this.minOccurrenceSpinner.setValue(1);
        }
    }

    protected static Vector<Object> createDataVector(Collection<?> collection) {
        Vector<Object> vector = new Vector<Object>(collection);
        Collections.sort(vector, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        vector.insertElementAt(" ", 0);
        return vector;
    }

    @Override
    public void saveValue(Document document, Element element) {
        super.saveValue(document, element);
        ComboBoxSearchField.appendDataElement(document, element, "combo", this.comboBox.getSelectedIndex());
        if (this.minOccurrenceSpinner != null) {
            ComboBoxSearchField.appendDataElement(document, element, "minOccurance", this.minOccurrenceSpinner.getValue());
        }
    }

    @Override
    public void loadValue(Element element) {
        super.loadValue(element);
        this.comboBox.setSelectedIndex(Integer.parseInt(ComboBoxSearchField.getDataElementValue(element, "combo")));
        if (this.minOccurrenceSpinner != null) {
            this.minOccurrenceSpinner.setValue(Integer.valueOf(ComboBoxSearchField.getDataElementValue(element, "minOccurance")));
        }
    }
}

