/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;

public class GameLengthSearchField
extends IntervalSearchField {
    public GameLengthSearchField() {
        super(SearchField.Id.GAME_LENGTH);
        this.minTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
        this.maxTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
    }

    @Override
    public boolean customValidateMin() {
        String string = this.minTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Integer n = GeneralUtils.parseSeconds(string);
        return n != null && n >= 0;
    }

    @Override
    public boolean customValidateMax() {
        String string = this.maxTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Integer n = GeneralUtils.parseSeconds(string);
        return n != null && n >= 0;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new GameLengthReplayFilter(this);
    }

    public static class GameLengthReplayFilter
    extends IntervalReplayFilter {
        private final Integer minSeconds;
        private final Integer maxSeconds;
        private boolean useRealTime;

        public GameLengthReplayFilter(IntervalSearchField intervalSearchField) {
            super(intervalSearchField);
            this.minSeconds = this.minText.length() > 0 ? GeneralUtils.parseSeconds(this.minText) : null;
            this.maxSeconds = this.maxText.length() > 0 ? GeneralUtils.parseSeconds(this.maxText) : null;
        }

        public void setUseRealTime(boolean bl) {
            this.useRealTime = bl;
        }

        @Override
        public boolean customAccept(File file, Replay replay) {
            int n;
            int n2 = n = this.useRealTime ? replay.converterGameSpeed.convertToRealTime(replay.gameLengthSec) : replay.gameLengthSec;
            if (this.minSeconds != null && n < this.minSeconds) {
                return false;
            }
            return this.maxSeconds == null || n <= this.maxSeconds;
        }
    }
}

