/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.components.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.TextReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.TextSearchField;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlayerSearchField
extends TextSearchField {
    private final JComboBox raceComboBox = new JComboBox<Object>(new Object[]{" ", ReplayConsts.Race.PROTOSS, ReplayConsts.Race.TERRAN, ReplayConsts.Race.ZERG, ReplayConsts.Race.RANDOM});
    private final JComboBox matchResultComboBox = new JComboBox<Object>(new Object[]{"", ReplayConsts.MatchResult.WIN, ReplayConsts.MatchResult.LOSS, ReplayConsts.MatchResult.UNKNOWN});
    private static final int MIN_VALID_APM = 0;
    private static final int MAX_VALID_APM = 9999;
    private final JSpinner minApmSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 9999, 1));
    private final JSpinner maxApmSpinner = new JSpinner(new SpinnerNumberModel(9999, 0, 9999, 1));

    public PlayerSearchField() {
        super(SearchField.Id.PLAYER, Settings.PredefinedList.REP_SEARCH_PLAYER_NAME);
        this.textField.setToolTipText(Language.getText("module.repSearch.tab.filters.name.playerNameToolTip"));
        this.uiComponent.remove(this.textComboBox);
        this.uiComponent.add((Component)GuiUtils.wrapInBorderPanel(this.textComboBox), this.uiComponent.getComponentCount() - 1);
        this.uiComponent.add((Component)new JLabel(Language.getText("module.repSearch.tab.filters.name.race")), this.uiComponent.getComponentCount() - 1);
        this.raceComboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                if (object instanceof ReplayConsts.Race) {
                    return Icons.getRaceIcon((ReplayConsts.Race)((Object)object));
                }
                return null;
            }
        });
        this.uiComponent.add((Component)this.raceComboBox, this.uiComponent.getComponentCount() - 1);
        this.uiComponent.add((Component)new JLabel(Language.getText("module.repSearch.tab.filters.name.result")), this.uiComponent.getComponentCount() - 1);
        this.uiComponent.add((Component)this.matchResultComboBox, this.uiComponent.getComponentCount() - 1);
        this.uiComponent.add((Component)new JLabel(Language.getText("module.repSearch.tab.filters.name.apm")), this.uiComponent.getComponentCount() - 1);
        this.minApmSpinner.setEditor(new JSpinner.NumberEditor(this.minApmSpinner));
        this.minApmSpinner.setMaximumSize(new Dimension(40, this.minApmSpinner.getPreferredSize().height));
        this.uiComponent.add((Component)this.minApmSpinner, this.uiComponent.getComponentCount() - 1);
        this.uiComponent.add((Component)new JLabel("-"), this.uiComponent.getComponentCount() - 1);
        this.maxApmSpinner.setEditor(new JSpinner.NumberEditor(this.maxApmSpinner));
        this.maxApmSpinner.setMaximumSize(new Dimension(40, this.maxApmSpinner.getPreferredSize().height));
        this.uiComponent.add((Component)this.maxApmSpinner, this.uiComponent.getComponentCount() - 1);
    }

    @Override
    public boolean validate() {
        boolean bl = super.validate();
        if ((Integer)this.minApmSpinner.getValue() <= (Integer)this.maxApmSpinner.getValue()) {
            this.minApmSpinner.getEditor().setBackground(null);
            this.maxApmSpinner.getEditor().setBackground(null);
            PlayerSearchField.restoreDefaultBackground(((JSpinner.NumberEditor)this.minApmSpinner.getEditor()).getTextField());
            PlayerSearchField.restoreDefaultBackground(((JSpinner.NumberEditor)this.maxApmSpinner.getEditor()).getTextField());
            return bl;
        }
        this.minApmSpinner.getEditor().setBackground(ERROR_COLOR);
        this.maxApmSpinner.getEditor().setBackground(ERROR_COLOR);
        ((JSpinner.NumberEditor)this.minApmSpinner.getEditor()).getTextField().setBackground(ERROR_COLOR);
        ((JSpinner.NumberEditor)this.maxApmSpinner.getEditor()).getTextField().setBackground(ERROR_COLOR);
        return false;
    }

    @Override
    public boolean customValidate() {
        return this.textField.getText().length() == 0 || PlayerSearchField.parseNames(this.textField.getText()) != null;
    }

    @Override
    public ReplayFilter getFilter() {
        Object object = this.raceComboBox.getSelectedItem();
        final ReplayConsts.Race race = object instanceof ReplayConsts.Race ? (ReplayConsts.Race)((Object)object) : null;
        Object object2 = this.matchResultComboBox.getSelectedItem();
        final ReplayConsts.MatchResult matchResult = object2 instanceof ReplayConsts.MatchResult ? (ReplayConsts.MatchResult)((Object)object2) : null;
        final int n = (Integer)this.minApmSpinner.getValue();
        final int n2 = (Integer)this.maxApmSpinner.getValue();
        return this.textField.getText().length() == 0 && race == null && matchResult == null && n <= 0 && n2 >= 9999 ? null : new TextReplayFilter(this){
            private final String[] names;
            {
                super(textSearchField);
                this.names = PlayerSearchField.parseNames(this.text);
            }

            @Override
            public boolean customAccept(File file, Replay replay) {
                if (this.names.length < 2) {
                    Details.Player[] playerArray = replay.details.players;
                    int n5 = replay.details.players.length;
                    int n22 = 0;
                    while (n22 < n5) {
                        Details.Player player = playerArray[n22];
                        if (this.isPlayerCandidate(replay, player)) {
                            if (this.names.length == 0) {
                                return true;
                            }
                            String string = player.playerId.name.toLowerCase();
                            if (this.exactMatch ? string.equals(this.names[0]) : string.contains(this.names[0])) {
                                return true;
                            }
                        }
                        ++n22;
                    }
                } else {
                    Object object;
                    ArrayList<String> arrayList = new ArrayList<String>(this.names.length);
                    Object[] objectArray = this.names;
                    int n6 = this.names.length;
                    int n3 = 0;
                    while (n3 < n6) {
                        object = objectArray[n3];
                        arrayList.add((String)object);
                        ++n3;
                    }
                    objectArray = replay.details.players;
                    n6 = replay.details.players.length;
                    n3 = 0;
                    while (n3 < n6) {
                        object = objectArray[n3];
                        if (this.isPlayerCandidate(replay, (Details.Player)object) && this.names.length > 0) {
                            String string = ((Details.Player)object).playerId.name.toLowerCase();
                            int n4 = arrayList.size() - 1;
                            while (n4 >= 0) {
                                if (this.exactMatch ? string.equals(arrayList.get(n4)) : string.contains((CharSequence)arrayList.get(n4))) {
                                    arrayList.remove(n4);
                                    break;
                                }
                                --n4;
                            }
                        }
                        ++n3;
                    }
                    return arrayList.isEmpty();
                }
                return false;
            }

            private boolean isPlayerCandidate(Replay replay, Details.Player player) {
                if (race != null && (race == ReplayConsts.Race.RANDOM && player.race != ReplayConsts.Race.RANDOM || race != ReplayConsts.Race.RANDOM && race != player.finalRace)) {
                    return false;
                }
                if (matchResult != null && (matchResult == ReplayConsts.MatchResult.UNKNOWN ? player.isWinner != null : player.isWinner == null || matchResult == ReplayConsts.MatchResult.WIN ^ player.isWinner)) {
                    return false;
                }
                if (n > 0 || n2 < 9999) {
                    int n3 = ReplayUtils.calculatePlayerApm(replay, player);
                    if (n > 0 && n3 < n || n2 < 9999 && n3 > n2) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private static String[] parseNames(String string) {
        if (string.length() == 0) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                if (stringArray[n].length() == 0) {
                    return null;
                }
                ++n;
            }
        }
        return stringArray;
    }

    @Override
    public void reset() {
        super.reset();
        this.raceComboBox.setSelectedIndex(0);
        this.matchResultComboBox.setSelectedIndex(0);
        this.minApmSpinner.getEditor().setBackground(null);
        PlayerSearchField.restoreDefaultBackground(((JSpinner.NumberEditor)this.minApmSpinner.getEditor()).getTextField());
        this.minApmSpinner.setValue(0);
        this.maxApmSpinner.getEditor().setBackground(null);
        PlayerSearchField.restoreDefaultBackground(((JSpinner.NumberEditor)this.maxApmSpinner.getEditor()).getTextField());
        this.maxApmSpinner.setValue(9999);
    }

    @Override
    public void saveValue(Document document, Element element) {
        super.saveValue(document, element);
        PlayerSearchField.appendDataElement(document, element, "raceCombo", this.raceComboBox.getSelectedIndex());
        PlayerSearchField.appendDataElement(document, element, "matchResultCombo", this.matchResultComboBox.getSelectedIndex());
        PlayerSearchField.appendDataElement(document, element, "minApm", this.minApmSpinner.getValue());
        PlayerSearchField.appendDataElement(document, element, "maxApm", this.maxApmSpinner.getValue());
    }

    @Override
    public void loadValue(Element element) {
        super.loadValue(element);
        this.raceComboBox.setSelectedIndex(Integer.parseInt(PlayerSearchField.getDataElementValue(element, "raceCombo")));
        this.matchResultComboBox.setSelectedIndex(Integer.parseInt(PlayerSearchField.getDataElementValue(element, "matchResultCombo")));
        this.minApmSpinner.setValue(Integer.valueOf(PlayerSearchField.getDataElementValue(element, "minApm")));
        this.maxApmSpinner.setValue(Integer.valueOf(PlayerSearchField.getDataElementValue(element, "maxApm")));
    }
}

