/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TextSearchField
extends SearchField {
    protected final JComboBox textComboBox;
    protected final JTextField textField;
    protected final JCheckBox exactMatch = new JCheckBox(Language.getText("module.repSearch.tab.filters.exactMatch"));

    public TextSearchField(SearchField.Id id, Settings.PredefinedList predefinedList) {
        super(id);
        this.textComboBox = GuiUtils.createPredefinedListComboBox(predefinedList, true);
        this.textField = (JTextField)this.textComboBox.getEditor().getEditorComponent();
        this.uiComponent.add(this.textComboBox);
        this.uiComponent.add(this.exactMatch);
    }

    @Override
    public boolean validate() {
        if (this.customValidate()) {
            TextSearchField.restoreDefaultBackground(this.textField);
            return true;
        }
        this.textField.setBackground(ERROR_COLOR);
        return false;
    }

    public boolean customValidate() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.textComboBox.setSelectedItem("");
        TextSearchField.restoreDefaultBackground(this.textField);
        this.exactMatch.setSelected(false);
    }

    @Override
    public void saveValue(Document document, Element element) {
        super.saveValue(document, element);
        TextSearchField.appendDataElement(document, element, "text", this.textField.getText());
        TextSearchField.appendDataElement(document, element, "exactMatch", this.exactMatch.isSelected());
    }

    @Override
    public void loadValue(Element element) {
        super.loadValue(element);
        this.textComboBox.setSelectedItem(TextSearchField.getDataElementValue(element, "text"));
        this.exactMatch.setSelected(Boolean.parseBoolean(TextSearchField.getDataElementValue(element, "exactMatch")));
    }
}

