/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ComboBoxReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ComboBoxSearchField;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;

public class UnitAbilitySearchField
extends ComboBoxSearchField {
    private static final Vector<Object> UNIT_ABILITY_VECTOR = UnitAbilitySearchField.createDataVector(EnumSet.allOf(ReplayConsts.UnitAbility.class));

    public UnitAbilitySearchField() {
        super(SearchField.Id.UNIT_ABILITY, UNIT_ABILITY_VECTOR);
    }

    @Override
    public ReplayFilter getFilter() {
        return this.comboBox.getSelectedIndex() == 0 ? null : new ComboBoxReplayFilter(this){

            @Override
            public Set<ReplayFactory.ReplayContent> getRequiredReplayContentSet() {
                return GAME_EVENTS_REPLAY_CONTENT_SET;
            }

            @Override
            public boolean customAccept(File file, Replay replay) {
                GameEvents.Action[] actionArray = replay.gameEvents.actions;
                int n = actionArray.length - 1;
                while (n >= 0) {
                    GameEvents.Action action = actionArray[n];
                    if (action instanceof GameEvents.UseUnitAbilityAction && ((GameEvents.UseUnitAbilityAction)action).unitAbility == this.selected) {
                        return true;
                    }
                    --n;
                }
                return false;
            }
        };
    }

    @Override
    public Icon getIcon(Object object) {
        return object instanceof ReplayConsts.UnitAbility ? Icons.getAbilityGroupIcon(((ReplayConsts.UnitAbility)((Object)object)).abilityGroup, IconHandler.Size.MEDIUM) : IconHandler.NULL.get((Object)IconHandler.Size.MEDIUM);
    }
}

