/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import java.io.File;

public class VersionSearchField
extends IntervalSearchField {
    public VersionSearchField() {
        super(SearchField.Id.VERSION);
    }

    @Override
    public boolean customValidateMin() {
        String string = this.minTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        int[] nArray = ReplayUtils.parseVersion(string);
        return nArray != null;
    }

    @Override
    public boolean customValidateMax() {
        String string = this.maxTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        int[] nArray = ReplayUtils.parseVersion(string);
        return nArray != null;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new IntervalReplayFilter(this){
            private final int[] minVersion;
            private final int[] maxVersion;
            {
                this.minVersion = this.minText.length() > 0 ? ReplayUtils.parseVersion(this.minText) : null;
                this.maxVersion = this.maxText.length() > 0 ? ReplayUtils.parseVersion(this.maxText) : null;
            }

            @Override
            public boolean customAccept(File file, Replay replay) {
                if (this.minText.length() > 0 && ReplayUtils.compareVersions(replay.buildNumbers, this.minVersion) < 0) {
                    return false;
                }
                return this.maxText.length() <= 0 || ReplayUtils.compareVersions(replay.buildNumbers, this.maxVersion) <= 0;
            }
        };
    }
}

