/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.startpage;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.TipsDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class StartPage
extends ModuleFrame {
    public static final int TIPS_COUNT = 45;
    private int currentTip = (int)(Math.random() * 45.0) + 1;
    private final JLabel tipLabel = new JLabel(Icons.LIGHT_BULB);
    private final JComboBox channelComboBox = GuiUtils.createComboBox((Object[])Channel.values(), "startPageChannel");
    private final JLabel refreshLabel = GeneralUtils.createLinkStyledLabel(Language.getText("module.startPage.refresh"));
    private final JEditorPane browser = GuiUtils.createEditorPane();

    public StartPage() {
        super(Language.getText("module.startPage.title"));
        this.setFrameIcon(Icons.NEWSPAPER);
        this.buildGUI();
    }

    private void buildGUI() {
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(Icons.ARROW_180);
        jLabel.setToolTipText(Language.getText("module.startPage.previousTipToolTip"));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StartPage startPage = StartPage.this;
                int n = startPage.currentTip - 1;
                startPage.currentTip = n;
                if (n < 1) {
                    StartPage.this.currentTip = 45;
                }
                StartPage.this.updateTip();
            }
        });
        box2.add(jLabel);
        box2.add(TipsDialog.createOpenLinkLabel("module.startPage.tips", false));
        JLabel jLabel2 = new JLabel(Icons.ARROW);
        jLabel2.setToolTipText(Language.getText("module.startPage.nextTipToolTip"));
        jLabel2.setCursor(Cursor.getPredefinedCursor(12));
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StartPage startPage = StartPage.this;
                int n = startPage.currentTip + 1;
                startPage.currentTip = n;
                if (n > 45) {
                    StartPage.this.currentTip = 1;
                }
                StartPage.this.updateTip();
            }
        });
        box2.add(jLabel2);
        box2.add(Box.createHorizontalStrut(10));
        this.updateTip();
        box2.add(this.tipLabel);
        JPanel jPanel = GuiUtils.wrapInPanelLeftAligned(box2);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.tipLabel.getForeground()));
        box.add(jPanel);
        Box box3 = Box.createHorizontalBox();
        box3.add(new JLabel(Language.getText("module.startPage.channel")));
        this.channelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartPage.this.refresh();
            }
        });
        box3.add(this.channelComboBox);
        box3.add(Box.createHorizontalStrut(5));
        this.refreshLabel.setIcon(Icons.ARROW_CIRCLE_315);
        this.refreshLabel.setToolTipText(Language.getText("module.startPage.refreshToolTip"));
        this.refreshLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StartPage.this.refresh();
            }
        });
        box3.add(this.refreshLabel);
        box3.add(Box.createHorizontalStrut(15));
        JLabel jLabel3 = GeneralUtils.createLinkLabel(Language.getText("module.startPage.visitHomePage"), "https://sites.google.com/site/sc2gears/");
        jLabel3.setIcon(Icons.HOME_ARROW);
        box3.add(jLabel3);
        box3.add(Box.createHorizontalStrut(30));
        JLabel jLabel4 = GeneralUtils.createLinkStyledLabel(Language.getText("module.startPage.openLastReplay"));
        jLabel4.setIcon(Icons.CHART);
        jLabel4.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MainFrame.INSTANCE.openLastReplayFile();
            }
        });
        box3.add(jLabel4);
        box3.add(Box.createHorizontalStrut(30));
        JLabel jLabel5 = GeneralUtils.createLinkStyledLabel(Language.getText("module.startPage.startStarCraft2"));
        jLabel5.setIcon(Icons.SC2);
        jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                GeneralUtils.startStarCraftII();
            }
        });
        box3.add(jLabel5);
        box3.add(Box.createHorizontalStrut(15));
        JLabel jLabel6 = GeneralUtils.createLinkStyledLabel(Language.getText("module.startPage.startStarCraft2Editor"));
        jLabel6.setIcon(Icons.SC2_EDITOR);
        jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                GeneralUtils.startStarCraftIIEditor();
            }
        });
        box3.add(jLabel6);
        box.add(GuiUtils.wrapInPanelLeftAligned(box3));
        box3.add(Box.createHorizontalStrut(30));
        JLabel jLabel7 = GeneralUtils.createLinkLabel(Language.getText("module.startPage.openUserPage"), Consts.URL_SC2GEARS_DATABASE_USER_PAGE);
        jLabel7.setIcon(Icons.SERVER_NETWORK);
        jLabel7.setToolTipText(Language.getText("module.startPage.openUserPageToolTip"));
        box3.add(jLabel7);
        this.getContentPane().add((Component)box, "North");
        Object object = new Object();
        this.getRootPane().getLayeredPane().getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), object);
        this.getRootPane().getLayeredPane().getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartPage.this.refresh();
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.browser), "Center");
    }

    private void updateTip() {
        this.tipLabel.setText(Language.getText("module.startPage.tip." + this.currentTip));
    }

    public void refresh() {
        this.channelComboBox.setEnabled(false);
        this.refreshLabel.setEnabled(false);
        new NormalThread("Start page Refresher"){

            @Override
            public void run() {
                block10: {
                    try {
                        Channel channel = (Channel)((Object)StartPage.this.channelComboBox.getSelectedItem());
                        if (channel.url == null) {
                            StartPage.this.browser.setContentType("text/html");
                            String string = channel.getContent();
                            if (string == null) {
                                throw new IOException("Failed to retrieve channel content.");
                            }
                            StartPage.this.browser.setText(string);
                            return;
                        }
                        try {
                            if (Consts.DEVELOPER_MODE) {
                                String string;
                                BufferedReader bufferedReader = new BufferedReader(new FileReader("../war/hosted/" + channel.url.substring(channel.url.lastIndexOf(47) + 1)));
                                StringBuffer stringBuffer = new StringBuffer();
                                while ((string = bufferedReader.readLine()) != null) {
                                    stringBuffer.append(string);
                                }
                                bufferedReader.close();
                                StartPage.this.browser.setContentType("text/html");
                                StartPage.this.browser.setText(stringBuffer.toString());
                                break block10;
                            }
                            StartPage.this.browser.setPage(String.valueOf(channel.url) + "?t=" + new Date().getTime());
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            StartPage.this.browser.setContentType("text/html");
                            StartPage.this.browser.setText("<html><body style='font-family:arial;font-size:10px;font-style:italic;background:#ffffff;'><p>The channel is currently unavailable. Please try again later.</p><p style='font-size:9px;'>If the problem remains, you should check the <a href='https://sites.google.com/site/sc2gears/'>home page</a> and download the latest version as the back-end server might have been moved.</p></body></html>");
                        }
                    }
                    finally {
                        StartPage.this.refreshLabel.setEnabled(true);
                        StartPage.this.channelComboBox.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    private static enum Channel {
        LATEST_SC2GEARS_NEWS("module.startPage.channel.latestSc2gearsNews", "https://sc2gearsdb.appspot.com/hosted/start_page.html", "Sc2gears"),
        SC2GEARS_DATABASE_USER_QUOTA("module.startPage.channel.sc2gearsDatabaseUserQuota", null, new Object[0]),
        ALL_SC2GEARS_NEWS("module.startPage.channel.allSc2gearsNews", "https://sc2gearsdb.appspot.com/hosted/start_page_all_sc2gears_news.html", "Sc2gears");

        public final String stringValue;
        public final String url;

        private Channel(String string2, String string3, Object ... objectArray) {
            this.stringValue = Language.getText(string2, objectArray);
            this.url = string3;
        }

        public String getContent() {
            if (this == SC2GEARS_DATABASE_USER_QUOTA) {
                String string = Settings.getString("settings.misc.authorizationKey");
                if (string.length() == 0) {
                    return "<html><body style='font-family:arial;font-size:10px;font-style:italic;background:#ffffff;'><p>You did not set an Authorization key. This channel requires a valid Authorization key.</p></body></html>";
                }
                return GeneralUtils.getUserQuotaInfo(string);
            }
            return null;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

