/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public class CliHandler {
    public static boolean checkCliMode(String[] stringArray) {
        return stringArray.length > 0 && stringArray[0].startsWith("--");
    }

    public static int handleArguments(String[] stringArray) {
        Object object;
        EnumSet<ModifierParameter> enumSet;
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        System.out.println("Sc2gears 7.0.1 Command Line Interface");
        int n = 0;
        ActionParameter actionParameter = ActionParameter.fromStringValue(stringArray[n]);
        if (actionParameter == null) {
            System.out.println("Unrecognized ACTION: " + stringArray[n]);
            CliHandler.printUsageWarning();
            return 1;
        }
        ++n;
        if (actionParameter.modifierParameters != null) {
            enumSet = EnumSet.noneOf(ModifierParameter.class);
            while (n < stringArray.length) {
                object = actionParameter.modifierFromStringValue(stringArray[n]);
                if (object != null) {
                    enumSet.add((ModifierParameter)((Object)object));
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            enumSet = null;
        }
        if (actionParameter.requiresReplayFile) {
            if (n >= stringArray.length) {
                System.out.println("Missing replay file argument!");
                CliHandler.printUsageWarning();
                return 2;
            }
            object = stringArray[n++];
        } else {
            object = null;
        }
        int n2 = 0;
        switch (actionParameter) {
            case PRINT_GAME_INFO: {
                n2 = CliHandler.printGameInfo((String)object, enumSet);
                break;
            }
            case PRINT_ACTION_LIST: {
                n2 = CliHandler.printActionList((String)object, enumSet);
                break;
            }
            case PRINT_INGAME_CHAT: {
                n2 = CliHandler.printIngameChat((String)object, enumSet);
                break;
            }
            case HELP: {
                n2 = CliHandler.printHelp((String)object, enumSet);
            }
        }
        return n2 == 0 ? 0 : n2 + (actionParameter.ordinal() + 1) * 100;
    }

    private static void printUsageWarning() {
        System.out.println("Type \"" + GeneralUtils.getSc2gearsStartCommand() + " --help\" for usage info.");
    }

    private static int printGameInfo(String string, Set<ModifierParameter> set) {
        Object object;
        Replay replay = ReplayFactory.parseReplay(string, EnumSet.of(ReplayFactory.ReplayContent.INIT_DATA, ReplayFactory.ReplayContent.DETAILS, ReplayFactory.ReplayContent.ATTRIBUTES_EVENTS, ReplayFactory.ReplayContent.GAME_EVENTS, ReplayFactory.ReplayContent.MAP_INFO));
        if (replay == null) {
            System.out.println("Could not parse replay: " + string);
            return 1;
        }
        System.out.println("-----" + ActionParameter.PRINT_GAME_INFO.stringValue);
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.fileName", new File(string).getAbsolutePath()));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.version", replay.version));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.date", Language.formatDateTime(new Date(replay.details.saveTime))));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.recorderTimeZone", String.format(Locale.US, "%+.2f", Float.valueOf(replay.details.saveTimeZone))));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(replay.gameLength * 500, replay.converterGameSpeed)));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{replay.initData.gameSpeed}));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{replay.initData.gameType}));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{replay.initData.format}));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{replay.initData.gateway}));
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = replay.initData.getArrangedClientNames(replay.details.players);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string2);
            }
            ++n2;
        }
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.clients", stringBuilder));
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", replay.details.mapName == replay.details.originalMapName ? replay.details.mapName : String.valueOf(replay.details.mapName) + " (" + replay.details.originalMapName + ")"));
        if (replay.initData.mapFileName != null) {
            System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.mapFile", replay.initData.mapFileName));
        }
        if (replay.mapInfo != null) {
            System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.mapSize", replay.mapInfo.getSizeString()));
            System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.mapPlayableSize", replay.mapInfo.getPlayableSizeString()));
        }
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.players"));
        int n3 = -1;
        int[] nArray = replay.details.getTeamOrderPlayerIndices();
        int n4 = nArray.length;
        n = 0;
        while (n < n4) {
            n2 = nArray[n];
            object = replay.details.players[n2];
            if (((Details.Player)object).team != n3) {
                System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.team", ((Details.Player)object).team == Integer.MAX_VALUE ? Language.getText("general.unknown") : Integer.valueOf(((Details.Player)object).team)));
                n3 = ((Details.Player)object).team;
            }
            System.out.println(String.valueOf(((Details.Player)object).playerId.name) + ", " + ((Details.Player)object).raceString() + ", " + Language.getText("module.repAnalyzer.tab.charts.chartText.apm", ReplayUtils.calculatePlayerApm(replay, (Details.Player)object)) + ", " + ((Details.Player)object).type.stringValue + " (" + (((Details.Player)object).type == ReplayConsts.PlayerType.COMPUTER ? ((Details.Player)object).difficulty.stringValue : ((Details.Player)object).playerId.getFullName()) + ")" + ", " + ((Details.Player)object).getColorName() + (((Details.Player)object).handicap < 100 ? ", " + Language.getText("module.repAnalyzer.tab.gameInfo.handicap", ((Details.Player)object).handicap) : ""));
            ++n;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        object = replay.details.players;
        int n5 = replay.details.players.length;
        n4 = 0;
        while (n4 < n5) {
            Details.Player player = object[n4];
            if (player.isWinner != null && player.isWinner.booleanValue()) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(player.playerId.name);
            }
            ++n4;
        }
        System.out.println(Language.getText("module.repAnalyzer.tab.gameInfo.winners", stringBuilder2.toString()));
        return 0;
    }

    private static int printActionList(String string, Set<ModifierParameter> set) {
        boolean bl;
        Replay replay = ReplayFactory.parseReplay(string, ReplayFactory.GENERAL_DATA_CONTENT);
        if (replay == null) {
            System.out.println("Could not parse replay: " + string);
            return 1;
        }
        System.out.println("-----" + ActionParameter.PRINT_ACTION_LIST.stringValue);
        boolean bl2 = bl = !set.contains((Object)ModifierParameter.NO_INACTION);
        replay.gameEvents.displayInSeconds = set.contains((Object)ModifierParameter.USE_FRAMES) ? false : (set.contains((Object)ModifierParameter.USE_SECONDS) ? true : Settings.getBoolean("module.repAnalyzer.charts.displayInSeconds"));
        GameEvents.Action[] actionArray = replay.gameEvents.actions;
        int n = replay.gameEvents.actions.length;
        int n2 = 0;
        while (n2 < n) {
            GameEvents.Action action = actionArray[n2];
            if (bl || action.type != ReplayConsts.ActionType.INACTION) {
                System.out.println(action.toString());
            }
            ++n2;
        }
        return 0;
    }

    private static int printIngameChat(String string, Set<ModifierParameter> set) {
        Replay replay = ReplayFactory.parseReplay(string, EnumSet.of(ReplayFactory.ReplayContent.INIT_DATA, ReplayFactory.ReplayContent.DETAILS, ReplayFactory.ReplayContent.ATTRIBUTES_EVENTS, ReplayFactory.ReplayContent.MESSAGE_EVENTS));
        if (replay == null) {
            System.out.println("Could not parse replay: " + string);
            return 1;
        }
        System.out.println("-----" + ActionParameter.PRINT_INGAME_CHAT.stringValue);
        boolean bl = set.contains((Object)ModifierParameter.PRINT_BLINKS) ? true : (set.contains((Object)ModifierParameter.NO_BLINKS) ? false : Settings.getBoolean("module.repAnalyzer.inGameChat.showBlinks"));
        boolean bl2 = set.contains((Object)ModifierParameter.PRINT_TARGETS) ? false : (set.contains((Object)ModifierParameter.NO_TARGETS) ? true : Settings.getBoolean("module.repAnalyzer.inGameChat.hideMessageTargets"));
        String string2 = bl2 ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAll");
        String string3 = bl2 ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAllies");
        String[] stringArray = replay.initData.getArrangedClientNames(replay.details.players);
        int n = 0;
        MessageEvents.Message[] messageArray = replay.messageEvents.messages;
        int n2 = replay.messageEvents.messages.length;
        int n3 = 0;
        while (n3 < n2) {
            MessageEvents.Message message;
            MessageEvents.Message message2 = messageArray[n3];
            String string4 = null;
            String string5 = stringArray[message2.client];
            n += message2.time;
            if (message2 instanceof MessageEvents.Text) {
                message = (MessageEvents.Text)message2;
                String string6 = message.text;
                string4 = bl2 ? Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageNoTarget", ReplayUtils.formatMs(n, replay.converterGameSpeed), string5, string6) : Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageFull", ReplayUtils.formatMs(n, replay.converterGameSpeed), string5, message.opCode == 0 ? string2 : string3, string6);
            } else if (message2 instanceof MessageEvents.Blink && bl) {
                message = (MessageEvents.Blink)message2;
                string4 = Language.getText("module.repAnalyzer.tab.inGameChat.blinkMessage", ReplayUtils.formatMs(n, replay.converterGameSpeed), string5, ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).x), ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).y));
            }
            if (string4 != null) {
                System.out.println(string4);
            }
            ++n3;
        }
        return 0;
    }

    private static int printHelp(String string, Set<ModifierParameter> set) {
        System.out.println("Usage:");
        System.out.println(String.valueOf(GeneralUtils.isWindows() ? "Sc2gears-win.cmd" : GeneralUtils.getSc2gearsStartCommand()) + " ACTION [ACTION_ARGS1] [ACTION_ARGS2] [...] [replayFile]");
        ActionParameter[] actionParameterArray = ActionParameter.values();
        int n = 0;
        ActionParameter[] actionParameterArray2 = actionParameterArray;
        int n2 = actionParameterArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ActionParameter actionParameter = actionParameterArray2[n3];
            n = Math.max(n, actionParameter.stringValue.length());
            ++n3;
        }
        int n4 = 0;
        Enum[] enumArray = ModifierParameter.values();
        int n5 = enumArray.length;
        n2 = 0;
        while (n2 < n5) {
            ModifierParameter modifierParameter = enumArray[n2];
            n4 = Math.max(n4, modifierParameter.stringValue.length());
            ++n2;
        }
        System.out.println("Possible values of ACTION:");
        enumArray = actionParameterArray;
        n5 = actionParameterArray.length;
        n2 = 0;
        while (n2 < n5) {
            Enum enum_ = enumArray[n2];
            System.out.printf("   %-" + n + "s  %s\n", ((ActionParameter)enum_).stringValue, ((ActionParameter)enum_).description);
            if (((ActionParameter)enum_).modifierParameters != null) {
                System.out.printf("   %-" + n + "s  ACTION_ARGS:\n", "");
                ModifierParameter[] modifierParameterArray = ((ActionParameter)enum_).modifierParameters;
                int n6 = ((ActionParameter)enum_).modifierParameters.length;
                int n7 = 0;
                while (n7 < n6) {
                    ModifierParameter modifierParameter = modifierParameterArray[n7];
                    System.out.printf("   %-" + n + "s      %-" + n4 + "s  %s\n", "", modifierParameter.stringValue, modifierParameter.description);
                    ++n7;
                }
            }
            ++n2;
        }
        System.out.println();
        System.out.println("For more information please visit https://sites.google.com/site/sc2gears/features/command-line-interface");
        return 0;
    }

    private static enum ActionParameter {
        PRINT_GAME_INFO("--print-game-info", true, "Prints general info about the specified replay", new ModifierParameter[0]),
        PRINT_ACTION_LIST("--print-action-list", true, "Prints the complete action list of the specified replay", ModifierParameter.NO_INACTION, ModifierParameter.USE_FRAMES, ModifierParameter.USE_SECONDS),
        PRINT_INGAME_CHAT("--print-in-game-chat", true, "Prints the in-game chat of the specified replay", ModifierParameter.PRINT_BLINKS, ModifierParameter.NO_BLINKS, ModifierParameter.PRINT_TARGETS, ModifierParameter.NO_TARGETS),
        HELP("--help", false, "Displays this help", new ModifierParameter[0]);

        public final String stringValue;
        public final boolean requiresReplayFile;
        public final String description;
        public final ModifierParameter[] modifierParameters;

        private ActionParameter(String string2, boolean bl, String string3, ModifierParameter ... modifierParameterArray) {
            this.stringValue = string2;
            this.requiresReplayFile = bl;
            this.description = string3;
            this.modifierParameters = modifierParameterArray.length == 0 ? null : modifierParameterArray;
        }

        public static ActionParameter fromStringValue(String string) {
            ActionParameter[] actionParameterArray = ActionParameter.values();
            int n = actionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionParameter actionParameter = actionParameterArray[n2];
                if (actionParameter.stringValue.equals(string)) {
                    return actionParameter;
                }
                ++n2;
            }
            return null;
        }

        public ModifierParameter modifierFromStringValue(String string) {
            ModifierParameter[] modifierParameterArray = this.modifierParameters;
            int n = this.modifierParameters.length;
            int n2 = 0;
            while (n2 < n) {
                ModifierParameter modifierParameter = modifierParameterArray[n2];
                if (modifierParameter.stringValue.equals(string)) {
                    return modifierParameter;
                }
                ++n2;
            }
            return null;
        }
    }

    private static enum ModifierParameter {
        NO_INACTION("--no-inaction", "Excludes the Inaction action types"),
        USE_FRAMES("--use-frames", "Overrides the setting and uses frames to display time"),
        USE_SECONDS("--use-seconds", "Overrides the setting and uses seconds to display time"),
        PRINT_BLINKS("--print-blinks", "Overrides the setting and includes the minimap pings"),
        NO_BLINKS("--no-blinks", "Overrides the setting and excludes the minimap pings"),
        PRINT_TARGETS("--print-targets", "Overrides the setting and includes the message targets"),
        NO_TARGETS("--no-targets", "Overrides the setting and excludes the message targets");

        public final String stringValue;
        public final String description;

        private ModifierParameter(String string2, String string3) {
            this.stringValue = string2;
            this.description = string3;
        }
    }
}

