/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.util.Base64;
import hu.belicza.andras.sc2gears.util.HttpPost;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ToolTipManager;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeneralUtils
extends SharedUtils {
    private static final int MAX_SC2GEARS_DATABASE_STORE_RETRIES = 3;
    public static final FileFilter SC2REPLAY_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".sc2replay");
        }
    };
    public static final FileFilter SC2REPLAY_FILES_ONLY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().toLowerCase().endsWith(".sc2replay");
        }
    };
    private static final DateFormat MIN_SEC_PARSER = new SimpleDateFormat("m:s");
    private static final DateFormat HOUR_MIN_SEC_PARSER = new SimpleDateFormat("H:m:s");

    private GeneralUtils() {
    }

    public static String getFileNameWithoutExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(0, n);
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(n, string.length());
    }

    public static boolean isDescendant(File file, File file2) {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        while (file2 != null) {
            if (file.equals(file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static boolean copyFile(File file, File file2, byte[] byArray, String string) {
        if (!file2.exists() && !file2.mkdirs()) {
            return false;
        }
        if (file2.exists() && !file2.isDirectory()) {
            return false;
        }
        File file3 = new File(file2, string == null ? file.getName() : string);
        if (file3.exists()) {
            System.out.println("Copy failed: target file already exists!");
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file3);
                if (byArray == null) {
                    byArray = new byte[4096];
                }
                while ((n = fileInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        file3.setLastModified(file.lastModified());
        return true;
    }

    public static String[] splitBySemicolon(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(59, n2)) >= 0) {
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int maxValue(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        int n2 = nArray.length - 1;
        while (n2 > 0) {
            if (n < nArray[n2]) {
                n = nArray[n2];
            }
            --n2;
        }
        return n;
    }

    public static String convertConstNameToNormal(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '_') {
                stringBuilder.append(' ');
                bl = true;
            } else if (bl) {
                stringBuilder.append(c);
                bl = false;
            } else {
                stringBuilder.append(Character.toLowerCase(c));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean isWindows7() {
        return "Windows 7".equals(OS_NAME);
    }

    public static boolean isWindowsVista() {
        return "Windows Vista".equals(OS_NAME);
    }

    public static boolean isWindowsXp() {
        return "Windows XP".equals(OS_NAME);
    }

    public static int countElements(Object[] objectArray, Object object) {
        int n = 0;
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = objectArray2[n3];
            if (object2.equals(object)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static <T> T[] remainingElements(T[] TArray, Set<T> set) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length - set.size());
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            if (!set.contains(t)) {
                arrayList.add(t);
            }
            ++n2;
        }
        return arrayList.toArray((Object[])Array.newInstance(TArray[0].getClass(), arrayList.size()));
    }

    public static int distanceSquare(int n, int n2, int n3, int n4) {
        return ((n >>= 16) - (n3 >>= 16)) * (n - n3) + ((n2 >>= 16) - (n4 >>= 16)) * (n2 - n4);
    }

    public static String formatLongSeconds(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 3600L;
        stringBuilder.append(l2).append(':');
        long l3 = (l %= 3600L) / 60L;
        if (l3 < 10L) {
            stringBuilder.append(0);
        }
        stringBuilder.append(l3).append(':');
        if ((l %= 60L) < 10L) {
            stringBuilder.append(0);
        }
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public static List<File> getAutoRepFolderList() {
        ArrayList<File> arrayList = new ArrayList<File>(5);
        int n = 1;
        while (n <= 5) {
            block5: {
                String string;
                block4: {
                    block3: {
                        if (n != 1) break block3;
                        string = Settings.getString("settings.folders.sc2AutoReplay");
                        break block4;
                    }
                    if (!Settings.getBoolean("settings.folders.enableExtraSc2AutoReplay" + n)) break block5;
                    string = Settings.getString("settings.folders.sc2AutoReplay" + n);
                }
                File file = new File(string);
                arrayList.add(file.exists() ? file : new File(Consts.FOLDER_USER_HOME, string));
            }
            ++n;
        }
        return arrayList;
    }

    public static List<String> getFavoredPlayerList() {
        String string = Settings.getString("settings.misc.favoredPlayerList").trim();
        if (string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(4);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }
        return new ArrayList<String>(0);
    }

    public static <T> Set<T> assembleHashSet(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            hashSet.add(t);
            ++n2;
        }
        return hashSet;
    }

    public static boolean downloadUrl(String string, File file) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            inputStream = new URL(string).openStream();
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Integer parseSeconds(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            Date date = null;
            try {
                date = HOUR_MIN_SEC_PARSER.parse(string);
            }
            catch (Exception exception2) {
                try {
                    date = MIN_SEC_PARSER.parse(string);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar.get(11) * 3600 + gregorianCalendar.get(12) * 60 + gregorianCalendar.get(13);
        }
    }

    public static File getLastReplay(File file, File file2) {
        long l = file2 == null ? 0L : file2.lastModified();
        File[] fileArray = file.listFiles(SC2REPLAY_FILE_FILTER);
        if (fileArray == null) {
            return file2;
        }
        int n = fileArray.length - 1;
        while (n >= 0) {
            File file3 = fileArray[n];
            if (file3.isDirectory()) {
                l = (file2 = GeneralUtils.getLastReplay(file3, file2)) == null ? 0L : file2.lastModified();
            } else if (file3.lastModified() > l) {
                file2 = file3;
                l = file3.lastModified();
            }
            --n;
        }
        return file2;
    }

    public static String getDefaultReplayFolder() {
        String string = Settings.getString("settings.folders.defaultReplay");
        return string == null || string.length() == 0 ? Settings.getString("settings.folders.sc2AutoReplay") : string;
    }

    public static void setToolTipDelays() {
        ToolTipManager.sharedInstance().setInitialDelay(Settings.getInt("settings.misc.toolTipInitialDelay"));
        ToolTipManager.sharedInstance().setDismissDelay(Settings.getInt("settings.misc.toolTipDismissDelay"));
    }

    public static Color getInvertedColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return new Color(Color.HSBtoRGB(1.0f - fArray[0], fArray[1], 1.0f - fArray[2]));
    }

    private static void launchExternalProgram(File file, String[] stringArray) {
        if (file != null && !file.exists()) {
            GuiUtils.showErrorDialog(new Object[]{Language.getText("misc.applicationDoesNotExist"), file.getAbsolutePath(), " ", Language.getText("misc.isStarCraft2FolderConfiguredProperly"), " ", MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.FOLDERS)}, new Frame[0]);
            return;
        }
        try {
            String[] stringArray2;
            Runtime runtime = Runtime.getRuntime();
            if (stringArray == null) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = file.getAbsolutePath();
            } else {
                stringArray2 = stringArray;
            }
            runtime.exec(stringArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void startStarCraftII() {
        GeneralUtils.launchExternalProgram(new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isMac() ? "StarCraft II.app/Contents/MacOS/StarCraft II" : "StarCraft II.exe"), null);
    }

    public static void startStarCraftIIEditor() {
        GeneralUtils.launchExternalProgram(new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isMac() ? "StarCraft II Editor.app/Contents/MacOS/StarCraft II Editor" : "StarCraft II Editor.exe"), null);
    }

    public static void launchReplay(File file) {
        File file2 = new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isMac() ? "StarCraft II.app/Contents/MacOS/StarCraft II" : "StarCraft II.exe");
        GeneralUtils.launchExternalProgram(file2, new String[]{file2.getAbsolutePath(), file.getAbsolutePath()});
    }

    public static Object[] prependOneElement(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = " ";
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }

    public static void copyToClipboard(String string) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> map) {
        HashMap<V, K> hashMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static byte[] toArray(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        int n = byArray.length - 1;
        while (n >= 0) {
            byArray[n] = list.get(n);
            --n;
        }
        return byArray;
    }

    public static short[] toArray(List<Short> list) {
        short[] sArray = new short[list.size()];
        int n = sArray.length - 1;
        while (n >= 0) {
            sArray[n] = list.get(n);
            --n;
        }
        return sArray;
    }

    public static int[] toArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = list.get(n);
            --n;
        }
        return nArray;
    }

    public static File generateUniqueName(File file) {
        String string = null;
        String string2 = null;
        String string3 = null;
        File file2 = file;
        int n = 2;
        while (file2.exists()) {
            if (n == 2) {
                string = file.getParent();
                string2 = GeneralUtils.getFileNameWithoutExt(file);
                string3 = GeneralUtils.getFileExtension(file);
            }
            file2 = new File(string, String.valueOf(string2) + " (" + n++ + ")" + string3);
        }
        return file2;
    }

    public static int[] parseRgbString(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = Integer.parseInt(stringArray[n].trim());
            if (nArray[n] < 0 || nArray[n] > 255) {
                return null;
            }
            --n;
        }
        return nArray;
    }

    public static Color getColorSetting(String string, String string2) {
        int[] nArray = null;
        if (string != null) {
            nArray = GeneralUtils.parseRgbString(string);
        }
        if (nArray == null && (nArray = GeneralUtils.parseRgbString(Settings.getString(string2))) == null) {
            nArray = GeneralUtils.parseRgbString(Settings.getDefaultString(string2));
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public static String toHtmlColorString(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Boolean checkAuthorizationKey(String string) {
        HttpPost httpPost = null;
        try {
            List<String> list;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("protVer", "1");
            hashMap.put("op", "checkKey");
            hashMap.put("authKey", string);
            httpPost = new HttpPost(Consts.URL_SC2GEARS_DATABASE_INFO_SERVLET, hashMap);
            if (httpPost.connect() && httpPost.doPost() && (list = httpPost.getResponseLines()) != null) {
                Boolean bl = Boolean.valueOf(list.get(0));
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (httpPost != null) {
                httpPost.close();
            }
        }
        return null;
    }

    public static String checkKeyBeforeStoringOrDownloading(Frame ... frameArray) {
        String string = Settings.getString("settings.misc.authorizationKey");
        Boolean bl = null;
        if (string.length() > 0 && (bl = GeneralUtils.checkAuthorizationKey(string)) == null) {
            GuiUtils.showErrorDialog(Language.getText("replayops.failedAuthKeyCheck"), new Frame[0]);
            return null;
        }
        if (string.length() == 0 || !bl.booleanValue()) {
            GuiUtils.showErrorDialog(new Object[]{Language.getText(string.length() == 0 ? "replayops.missingAuthKey" : "replayops.invalidAuthKey"), Language.getText("replayops.authKeyRequired"), " ", MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.SC2GEARS_DATABASE)}, frameArray);
            return null;
        }
        return string;
    }

    public static boolean storeReplay(File file, String string) {
        Replay replay = ReplayFactory.parseReplay(file.getAbsolutePath(), ReplayFactory.GENERAL_DATA_CONTENT);
        if (replay == null) {
            System.out.println("Failed to store replay in the Sc2gears Database: failed to parse replay: " + file.getAbsolutePath());
            return false;
        }
        if (Settings.getBoolean("settings.misc.rearrangePlayersInRepAnalyzer")) {
            ReplayUtils.applyFavoredPlayerListSetting(replay.details);
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = replay.details.getTeamOrderPlayerIndices();
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = object[n2];
            Details.Player player = replay.details.players[n3];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(player.team);
            if (player.isWinner != null && player.isWinner.booleanValue()) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(',');
                }
                stringBuilder2.append(player.playerId.name);
            }
            ++n2;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("protVer", "1");
        hashMap.put("op", "st");
        hashMap.put("authKey", string);
        hashMap.put("sha1", GeneralUtils.calculateFileSha1(file));
        hashMap.put("fileName", file.getName());
        hashMap.put("lastMod", Long.toString(file.lastModified()));
        hashMap.put("fileType", "SC2Replay");
        hashMap.put("fileContent", Base64.encodeFile(file));
        hashMap.put("version", replay.version);
        hashMap.put("repDate", Long.toString(replay.details.saveTime));
        hashMap.put("gameLength", Integer.toString(replay.gameLengthSec));
        hashMap.put("gateway", replay.initData.gateway.stringValue);
        hashMap.put("gameType", replay.initData.gameType.stringValue);
        hashMap.put("mapName", replay.details.mapName);
        hashMap.put("mapFileName", replay.initData.mapFileName == null ? "" : replay.initData.mapFileName);
        hashMap.put("raceMtchp", replay.details.getRaceMatchup());
        hashMap.put("players", replay.details.getPlayerNames());
        hashMap.put("playerTeams", stringBuilder.toString());
        hashMap.put("winners", stringBuilder2.toString());
        n2 = 0;
        while (n2 < 3) {
            if (n2 > 0) {
                System.out.println("Retrying storing replay... (" + (n2 + 1) + ")");
            }
            HttpPost httpPost = null;
            try {
                httpPost = new HttpPost(Consts.URL_SC2GEARS_DATABASE_FILE_SERVLET, hashMap);
                if (httpPost.connect() && httpPost.doPost() && (object = (Object)httpPost.getResponseLines()) != null && Boolean.valueOf((String)object.get(0)).booleanValue()) {
                    System.out.println("Successfully stored replay in the Sc2gears Database: " + file.getAbsolutePath());
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (httpPost != null) {
                    httpPost.close();
                }
            }
            System.out.println("Failed to store replay in the Sc2gears Database: " + file.getAbsolutePath());
            ++n2;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static boolean storeMousePrint(File var0, String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getUserQuotaInfo(String string) {
        HttpPost httpPost = null;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("protVer", "1");
            hashMap.put("op", "getQtInf");
            hashMap.put("authKey", string);
            httpPost = new HttpPost(Consts.URL_SC2GEARS_DATABASE_INFO_SERVLET, hashMap);
            if (httpPost.connect() && httpPost.doPost()) {
                String string2 = httpPost.getResponse();
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (httpPost != null) {
                httpPost.close();
            }
        }
        return null;
    }
}

