/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public class GoogleTranslator {
    private static final String SERVICE_URL = "http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&langpair=";
    private static final String KEY_RESPONSE_DATA = "responseData";
    private static final String KEY_TRANSLATED_TEXT = "translatedText";

    public static String[] translateTexts(String[] stringArray, Language language, Language language2) {
        if (stringArray.length == 0) {
            return new String[0];
        }
        StringBuilder stringBuilder = new StringBuilder(SERVICE_URL);
        stringBuilder.append(language.code).append("%7C").append(language2.code);
        BufferedReader bufferedReader = null;
        try {
            String string;
            Object object;
            Object object2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                stringBuilder.append("&q=").append(URLEncoder.encode((String)object, "UTF-8"));
                ++n2;
            }
            object = new URL(stringBuilder.toString()).openConnection();
            ((URLConnection)object).setRequestProperty("Accept-Charset", "UTF-8");
            bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream(), "UTF-8"));
            stringBuilder.setLength(0);
            StringBuilder stringBuilder2 = stringBuilder;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder2.append(string);
            }
            object2 = new JSONObject(stringBuilder2.toString());
            String[] stringArray2 = null;
            Object object3 = ((JSONObject)object2).get(KEY_RESPONSE_DATA);
            if (object3 instanceof JSONArray) {
                stringArray2 = new String[stringArray.length];
                JSONArray jSONArray = (JSONArray)object3;
                int n3 = Math.min(stringArray.length, jSONArray.length()) - 1;
                while (n3 >= 0) {
                    Object object4 = jSONArray.getJSONObject(n3).get(KEY_RESPONSE_DATA);
                    stringArray2[n3] = object4 instanceof JSONObject ? ((JSONObject)object4).getString(KEY_TRANSLATED_TEXT) : stringArray[n3];
                    --n3;
                }
            } else if (object3 instanceof JSONObject) {
                stringArray2 = new String[stringArray.length];
                stringArray2[0] = ((JSONObject)object3).getString(KEY_TRANSLATED_TEXT);
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static enum Language {
        AUTO_DETECT(""),
        ENGLISH("en"),
        AFRIKAANS("af"),
        ALBANIAN("sq"),
        AMHARIC("am"),
        ARABIC("ar"),
        ARMENIAN("hy"),
        AZERBAIJANI("az"),
        BASQUE("eu"),
        BELARUSIAN("be"),
        BENGALI("bn"),
        BIHARI("bh"),
        BRETON("br"),
        BULGARIAN("bg"),
        BURMESE("my"),
        CATALAN("ca"),
        CHEROKEE("chr"),
        CHINESE("zh"),
        CHINESE_SIMPLIFIED("zh-CN"),
        CHINESE_TRADITIONAL("zh-TW"),
        CORSICAN("co"),
        CROATIAN("hr"),
        CZECH("cs"),
        DANISH("da"),
        DHIVEHI("dv"),
        DUTCH("nl"),
        ESPERANTO("eo"),
        ESTONIAN("et"),
        FAROESE("fo"),
        FILIPINO("tl"),
        FINNISH("fi"),
        FRENCH("fr"),
        FRISIAN("fy"),
        GALICIAN("gl"),
        GEORGIAN("ka"),
        GERMAN("de"),
        GREEK("el"),
        GUJARATI("gu"),
        HAITIAN_CREOLE("ht"),
        HEBREW("iw"),
        HINDI("hi"),
        HUNGARIAN("hu"),
        ICELANDIC("is"),
        INDONESIAN("id"),
        INUKTITUT("iu"),
        IRISH("ga"),
        ITALIAN("it"),
        JAPANESE("ja"),
        JAVANESE("jw"),
        KANNADA("kn"),
        KAZAKH("kk"),
        KHMER("km"),
        KOREAN("ko"),
        KURDISH("ku"),
        KYRGYZ("ky"),
        LAO("lo"),
        LATIN("la"),
        LATVIAN("lv"),
        LITHUANIAN("lt"),
        LUXEMBOURGISH("lb"),
        MACEDONIAN("mk"),
        MALAY("ms"),
        MALAYALAM("ml"),
        MALTESE("mt"),
        MAORI("mi"),
        MARATHI("mr"),
        MONGOLIAN("mn"),
        NEPALI("ne"),
        NORWEGIAN("no"),
        OCCITAN("oc"),
        ORIYA("or"),
        PASHTO("ps"),
        PERSIAN("fa"),
        POLISH("pl"),
        PORTUGUESE("pt"),
        PORTUGUESE_PORTUGAL("pt-PT"),
        PUNJABI("pa"),
        QUECHUA("qu"),
        ROMANIAN("ro"),
        RUSSIAN("ru"),
        SANSKRIT("sa"),
        SCOTS_GAELIC("gd"),
        SERBIAN("sr"),
        SINDHI("sd"),
        SINHALESE("si"),
        SLOVAK("sk"),
        SLOVENIAN("sl"),
        SPANISH("es"),
        SUNDANESE("su"),
        SWAHILI("sw"),
        SWEDISH("sv"),
        SYRIAC("syr"),
        TAJIK("tg"),
        TAMIL("ta"),
        TATAR("tt"),
        TELUGU("te"),
        THAI("th"),
        TIBETAN("bo"),
        TONGA("to"),
        TURKISH("tr"),
        UKRAINIAN("uk"),
        URDU("ur"),
        UZBEK("uz"),
        UIGHUR("ug"),
        VIETNAMESE("vi"),
        WELSH("cy"),
        YIDDISH("yi"),
        YORUBA("yo"),
        UNKNOWN("");

        public final String stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        public final String code;

        private Language(String string2) {
            this.code = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

