/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpPost {
    private static final String CHARSET = "UTF-8";
    private final Map<String, String> paramsMap;
    private final String urlString;
    private HttpURLConnection httpUrlConnection;

    public HttpPost(String string, Map<String, String> map) {
        this.paramsMap = map;
        this.urlString = string;
    }

    public boolean connect() {
        try {
            this.httpUrlConnection = (HttpURLConnection)new URL(this.urlString).openConnection();
            this.httpUrlConnection.setDoOutput(true);
            this.httpUrlConnection.setRequestProperty("Accept-Charset", CHARSET);
            this.httpUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            this.httpUrlConnection.connect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean doPost() {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = this.httpUrlConnection.getOutputStream();
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<String, String> entry : this.paramsMap.entrySet()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), CHARSET));
                }
                outputStream.write(stringBuilder.toString().getBytes(CHARSET));
                outputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public String getResponse() {
        return (String)this.readResponse(false);
    }

    public List<String> getResponseLines() {
        return (List)this.readResponse(true);
    }

    private Object readResponse(boolean bl) {
        block23: {
            String string;
            InputStream inputStream = null;
            try {
                String string2;
                Object object;
                inputStream = this.httpUrlConnection.getInputStream();
                int n = this.httpUrlConnection.getResponseCode();
                if (n != 200) break block23;
                String string3 = CHARSET;
                String string4 = this.httpUrlConnection.getHeaderField("Content-Type");
                if (string4 != null) {
                    String[] stringArray = string4.replace(" ", "").split(";");
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        object = stringArray[n3];
                        if (((String)object).startsWith("charset=")) {
                            string3 = ((String)object).split("=", 2)[1];
                            break;
                        }
                        ++n3;
                    }
                }
                object = new BufferedReader(new InputStreamReader(inputStream, string3));
                if (bl) {
                    String string5;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while ((string5 = ((BufferedReader)object).readLine()) != null) {
                        arrayList.add(string5);
                    }
                    ArrayList<String> arrayList2 = arrayList;
                    return arrayList2;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block23;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return string;
        }
        return null;
    }

    public boolean saveAttachmentToFile(FileProvider fileProvider, byte[] ... byArray) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = this.httpUrlConnection.getInputStream();
            int n = this.httpUrlConnection.getResponseCode();
            if (n == 200) {
                int n2;
                File file = fileProvider.getFile(this.httpUrlConnection);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray2 = byArray.length == 0 ? new byte[16384] : byArray[0];
                while ((n2 = inputStream.read(byArray2)) > 0) {
                    fileOutputStream.write(byArray2, 0, n2);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
                fileOutputStream = null;
                Long l = fileProvider.getLastModified(this.httpUrlConnection);
                if (l != null) {
                    file.setLastModified(l);
                }
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void close() {
        if (this.httpUrlConnection != null) {
            this.httpUrlConnection.disconnect();
        }
    }

    public static interface FileProvider {
        public File getFile(HttpURLConnection var1);

        public Long getLastModified(HttpURLConnection var1);
    }
}

