/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.services.Downloader;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.FileBasedCache;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gearspluginapi.api.listener.DownloaderCallback;
import java.awt.Dialog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProfileCache
extends FileBasedCache {
    public static final short CACHE_VERSION = 2;
    private static final Map<String, CustomPortraitInfo> USER_ID_CUSTOM_PORTRAIT_MAP = new HashMap<String, CustomPortraitInfo>();
    private static final Date CUSTOM_PORTRAIT_LIST_UPDATED_AT = new Date();

    static {
        int n = 0;
        while (n < 3) {
            if (ProfileCache.downloadCustomPortraitList()) break;
            ++n;
        }
    }

    private static boolean downloadCustomPortraitList() {
        if (Consts.DEVELOPER_MODE) {
            return true;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new URL("https://sc2gearsdb.appspot.com/hosted/custom_portraits.xml").toURI().toString());
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("p");
            int n = nodeList.getLength();
            HashMap<String, CustomPortraitInfo> hashMap = new HashMap<String, CustomPortraitInfo>(n);
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                hashMap.put(element2.getAttribute("uid"), new CustomPortraitInfo(element2.getAttribute("ver"), element2.getAttribute("url45"), element2.getAttribute("url90")));
                ++n2;
            }
            USER_ID_CUSTOM_PORTRAIT_MAP.clear();
            USER_ID_CUSTOM_PORTRAIT_MAP.putAll(hashMap);
            CUSTOM_PORTRAIT_LIST_UPDATED_AT.setTime(new Date().getTime());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private ProfileCache() {
    }

    public static boolean queryProfile(Details.PlayerId playerId, ProfileListener profileListener, boolean bl) {
        return ProfileCache.queryProfile(playerId, profileListener, bl, false);
    }

    public static boolean queryProfile(final Details.PlayerId playerId, final ProfileListener profileListener, boolean bl, boolean bl2) {
        boolean bl3;
        if (playerId.gateway == ReplayConsts.Gateway.UNKNOWN || playerId.gateway == ReplayConsts.Gateway.PUBLIC_TEST || playerId.battleNetId == 0) {
            profileListener.profileReady(null, false);
            return true;
        }
        final Profile profile = ProfileCache.readCachedProfile(playerId);
        final boolean bl4 = profile == null || bl2 || profile.updatedAt.getTime() + (long)Settings.getInt("settings.misc.profileInfoValidityTime") * 24L * 60L * 60L * 1000L < new Date().getTime();
        boolean bl5 = bl3 = bl && (profile == null || bl2 || profile.allRanksUpdatedAt.getTime() + (long)Settings.getInt("settings.misc.profileInfoValidityTime") * 24L * 60L * 60L * 1000L < new Date().getTime());
        if (profile != null && !bl2) {
            profileListener.profileReady(profile, bl4 || bl3);
        }
        if (bl4 || bl3) {
            new NormalThread("Profile retriever"){

                @Override
                public void run() {
                    Profile profile4;
                    if (bl4) {
                        profile4 = ProfileCache.retrieveProfile(playerId);
                        if (profile4 != null) {
                            ProfileCache.cacheProfile(profile4, playerId);
                        }
                        if (profile4 != null || profile == null) {
                            profileListener.profileReady(profile4, bl3);
                        }
                    } else {
                        profile4 = null;
                    }
                    if (bl3) {
                        Profile profile2;
                        Profile profile3 = profile2 = profile4 == null ? profile : profile4;
                        if (profile2 != null && (profile2 = ProfileCache.retrieveExtProfile(playerId, profile2)) != null) {
                            ProfileCache.cacheProfile(profile2, playerId);
                            profileListener.profileReady(profile2, false);
                        }
                    }
                }
            }.start();
        }
        return profile != null && !bl2;
    }

    public static Profile retrieveProfile(Details.PlayerId playerId) {
        Profile profile = new Profile();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = documentBuilder.parse(new URL(playerId.getBnetProfileUrl(ReplayConsts.BnetLanguage.ENGLISH)).toURI().toString());
            NodeList nodeList = document.getElementsByTagName("div");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)nodeList.item(n2);
                String string = element.getAttribute("id");
                if (string.length() != 0) {
                    int n3;
                    Object object;
                    if ("portrait".equals(string)) {
                        object = ((Element)element.getElementsByTagName("span").item(0)).getAttribute("style");
                        n3 = ((String)object).indexOf("url('");
                        int n4 = ((String)object).indexOf(39, n3 + 5);
                        profile.portraitGroup = ((String)object).charAt(((String)object).lastIndexOf(47, n4) + 1) - 48;
                        int n5 = ((String)object).indexOf(32, n4 + 1);
                        int n6 = ((String)object).indexOf(32, n5 + 1);
                        profile.portraitColumn = Math.abs(Integer.parseInt(((String)object).substring(n5 + 1, ((String)object).indexOf("px", n5)))) / 90;
                        profile.portraitRow = Math.abs(Integer.parseInt(((String)object).substring(n6 + 1, ((String)object).indexOf("px", n6)))) / 90;
                    } else if ("profile-header".equals(string)) {
                        profile.achievementPoints = Integer.parseInt(((Element)element.getElementsByTagName("h3").item(0)).getTextContent().trim());
                    } else if ("season-snapshot".equals(string)) {
                        object = element.getElementsByTagName("div");
                        Element element2 = (Element)object.item(object.getLength() - 1);
                        String string2 = ((Element)element2.getElementsByTagName("a").item(0)).getAttribute("class");
                        ReplayConsts.Race[] raceArray = ReplayConsts.Race.values();
                        int n7 = raceArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            ReplayConsts.Race race = raceArray[n8];
                            if (string2.contains(race.bnetString)) {
                                profile.favoriteRace = race;
                                break;
                            }
                            ++n8;
                        }
                    } else if ("career-stats".equals(string)) {
                        profile.leagueWins = Integer.parseInt(((Element)((Element)element.getElementsByTagName("div").item(1)).getElementsByTagName("h2").item(0)).getTextContent().trim());
                    } else if (string.startsWith("best-team-") && (object = element.getElementsByTagName("div")).getLength() > 0) {
                        n3 = string.charAt(string.length() - 1) - 49;
                        Profile.TeamRank teamRank = profile.bestRanks[n3] = new Profile.TeamRank();
                        teamRank.divisionRank = Integer.parseInt(((Element)object.item(1)).getLastChild().getTextContent().trim());
                        Element element3 = (Element)element.getParentNode();
                        String string3 = ((Element)((Element)element3.getElementsByTagName("a").item(0)).getElementsByTagName("span").item(0)).getAttribute("class");
                        teamRank.league = ProfileCache.getLeagueFromBadgeClass(string3);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return profile;
    }

    public static Profile retrieveExtProfile(Details.PlayerId playerId, Profile profile) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = documentBuilder.parse(new URL(String.valueOf(playerId.getBnetProfileUrl(ReplayConsts.BnetLanguage.ENGLISH)) + "/ladder/leagues").toURI().toString());
            List[] listArray = new List[profile.allRankss.length];
            int n = 0;
            while (n < listArray.length) {
                listArray[n] = new ArrayList();
                ++n;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            NodeList nodeList = document.getElementsByTagName("div");
            int n2 = nodeList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Element element = (Element)nodeList.item(n3);
                String string = element.getAttribute("id");
                if (string.length() != 0) {
                    int n4;
                    if ("profile-left".equals(string)) {
                        NodeList nodeList2 = ((Element)element.getElementsByTagName("ul").item(0)).getElementsByTagName("a");
                        int n5 = nodeList2.getLength();
                        n4 = 0;
                        while (n4 < n5) {
                            Element element2 = (Element)nodeList2.item(n4);
                            if (element2.getAttribute("data-tooltip").length() > 0) {
                                arrayList.add(element2.getTextContent().trim().charAt(0) - 49);
                            }
                            ++n4;
                        }
                    } else if ("profile-right".equals(string)) {
                        int n6 = 0;
                        NodeList nodeList3 = element.getElementsByTagName("div");
                        n4 = nodeList3.getLength();
                        int n7 = 0;
                        while (n7 < n4) {
                            Element element3 = (Element)nodeList3.item(n7);
                            if ("ladder-tooltip".equals(element3.getAttribute("class"))) {
                                int n8 = (Integer)arrayList.get(n6++);
                                Profile.TeamRank teamRank = new Profile.TeamRank();
                                String string2 = ((Element)element3.getElementsByTagName("span").item(0)).getAttribute("class");
                                teamRank.league = ProfileCache.getLeagueFromBadgeClass(string2);
                                String string3 = element3.getElementsByTagName("strong").item(0).getTextContent().trim();
                                int n9 = string3.length() - 1;
                                char c = string3.charAt(n9);
                                while (c >= '0' && c <= '9') {
                                    c = string3.charAt(--n9);
                                }
                                if (n9 < string3.length() - 1) {
                                    teamRank.divisionRank = Integer.parseInt(string3.substring(n9 + 1));
                                } else {
                                    n9 = 0;
                                    c = string3.charAt(n9);
                                    while (c >= '0' && c <= '9') {
                                        c = string3.charAt(++n9);
                                    }
                                    if (n9 > 0) {
                                        teamRank.divisionRank = Integer.parseInt(string3.substring(0, n9));
                                    }
                                }
                                StringTokenizer stringTokenizer = new StringTokenizer(element3.getLastChild().getTextContent(), ",");
                                ArrayList<String> arrayList2 = new ArrayList<String>(n8);
                                while (stringTokenizer.hasMoreTokens()) {
                                    arrayList2.add(stringTokenizer.nextToken().trim());
                                }
                                teamRank.teamMembers = arrayList2.toArray(new String[arrayList2.size()]);
                                listArray[n8].add(teamRank);
                            }
                            ++n7;
                        }
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < listArray.length) {
                profile.allRankss[n3] = listArray[n3].toArray(new Profile.TeamRank[listArray[n3].size()]);
                Arrays.sort(profile.allRankss[n3]);
                ++n3;
            }
            profile.allRanksUpdatedAt = new Date();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return profile;
    }

    private static Icons.League getLeagueFromBadgeClass(String string) {
        Icons.League[] leagueArray = Icons.League.values();
        int n = leagueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Icons.League league = leagueArray[n2];
            if (string.contains(league.bnetString)) {
                return league;
            }
            ++n2;
        }
        return Icons.League.UNKNOWN;
    }

    private static Profile readCachedProfile(Details.PlayerId playerId) {
        Profile profile;
        File file = new File(ProfileCache.getCacheFolder(playerId), Integer.toHexString(playerId.battleNetId));
        if (!file.exists()) {
            return null;
        }
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new FileInputStream(file));
            short s = ((DataInputStream)filterInputStream).readShort();
            if (s != 2) {
                return null;
            }
            Profile profile2 = new Profile(new Date(((DataInputStream)filterInputStream).readLong()));
            profile2.allRanksUpdatedAt = new Date(((DataInputStream)filterInputStream).readLong());
            profile2.portraitGroup = ((DataInputStream)filterInputStream).readShort();
            profile2.portraitRow = ((DataInputStream)filterInputStream).readShort();
            profile2.portraitColumn = ((DataInputStream)filterInputStream).readShort();
            profile2.achievementPoints = ((DataInputStream)filterInputStream).readInt();
            profile2.favoriteRace = ReplayConsts.Race.values()[((DataInputStream)filterInputStream).readByte()];
            profile2.leagueWins = ((DataInputStream)filterInputStream).readInt();
            Icons.League[] leagueArray = Icons.League.values();
            int n = 0;
            while (n < profile2.bestRanks.length) {
                if (((DataInputStream)filterInputStream).readBoolean()) {
                    profile2.bestRanks[n] = new Profile.TeamRank();
                    profile2.bestRanks[n].league = leagueArray[((DataInputStream)filterInputStream).readByte()];
                    profile2.bestRanks[n].divisionRank = ((DataInputStream)filterInputStream).readShort();
                }
                ++n;
            }
            n = 0;
            while (n < profile2.allRankss.length) {
                int n2 = ((DataInputStream)filterInputStream).readInt();
                if (n2 > 0) {
                    profile2.allRankss[n] = new Profile.TeamRank[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        Profile.TeamRank teamRank = new Profile.TeamRank();
                        profile2.allRankss[n][n3] = teamRank;
                        Profile.TeamRank teamRank2 = teamRank;
                        teamRank2.league = leagueArray[((DataInputStream)filterInputStream).readByte()];
                        teamRank2.divisionRank = ((DataInputStream)filterInputStream).readShort();
                        teamRank2.teamMembers = new String[((DataInputStream)filterInputStream).readByte()];
                        int n4 = 0;
                        while (n4 < teamRank2.teamMembers.length) {
                            teamRank2.teamMembers[n4] = ((DataInputStream)filterInputStream).readUTF();
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            profile = profile2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return profile;
    }

    private static void cacheProfile(Profile profile, Details.PlayerId playerId) {
        block21: {
            File file = ProfileCache.getCacheFolder(playerId);
            if (!file.exists() && !file.mkdirs()) {
                return;
            }
            File file2 = new File(file, Integer.toHexString(playerId.battleNetId));
            FilterOutputStream filterOutputStream = null;
            try {
                try {
                    Profile.TeamRank teamRank;
                    filterOutputStream = new DataOutputStream(new FileOutputStream(file2));
                    ((DataOutputStream)filterOutputStream).writeShort(2);
                    ((DataOutputStream)filterOutputStream).writeLong(profile.updatedAt.getTime());
                    ((DataOutputStream)filterOutputStream).writeLong(profile.allRanksUpdatedAt.getTime());
                    ((DataOutputStream)filterOutputStream).writeShort(profile.portraitGroup);
                    ((DataOutputStream)filterOutputStream).writeShort(profile.portraitRow);
                    ((DataOutputStream)filterOutputStream).writeShort(profile.portraitColumn);
                    ((DataOutputStream)filterOutputStream).writeInt(profile.achievementPoints);
                    ((DataOutputStream)filterOutputStream).writeByte(profile.favoriteRace.ordinal());
                    ((DataOutputStream)filterOutputStream).writeInt(profile.leagueWins);
                    Profile.TeamRank[] teamRankArray = profile.bestRanks;
                    int n = profile.bestRanks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        teamRank = teamRankArray[n2];
                        if (teamRank == null) {
                            ((DataOutputStream)filterOutputStream).writeBoolean(false);
                        } else {
                            ((DataOutputStream)filterOutputStream).writeBoolean(true);
                            ((DataOutputStream)filterOutputStream).writeByte(teamRank.league.ordinal());
                            ((DataOutputStream)filterOutputStream).writeShort(teamRank.divisionRank);
                        }
                        ++n2;
                    }
                    teamRankArray = profile.allRankss;
                    n = profile.allRankss.length;
                    n2 = 0;
                    while (n2 < n) {
                        teamRank = teamRankArray[n2];
                        if (teamRank == null) {
                            ((DataOutputStream)filterOutputStream).writeInt(0);
                        } else {
                            ((DataOutputStream)filterOutputStream).writeInt(((Profile.TeamRank)teamRank).length);
                            Profile.TeamRank teamRank2 = teamRank;
                            int n3 = ((Profile.TeamRank)teamRank2).length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Profile.TeamRank teamRank3 = teamRank2[n4];
                                ((DataOutputStream)filterOutputStream).writeByte(teamRank3.league.ordinal());
                                ((DataOutputStream)filterOutputStream).writeShort(teamRank3.divisionRank);
                                ((DataOutputStream)filterOutputStream).writeByte(teamRank3.teamMembers.length);
                                String[] stringArray = teamRank3.teamMembers;
                                int n5 = teamRank3.teamMembers.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    String string = stringArray[n6];
                                    ((DataOutputStream)filterOutputStream).writeUTF(string);
                                    ++n6;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    ((DataOutputStream)filterOutputStream).flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (filterOutputStream == null) break block21;
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static Boolean queryCustomPortrait(Details.PlayerId playerId, boolean bl, final CustomPortraitListener customPortraitListener) {
        CustomPortraitInfo customPortraitInfo;
        if (CUSTOM_PORTRAIT_LIST_UPDATED_AT.getTime() + 86400000L < new Date().getTime() && !ProfileCache.downloadCustomPortraitList()) {
            CUSTOM_PORTRAIT_LIST_UPDATED_AT.setTime(new Date().getTime());
        }
        if ((customPortraitInfo = USER_ID_CUSTOM_PORTRAIT_MAP.get(String.valueOf(playerId.gateway.binaryValue) + "-" + playerId.battleNetSubid + "-" + playerId.battleNetId)) == null) {
            return null;
        }
        final File file = new File(ProfileCache.getCacheFolder(playerId), String.valueOf(bl ? "cp90-" : "cp45-") + customPortraitInfo.version + "-" + Integer.toHexString(playerId.battleNetId));
        if (file.exists()) {
            customPortraitListener.customPortraitReady(new ImageIcon(file.getAbsolutePath()));
            return Boolean.TRUE;
        }
        new Downloader(customPortraitInfo.getCustomPortraitUrl(bl), file, false, new DownloaderCallback(){

            @Override
            public void downloadFinished(boolean bl) {
                customPortraitListener.customPortraitReady(bl ? new ImageIcon(file.getAbsolutePath()) : null);
            }
        }).start();
        return Boolean.FALSE;
    }

    private static File getCacheFolder(Details.PlayerId playerId) {
        return new File("User Content/Profile cache", String.valueOf(playerId.gateway.binaryValue) + "-" + playerId.battleNetSubid + "/" + ProfileCache.getByteHashOfInt(playerId.battleNetId));
    }

    private static String getByteHashOfInt(int n) {
        int n2 = n & 0xFF;
        int n3 = 0;
        while (n3 < 3) {
            n2 ^= (n >>= 8) & 0xFF;
            ++n3;
        }
        return String.format("%02x", n2);
    }

    public static void emptyCache(Dialog dialog) {
        ProfileCache.emptyCache_("Profile", dialog, "miscSettings.clearingProfileCache", "User Content/Profile cache");
    }

    private static class CustomPortraitInfo {
        public final String version;
        public final String url45;
        public final String url90;

        public CustomPortraitInfo(String string, String string2, String string3) {
            this.version = string;
            this.url45 = string2;
            this.url90 = string3;
        }

        public String getCustomPortraitUrl(boolean bl) {
            return bl ? this.url90 : this.url45;
        }
    }

    public static interface CustomPortraitListener {
        public void customPortraitReady(ImageIcon var1);
    }

    public static class Profile {
        public Date updatedAt;
        public Date allRanksUpdatedAt;
        public int portraitGroup;
        public int portraitRow;
        public int portraitColumn;
        public int achievementPoints;
        public ReplayConsts.Race favoriteRace;
        public int leagueWins;
        public final TeamRank[] bestRanks = new TeamRank[4];
        public final TeamRank[][] allRankss = new TeamRank[4][];

        public Profile() {
            this.updatedAt = new Date();
            this.allRanksUpdatedAt = new Date(0L);
            this.favoriteRace = ReplayConsts.Race.UNKNOWN;
        }

        public Profile(Date date) {
            this.updatedAt = date;
        }

        public static class TeamRank
        implements Comparable<TeamRank> {
            public Icons.League league;
            public int divisionRank;
            public String[] teamMembers;

            @Override
            public int compareTo(TeamRank teamRank) {
                int n = this.league.compareTo(teamRank.league);
                if (n != 0) {
                    return n;
                }
                return this.divisionRank - teamRank.divisionRank;
            }
        }
    }

    public static interface ProfileListener {
        public void profileReady(Profile var1, boolean var2);
    }
}

