/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.InitData;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.FileBasedCache;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import java.awt.Dialog;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReplayCache
extends FileBasedCache {
    public static final short CACHE_VERSION = 12;
    private static final Map<String, byte[]> IN_MEMORY_REPLAY_CACHE;
    private static final char[] ENCODED_MD5_ALPHABET;

    static {
        if (Settings.getBoolean("settings.misc.useInMemoryReplayCache")) {
            IN_MEMORY_REPLAY_CACHE = new HashMap<String, byte[]>();
            ReplayCache.loadCacheToMemory(new File("User Content/Replay cache"));
        } else {
            IN_MEMORY_REPLAY_CACHE = null;
        }
        ENCODED_MD5_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$#".toCharArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadCacheToMemory(File file) {
        File[] fileArray;
        if (file.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                try {
                    byte[] byArray = new byte[(int)file.length()];
                    fileInputStream = new FileInputStream(file);
                    fileInputStream.read(byArray);
                    IN_MEMORY_REPLAY_CACHE.put(file.getName(), byArray);
                    return;
                }
                catch (Exception exception) {
                    if (fileInputStream == null) return;
                    try {
                        fileInputStream.close();
                        return;
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        File[] fileArray2 = fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            ReplayCache.loadCacheToMemory(file2);
            ++n2;
        }
    }

    private ReplayCache() {
    }

    public static Replay getReplay(File file, Integer n, Integer n2, boolean bl, boolean bl2, Set<ReplayFactory.ReplayContent> set) {
        Object object;
        String string;
        if (!file.exists()) {
            return null;
        }
        if (bl || bl2) {
            String string2 = string = Settings.getBoolean("settings.misc.useMd5HashFromFileName") ? ReplayCache.peekFileMd5(file) : null;
            if (string == null) {
                string = GeneralUtils.calculateFileMd5(file);
            }
            if (string.length() == 0) {
                return null;
            }
        } else {
            string = null;
        }
        if (!(!bl || (object = ReplayCache.readCachedReplay(string)) == null || n != null && ((CacheInfo)object).buildOrderLength < n || n2 != null && ((CacheInfo)object).replay.excludedInitialFrames != n2)) {
            return ((CacheInfo)object).replay;
        }
        object = ReplayFactory.parseReplay(file.getAbsolutePath(), set == null ? ReplayFactory.GENERAL_DATA_CONTENT : set);
        if (object != null && bl2) {
            ReplayCache.cacheReplay((Replay)object, n, string);
        }
        return object;
    }

    private static String peekFileMd5(File file) {
        String string = GeneralUtils.getFileNameWithoutExt(file);
        int n = string.indexOf("MD5_");
        while (n >= 0) {
            if (string.length() - (n += 4) < 22) break;
            String string2 = ReplayCache.decodeEncodedMd5(string.substring(n, n + 22));
            if (string2 != null) {
                return string2;
            }
            n = string.indexOf("MD5_", n);
        }
        return null;
    }

    private static CacheInfo readCachedReplay(String string) {
        CacheInfo cacheInfo;
        File file;
        byte[] byArray;
        byte[] byArray2 = byArray = IN_MEMORY_REPLAY_CACHE == null ? null : IN_MEMORY_REPLAY_CACHE.get(string);
        if (byArray == null) {
            file = new File("User Content/Replay cache", String.valueOf(string.substring(0, 2)) + "/" + string);
            if (!file.exists()) {
                return null;
            }
        } else {
            file = null;
        }
        CacheInfo cacheInfo2 = new CacheInfo();
        FilterInputStream filterInputStream = null;
        try {
            Object object;
            filterInputStream = new DataInputStream(byArray == null ? new FileInputStream(file) : new ByteArrayInputStream(byArray));
            short s = ((DataInputStream)filterInputStream).readShort();
            if (s != 12) {
                return null;
            }
            cacheInfo2.buildOrderLength = ((DataInputStream)filterInputStream).readShort();
            Replay replay = cacheInfo2.replay = new Replay();
            replay.initData = new InitData();
            replay.details = new Details();
            int[] nArray = new int[4];
            int n = 0;
            while (n < 4) {
                nArray[n] = ((DataInputStream)filterInputStream).readInt();
                ++n;
            }
            replay.setBuildNumbers(nArray);
            replay.setGameDuration(((DataInputStream)filterInputStream).readInt());
            replay.excludedInitialFrames = ((DataInputStream)filterInputStream).readInt();
            replay.initData.gateway = ReplayConsts.Gateway.values()[((DataInputStream)filterInputStream).readByte()];
            replay.initData.format = ReplayConsts.Format.values()[((DataInputStream)filterInputStream).readByte()];
            replay.initData.gameSpeed = ReplayConsts.GameSpeed.values()[((DataInputStream)filterInputStream).readByte()];
            replay.converterGameSpeed = Settings.getBoolean("settings.misc.useRealTimeMeasurement") ? replay.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL;
            replay.initData.gameType = ReplayConsts.GameType.values()[((DataInputStream)filterInputStream).readByte()];
            replay.details.saveTime = ((DataInputStream)filterInputStream).readLong();
            replay.details.originalMapName = ((DataInputStream)filterInputStream).readUTF();
            replay.details.mapName = Settings.getMapAliasGroupName(replay.details.originalMapName);
            replay.details.players = new Details.Player[((DataInputStream)filterInputStream).readByte()];
            n = 0;
            while (n < replay.details.players.length) {
                replay.details.players[n] = new Details.Player();
                object = replay.details.players[n];
                ((Details.Player)object).playerId.name = ((DataInputStream)filterInputStream).readUTF();
                ((Details.Player)object).playerId.battleNetId = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).playerId.battleNetSubid = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).playerId.gateway = replay.initData.gateway;
                ((Details.Player)object).type = ReplayConsts.PlayerType.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).lastActionFrame = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).race = ReplayConsts.Race.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).finalRace = ReplayConsts.Race.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).team = ((DataInputStream)filterInputStream).readInt();
                if (((DataInputStream)filterInputStream).readBoolean()) {
                    ((Details.Player)object).isWinner = ((DataInputStream)filterInputStream).readBoolean();
                }
                ((Details.Player)object).actionsCount = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).excludedActionsCount = ((DataInputStream)filterInputStream).readInt();
                ++n;
            }
            replay.gameEvents = new GameEvents(replay, null);
            n = ((DataInputStream)filterInputStream).readShort();
            object = new ArrayList(n);
            int n2 = n - 1;
            while (n2 >= 0) {
                GameEvents gameEvents = replay.gameEvents;
                gameEvents.getClass();
                GameEvents.BuildAction buildAction = gameEvents.new GameEvents.BuildAction(ReplayConsts.Building.values()[((DataInputStream)filterInputStream).readByte()]);
                buildAction.player = ((DataInputStream)filterInputStream).readByte();
                object.add(buildAction);
                --n2;
            }
            replay.gameEvents.actions = object.toArray(new GameEvents.Action[n]);
            replay.messageEvents = new MessageEvents();
            Map[] mapArray = new Map[((DataInputStream)filterInputStream).readShort()];
            int n3 = 0;
            while (n3 < mapArray.length) {
                int n4 = ((DataInputStream)filterInputStream).readShort() & 0xFFFF;
                if (n4 > 0) {
                    mapArray[n3] = new HashMap(n4);
                    int n5 = n4 - 1;
                    while (n5 >= 0) {
                        String string2 = ((DataInputStream)filterInputStream).readUTF();
                        mapArray[n3].put(string2, new IntHolder(((DataInputStream)filterInputStream).readShort() & 0xFFFF));
                        --n5;
                    }
                }
                ++n3;
            }
            replay.messageEvents.setWordCountMaps(mapArray);
            cacheInfo = cacheInfo2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CacheInfo cacheInfo3 = cacheInfo2;
            return cacheInfo3;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return cacheInfo;
    }

    private static void cacheReplay(Replay replay, Integer n, String string) {
        File file;
        block25: {
            File file2 = new File("User Content/Replay cache", string.substring(0, 2));
            if (!file2.exists() && !file2.mkdirs()) {
                return;
            }
            file = new File(file2, string);
            FilterOutputStream filterOutputStream = null;
            try {
                try {
                    filterOutputStream = new DataOutputStream(new FileOutputStream(file));
                    ((DataOutputStream)filterOutputStream).writeShort(12);
                    int n2 = n == null ? Settings.getInt("settings.misc.buildOrderLength") : n;
                    ((DataOutputStream)filterOutputStream).writeShort(n2);
                    Object object = replay.buildNumbers;
                    int n3 = replay.buildNumbers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = object[n4];
                        ((DataOutputStream)filterOutputStream).writeInt(n5);
                        ++n4;
                    }
                    ((DataOutputStream)filterOutputStream).writeInt(replay.frames);
                    ((DataOutputStream)filterOutputStream).writeInt(replay.excludedInitialFrames);
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gateway.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.format.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gameSpeed.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gameType.ordinal());
                    ((DataOutputStream)filterOutputStream).writeLong(replay.details.saveTime);
                    ((DataOutputStream)filterOutputStream).writeUTF(replay.details.originalMapName);
                    ((DataOutputStream)filterOutputStream).writeByte(replay.details.players.length);
                    object = replay.details.players;
                    n3 = replay.details.players.length;
                    n4 = 0;
                    while (n4 < n3) {
                        int n6 = object[n4];
                        ((DataOutputStream)filterOutputStream).writeUTF(n6.playerId.name);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.playerId.battleNetId);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.playerId.battleNetSubid);
                        ((DataOutputStream)filterOutputStream).writeByte(n6.type.ordinal());
                        ((DataOutputStream)filterOutputStream).writeInt(n6.lastActionFrame);
                        ((DataOutputStream)filterOutputStream).writeByte(n6.race.ordinal());
                        ((DataOutputStream)filterOutputStream).writeByte(n6.finalRace.ordinal());
                        ((DataOutputStream)filterOutputStream).writeInt(n6.team);
                        ((DataOutputStream)filterOutputStream).writeBoolean(n6.isWinner != null);
                        if (n6.isWinner != null) {
                            ((DataOutputStream)filterOutputStream).writeBoolean(n6.isWinner);
                        }
                        ((DataOutputStream)filterOutputStream).writeInt(n6.actionsCount);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.excludedActionsCount);
                        ++n4;
                    }
                    int[] nArray = new int[replay.details.players.length];
                    n4 = 0;
                    ArrayList<GameEvents.BuildAction> arrayList = new ArrayList<GameEvents.BuildAction>(Math.min(300, nArray.length * n2));
                    GameEvents.Action[] actionArray = replay.gameEvents.actions;
                    int n7 = replay.gameEvents.actions.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        object = actionArray[n8];
                        if (object instanceof GameEvents.BuildAction && nArray[object.player] < n2) {
                            arrayList.add((GameEvents.BuildAction)object);
                            byte by = object.player;
                            nArray[by] = nArray[by] + 1;
                            if (nArray[by] == n2 && ++n4 == nArray.length) break;
                        }
                        ++n8;
                    }
                    ((DataOutputStream)filterOutputStream).writeShort(arrayList.size());
                    Object object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        object = (GameEvents.BuildAction)object2.next();
                        ((DataOutputStream)filterOutputStream).writeByte(object.building.ordinal());
                        ((DataOutputStream)filterOutputStream).writeByte(object.player);
                    }
                    object = replay.messageEvents.getWordCountMaps(replay.initData.clientNames.length);
                    ((DataOutputStream)filterOutputStream).writeShort(((int[])object).length);
                    Object object3 = object;
                    int n9 = ((int[])object).length;
                    n7 = 0;
                    while (n7 < n9) {
                        object2 = object3[n7];
                        ((DataOutputStream)filterOutputStream).writeShort(object2 == null ? 0 : object2.size());
                        if (object2 != null) {
                            for (Map.Entry entry : object2.entrySet()) {
                                ((DataOutputStream)filterOutputStream).writeUTF((String)entry.getKey());
                                ((DataOutputStream)filterOutputStream).writeShort(((IntHolder)entry.getValue()).value);
                            }
                        }
                        ++n7;
                    }
                    ((DataOutputStream)filterOutputStream).flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (IN_MEMORY_REPLAY_CACHE != null) {
            ReplayCache.loadCacheToMemory(file);
        }
    }

    public static void emptyCache(Dialog dialog) {
        ReplayCache.emptyCache_("Preprocessed replay", dialog, "miscSettings.clearingReplayCache", "User Content/Replay cache");
        if (IN_MEMORY_REPLAY_CACHE != null) {
            IN_MEMORY_REPLAY_CACHE.clear();
        }
    }

    public static String encodeMd5(String string) {
        StringBuilder stringBuilder = new StringBuilder(22);
        int[] nArray = new int[3];
        int n = 0;
        while (n < 32) {
            int n2 = 0;
            while (n2 < 3) {
                if (n < 32) {
                    char c;
                    nArray[n2] = (c = string.charAt(n++)) >= '0' && c <= '9' ? c - 48 : 10 + c - 97;
                }
                ++n2;
            }
            stringBuilder.append(ENCODED_MD5_ALPHABET[nArray[0] << 2 | (nArray[1] & 0xC) >> 2]);
            stringBuilder.append(ENCODED_MD5_ALPHABET[(nArray[1] & 3) << 4 | nArray[2]]);
        }
        return stringBuilder.toString();
    }

    private static String decodeEncodedMd5(String string) {
        if (string.length() != 22) {
            return null;
        }
        char[] cArray = GeneralUtils.HEX_DIGITS;
        StringBuilder stringBuilder = new StringBuilder(32);
        int[] nArray = new int[2];
        int n = 0;
        while (n < 22) {
            int n2 = 0;
            while (n2 < 2) {
                char c;
                if ((c = string.charAt(n++)) >= 'a' && c <= 'z') {
                    nArray[n2] = c - 97 + 10;
                } else if (c >= 'A' && c <= 'Z') {
                    nArray[n2] = c - 65 + 36;
                } else if (c >= '0' && c <= '9') {
                    nArray[n2] = c - 48;
                } else if (c == ENCODED_MD5_ALPHABET[62]) {
                    nArray[n2] = 62;
                } else if (c == ENCODED_MD5_ALPHABET[63]) {
                    nArray[n2] = 63;
                } else {
                    return null;
                }
                ++n2;
            }
            stringBuilder.append(cArray[nArray[0] >> 2]);
            stringBuilder.append(cArray[(nArray[0] & 3) << 2 | nArray[1] >> 4]);
            if (n >= 22) continue;
            stringBuilder.append(cArray[nArray[1] & 0xF]);
        }
        return stringBuilder.toString();
    }

    private static class CacheInfo {
        public int buildOrderLength;
        public Replay replay;

        private CacheInfo() {
        }
    }
}

