/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.ReplayCache;
import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;

public class TemplateEngine {
    private static final String[] PLAYER_INFO_SYMBOLS = new String[]{"/p", "/r", "/R", "/A", "/W"};
    public static final String PLAYER_INFO_SYMBOLS_STRING;
    private final boolean cacheEnabled = Settings.getBoolean("settings.misc.cachePreprocessedReplays");
    private final String template;
    private final char[] templateCharArray;
    private boolean requiresGameEvent;
    private boolean replayParseError;
    private int counter = 1;
    private int counter2 = 1;
    private final StringBuilder nameBuilder = new StringBuilder();
    private File file;
    private File targetFolder;
    private File targetFolderWithSubfolders;
    private Replay replay;

    static {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = PLAYER_INFO_SYMBOLS;
        int n = PLAYER_INFO_SYMBOLS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            ++n2;
        }
        PLAYER_INFO_SYMBOLS_STRING = stringBuilder.toString();
    }

    public TemplateEngine(String string) throws Exception {
        if (string.length() == 0) {
            throw new IllegalArgumentException("Template cannot be an empty string!");
        }
        this.template = string;
        this.templateCharArray = string.toCharArray();
        this.requiresGameEvent = this.checkNameTemplate(this.templateCharArray);
    }

    public String applyToReplay(File file, File file2) throws Exception {
        this.file = file;
        this.targetFolderWithSubfolders = this.targetFolder = file2;
        this.replay = null;
        this.replayParseError = false;
        this.nameBuilder.setLength(0);
        this.applyToReplay_(this.templateCharArray);
        if (this.replayParseError) {
            return null;
        }
        String string = this.nameBuilder.toString();
        return string.toLowerCase().endsWith(".sc2replay") ? string : String.valueOf(string) + ".SC2Replay";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void applyToReplay_(char[] var1_1) throws Exception {
        var2_2 = 0;
        while (var2_2 < var1_1.length) {
            block59: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                if (var1_1[var2_2] != '/') break block60;
                                var3_3 = var1_1[++var2_2];
                                switch (var3_3) {
                                    case 110: {
                                        this.nameBuilder.append(GeneralUtils.getFileNameWithoutExt(this.file));
                                        break block59;
                                    }
                                    case 101: {
                                        this.nameBuilder.append("SC2Replay");
                                        break block59;
                                    }
                                    case 104: {
                                        this.nameBuilder.append("MD5_" + ReplayCache.encodeMd5(GeneralUtils.calculateFileMd5(this.file)));
                                        break block59;
                                    }
                                    case 99: {
                                        this.nameBuilder.append(Integer.toString(this.counter++));
                                        break block59;
                                    }
                                    case 67: 
                                    case 70: {
                                        var4_4 = var1_1[++var2_2] - 48;
                                        if (var4_4 < 1 || var4_4 > 9) {
                                            v0 = new StringBuilder("Invalid ");
                                            if (var3_3 == 67) {
                                                v1 = "word";
                                                throw new Exception(v0.append(v1).append(" count: ").append(var1_1[var2_2]).toString());
                                            }
                                            if (var3_3 == 70) {
                                                v1 = "digit";
                                                throw new Exception(v0.append(v1).append(" count: ").append(var1_1[var2_2]).toString());
                                            }
                                            v1 = "";
                                            throw new Exception(v0.append(v1).append(" count: ").append(var1_1[var2_2]).toString());
                                        }
                                        switch (var3_3) {
                                            case 67: {
                                                this.nameBuilder.append(String.format("%0" + var4_4 + "d", new Object[]{this.counter2++}));
                                                break;
                                            }
                                            case 70: {
                                                var5_7 = this.targetFolderWithSubfolders.listFiles(GeneralUtils.SC2REPLAY_FILES_ONLY_FILTER);
                                                this.nameBuilder.append(String.format("%0" + var4_4 + "d", new Object[]{(var5_7 == null ? 0 : var5_7.length) + 1}));
                                            }
                                        }
                                        break block59;
                                    }
                                    case 65: 
                                    case 68: 
                                    case 71: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 87: 
                                    case 89: 
                                    case 100: 
                                    case 102: 
                                    case 103: 
                                    case 108: 
                                    case 109: 
                                    case 112: 
                                    case 113: 
                                    case 114: {
                                        if (this.replay == null) {
                                            this.replay = this.requiresGameEvent != false ? ReplayCache.getReplay(this.file, null, null, this.cacheEnabled, this.cacheEnabled, ReplayFactory.GENERAL_DATA_CONTENT) : ReplayCache.getReplay(this.file, null, null, this.cacheEnabled, false, ReplayFactory.GENERAL_INFO_CONTENT);
                                        }
                                        if (this.replay == null) {
                                            System.out.println("Could not parse replay!");
                                            this.replayParseError = true;
                                            return;
                                        }
                                        ReplayUtils.applyFavoredPlayerListSetting(this.replay.details);
                                        var4_5 = this.replay.details.getTeamOrderPlayerIndices();
                                        switch (var3_3) {
                                            case 100: {
                                                this.nameBuilder.append(Language.formatDate(new Date(this.replay.details.saveTime)).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break;
                                            }
                                            case 68: {
                                                this.nameBuilder.append(Language.formatDateTime(new Date(this.replay.details.saveTime)).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break;
                                            }
                                            case 108: {
                                                this.nameBuilder.append(ReplayUtils.formatFramesShort(this.replay.gameLength << 5, this.replay.converterGameSpeed).replace(':', '-'));
                                                break;
                                            }
                                            case 76: {
                                                this.nameBuilder.append(ReplayUtils.formatMs(this.replay.gameLength * 500, this.replay.converterGameSpeed).replace(':', '-'));
                                                break;
                                            }
                                            case 89: {
                                                this.nameBuilder.append((Object)this.replay.initData.gameType);
                                                break;
                                            }
                                            case 71: {
                                                this.nameBuilder.append((Object)this.replay.initData.gateway);
                                                break;
                                            }
                                            case 109: {
                                                this.nameBuilder.append(this.replay.details.mapName);
                                                break;
                                            }
                                            case 113: {
                                                this.nameBuilder.append(this.replay.details.getPlayerNames());
                                                break;
                                            }
                                            case 103: {
                                                this.nameBuilder.append(this.replay.details.getPlayerNamesGrouped());
                                                break;
                                            }
                                            case 102: {
                                                this.nameBuilder.append((Object)this.replay.initData.format);
                                                break;
                                            }
                                            case 84: {
                                                this.nameBuilder.append(this.replay.details.getRaceMatchup());
                                                break;
                                            }
                                            case 83: {
                                                var5_8 = new StringTokenizer(this.replay.details.mapName);
                                                while (var5_8.hasMoreTokens()) {
                                                    this.nameBuilder.append(var5_8.nextToken().charAt(0));
                                                }
                                                break block59;
                                            }
                                            case 65: 
                                            case 82: 
                                            case 87: 
                                            case 112: 
                                            case 114: {
                                                var5_9 = var1_1[++var2_2] - 49;
                                                if (var5_9 < 0) throw new Exception("Invalid player index: " + var1_1[var2_2]);
                                                if (var5_9 > 7) {
                                                    throw new Exception("Invalid player index: " + var1_1[var2_2]);
                                                }
                                                if (var5_9 >= this.replay.details.players.length) break block59;
                                                switch (var3_3) {
                                                    case 112: {
                                                        this.nameBuilder.append(this.replay.details.players[var4_5[var5_9]].playerId.name);
                                                        ** break;
                                                    }
                                                    case 82: {
                                                        this.nameBuilder.append((Object)this.replay.details.players[var4_5[var5_9]].finalRace);
                                                        ** break;
                                                    }
                                                    case 114: {
                                                        this.nameBuilder.append(this.replay.details.players[var4_5[var5_9]].raceLetter());
                                                        ** break;
                                                    }
                                                    case 65: {
                                                        this.nameBuilder.append(ReplayUtils.calculatePlayerApm(this.replay, this.replay.details.players[var4_5[var5_9]]));
                                                        ** break;
                                                    }
                                                    case 87: {
                                                        var6_13 = this.replay.details.players[var4_5[var5_9]].isWinner;
                                                        this.nameBuilder.append(var6_13 == null ? ReplayConsts.MatchResult.UNKNOWN.letter : (var6_13 != false ? ReplayConsts.MatchResult.WIN.letter : ReplayConsts.MatchResult.LOSS.letter));
                                                        break block59;
                                                    }
                                                    default: {
                                                        ** break;
                                                    }
                                                }
lbl136:
                                                // 5 sources

                                                break block59;
                                            }
                                            case 77: {
                                                var5_10 = var1_1[++var2_2] - 48;
                                                if (var5_10 < 1) throw new Exception("Invalid word count: " + var1_1[var2_2]);
                                                if (var5_10 > 9) {
                                                    throw new Exception("Invalid word count: " + var1_1[var2_2]);
                                                }
                                                var6_14 = new StringTokenizer(this.replay.details.mapName);
                                                var7_17 = 0;
                                                while (var7_17 < var5_10) {
                                                    if (var6_14.hasMoreElements()) {
                                                        if (var7_17 > 0) {
                                                            this.nameBuilder.append(' ');
                                                        }
                                                        this.nameBuilder.append(var6_14.nextToken());
                                                        ++var7_17;
                                                        continue;
                                                    }
                                                    break block59;
                                                }
                                                break block59;
                                            }
                                            case 78: {
                                                var5_11 = var1_1[++var2_2] - 48;
                                                var6_15 = var1_1[++var2_2] - 48;
                                                if (var5_11 < 0) throw new Exception("Invalid letter count: " + var1_1[var2_2 - 1] + var1_1[var2_2]);
                                                if (var5_11 > 9) throw new Exception("Invalid letter count: " + var1_1[var2_2 - 1] + var1_1[var2_2]);
                                                if (var6_15 < 0) throw new Exception("Invalid letter count: " + var1_1[var2_2 - 1] + var1_1[var2_2]);
                                                if (var6_15 > 9) {
                                                    throw new Exception("Invalid letter count: " + var1_1[var2_2 - 1] + var1_1[var2_2]);
                                                }
                                                var7_17 = var5_11 * 10 + var6_15;
                                                this.nameBuilder.append(this.replay.details.mapName.substring(0, Math.min(var7_17, this.replay.details.mapName.length())));
                                            }
                                        }
                                        break block59;
                                    }
                                    default: {
                                        throw new Exception("Invalid symbol: " + (char)var3_3);
                                    }
                                }
                            }
                            if (var1_1[var2_2] != '\\') break block61;
                            this.targetFolderWithSubfolders = new File(this.targetFolder, this.nameBuilder.toString());
                            this.nameBuilder.append(File.separatorChar);
                            break block59;
                        }
                        if (var1_1[var2_2] == '>') {
                            throw new Exception("Invalid Player info block closing tag!");
                        }
                        if (var1_1[var2_2] != '<') break block62;
                        if ((var3_3 = this.template.indexOf(62, ++var2_2)) < 0) {
                            throw new Exception("Player info block is not closed properly!");
                        }
                        var4_6 = this.template.substring(var2_2, var3_3);
                        if (var4_6.indexOf(60, var2_2) >= 0) {
                            throw new Exception("Player info block cannot be embedded in another block!");
                        }
                        if (this.replay == null) {
                            this.replay = ReplayCache.getReplay(this.file, null, null, this.cacheEnabled, false, ReplayFactory.GENERAL_INFO_CONTENT);
                        }
                        if (this.replay == null) {
                            System.out.println("Could not parse replay!");
                            this.replayParseError = true;
                            return;
                        }
                        var5_12 = this.replay.details.getTeamOrderPlayerIndices();
                        if (var5_12.length <= 0) break block63;
                        var6_16 = this.replay.details.players[var5_12[0]].team;
                        var7_17 = 1;
                        var11_21 = var5_12;
                        var10_20 = var5_12.length;
                        var9_19 = 0;
                        if (true) ** GOTO lbl226
                    }
                    this.nameBuilder.append(var1_1[var2_2]);
                    break block59;
                    do {
                        var8_18 = var11_21[var9_19];
                        var12_22 = this.replay.details.players[var8_18];
                        if (var12_22.team != var6_16) {
                            this.nameBuilder.append(" vs ");
                            var6_16 = var12_22.team;
                            var7_17 = 1;
                        }
                        if (var7_17 != 0) {
                            var7_17 = 0;
                        } else {
                            this.nameBuilder.append(", ");
                        }
                        var13_23 = var4_6;
                        var17_27 = TemplateEngine.PLAYER_INFO_SYMBOLS;
                        var16_26 = TemplateEngine.PLAYER_INFO_SYMBOLS.length;
                        var15_25 = 0;
                        while (var15_25 < var16_26) {
                            var14_24 = var17_27[var15_25];
                            var13_23 = var13_23.replace(var14_24, String.valueOf(var14_24) + (var5_12[var8_18] + 1));
                            ++var15_25;
                        }
                        this.applyToReplay_(var13_23.toCharArray());
                        ++var9_19;
lbl226:
                        // 2 sources

                    } while (var9_19 < var10_20);
                }
                var2_2 = var3_3;
            }
            ++var2_2;
        }
    }

    private boolean checkNameTemplate(char[] cArray) throws Exception {
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            block16: {
                int n2;
                block15: {
                    if (cArray[n] != '/') break block15;
                    n2 = cArray[++n];
                    switch (n2) {
                        case 68: 
                        case 71: 
                        case 76: 
                        case 83: 
                        case 84: 
                        case 89: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 113: {
                            break block16;
                        }
                        case 65: 
                        case 82: 
                        case 87: 
                        case 112: 
                        case 114: {
                            bl |= n2 == 65 || n2 == 87;
                            int n3 = cArray[++n] - 49;
                            if (n3 < 0 || n3 > 8) {
                                throw new Exception("Invalid player index: " + cArray[n]);
                            }
                            break block16;
                        }
                        case 67: 
                        case 70: 
                        case 77: {
                            int n3 = cArray[++n] - 48;
                            if (n3 < 1 || n3 > 9) {
                                throw new Exception("Invalid " + (n2 == 77 ? "word" : (n2 == 67 || n2 == 70 ? "digit" : "")) + " count: " + cArray[n]);
                            }
                            break block16;
                        }
                        case 78: {
                            int n4 = cArray[++n] - 48;
                            int n5 = cArray[++n] - 48;
                            if (n4 < 0 || n4 > 9 || n5 < 0 || n5 > 9) {
                                throw new Exception("Invalid letter count: " + cArray[n - 1] + cArray[n]);
                            }
                            break block16;
                        }
                        default: {
                            throw new Exception("Invalid symbol: " + (char)n2);
                        }
                    }
                }
                if (cArray[n] == '>') {
                    throw new Exception("Invalid Player info block closing tag!");
                }
                if (cArray[n] == '<') {
                    if ((n2 = this.template.indexOf(62, ++n)) < 0) {
                        throw new Exception("Player info block is not closed properly!");
                    }
                    String string = this.template.substring(n, n2);
                    if (string.indexOf(60, n) >= 0) {
                        throw new Exception("Player info block cannot be embedded in another block!");
                    }
                    String string2 = string;
                    String[] stringArray = PLAYER_INFO_SYMBOLS;
                    int n6 = PLAYER_INFO_SYMBOLS.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String string3 = stringArray[n7];
                        string2 = string2.replace(string3, String.valueOf(string3) + 1);
                        ++n7;
                    }
                    bl |= this.checkNameTemplate(string2.toCharArray());
                    n = n2;
                }
            }
            ++n;
        }
        return bl;
    }
}

