/*
 * Decompiled with CFR 0.152.
 */
package mumart.micromod.replay;

import mumart.micromod.replay.Replay;
import mumart.micromod.xm.IBXM;
import mumart.micromod.xm.Module;

public class Player {
    private static final int OVERSAMPLE = 2;
    private Replay replay;
    private int filt_l;
    private int filt_r;
    private int mix_pos;
    private int mix_len;
    private int duration;
    private int[] mix_buffer;

    public Player(byte[] module_data, int sampling_rate, int resampling) {
        this.replay = Player.init_replay(module_data, sampling_rate * 2, resampling);
        this.duration = this.replay.calculate_song_duration() / 2;
        this.mix_buffer = new int[this.replay.get_mix_buffer_length()];
    }

    public String get_version() {
        return this.replay.get_version();
    }

    public String get_string(int idx) {
        return this.replay.get_string(idx);
    }

    public int get_song_duration() {
        return this.duration;
    }

    public void set_sequence_pos(int pos) {
        this.mix_len = 0;
        this.mix_pos = 0;
        this.replay.set_sequence_pos(pos);
    }

    public int seek(int sample_pos) {
        this.mix_len = 0;
        this.mix_pos = 0;
        sample_pos = this.replay.seek(sample_pos * 2) / 2;
        return sample_pos;
    }

    public void get_audio(short[] output, int offset, int count) {
        int[] mix_buf = this.mix_buffer;
        while (count > 0) {
            int len;
            if (this.mix_pos >= this.mix_len) {
                this.mix_pos = 0;
                this.mix_len = this.downsample(mix_buf, this.replay.get_audio(mix_buf));
            }
            if ((len = this.mix_len - this.mix_pos) > count) {
                len = count;
            }
            int end = offset + len * 2;
            int mix_idx = this.mix_pos * 2;
            while (offset < end) {
                int sam;
                if ((sam = mix_buf[mix_idx++]) > Short.MAX_VALUE) {
                    sam = Short.MAX_VALUE;
                }
                if (sam < Short.MIN_VALUE) {
                    sam = Short.MIN_VALUE;
                }
                output[offset++] = (short)sam;
            }
            this.mix_pos += len;
            count -= len;
        }
    }

    private int downsample(int[] buf, int count) {
        int fl = this.filt_l;
        int fr = this.filt_r;
        int in_idx = 0;
        int out_idx = 0;
        while (out_idx < count) {
            int out_l = fl + (buf[in_idx++] >> 1);
            int out_r = fr + (buf[in_idx++] >> 1);
            fl = buf[in_idx++] >> 2;
            fr = buf[in_idx++] >> 2;
            buf[out_idx++] = out_l + fl;
            buf[out_idx++] = out_r + fr;
        }
        this.filt_l = fl;
        this.filt_r = fr;
        return count >> 1;
    }

    public static Replay init_replay(byte[] module_data, int sampling_rate, int resampling) {
        try {
            Module module = new Module(module_data);
            return new IBXM(module, sampling_rate, resampling != 1);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

